<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\Export_Promotion\ExportPromotionService;

class ExportPromotionController extends Controller
{   
    public function exportPromotionService()
    {
        return new ExportPromotionService;
    }

    public function index(Request $request)
    {   
        $export_promotions = $this->getRequestData($request, 'export_promotions');
        $date_range = $this->getRequestData($request, 'date_range');
        return view('content.dashboard.export-promotion', compact(
            'export_promotions',
            'date_range',
        ));
    }

    private function getRequestData(Request $request, $field_name)
    {   
        return json_decode(decrypt($request->query($field_name)));
    }

    public function programme(Request $request)
    {   
        $date_range = $this->getRequestData($request, 'date_range');
        $result = $this->exportPromotionService()->getExportPromotionProgrammeData($date_range);
        return view('content.dashboard.programme-bpeap', compact(
            'result',
            'date_range'
        ));
    }

    public function exportSales(Request $request)
    {   
        $date_range = $this->getRequestData($request, 'date_range');
        $result = $this->exportPromotionService()->getExportPromotionExportSalesData($date_range);
        return view('content.dashboard.export-sales-bpeap', compact(
            'result',
            'date_range'
        ));
    }

    public function companiesAssisted(Request $request)
    {
        $date_range = $this->getRequestData($request, 'date_range');
        $result = $this->exportPromotionService()->getExportPromotionCompaniesAssistedData($date_range);
        return view('content.dashboard.companies-assisted-bpeap', compact(
            'result',
            'date_range'
        ));
    }
}