<?php
namespace App\Services\Export_Promotion;

use DB;

class ExportPromotionService
{
    public function getExportPromotionProgrammeData($date_range)
    {
        $result = DB::table('kpi_indicator as ki')
                    ->join('kpi_achievement as ka', 'ki.kpi_achievement_id', '=', 'ka.kpi_achievement_id')
                    ->join('kpi_achievement_detail as kad', 'ka.kpi_achievement_det_id', '=', 'kad.kpi_achievement_det_id')
                    ->select('ka.division','ka.section','ka.unit', 'kad.activity_name',
                              'kad.activity_type', 'kad.programme_type','kad.start_date', //need to add progrramm
                              'kad.end_date', 'kad.total_sales_generated', 
                              'kad.total_approved_participants')
                    ->where('ki.indicator', 'Programme')
                    ->where('ki.Component_Achievement', 'promotion')
                    ->where(function ($query) use ($date_range) {
                        $query->whereBetween(
                            DB::raw("
                                CASE 
                                    WHEN kad.start_date IS NOT NULL THEN kad.start_date
                                    WHEN kad.approved_date IS NOT NULL THEN kad.approved_date
                                    ELSE NULL
                                END
                            "), [$date_range->start_date, $date_range->end_date]
                        )
                        ->orWhere(function ($q) use ($date_range) {
                            $q->whereNull('kad.start_date')
                            ->whereNull('kad.approved_date')
                            ->whereBetween('kad.year', [$date_range->year_from, $date_range->year_to])
                            ->whereIn('kad.quarter', array_unique(array_merge($date_range->quarter_from,
                            $date_range->quarter_to)));
                        });
                    })
                    ->get();
        return $result;
    }

    public function getExportPromotionExportSalesData($date_range)
    {
        $result = DB::table('kpi_indicator as ki')
                    ->join('kpi_achievement as ka', 'ki.kpi_achievement_id', '=', 'ka.kpi_achievement_id')
                    ->join('kpi_achievement_detail as kad', 'ka.kpi_achievement_det_id', '=', 'kad.kpi_achievement_det_id')
                    ->select('ka.division','ka.section','ka.unit', 'kad.activity_name',
                              'kad.activity_type', 'kad.programme_type','kad.start_date',
                              'kad.end_date', 'kad.total_sales_generated', 
                              'kad.total_approved_malaysian_companies',
                              'kad.no_of_malaysian_companies_with_sales')
                    ->where('ki.indicator', 'Export Sales')
                    ->where('ki.Component_Achievement', 'promotion')
                    ->where(function ($query) use ($date_range) {
                        $query->whereBetween(
                            DB::raw("
                                CASE 
                                    WHEN kad.start_date IS NOT NULL THEN kad.start_date
                                    WHEN kad.approved_date IS NOT NULL THEN kad.approved_date
                                    ELSE NULL
                                END
                            "), [$date_range->start_date, $date_range->end_date]
                        )
                        ->orWhere(function ($q) use ($date_range) {
                            $q->whereNull('kad.start_date')
                            ->whereNull('kad.approved_date')
                            ->whereBetween('kad.year', [$date_range->year_from, $date_range->year_to])
                            ->whereIn('kad.quarter', array_unique(array_merge($date_range->quarter_from,
                            $date_range->quarter_to)));
                        });
                    })
                    ->get();
        return $result;

    }

    public function getExportPromotionCompaniesAssistedData($date_range)
    {
        $result = DB::table('kpi_indicator as ki')
                    ->join('kpi_achievement as ka', 'ki.kpi_achievement_id', '=', 'ka.kpi_achievement_id')
                    ->join('kpi_achievement_detail as kad', 'ka.kpi_achievement_det_id', '=', 'kad.kpi_achievement_det_id')
                    ->select('ka.division','ka.section','kad.programme',
                            'kad.programme_type','kad.sector',
                              'kad.name_of_approved_participants', 'kad.registration_number', 
                              'kad.approved_date')
                    ->where('ki.indicator', 'Companies Assisted')
                    ->where('ki.Component_Achievement', 'promotion')
                    ->where(function ($query) use ($date_range) {
                        $query->whereBetween(
                            DB::raw("
                                CASE 
                                    WHEN kad.start_date IS NOT NULL THEN kad.start_date
                                    WHEN kad.approved_date IS NOT NULL THEN kad.approved_date
                                    ELSE NULL
                                END
                            "), [$date_range->start_date, $date_range->end_date]
                        )
                        ->orWhere(function ($q) use ($date_range) {
                            $q->whereNull('kad.start_date')
                            ->whereNull('kad.approved_date')
                            ->whereBetween('kad.year', [$date_range->year_from, $date_range->year_to])
                            ->whereIn('kad.quarter', array_unique(array_merge($date_range->quarter_from,
                            $date_range->quarter_to)));
                        });
                    })
                    ->get();
        return $result;
    }
}