import '../css/menu-collapsed.css';
/**
 * Main
 */

('use strict');

let menu, animate;

(function () {
  // Initialize menu
  //-----------------

  let layoutMenuEl = document.querySelectorAll('#layout-menu');
  layoutMenuEl.forEach(function (element) {
    menu = new Menu(element, {
      orientation: 'vertical',
      closeChildren: false
    });
    // Change parameter to true if you want scroll animation
    window.Helpers.scrollToActive((animate = false));
    window.Helpers.mainMenu = menu;
  });

  // Initialize menu togglers and bind click on each
  // let menuToggler = document.querySelectorAll('.layout-menu-toggle');
  //menuToggler.forEach(item => {
  // item.addEventListener('click', event => {
  //  event.preventDefault();
  //    window.Helpers.toggleCollapsed();
  //});
  // });

  // Make sure this code runs when the DOM is fully loaded
  document.addEventListener('DOMContentLoaded', function () {
    console.log('DOM loaded, looking for toggle buttons...');

    //Add toggle sidebar collapse

    document.addEventListener('DOMContentLoaded', function () {
      const toggle = document.querySelector('.layout-menu-toggle');
      if (toggle) {
        toggle.addEventListener('click', function (e) {
          e.preventDefault();
          document.body.classList.toggle('layout-menu-collapsed');
        });
      }
    });

    // Find all toggle buttons
    const toggleButtons = document.querySelectorAll('.layout-menu-toggle');
    console.log('Found toggle buttons:', toggleButtons.length);

    // Directly implement the toggle functionality
    toggleButtons.forEach(button => {
      console.log('Setting up click handler for button:', button);

      button.addEventListener('click', function (e) {
        console.log('Toggle button clicked!');
        e.preventDefault();

        const layoutMenu = document.getElementById('layout-menu');
        console.log('Layout menu element:', layoutMenu);

        if (layoutMenu) {
          console.log('Current collapsed state:', layoutMenu.classList.contains('collapsed'));

          // Toggle the collapsed class
          layoutMenu.classList.toggle('collapsed');
          document.body.classList.toggle('layout-menu-collapsed');

          // Toggle the icon
          const icon = this.querySelector('.bx');
          if (icon) {
            if (layoutMenu.classList.contains('collapsed')) {
              icon.classList.remove('bx-chevron-left');
              icon.classList.add('bx-chevron-right');
            } else {
              icon.classList.remove('bx-chevron-right');
              icon.classList.add('bx-chevron-left');
            }
          }

          // Save state to localStorage
          const isCollapsed = layoutMenu.classList.contains('collapsed');
          localStorage.setItem('isCollapsed', isCollapsed);
          console.log('Saved collapsed state to localStorage:', isCollapsed);
        } else {
          console.error('Layout menu element not found!');
        }
      });
    });

    // Try to load saved state
    const layoutMenu = document.getElementById('layout-menu');
    if (layoutMenu) {
      const savedState = localStorage.getItem('isCollapsed');
      console.log('Loaded saved state from localStorage:', savedState);

      if (savedState === 'true') {
        layoutMenu.classList.add('collapsed');
        document.body.classList.add('layout-menu-collapsed');

        // Update all toggle icons
        document.querySelectorAll('.layout-menu-toggle .bx').forEach(icon => {
          icon.classList.remove('bx-chevron-left');
          icon.classList.add('bx-chevron-right');
        });
      }
    }
  });

  // Display menu toggle (layout-menu-toggle) on hover with delay
  let delay = function (elem, callback) {
    let timeout = null;
    elem.onmouseenter = function () {
      // Set timeout to be a timer which will invoke callback after 300ms (not for small screen)
      if (!Helpers.isSmallScreen()) {
        timeout = setTimeout(callback, 300);
      } else {
        timeout = setTimeout(callback, 0);
      }
    };

    elem.onmouseleave = function () {
      // Clear any timers set to timeout
      document.querySelector('.layout-menu-toggle').classList.remove('d-block');
      clearTimeout(timeout);
    };
  };
  if (document.getElementById('layout-menu')) {
    delay(document.getElementById('layout-menu'), function () {
      // not for small screen
      if (!Helpers.isSmallScreen()) {
        document.querySelector('.layout-menu-toggle').classList.add('d-block');
      }
    });
  }

  // Display in main menu when menu scrolls
  let menuInnerContainer = document.getElementsByClassName('menu-inner'),
    menuInnerShadow = document.getElementsByClassName('menu-inner-shadow')[0];
  if (menuInnerContainer.length > 0 && menuInnerShadow) {
    menuInnerContainer[0].addEventListener('ps-scroll-y', function () {
      if (this.querySelector('.ps__thumb-y').offsetTop) {
        menuInnerShadow.style.display = 'block';
      } else {
        menuInnerShadow.style.display = 'none';
      }
    });
  }

  // Init helpers & misc
  // --------------------

  // Init BS Tooltip
  const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
  tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new bootstrap.Tooltip(tooltipTriggerEl);
  });

  // Accordion active class
  const accordionActiveFunction = function (e) {
    if (e.type == 'show.bs.collapse' || e.type == 'show.bs.collapse') {
      e.target.closest('.accordion-item').classList.add('active');
    } else {
      e.target.closest('.accordion-item').classList.remove('active');
    }
  };

  const accordionTriggerList = [].slice.call(document.querySelectorAll('.accordion'));
  const accordionList = accordionTriggerList.map(function (accordionTriggerEl) {
    accordionTriggerEl.addEventListener('show.bs.collapse', accordionActiveFunction);
    accordionTriggerEl.addEventListener('hide.bs.collapse', accordionActiveFunction);
  });

  // Auto update layout based on screen size
  window.Helpers.setAutoUpdate(true);

  // Toggle Password Visibility
  window.Helpers.initPasswordToggle();

  // Speech To Text
  window.Helpers.initSpeechToText();

  // Manage menu expanded/collapsed with templateCustomizer & local storage
  //------------------------------------------------------------------

  // If current layout is horizontal OR current window screen is small (overlay menu) than return from here
  if (window.Helpers.isSmallScreen()) {
    return;
  }

  // If current layout is vertical and current window screen is > small

  // Auto update menu collapsed/expanded based on the themeConfig
  window.Helpers.setCollapsed(true, false);
})();
