@extends('layouts/contentNavbarLayout')

@section('title', 'Export Promotion - Companies Assisted')

@php
  $breadcrumbs = [
    ['label' => 'Dashboard', 'url' => route('dashboard-analytics')],
    ['label' => 'Exporters Development'],
    ['label' => 'Companies Assisted']
  ];
@endphp

@section('content')

{{-- Page header & breadcrumbs --}}
@include('layouts.partials.page-header', [
  'title' => 'Companies Assisted',
  'slot' => view('layouts.partials.breadcrumb', compact('breadcrumbs'))
])

@include('layouts.partials.print-setup')

@section('page-script')
@vite('resources/assets/js/dashboards-analytics.js')

<!-- Feather Icons CDN -->
<script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    feather.replace();
  });
</script>
@endsection
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<br><br>

<style>
  .table th {
    text-transform: capitalize !important;
  }

  @media print {
    .table {
      font-size: 10px !important;
    }

    th, td {
      font-size: 10px !important;
      white-space: normal !important;
    }

    .table-responsive {
      overflow: visible !important;
    }

    .d-print-none {
      display: none !important;
    }

    #printTitle {
      font-size: 16px;
      font-weight: bold;
      text-align: center;
      text-transform: uppercase;
      margin-bottom: 10px;
    }

    @page {
      margin: 15mm;
    }
  }
</style>

<div class="container-xxxl">
  <div class="card p-4 mb-4 print-section">

    <!-- ✅ Tajuk versi cetakan -->
    <h3 id="printTitle" class="d-none d-print-block"></h3>

    <div class="d-flex justify-content-between align-items-center mb-3">
      <div class="d-print-none">
        {!! formatDateRangeDisplay($date_range) !!}
        {{-- <strong>Year From:</strong> 2022 Duration From: Q1 (January - March) ||
        <strong>Year To:</strong> 2022 Duration To: Q4 (October - December) --}}
      </div>
      <div class="d-flex gap-2 no-print">
         <button class="btn btn-info btn-sm" onclick="printPage()"><i data-feather="printer" class="me-2" style="width: 14px; height: 14px;"></i>Print</button>
        <div class="dropdown">
        <button class="btn btn-danger btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i data-feather="download" class="me-2" style="width: 14px; height: 14px;"></i>Export</button>
          <ul class="dropdown-menu">
            <li><a class="dropdown-item" href="#"><i class="fas fa-file-excel me-2 text-success"></i>EXCEL</a></li>
            <li><a class="dropdown-item" href="#"><i class="fas fa-file-pdf me-2 text-danger"></i>PDF</a></li>
            <li><a class="dropdown-item" href="#"><i class="fas fa-file-word me-2 text-primary"></i>WORD</a></li>
            <li><a class="dropdown-item" href="#"><i class="fas fa-file-image me-2 text-warning"></i>JPG</a></li>
          </ul>
        </div>
      </div>
    </div>

    <div class="table-responsive">
      <table class="table table-bordered table-hover">
        <thead class="table-light align-middle text-center">
          <tr>
            <th>No</th>
            <th>Division</th>
            <th>Section</th>
            <th>Unit</th>
            <th>Programme</th>
            <th>Name of Approved Participants (Companies)</th>
            <th>Sector</th>
            <th>Registration Number (ROC/ROB)</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($result as $key => $field )
            <tr>
                <td class="text-center">{{ $key +1 }}</td>
                <td>{{ $field->division }}</td>
                <td>{{ $field->section }}</td>
                <td>{{ $field->unit }}</td>
                <td>{{ $field->programme }}</td>
                <td>{{ $field->name_of_approved_participants }}</td>
                <td>{{ $field->sector }}</td>
                <td>{{ $field->registration_number }}</td>
            </tr>
          @endforeach
        </tbody>
      </table>
    </div>


<script>
  function printPage() {
    const now = new Date();
    const date = now.toLocaleDateString('en-GB', {
      day: '2-digit', month: 'short', year: 'numeric'
    }).toUpperCase();
    const time = now.toLocaleTimeString('en-GB', {
      hour: '2-digit', minute: '2-digit'
    });
    const full = `Companies Assisted (${date}, ${time})`;
    document.getElementById('printTitle').textContent = full;
    window.print();
  }
</script>

@endsection
