@extends('layouts/contentNavbarLayout')

@section('title', 'Dashboard - Analytics')

@section('vendor-style')
@vite('resources/assets/vendor/libs/apex-charts/apex-charts.scss')
@endsection

@section('vendor-script')
@vite('resources/assets/vendor/libs/apex-charts/apexcharts.js')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
@endsection

@section('page-script')
@vite('resources/assets/js/dashboards-analytics.js')

<!-- Feather Icons CDN -->
<script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    feather.replace();
  });
</script>
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.10.0/font/bootstrap-icons.min.css" rel="stylesheet">
<style>
    .sortable-header {
        cursor: pointer;
        position: relative;
        user-select: none;
        padding-right: 25px !important;
    }

    .sortable-header:hover {
        background-color: #f8f9fa;
    }

    .sort-icon {
        position: absolute;
        right: 8px;
        top: 50%;
        transform: translateY(-50%);
        font-size: 12px;
        color: #6c757d;
        transition: color 0.2s;
    }

    .sort-icon.active {
        color: #0d6efd;
    }

     /* Hide non-print elements & control print layout */
  @media print {
    body * {
      visibility: hidden;
    }

    .print-section, .print-section * {
      visibility: visible !important;
    }

    .print-section {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      background: white;
      padding: 20px;
      z-index: 9999;
      font-size: 12px !important; /* shrink text size for print */
    }

    table th,
    table td {
      font-size: 12.5px !important; /* also apply smaller size to table */
    }

    #printTitle {
      font-size: 18px !important; /* slightly bigger for title */
    }

    nav, aside, .btn, .dropdown, .page-header, footer {
      display: none !important;
    }

    .hide-on-print {
      display: none !important;
    }

    .d-print-block {
      display: block !important;
    }

    @page {
      margin: 20mm;
    }
  }
</style>

@endsection

@php
  $breadcrumbs = [
    ['label' => 'Dashboard', 'url' => route('dashboard-analytics')],
    ['label' => 'Export Promotion']
  ];
@endphp

@section('content')

@include('layouts.partials.page-header', [
  'title' => 'Export Promotion',
  'slot' => view('layouts.partials.breadcrumb', compact('breadcrumbs'))
])
<br><br>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<div class="container-xxxl">
  <div class="card p-4 mb-4 print-section">
    <div class="d-flex justify-content-between align-items-center mb-3">
      <div class="d-print-none">
        {!! formatDateRangeDisplay($date_range) !!}
        {{-- <strong>Year From:</strong> 2022 Duration From: Q1 (January - March) ||
        <strong>Year To:</strong> 2022 Duration To: Q4 (October - December) --}}
      </div>
      <h3 id="printTitle" class="text-center d-none d-print-block my-0 text-uppercase"></h3>
      <div class="d-flex gap-2 no-print">
         <button class="btn btn-info btn-sm" onclick="printPage()"><i data-feather="printer" class="me-2" style="width: 14px; height: 14px;"></i>Print</button>
        <div class="dropdown">
        <button class="btn btn-danger btn-sm dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"><i data-feather="download" class="me-2" style="width: 14px; height: 14px;"></i>Export</button>
          <ul class="dropdown-menu">
            <li><a class="dropdown-item" href="#"><i class="fas fa-file-excel me-2 text-success"></i>EXCEL</a></li>
            <li><a class="dropdown-item" href="#"><i class="fas fa-file-pdf me-2 text-danger"></i>PDF</a></li>
            <li><a class="dropdown-item" href="#"><i class="fas fa-file-word me-2 text-primary"></i>WORD</a></li>
            <li><a class="dropdown-item" href="#"><i class="fas fa-file-image me-2 text-warning"></i>JPG</a></li>
          </ul>
        </div>
      </div>
    </div>

    <div class="table-responsive">
      <table class="table table-bordered table-hover" id="exportTable">
        <thead class="table-light">
          <tr>
            <th class="sortable-header" onclick="sortTable('exportTable', 0, 'text')">
              Indicator
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="sortable-header" onclick="sortTable('exportTable', 1, 'number')">
              Annual Target
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="sortable-header" onclick="sortTable('exportTable', 2, 'number')">
              Achievement
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="sortable-header" onclick="sortTable('exportTable', 3, 'number')">
              Performance Rating
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
          </tr>
        </thead>
        <tbody style="font-size: 16px;">
          <tr>
            <td>
            <a href="{{ route('dashboard.programme-bpeap', [
                    'date_range' => encrypt(json_encode($date_range))]) }}" class="text-decoration-none text-primary">Programme</a>
          </td>
            <td>{{ $export_promotions->programme->total_achievement_short }}</td>
            <td>{{ $export_promotions->programme->total_target_short }}</td>
            <td>
              <div class="d-flex align-items-center gap-2">
                <span class="rounded-circle d-inline-block" style="background-color: #f4c542; width: 12px; height: 12px;"></span>
                <span>{{ $export_promotions->programme->percentage }}%</span>
              </div>
            </td>
          </tr>
          <tr>
            <td>
            <a href="{{ route('dashboard.export-sales-bpeap', [
                    'date_range' => encrypt(json_encode($date_range))]) }}" class="text-decoration-none text-primary">Export Sales (RM)</a>
            </td>
            <td>{{ $export_promotions->export_sales_rm->total_achievement_short }}</td>
            <td>{{ $export_promotions->export_sales_rm->total_target_short }}</td>
            <td>
              <div class="d-flex align-items-center gap-2">
                <span class="rounded-circle d-inline-block" style="background-color: #e74c3c; width: 12px; height: 12px;"></span>
                <span>{{ $export_promotions->export_sales_rm->percentage }}%</span>
              </div>
            </td>
          </tr>
          <tr>
            <td>
            <a href="{{ route('dashboard.companies-assisted-bpeap', [
                    'date_range' => encrypt(json_encode($date_range))]) }}" class="text-decoration-none text-primary">Companies Assisted</a>
            </td>
            <td>{{ $export_promotions->company_assisted->total_achievement_short }}</td>
            <td>{{ $export_promotions->company_assisted->total_target_short }}</td>
            <td>
              <div class="d-flex align-items-center gap-2">
                <span class="rounded-circle d-inline-block" style="background-color: #f4c542; width: 12px; height: 12px;"></span>
                <span>{{ $export_promotions->company_assisted->percentage }}%</span>
              </div>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
</div>

<script>
    let sortDirections = {}; // Track sort direction for each column

    function sortTable(tableId, columnIndex, dataType) {
        const table = document.getElementById(tableId);
        const tbody = table.querySelector('tbody');
        const rows = Array.from(tbody.querySelectorAll('tr'));
        const header = table.querySelector(`thead th:nth-child(${columnIndex + 1})`);
        const sortIcon = header.querySelector('.sort-icon');

        // Clear other active sort icons
        table.querySelectorAll('.sort-icon').forEach(icon => {
            if (icon !== sortIcon) {
                icon.classList.remove('active');
                icon.className = 'bi bi-arrow-down-up sort-icon';
            }
        });

        // Determine sort direction
        const sortKey = `${tableId}_${columnIndex}`;
        const currentDirection = sortDirections[sortKey] || 'asc';
        const newDirection = currentDirection === 'asc' ? 'desc' : 'asc';
        sortDirections[sortKey] = newDirection;

        // Update sort icon
        sortIcon.classList.add('active');
        sortIcon.className = newDirection === 'asc' ?
            'bi bi-arrow-up sort-icon active' :
            'bi bi-arrow-down sort-icon active';

        // Sort rows
        rows.sort((a, b) => {
            const aCell = a.cells[columnIndex];
            const bCell = b.cells[columnIndex];

            let aValue = aCell.textContent.trim();
            let bValue = bCell.textContent.trim();

            // Handle status badges - extract text content
            if (aCell.querySelector('.badge')) {
                aValue = aCell.querySelector('.badge').textContent.trim();
            }
            if (bCell.querySelector('.badge')) {
                bValue = bCell.querySelector('.badge').textContent.trim();
            }

            // Convert to appropriate data type
            if (dataType === 'number') {
                // Handle billions (bil) and thousands (k)
                aValue = extractNumber(aValue);
                bValue = extractNumber(bValue);

                if (newDirection === 'asc') {
                    return aValue - bValue;
                } else {
                    return bValue - aValue;
                }
            } else {
                // Text sorting (alphabetical)
                aValue = aValue.toLowerCase();
                bValue = bValue.toLowerCase();

                if (newDirection === 'asc') {
                    return aValue.localeCompare(bValue);
                } else {
                    return bValue.localeCompare(aValue);
                }
            }
        });

        // Clear tbody and re-append sorted rows
        tbody.innerHTML = '';
        rows.forEach(row => tbody.appendChild(row));

        // Add visual feedback
        header.style.backgroundColor = '#e3f2fd';
        setTimeout(() => {
            header.style.backgroundColor = '';
        }, 300);
    }

    function extractNumber(text) {
        // Handle billions (bil) and thousands (k)
        const num = parseFloat(text.replace(/[^\d.]/g, ''));
        if (text.includes('bil')) {
            return num * 1000000000;
        } else if (text.includes('k')) {
            return num * 1000;
        }
        return num || 0;
    }

    function printPage() {
    const now = new Date();
    const date = now.toLocaleDateString('en-GB', {
      day: '2-digit', month: 'short', year: 'numeric'
    }).toUpperCase();
    const time = now.toLocaleTimeString('en-GB', {
      hour: '2-digit', minute: '2-digit'
    });
    const full = `Export Promotion (${date}, ${time})`;

    document.getElementById('printTitle').textContent = full;
    window.print();
  }
</script>

@endsection
