@extends('layouts/contentNavbarLayout')

@section('title', 'KPI Achievement')

@section('content')
<br>
<div class="container-fluid my-4 px-3">
  <div class="card mx-auto" style="max-width: 98%;">
    <div class="card-header">
      <h4 class="mb-0">Manage Indicator Type 4</h4>
    </div>

    <div class="card-body">
      <!-- START: Indicator Details Section -->
      <div class="mb-4">
        <!-- Top Section -->
        <div class="row mb-3">
          <div class="col-md-4">
            <label class="form-label fw-semibold">Division:</label>
            <input type="text" class="form-control" value="EXPORT PROMOTION & MARKET ACCESS" readonly>
          </div>
          <div class="col-md-4">
            <label class="form-label fw-semibold">Section:</label>
            <input type="text" class="form-control" value="ASEAN & Oceania" readonly>
          </div>
          <div class="col-md-4">
            <label class="form-label fw-semibold">Unit / Offices:</label>
            <input type="text" class="form-control" value="TC-BANGKOK" readonly>
          </div>
        </div>

        <!-- Main Table -->
        <div class="table-responsive mb-4">
          <table class="table table-bordered align-middle text-center small">
            <thead class="table-light">
              <tr>
                <th>Indicator</th>
                <th>Indicator Description</th>
                <th>Submission</th>
                <th>Annual Target</th>
                <th>Metric</th>
                <th>Category</th>
                <th>Output<br>/Outcome</th>
                <th>Component Achievement</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>Webinar organised by MATRADE</td>
                <td style="text-align: justify;">Webinar /Seminar including Market Briefing organised by MATRADE for Malaysian exporters/ companies.  TC to coordinate the Webinar /Seminar  with Market/ Sectoral Desk/ ETU. TC / ATC to assume the role as a speaker/panelist at Webinar /Seminar.

The following cannot be considered as KPI achievement: 

- Participation as panelist in Q&A session or attending event

- Webinar / Seminar organised in conjunction with export promotion programmes  (E.g; EAM/TIM etc...)

Note: TC/ATC/MO to submit supporting documents (E.g; Flyers/Pictures/Etc.) for verification</td>
                <td>Quarter</td>
                <td>1</td>
                <td>Programme</td>
                <td>Customer</td>
                <td>Output</td>
                <td>Export Promotion Market Access</td>
              </tr>
            </tbody>
          </table>
        </div>

        <!-- Achievement Input -->
        <div class="table-responsive mb-3">
          <table class="table table-bordered align-middle text-center small">
            <thead class="table-light">
              <tr>
                <th>Year</th>
                <th>Quarter/Month Group</th>
                <th>Achievement Count</th>
                <th>Date</th>
                <th>Activity Name</th>
                <th>No. of Companies Outreached</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>
                  <input type="text" class="form-control text-center" value="2024" readonly>
                </td>
                <td>
                  <input type="text" class="form-control text-center" placeholder="Q1 / Jan">
                </td>
                <td class="fw-semibold">Achievement Count</td>
                <td><input type="radio" name="achievement_option" value="date" class="form-check-input" checked></td>
                <td><input type="radio" name="achievement_option" value="activity" class="form-check-input"></td>
                <td><input type="radio" name="achievement_option" value="companies" class="form-check-input"></td>
              </tr>
            </tbody>
          </table>
        </div>

        <!-- Column & Sub Component -->
        <div class="table-responsive">
          <table class="table table-bordered small">
            <thead class="table-light">
              <tr>
                <th>Column Name</th>
                <th>Sub Component Achievement</th>
              </tr>
            </thead>
            <tbody>
              @foreach (['Date', 'Activity Name', 'No. of Companies outreached'] as $column)
              <tr>
                <td>{{ $column }}</td>
                <td>
                  <label class="form-label">Please select one option below:</label>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="subComponent4_{{ $loop->index }}" value="companies">
                    <label class="form-check-label">No. of companies assisted</label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="subComponent4_{{ $loop->index }}" value="programmes">
                    <label class="form-check-label">No. of programmes</label>
                  </div>
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="subComponent4_{{ $loop->index }}" value="sales">
                    <label class="form-check-label">No. of export sales</label>
                  </div>
                  
                  <div class="form-check">
                    <input class="form-check-input" type="radio" name="subComponent4_{{ $loop->index }}" value="none" checked>
                    <label class="form-check-label">None</label>
                  </div>
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
      <!-- END: Indicator Details Section -->

      <!-- Save Button -->
      <div class="text-end">
        <button type="button" class="btn btn-primary">Save</button>
      </div>

    </div> <!-- end card-body -->
  </div> <!-- end card -->
</div> <!-- end container -->
@endsection
