@extends('layouts/contentNavbarLayout')

@section('title', 'Create Report')

@section('content')
<div class="container-fluid">
  <div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h4 class="fw-bold mb-0">Create Report</h4>
          <a href="{{ route('kpiAdmin-edit-report') }}" class="btn btn-secondary">
            <i class="bx bx-arrow-back me-1"></i>Back to Reports
          </a>
        </div>
        <div class="card-body">
          <form id="createReportForm" method="POST" action="{{ route('kpiAdmin-edit-report') }}">
            @csrf

            <!-- Division, Section, Unit Row -->
            <div class="row mb-4">
              <div class="col-md-4">
                <label for="division" class="form-label fw-semibold">
                  Division <span class="text-danger">*</span>
                </label>
                <select class="form-select" id="division" name="division" required>
                  <option value="">STRATEGIC PLANNING DIVISION</option>
                  <option value="hr">HR DIVISION</option>
                  <option value="finance">FINANCE DIVISION</option>
                  <option value="operations">OPERATIONS DIVISION</option>
                </select>
              </div>
              
              <div class="col-md-4">
                <label for="section" class="form-label fw-semibold">
                  Section <span class="text-danger">*</span>
                </label>
                <select class="form-select" id="section" name="section" required>
                  <option value="">COORDINATION AND MONITORING SECTION</option>
                  <option value="planning">PLANNING SECTION</option>
                  <option value="analysis">ANALYSIS SECTION</option>
                  <option value="evaluation">EVALUATION SECTION</option>
                </select>
              </div>
              
              <div class="col-md-4">
                <label for="unit" class="form-label fw-semibold">
                  Unit <span class="text-danger">*</span>
                </label>
                <select class="form-select" id="unit" name="unit" required>
                  <option value="">PERFORMANCE MONITORING UNIT</option>
                  <option value="data-analysis">DATA ANALYSIS UNIT</option>
                  <option value="reporting">REPORTING UNIT</option>
                  <option value="quality-assurance">QUALITY ASSURANCE UNIT</option>
                </select>
              </div>
            </div>

             <!-- Title -->
            <div class="row mb-4">
              <div class="col-12">
                <label for="title" class="form-label fw-semibold">
                  Title <span class="text-danger">*</span>
                </label>
                <input type="text" class="form-control" id="title" name="title" required placeholder="Enter report title">
              </div>
            </div>

              <!-- Indicator Selection (Replaced Sub-Title) -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <label for="indicator" class="form-label fw-semibold">
                                        Indicator <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select" id="indicator" name="indicator" required>
                                        <option value="">Please Select Indicator</option>
                                        <option value="Type1">Type 1</option>
                                        <option value="Type2">Type 2</option>
                                        <option value="Type3">Type 3</option>
                                        <option value="Type4">Type 4</option>
                                        <option value="Type5">Type 5</option>
                                        <option value="Type6">Type 6</option>
                                    </select>
                                </div>
                            </div>

                             <!-- Category -->
                            <div class="row mb-4">
                                <div class="col-12">
                                    <label for="category" class="form-label fw-semibold">
                                        Category <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select" id="category" name="category" required>
                                        <option value="">Please Select Category</option>
                                        <option value="customer">Customer</option>
                                        <option value="finance">Finance</option>
                                        <option value="people">People</option>
                                        <option value="process">Process</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Year and Quarter Row -->
                            <div class="row mb-4">
                                <div class="col-md-6">
                                    <label for="year" class="form-label fw-semibold">
                                        Year <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select" id="year" name="year" required>
                                        <option value="">Please Select Year</option>
                                        <option value="2020">2020</option>
                                        <option value="2021">2021</option>
                                        <option value="2022">2022</option>
                                        <option value="2023">2023</option>
                                        <option value="2024">2024</option>
                                        <option value="2025">2025</option>
                                        <option value="2026">2026</option>
                                        <option value="2027">2027</option>
                                    </select>
                                </div>
                                
                                <div class="col-md-6">
                                    <label for="quarter" class="form-label fw-semibold">
                                        Quarter <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select" id="quarter" name="quarter" required>
                                        <option value="">Please Select Quarter</option>
                                        <option value="Q1">Q1 (January - March)</option>
                                        <option value="Q2">Q2 (April - June)</option>
                                        <option value="Q3">Q3 (July - September)</option>
                                        <option value="Q4">Q4 (October - December)</option>
                                    </select>
                                </div>
                            </div>

                            <!-- Report Type / Query Mapping -->
                           <!-- <div class="row mb-4">
                                <div class="col-12">
                                    <label for="reportType" class="form-label fw-semibold">
                                        Report Type / Query Mapping <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select" id="reportType" name="report_type" required>
                                        <option value="">Please Select</option>
                                        <option value="performance">Performance Report</option>
                                        <option value="financial">Financial Report</option>
                                        <option value="operational">Operational Report</option>
                                        <option value="strategic">Strategic Report</option>
                                        <option value="compliance">Compliance Report</option>
                                    </select>
                                </div>
                            </div>-->
            <!-- Report Type / Query Mapping -->
            <!-- <div class="row mb-4">
              <div class="col-12">
                <label for="reportType" class="form-label fw-semibold">
                  Report Type / Query Mapping <span class="text-danger">*</span>
                </label>
                <select class="form-select" id="reportType" name="report_type" required>SUB
                  <option value="">Please Select</option>
                  <option value="performance">Performance Report</option>
                  <option value="financial">Financial Report</option>
                  <option value="operational">Operational Report</option>
                  <option value="strategic">Strategic Report</option>
                  <option value="compliance">Compliance Report</option>
                </select>
              </div>
            </div>-->

            <!-- Type -->
            <div class="row mb-4">
              <div class="col-12">
                <label for="type" class="form-label fw-semibold">
                  Type <span class="text-danger">*</span>
                </label>
                <div class="form-control bg-light">Table</div>
                <input type="hidden" id="type" name="type" value="table">
              </div>
            </div>

            <!-- Data Configuration Table (shown when Table is selected) -->
            <div id="dataTableSection" class="row mb-4" style="display: block;">
              <div class="col-12">
                <div class="table-responsive">
                  <table class="table table-bordered data-config-table" id="dataTable">
                    <thead>
                      <tr class="table-header">
                        <th class="data-column">Data</th>
                        <th class="use-column">Use</th>
                        <th class="direction-column">Direction</th>
                        <th class="split-column">Split</th>
                        <th class="action-column">Action</th>
                      </tr>
                    </thead>
                    <tbody>
                      <tr class="data-row">
                        <td class="data-field">No</td>
                        <td class="use-field">
                          <input type="checkbox" class="form-check-input" name="data_use[]" value="no">
                        </td>
                        <td class="direction-field">
                          <select class="form-select direction-select" name="data_direction[]">
                            <option value="row" selected>Row</option>
                            <option value="column">Column</option>
                          </select>
                        </td>
                        <td class="split-field">
                          <input type="checkbox" class="form-check-input" name="data_split[]" value="no">
                        </td>
                        <td class="action-field"></td>
                      </tr>
                      <tr class="data-row">
                        <td class="data-field">Programme</td>
                        <td class="use-field">
                          <input type="checkbox" class="form-check-input" name="data_use[]" value="programme" checked>
                        </td>
                        <td class="direction-field">
                          <select class="form-select direction-select" name="data_direction[]">
                            <option value="row" selected>Row</option>
                            <option value="column">Column</option>
                          </select>
                        </td>
                        <td class="split-field">
                          <input type="checkbox" class="form-check-input" name="data_split[]" value="programme">
                        </td>
                        <td class="action-field"></td>
                      </tr>
                      <tr class="data-row">
                        <td class="data-field">Exporter Target</td>
                        <td class="use-field">
                          <input type="checkbox" class="form-check-input" name="data_use[]" value="exporter_target">
                        </td>
                        <td class="direction-field">
                          <select class="form-select direction-select" name="data_direction[]">
                            <option value="row" selected>Row</option>
                            <option value="column">Column</option>
                          </select>
                        </td>
                        <td class="split-field">
                          <input type="checkbox" class="form-check-input" name="data_split[]" value="exporter_target">
                        </td>
                        <td class="action-field"></td>
                      </tr>
                      <tr class="data-row">
                        <td class="data-field">Exporter Achievement</td>
                        <td class="use-field">
                          <input type="checkbox" class="form-check-input" name="data_use[]" value="exporter_achievement">
                        </td>
                        <td class="direction-field">
                          <select class="form-select direction-select" name="data_direction[]">
                            <option value="row" selected>Row</option>
                            <option value="column">Column</option>
                          </select>
                        </td>
                        <td class="split-field">
                          <input type="checkbox" class="form-check-input" name="data_split[]" value="exporter_achievement">
                        </td>
                        <td class="action-field"></td>
                      </tr>
                      <tr class="data-row">
                        <td class="data-field">Exporter Performance</td>
                        <td class="use-field">
                          <input type="checkbox" class="form-check-input" name="data_use[]" value="exporter_performance">
                        </td>
                        <td class="direction-field">
                          <select class="form-select direction-select" name="data_direction[]">
                            <option value="row" selected>Row</option>
                            <option value="column">Column</option>
                          </select>
                        </td>
                        <td class="split-field">
                          <input type="checkbox" class="form-check-input" name="data_split[]" value="exporter_performance">
                        </td>
                        <td class="action-field"></td>
                      </tr>
                      <tr class="data-row">
                        <td class="data-field">Activities Target</td>
                        <td class="use-field">
                          <input type="checkbox" class="form-check-input" name="data_use[]" value="activities_target">
                        </td>
                        <td class="direction-field">
                          <select class="form-select direction-select" name="data_direction[]">
                            <option value="row" selected>Row</option>
                            <option value="column">Column</option>
                          </select>
                        </td>
                        <td class="split-field">
                          <input type="checkbox" class="form-check-input" name="data_split[]" value="activities_target">
                        </td>
                        <td class="action-field"></td>
                      </tr>
                      <tr class="data-row">
                        <td class="data-field">Activities Achievement</td>
                        <td class="use-field">
                          <input type="checkbox" class="form-check-input" name="data_use[]" value="activities_achievement">
                        </td>
                        <td class="direction-field">
                          <select class="form-select direction-select" name="data_direction[]">
                            <option value="row" selected>Row</option>
                            <option value="column">Column</option>
                          </select>
                        </td>
                        <td class="split-field">
                          <input type="checkbox" class="form-check-input" name="data_split[]" value="activities_achievement">
                        </td>
                        <td class="action-field"></td>
                      </tr>
                      <tr class="data-row">
                        <td class="data-field">Activities Performance</td>
                        <td class="use-field">
                          <input type="checkbox" class="form-check-input" name="data_use[]" value="activities_performance">
                        </td>
                        <td class="direction-field">
                          <select class="form-select direction-select" name="data_direction[]">
                            <option value="row" selected>Row</option>
                            <option value="column">Column</option>
                          </select>
                        </td>
                        <td class="split-field">
                          <input type="checkbox" class="form-check-input" name="data_split[]" value="activities_performance">
                        </td>
                        <td class="action-field"></td>
                      </tr>
                      <tr class="data-row">
                        <td class="data-field">Budget Target</td>
                        <td class="use-field">
                          <input type="checkbox" class="form-check-input" name="data_use[]" value="budget_target">
                        </td>
                        <td class="direction-field">
                          <select class="form-select direction-select" name="data_direction[]">
                            <option value="row" selected>Row</option>
                            <option value="column">Column</option>
                          </select>
                        </td>
                        <td class="split-field">
                          <input type="checkbox" class="form-check-input" name="data_split[]" value="budget_target">
                        </td>
                        <td class="action-field"></td>
                      </tr>
                      <tr class="data-row">
                        <td class="data-field">Budget Achievement</td>
                        <td class="use-field">
                          <input type="checkbox" class="form-check-input" name="data_use[]" value="budget_achievement">
                        </td>
                        <td class="direction-field">
                          <select class="form-select direction-select" name="data_direction[]">
                            <option value="row" selected>Row</option>
                            <option value="column">Column</option>
                          </select>
                        </td>
                        <td class="split-field">
                          <input type="checkbox" class="form-check-input" name="data_split[]" value="budget_achievement">
                        </td>
                        <td class="action-field"></td>
                      </tr>
                      <tr class="data-row">
                        <td class="data-field">Budget Performance</td>
                        <td class="use-field">
                          <input type="checkbox" class="form-check-input" name="data_use[]" value="budget_performance">
                        </td>
                        <td class="direction-field">
                          <select class="form-select direction-select" name="data_direction[]">
                            <option value="row" selected>Row</option>
                            <option value="column">Column</option>
                          </select>
                        </td>
                        <td class="split-field">
                          <input type="checkbox" class="form-check-input" name="data_split[]" value="budget_performance">
                        </td>
                        <td class="action-field"></td>
                      </tr>
                    </tbody>
                  </table>
                  <div class="mt-3">
                    <button type="button" class="btn btn-primary" onclick="addCustomDataRow()">
                      <i class="bx bx-plus me-1"></i>Add Custom Data
                    </button>
                  </div>
                </div>
              </div>
            </div>

            <!-- Remark -->
            <div class="row mb-4">
              <div class="col-12">
                <label for="remark" class="form-label fw-semibold">
                  Remark (Optional)
                </label>
                <textarea class="form-control" id="remark" name="remark" rows="4" placeholder="Enter any additional remarks or comments about this report..."></textarea>
              </div>
            </div>

            <!-- Action Buttons -->
            <div class="row">
              <div class="col-12">
                <div class="d-flex justify-content-end gap-2">
                  <button type="button" class="btn btn-outline-secondary" onclick="window.history.back()">
                    Cancel
                  </button>
                  <button type="submit" class="btn btn-primary">
                    <i class="bx bx-save me-1"></i>Create Report
                  </button>
                </div>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  document.addEventListener('DOMContentLoaded', function() {
    // Form validation
    const form = document.getElementById('createReportForm');
    form.addEventListener('submit', function(e) {
      if (!form.checkValidity()) {
        e.preventDefault();
        e.stopPropagation();
      }
      form.classList.add('was-validated');
    });
  });

  function addCustomDataRow() {
    const tbody = document.querySelector('#dataTable tbody');
    const newRow = document.createElement('tr');
    newRow.classList.add('data-row');
    newRow.innerHTML = `
      <td class="data-field">
        <input type="text" class="form-control form-control-sm" placeholder="Enter custom data field" required>
      </td>
      <td class="use-field">
        <input type="checkbox" class="form-check-input" name="data_use[]" value="">
      </td>
      <td class="direction-field">
        <select class="form-select form-select-sm direction-select" name="data_direction[]">
          <option value="row" selected>Row</option>
          <option value="column">Column</option>
        </select>
      </td>
      <td class="split-field">
        <input type="checkbox" class="form-check-input" name="data_split[]" value="">
      </td>
      <td class="action-field">
        <button type="button" class="btn btn-sm btn-danger" onclick="removeCustomDataRow(this)">
          <i class="bx bx-trash"></i>
        </button>
      </td>
    `;
    tbody.appendChild(newRow);
  }

  function removeCustomDataRow(button) {
    button.closest('tr').remove();
  }

  function addDataRow() {
    const tbody = document.querySelector('#dataTable tbody');
    const newRow = document.createElement('tr');
    newRow.innerHTML = `
        <td>
            <input type="text" class="form-control" name="data_fields[]" placeholder="Enter data field">
        </td>
        <td>
            <select class="form-select form-select-sm" name="data_use[]">
                <option value="">Select</option>
                <option value="primary">Primary</option>
                <option value="secondary">Secondary</option>
                <option value="reference">Reference</option>
            </select>
        </td>
        <td>
            <select class="form-select form-select-sm" name="data_direction[]">
                <option value="">Select</option>
                <option value="ascending">Ascending</option>
                <option value="descending">Descending</option>
            </select>
        </td>
        <td>
            <select class="form-select form-select-sm" name="data_split[]">
                <option value="">Select</option>
                <option value="yes">Yes</option>
                <option value="no">No</option>
            </select>
        </td>
        <td>
            <button type="button" class="btn btn-sm btn-danger remove-row" onclick="removeDataRow(this)">
                <i class="bx bx-trash"></i>
            </button>
        </td>
    `;
    tbody.appendChild(newRow);
  }

  function removeDataRow(button) {
    const tbody = document.querySelector('#dataTable tbody');
    if (tbody.children.length > 1) {
      button.closest('tr').remove();
    } else {
      alert('At least one data field is required.');
    }
  }
</script>

<style>
  .card {
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    border: 1px solid rgba(0, 0, 0, 0.125);
  }

  .form-label.fw-semibold {
    color: #495057;
    margin-bottom: 0.5rem;
  }

  .table-responsive {
    border-radius: 0.375rem;
  }

  .badge {
    font-size: 0.75rem;
    padding: 0.25rem 0.5rem;
  }

  .btn-sm {
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
  }

  .form-select-sm {
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
  }

  #dataTable {
    border: 1px solid #dee2e6;
  }

  #dataTable th,
  #dataTable td {
    border: 1px solid #dee2e6;
    background-color: #f8f9fa;
    font-weight: 600;
    vertical-align: middle;
  }

  #dataTable td {
    background-color: #fff;
    font-weight: normal;
  }

  .remove-row:hover {
    transform: scale(1.05);
    transition: transform 0.2s ease;
  }

  .form-check-label {
    cursor: pointer;
  }

  textarea.form-control {
    resize: vertical;
    min-height: 100px;
  }

  .text-danger {
    color: #dc3545 !important;
  }
</style>
@endsection