@extends('layouts/contentNavbarLayout')

@section('title', 'User Access Configuration')

@php
  $breadcrumbs = [
    ['label' => 'Dashboard', 'url' => route('dashboard-analytics')],
    ['label' => 'KPI Administration'],
    ['label' => 'KPI Access Configuration']
  ];
@endphp

@section('content')

@include('layouts.partials.page-header', [
  'title' => 'KPI Access Configuration',
  'slot' => view('layouts.partials.breadcrumb', compact('breadcrumbs'))
])

<!-- Choices.js CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/choices.js/public/assets/styles/choices.min.css" />

@section('content')
<!-- Choices.js JS -->
<script src="https://cdn.jsdelivr.net/npm/choices.js/public/assets/scripts/choices.min.js"></script>
<div class="container py-4">

  <div class="card shadow-sm rounded-3">
    <div class="card-body">
         <h4>Edit User Access</h4>
      <form id="editUserForm">
        <!-- Name -->
        <div class="mb-3">
          <label for="name" class="form-label">Name:</label>
          <input type="text" class="form-control" id="name" name="name">
        </div>

        <!-- Email -->
        <div class="mb-3">
          <label for="email" class="form-label">Email:</label>
          <input type="email" class="form-control" id="email" name="email">
        </div>

        <!-- Division -->
        <div class="mb-3">
          <label for="division" class="form-label">Division:</label>
          <input type="text" class="form-control" id="division" name="division">
        </div>

        <!-- Section -->
        <div class="mb-3">
          <label for="section" class="form-label">Section:</label>
          <input type="text" class="form-control" id="section" name="section">
        </div>

        <!-- Unit/Office -->
        <div class="mb-3">
          <label for="unitOffice" class="form-label">Unit/Office:</label>
          <input type="text" class="form-control" id="unitOffice" name="unitOffice">
        </div>

        <!-- Roles -->
        <div class="mb-3">
        <label for="role" class="form-label">Role:</label>
        <select id="role" name="roles[]" multiple class="form-select">
            <option value="PMU Admin">PMU Admin</option>
            <option value="IT Admin">IT Admin</option>
            <option value="MATRADE Employee">MATRADE Employee</option>
        </select>
        </div>


        <!-- Access Status -->
        <div class="mb-3">
          <label for="accessStatus" class="form-label">Access Status:</label>
          <select class="form-select" id="accessStatus" name="accessStatus">
            <option value="Active">Active</option>
            <option value="Inactive">Inactive</option>
            <option value="Suspended">Suspended</option>
          </select>
        </div>
    <br>
        <!-- User's Roles -->
        <div class="mb-3">
        <label class="form-label fs-5">User roles</label> <br><br>

              @php
          $availableRoles = [
            'KPI Administration' => [
              'Save KPI Configuration(s)',
              'View KPI Configuration(s)',
              'Update KPI Configuration(s)',
              'Delete New Category',
              'View User Roles',
              'Assign/Reassign User Role and Access',
              'Enable/Disable Existing User Access',
            ],
            'KPI Indicator' => [
              'View KPI Indicator(s)',
              'Reject KPI Indicator(s)',
              'Endorse KPI Indicator(s)',
              'Update Status With Remark',
              'Assign Indicator Type and Info',
              'Upload & View Attachments',
              'Print KPI Indicator(s)',
              'Export KPI indicator(s)',
            ],
            'KPI Achievement' => [
              'View KPI Achievement(s)',
              'Upload & Download Attachment(s)',
              'Accept / Accept With condition on KPI Achievement(s)',
              'Endorse KPI Achievement(s)',
              'Print KPI Achievement(s)',
              'Export KPI Achievement(s)',
              'Disable/Enable KPI Indicator Based From Achievement(s)',
            ],
            'KPI Dashboard' => [
              'View Report(s)',
              'Print Report(s)',
              'Export Report(s)',
            ],
            'KPI Reporting' => [
              'View Report(s)',
              'Add Anotations',
              'Update Report (via SQL only)',
              'Remove Report',
              'Print Report',
              'Export Report',
              'Share/Unshare Report',
              'Create Report',
            ],
          ];
        @endphp

        @foreach ($availableRoles as $module => $roles)
          <div class="mb-4">
            <h5 class="fw-bold">{{ $module }}</h5>

            <div class="table-responsive">
              <table class="table align-middle">
                <thead class="table-light">
                  <tr>
                    <th>Permission</th>
                    <th class="text-end">Active</th>
                  </tr>
                </thead>
                <tbody>
                  @foreach ($roles as $role)
                    <tr>
                      <td>{{ $role }}</td>
                      <td class="text-end">
                        <div class="form-check form-switch d-inline-block">
                          <input class="form-check-input" type="checkbox" name="roles[]" value="{{ $role }}" id="role_{{ \Str::slug($role) }}">
                        </div>
                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>
        @endforeach

      </tbody>
    </table>
  </div>

        <div class="d-flex justify-content-end">
        <button type="submit" class="btn btn-primary">
          <i class="bx bx-refresh me-1"></i> Update Details
        </button>
      </div>
      </form>
    </div>
  </div>
</div>
        </div>

<script>
   document.addEventListener('DOMContentLoaded', function () {
    new Choices('#role', {
      removeItemButton: true,
      placeholderValue: '',
      maxItemCount: 5,
      searchEnabled: false,
      shouldSort: false
    });
  });
</script>


@endsection
