<div class="card-body p-5"> <!-- Changed from p-0 to p-3 -->
    <div class="list-group list-group-flush">


        <!-- Main KPI Configuration Options -->
        <div class="row">
            <div class="col-12">

                <!-- System Configuration Section -->
                <div class="card mb-4">
                    <!-- <div class="card-header bg-primary text-white">-->
                    <div class="card-header bg-primary text-white" style="color:white;">
                        <h5 class="mb-0" style="color: white;">System Configuration</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="list-group list-group-flush">
                            <!-- Configure Duration Setup -->
                            <a href="javascript:void(0);" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center"
                                onclick="toggleDurationSetup()">
                                <div>Configure Duration Setup</div>
                                <i class="bx bx-chevron-right"></i>
                            </a>

                            <!-- Duration Setup Detail Section (Hidden by default) -->
                            <div class="row mt-4" id="durationSetupDetail" style="display: none;">
                                <div class="col-12">
                                    <div class="card mb-4">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-center mb-4">
                                                <h5 class="card-title mb-0">Configure Duration Setup</h5>
                                            </div>

                                            <form id="durationSetupForm" method="POST" action="{{ url('/kpi-configuration/duration-setup') }}">
                                                @csrf

                                                <div class="row mb-4">
                                                    <label for="year" class="col-md-2 col-form-label">Duration Type for Year:</label>
                                                    <div class="col-md-4">
                                                        <select class="form-select" id="year" name="year">
                                                            <option value="2024" selected>2025</option>
                                                            <option value="2025">2024</option>
                                                            <option value="2026">2023</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="row mb-4">
                                                    <div class="col-md-4">
                                                        <div class="form-check mb-2">
                                                            <input class="form-check-input" type="radio" name="durationType" id="quarterly" value="quarterly" checked>
                                                            <label class="form-check-label" for="quarterly">
                                                                Quarterly
                                                            </label>
                                                        </div>
                                                        <div class="form-check mb-2">
                                                            <input class="form-check-input" type="radio" name="durationType" id="annually" value="annually">
                                                            <label class="form-check-label" for="annually">Annually</label>
                                                        </div>
                                                        <div class="form-check mb-2">
                                                            <input class="form-check-input" type="radio" name="durationType" id="biannually" value="bi-annually">
                                                            <label class="form-check-label" for="biannually">Bi-Annually</label>
                                                        </div>
                                                    </div>
                                                </div>

                                                
                                                <div class="table-responsive mb-4" id="quarterlyTable">
                                                    <table class="table table-bordered">
                                                        <thead class="table-light">
                                                            <tr>
                                                                <th class="text-uppercase">QUARTER</th>
                                                                <th class="text-uppercase">START DATE</th>
                                                                <th class="text-uppercase">END DATE</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr>
                                                                <td>Q1 (January - March)</td>
                                                                <td>01/01/2024</td>
                                                                <td>31/03/2024</td>
                                                            </tr>
                                                            <tr>
                                                                <td>Q2 (April - June)</td>
                                                                <td>01/04/2024</td>
                                                                <td>30/06/2024</td>
                                                            </tr>
                                                            <tr>
                                                                <td>Q3 (July - September)</td>
                                                                <td>01/07/2024</td>
                                                                <td>30/09/2024</td>
                                                            </tr>
                                                            <tr>
                                                                <td>Q4 (October - December)</td>
                                                                <td>01/10/2024</td>
                                                                <td>31/12/2024</td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <!-- Annually Table -->
                                        <div class="table-responsive mb-4" id="annuallyTable" style="display: none;">
                                            <table class="table table-bordered">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th class="text-uppercase">MONTH GROUP</th>
                                                        <th class="text-uppercase">START MONTH</th>
                                                        <th class="text-uppercase">END MONTH</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>H1</td>
                                                        <td>January</td>
                                                        <td>December</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>

                                        <!-- Bi-Annually Table -->
                                        <div class="table-responsive mb-4" id="biAnnuallyTable" style="display: none;">
                                            <table class="table table-bordered">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th class="text-uppercase">MONTH GROUP</th>
                                                        <th class="text-uppercase">START MONTH</th>
                                                        <th class="text-uppercase">END MONTH</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>H1</td>
                                                        <td>January</td>
                                                        <td>June</td>
                                                    </tr>
                                                    <tr>
                                                        <td>H2</td>
                                                        <td>July</td>
                                                        <td>December</td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>



                                        <!-- Save Button
                                        <div class="d-flex justify-content-end">
                                            <button type="submit" class="btn btn-primary">Save</button>
                                        </div>
                                    </form> -->

                                                <div class="d-flex justify-content-end">
                                                    <button type="submit" class="btn btn-primary">Save</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Percentage Target Achievement -->
                            <a href="javascript:void(0);" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center"
                                onclick="togglePercentageTarget()">
                                <div>Percentage Target Achievement</div>
                                <i class="bx bx-chevron-right"></i>
                            </a>

                            <!-- Percentage Target Achievement Detail Section (Hidden by default) -->
                            <div class="row mt-4" id="percentageTargetDetail" style="display: none;">
                                <div class="col-12">
                                    <div class="card mb-4">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-center mb-4">
                                                <h5 class="card-title mb-0">Percentage Target Achievement</h5>

                                            </div>

                                            <!-- Year Selection Form -->
                                            <form id="yearSelectionForm" class="mb-4">
                                                <div class="row mb-3">
                                                    <label for="selectYear" class="col-md-2 col-form-label">Year:</label>
                                                    <div class="col-md-4">
                                                        <select class="form-select" id="selectYear" name="selectYear" onchange="this.form.submit()">
                                                            <option value="2023">2025</option>
                                                            <option value="2024" selected>2024</option>
                                                            <option value="2025">2023</option>
                                                            <option value="2026">2022</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </form>

                                            <div class="mb-4">
                                            <div class="d-flex align-items-center mb-3">
                                                <!-- Circle Preview -->
                                                <div id="colorPreviewGreen" class="me-2" style="width: 16px; height: 16px; border-radius: 50%; background-color: green;"></div>

                                                <!-- Label + Edit Icon -->
                                                <h6 class="mb-0">
                                                Indicator Color: <span id="colorLabelGreen">Green</span>
                                                <i class="bx bx-edit-alt ms-2 text-primary cursor-pointer" data-bs-toggle="modal" data-bs-target="#colorPickerModalGreen"></i>
                                                </h6>
                                            </div>

                                                <div class="table-responsive">
                                                    <table class="table table-bordered">
                                                        <thead class="table-light">
                                                            <tr>
                                                                <th class="text-uppercase">QUARTER/MONTH GROUP</th>
                                                                <th class="text-uppercase">PERCENTAGE</th>
                                                                <th class="text-uppercase">ACTION</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr>
                                                                <td>1</td>
                                                                <td>25% & above</td>
                                                                <td>
                                                                    <button type="button" class="btn btn-primary btn-sm"
                                                                        onclick="showEditModal('green', 1, '25% & above')">
                                                                        <i class="bx bx-edit"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>2</td>
                                                                <td>50% & above</td>
                                                                <td>
                                                                    <button type="button" class="btn btn-primary btn-sm"
                                                                        onclick="showEditModal('green', 2, '50% & above')">
                                                                        <i class="bx bx-edit"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>3</td>
                                                                <td>75% & above</td>
                                                                <td>
                                                                    <button type="button" class="btn btn-primary btn-sm"
                                                                        onclick="showEditModal('green', 3, '75% & above')">
                                                                        <i class="bx bx-edit"></i>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>4</td>
                                                                <td>100% & above</td>
                                                                <td>
                                                                    <button type="button" class="btn btn-primary btn-sm"
                                                                        onclick="showEditModal('green', 4, '100% & above')">
                                                                        <i class="bx bx-edit"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            <!-- MODAL COLOR PICKER (GREEN) -->
                                            <div class="modal fade" id="colorPickerModalGreen" tabindex="-1" aria-labelledby="colorPickerModalGreenLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Choose Indicator Color</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body text-center">
                                                    <input type="color" id="colorInputGreen" class="form-control form-control-color" value="#28a745" style="width: 100px; height: 60px;">
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-sm btn-primary" onclick="saveColor('Green')" data-bs-dismiss="modal">Save</button>
                                                </div>
                                                </div>
                                            </div>
                                            </div>

                                           <!-- YELLOW INDICATOR -->
                                            <div class="mb-4">
                                            <div class="d-flex align-items-center mb-3">
                                                <!-- Circle Preview -->
                                                <div id="colorPreviewYellow" class="me-2" style="width: 16px; height: 16px; border-radius: 50%; background-color: #FFD700;"></div>

                                                <!-- Label + Edit Icon -->
                                                <h6 class="mb-0">
                                                Indicator Color: <span id="colorLabelYellow">Yellow</span>
                                                <i class="bx bx-edit-alt ms-2 text-primary cursor-pointer" data-bs-toggle="modal" data-bs-target="#colorPickerModalYellow"></i>
                                                </h6>
                                            </div>

                                                <div class="table-responsive">
                                                    <table class="table table-bordered">
                                                        <thead class="table-light">
                                                            <tr>
                                                                <th class="text-uppercase">QUARTER/MONTH GROUP</th>
                                                                <th class="text-uppercase">PERCENTAGE</th>
                                                                <th class="text-uppercase">ACTION</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr>
                                                                <td>1</td>
                                                                <td>Between 13% and 24%</td>
                                                                <td>
                                                                    <button type="button" class="btn btn-primary btn-sm"
                                                                        onclick="showEditModal('yellow', 1, 'Between 13% and 24%')">
                                                                        <i class="bx bx-edit"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>2</td>
                                                                <td>Between 25% and 49%</td>
                                                                <td>
                                                                    <button type="button" class="btn btn-primary btn-sm"
                                                                        onclick="showEditModal('yellow', 2, 'Between 25% and 49%')">
                                                                        <i class="bx bx-edit"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>3</td>
                                                                <td>Between 50% and 74%</td>
                                                                <td>
                                                                    <button type="button" class="btn btn-primary btn-sm"
                                                                        onclick="showEditModal('yellow', 3, 'Between 50% and 74%')">
                                                                        <i class="bx bx-edit"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>4</td>
                                                                <td>Between 75% and 99%</td>
                                                                <td>
                                                                    <button type="button" class="btn btn-primary btn-sm"
                                                                        onclick="showEditModal('yellow', 4, 'Between 75% and 99%')">
                                                                        <i class="bx bx-edit"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            <!-- MODAL COLOR PICKER (YELLOW) -->
                                            <div class="modal fade" id="colorPickerModalYellow" tabindex="-1" aria-labelledby="colorPickerModalYellowLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Choose Indicator Color (Yellow)</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body text-center">
                                                    <input type="color" id="colorInputYellow" class="form-control form-control-color" value="#FFD700" style="width: 100px; height: 60px;">
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-sm btn-primary" onclick="saveColor('Yellow')" data-bs-dismiss="modal">Save</button>
                                                </div>
                                                </div>
                                            </div>
                                            </div>

                                           <!-- RED INDICATOR -->
                                            <div class="mb-4">
                                            <div class="d-flex align-items-center mb-3">
                                                <!-- Circle Preview -->
                                                <div id="colorPreviewRed" class="me-2" style="width: 16px; height: 16px; border-radius: 50%; background-color: red;"></div>

                                                <!-- Label + Edit Icon -->
                                                <h6 class="mb-0">
                                                Indicator Color: <span id="colorLabelRed">Red</span>
                                                <i class="bx bx-edit-alt ms-2 text-primary cursor-pointer" data-bs-toggle="modal" data-bs-target="#colorPickerModalRed"></i>
                                                </h6>
                                            </div>

                                                <div class="table-responsive">
                                                    <table class="table table-bordered">
                                                        <thead class="table-light">
                                                            <tr>
                                                                <th class="text-uppercase">QUARTER/MONTH GROUP</th>
                                                                <th class="text-uppercase">PERCENTAGE</th>
                                                                <th class="text-uppercase">ACTION</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr>
                                                                <td>1</td>
                                                                <td>12% & below</td>
                                                                <td>
                                                                    <button type="button" class="btn btn-primary btn-sm"
                                                                        onclick="showEditModal('red', 1, '12% & below')">
                                                                        <i class="bx bx-edit"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>2</td>
                                                                <td>24% & below</td>
                                                                <td>
                                                                    <button type="button" class="btn btn-primary btn-sm"
                                                                        onclick="showEditModal('red', 2, '24% & below')">
                                                                        <i class="bx bx-edit"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>3</td>
                                                                <td>49% & below</td>
                                                                <td>
                                                                    <button type="button" class="btn btn-primary btn-sm"
                                                                        onclick="showEditModal('red', 3, '49% & below')">
                                                                        <i class="bx bx-edit"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>4</td>
                                                                <td>74% & below</td>
                                                                <td>
                                                                    <button type="button" class="btn btn-primary btn-sm"
                                                                        onclick="showEditModal('red', 4, '74% & below')">
                                                                        <i class="bx bx-edit"></i>
                                                                    </button>
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>

                                            <!-- MODAL COLOR PICKER (RED) -->
                                            <div class="modal fade" id="colorPickerModalRed" tabindex="-1" aria-labelledby="colorPickerModalRedLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Choose Indicator Color (Red)</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body text-center">
                                                    <input type="color" id="colorInputRed" class="form-control form-control-color" value="#ff0000" style="width: 100px; height: 60px;">
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-sm btn-primary" onclick="saveColor('Red')" data-bs-dismiss="modal">Save</button>
                                                </div>
                                                </div>
                                            </div>
                                            </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
</div>

                            <!-- KPI Category -->
                            <a href="javascript:void(0);" onclick="toggleKpiCategorySection()" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                <div>KPI Category</div>
                                <i class="bx bx-chevron-right"></i>
                            </a>

                            <!-- KPI Category Section Start -->
                            <div id="kpiCategorySection" class="mt-3" style="display: none;">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title">KPI Category</h5>

                                        <!-- Year Filter and Add Button -->
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <div>
                                                <label for="filterYear" class="form-label mb-0">Year</label>
                                                <select id="filterYear" class="form-select w-auto">
                                                    <option value="all">All</option>
                                                    <option value="2025">2025</option>
                                                    <option value="2024">2024</option>
                                                </select>
                                            </div>
                                            <button class="btn btn-primary" style="margin-left: 650px;" data-bs-toggle="modal" data-bs-target="#addKpiCategoryModal">Add New Category</button>
                                        </div>

                                        <!-- KPI Table -->
                                        <div class="table-responsive">
                                            <table class="table table-bordered align-middle">
                                                <thead class="table-light">
                                                    <tr>
                                                        <th>No</th>
                                                        <th>Category</th>
                                                        <th>Description</th>
                                                        <th>Status</th>
                                                        <th class="text-center">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody id="kpiCategoryTableBody">
                                                    <tr>
                                                        <td>CAT1</td>
                                                        <td>Customer</td>
                                                        <td style="text-align: justify;">
                                                            This perspective is the appreciation of the importance of customer and stakeholders satisfaction towards
                                                            MATRADE services. Success for MATRADE should be measured by how effectively and efficiently they meet the
                                                            need of their of the Customer's and Stakeholders. Customers and Stakeholders include the agency different
                                                            market or customer segments, minister, ministry and government agencies that have an impact and influence on
                                                            the MATRADE ability to deliver its services.</td>
                                                        <td class="text-center">
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input toggle-switch" type="checkbox" checked>
                                                            </div>
                                                        </td>
                                                        <td class="text-center">
                                                            <button class="btn btn-outline-primary btn-sm" onclick="openUpdateModal('CAT1', 'Customer', 'This perspective is the appreciation of the importance of customer and stakeholders satisfaction towards MATRADE services.')"><i class="bx bx-edit-alt"></i></button>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>CAT2</td>
                                                        <td>Finance</td>
                                                        <td style="text-align: justify;">This perspective measures the ability of MATRADE in its financial stewardship and management which include budget management, revenue growth and mix, cost reduction/productivity improvement, and asset use/investment strategy.</td>
                                                        <td class="text-center">
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input toggle-switch" type="checkbox" checked>
                                                            </div>
                                                        </td>
                                                        <td class="text-center">
                                                            <button class="btn btn-outline-primary btn-sm" onclick="openUpdateModal('CAT2', 'Finance', 'This perspective measures the ability of MATRADE in its financial stewardship and management.')"><i class="bx bx-edit-alt"></i></button>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>CAT3</td>
                                                        <td>Process</td>
                                                        <td style="text-align: justify;">This perspective refers to internal business processes of MATRADE, processes are most critical for MATRADE to achieve its customer and financial objectives. The processes include the innovations process, the operations process, and the service follow up process. It will enable MATRADE to understand how well each of their unit is performing, and whether its activities and services are actually contributing to mission outcomes – to the extent expected.</td>
                                                        <td class="text-center">
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input toggle-switch" type="checkbox" checked>
                                                            </div>
                                                        </td>
                                                        <td class="text-center">
                                                            <button class="btn btn-outline-primary btn-sm" onclick="openUpdateModal('CAT3', 'Process', 'This perspective refers to internal business processes of MATRADE, most critical for achieving its objectives.')"><i class="bx bx-edit-alt"></i></button>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td>CAT4</td>
                                                        <td>People</td>
                                                        <td style="text-align: justify;">This perspective includes employee training and development, cultural attitudes around individual self-improvement and effectiveness in people utilisation. In a knowledge-worker enterprise, It is important to understand that learning is more than training. Employee development programs should include mentoring and coaching programs, accompanied by “good” communications media that allow workers to gain ready access to help as it is needed. Effective people utilization includes return on investment and employees productivity. </td>
                                                        <td class="text-center">
                                                            <div class="form-check form-switch">
                                                                <input class="form-check-input toggle-switch" type="checkbox" checked>
                                                            </div>
                                                        </td>
                                                        <td class="text-center">
                                                            <button class="btn btn-outline-primary btn-sm" onclick="openUpdateModal('CAT4', 'People', 'This perspective includes employee training and development.')"><i class="bx bx-edit-alt"></i></button>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Add KPI Category Modal -->
                            <div class="modal fade" id="addKpiCategoryModal" tabindex="-1" aria-labelledby="addKpiCategoryModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Add New KPI Category</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <form id="kpiCategoryForm">
                                                <div class="mb-3">
                                                    <label for="categoryName" class="form-label">Category</label>
                                                    <input type="text" class="form-control" id="categoryName" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="categoryDescription" class="form-label">Description</label>
                                                    <textarea class="form-control" id="categoryDescription" rows="3" required></textarea>
                                                </div>
                                            </form>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary me-3" data-bs-dismiss="modal">Cancel</button>
                                            <button type="button" class="btn btn-primary" onclick="saveKpiCategory()">Save</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Update KPI Category Modal -->
                            <div class="modal fade" id="updateKpiCategoryModal" tabindex="-1" aria-labelledby="updateKpiCategoryModalLabel" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Update KPI Category</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <input type="hidden" id="updateCategoryId">
                                            <div class="mb-3">
                                                <label for="updateCategoryName" class="form-label">Category</label>
                                                <input type="text" class="form-control" id="updateCategoryName" required>
                                            </div>
                                            <div class="mb-3">
                                                <label for="updateCategoryDescription" class="form-label">Description</label>
                                                <textarea class="form-control" id="updateCategoryDescription" rows="3" required></textarea>
                                            </div>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary me-3" data-bs-dismiss="modal">Cancel</button>
                                            <button type="button" class="btn btn-primary" onclick="saveUpdatedKpiCategory()">Update</button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- JavaScript -->
                            <script>
                                function saveKpiCategory() {
                                    const tableBody = document.getElementById("kpiCategoryTableBody");
                                    const newRow = `<tr>
      <td>CAT${tableBody.rows.length + 1}</td>
      <td>${document.getElementById("categoryName").value}</td>
      <td>${document.getElementById("categoryDescription").value}</td>
      <td class="text-center">
        <div class="form-check form-switch"><input class="form-check-input toggle-switch" type="checkbox" checked></div>
      </td>
      <td class="text-center"><button class="btn btn-outline-primary btn-sm"><i class="bx bx-edit-alt"></i></button></td>
    </tr>`;
                                    tableBody.insertAdjacentHTML("beforeend", newRow);
                                }

                                function openUpdateModal(id, category, description) {
                                    document.getElementById("updateCategoryId").value = id;
                                    document.getElementById("updateCategoryName").value = category;
                                    document.getElementById("updateCategoryDescription").value = description;
                                    const modal = new bootstrap.Modal(document.getElementById("updateKpiCategoryModal"));
                                    modal.show();
                                }
                            </script>

                            <!-- Column Default Setting -->
                            <a href="javascript:void(0);" onclick="toggleColumnDefaultSection(this)" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                <div>Column Default Setting</div>
                                <i class="bx bx-chevron-right"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Column Default Setting -->
                <div class="card" id="columnDefaultSettingSection" style="display: none;">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Column Default Settings</h5>
                        <!-- Save button removed from here -->
                    </div>
                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="kpiModuleSelect" class="form-label">Select KPI Module</label>
                                    <select class="form-select" id="kpiModuleSelect" onchange="showTableColumns()">
                                        <option selected disabled>Select a KPI module</option>
                                        <option value="kpi_indicator">KPI Indicator</option>
                                        <option value="kpi_achievement">KPI Achievement</option>
                                        <option value="kpi_reporting_predefined">KPI Reporting</option>
                                        <option value="kpi_admin_access">KPI Administration - Access Configuration</option>
                                        <option value="kpi_admin_audit">KPI Administration - Operational Audit Trail</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- KPI Indicator Columns -->
                        <div class="column-settings" id="kpi_indicator_columns" style="display: none;">
                            <h6 class="mb-3">KPI Indicator - List of Indicator Columns</h6>
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_no" checked disabled>
                                        <label class="form-check-label" for="indicator_no">No</label>
                                        <span class="badge bg-secondary ms-1" title="Required column">Required</span>
                                    </div>
                                </div>
                                <!-- Column 2: Year -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_year">
                                        <label class="form-check-label" for="indicator_year">Year</label>
                                    </div>
                                </div>

                                <!-- Column 3: Division -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_division">
                                        <label class="form-check-label" for="indicator_division">Division</label>
                                    </div>
                                </div>

                                <!-- Column 4: Section -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_section">
                                        <label class="form-check-label" for="indicator_section">Section</label>
                                    </div>
                                </div>

                                <!-- Column 5: Unit/Office -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_unit_office">
                                        <label class="form-check-label" for="indicator_unit_office">Unit/Office</label>
                                    </div>
                                </div>

                                <!-- Column 6: Indicator -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_indicator">
                                        <label class="form-check-label" for="indicator_indicator">Indicator</label>
                                    </div>
                                </div>

                                <!-- Column 7: Description -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_description">
                                        <label class="form-check-label" for="indicator_description">Description</label>
                                    </div>
                                </div>

                                <!-- Column 8: Submission -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_submission">
                                        <label class="form-check-label" for="indicator_submission">Submission</label>
                                    </div>
                                </div>

                                <!-- Column 9: Annually Target -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_annually_target">
                                        <label class="form-check-label" for="indicator_annually_target">Annually Target</label>
                                    </div>
                                </div>

                                <!-- Column 10: Metric -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_metric">
                                        <label class="form-check-label" for="indicator_metric">Metric</label>
                                    </div>
                                </div>

                                <!-- Column 11: Category -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_category">
                                        <label class="form-check-label" for="indicator_category">Category</label>
                                    </div>
                                </div>

                                <!-- Column 12: Output/Outcome -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_output_outcome">
                                        <label class="form-check-label" for="indicator_output_outcome">Output/Outcome</label>
                                    </div>
                                </div>

                                <!-- Column 13: Indicator Type -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_type">
                                        <label class="form-check-label" for="indicator_type">Indicator Type</label>
                                    </div>
                                </div>

                                <!-- Column 14: Indicator Type Definition -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_type_definition">
                                        <label class="form-check-label" for="indicator_type_definition">Indicator Type Definition</label>
                                    </div>
                                </div>

                                <!-- Column 15: Component Achievement -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_component_achievement">
                                        <label class="form-check-label" for="indicator_component_achievement">Component Achievement</label>
                                    </div>
                                </div>

                                <!-- Column 16: Status -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_status">
                                        <label class="form-check-label" for="indicator_status">Status</label>
                                    </div>
                                </div>

                                <!-- Column 17: PMU Remarks -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="indicator_pmu_remarks">
                                        <label class="form-check-label" for="indicator_pmu_remarks">PMU Remarks</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- KPI Achievement Columns -->
                        <div class="column-settings" id="kpi_achievement_columns" style="display: none;">
                            <h6 class="mb-3">KPI Achievement - List of Achievement Columns</h6>
                            <div class="row">
                                <!-- Column 1: No -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_no" checked disabled>
                                        <label class="form-check-label" for="achievement_no">No</label>
                                        <span class="badge bg-secondary ms-1" title="Required column">Required</span>
                                    </div>
                                </div>

                                <!-- Column 2: Year -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_year">
                                        <label class="form-check-label" for="achievement_year">Year</label>
                                    </div>
                                </div>

                                <!-- Column 3: Division -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_division">
                                        <label class="form-check-label" for="achievement_division">Division</label>
                                    </div>
                                </div>

                                <!-- Column 4: Section -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_section">
                                        <label class="form-check-label" for="achievement_section">Section</label>
                                    </div>
                                </div>

                                <!-- Column 5: Unit/Office -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_unit_office">
                                        <label class="form-check-label" for="achievement_unit_office">Unit/Office</label>
                                    </div>
                                </div>

                                <!-- Column 6: Indicator -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_indicator">
                                        <label class="form-check-label" for="achievement_indicator">Indicator</label>
                                    </div>
                                </div>

                                <!-- Column 7: Description -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_description">
                                        <label class="form-check-label" for="achievement_description">Description</label>
                                    </div>
                                </div>

                                <!-- Column 8: Submission -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_submission">
                                        <label class="form-check-label" for="achievement_submission">Submission</label>
                                    </div>
                                </div>

                                <!-- Column 9: Annually Target -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_annually_target">
                                        <label class="form-check-label" for="achievement_annually_target">Annually Target</label>
                                    </div>
                                </div>

                                <!-- Column 10: Metric -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_metric">
                                        <label class="form-check-label" for="achievement_metric">Metric</label>
                                    </div>
                                </div>

                                <!-- Column 11: Category -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_category">
                                        <label class="form-check-label" for="achievement_category">Category</label>
                                    </div>
                                </div>

                                <!-- Column 12: Output/Outcome -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_output_outcome">
                                        <label class="form-check-label" for="achievement_output_outcome">Output/Outcome</label>
                                    </div>
                                </div>

                                <!-- Column 13: Indicator Type -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_indicator_type">
                                        <label class="form-check-label" for="achievement_indicator_type">Indicator Type</label>
                                    </div>
                                </div>

                                <!-- Column 14: Indicator Type Definition -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_type_definition">
                                        <label class="form-check-label" for="achievement_type_definition">Indicator Type Definition</label>
                                    </div>
                                </div>

                                <!-- Column 15: Component Achievement -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_component_achievement">
                                        <label class="form-check-label" for="achievement_component_achievement">Component Achievement</label>
                                    </div>
                                </div>

                                <!-- Column 16: Status -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_status">
                                        <label class="form-check-label" for="achievement_status">Status</label>
                                    </div>
                                </div>

                                <!-- Column 17: PMU Remarks -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="achievement_pmu_remarks">
                                        <label class="form-check-label" for="achievement_pmu_remarks">PMU Remarks</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- KPI Reporting - Predefined Report Columns -->
                        <div class="column-settings" id="kpi_reporting_predefined_columns" style="display: none;">
                            <h6 class="mb-3">KPI Reporting - List of Reporting Columns</h6>
                            <div class="row">
                                <!-- Column 1: No -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_no" checked disabled>
                                        <label class="form-check-label" for="predefined_no">No</label>
                                        <span class="badge bg-secondary ms-1" title="Required column">Required</span>
                                    </div>
                                </div>

                                <!-- Column 2: Year -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_year">
                                        <label class="form-check-label" for="predefined_year">Year</label>
                                    </div>
                                </div>

                                <!-- Column 3: Division -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_division">
                                        <label class="form-check-label" for="predefined_division">Division</label>
                                    </div>
                                </div>

                                <!-- Column 4: Section -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_section">
                                        <label class="form-check-label" for="predefined_section">Section</label>
                                    </div>
                                </div>

                                <!-- Column 5: Unit/Office -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_unit_office">
                                        <label class="form-check-label" for="predefined_unit_office">Unit/Office</label>
                                    </div>
                                </div>

                                <!-- Column 6: Indicator -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_indicator">
                                        <label class="form-check-label" for="predefined_indicator">Indicator</label>
                                    </div>
                                </div>

                                <!-- Column 7: Description -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_description">
                                        <label class="form-check-label" for="predefined_description">Description</label>
                                    </div>
                                </div>

                                <!-- Column 8: Submission -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_submission">
                                        <label class="form-check-label" for="predefined_submission">Submission</label>
                                    </div>
                                </div>

                                <!-- Column 9: Annually Target -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_annually_target">
                                        <label class="form-check-label" for="predefined_annually_target">Annually Target</label>
                                    </div>
                                </div>

                                <!-- Column 10: Metric -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_metric">
                                        <label class="form-check-label" for="predefined_metric">Metric</label>
                                    </div>
                                </div>

                                <!-- Column 11: Category -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_category">
                                        <label class="form-check-label" for="predefined_category">Category</label>
                                    </div>
                                </div>

                                <!-- Column 12: Output/Outcome -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_output_outcome">
                                        <label class="form-check-label" for="predefined_output_outcome">Output/Outcome</label>
                                    </div>
                                </div>

                                <!-- Column 13: Indicator Type -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_indicator_type">
                                        <label class="form-check-label" for="predefined_indicator_type">Indicator Type</label>
                                    </div>
                                </div>

                                <!-- Column 14: Indicator Type Definition -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_type_definition">
                                        <label class="form-check-label" for="predefined_type_definition">Indicator Type Definition</label>
                                    </div>
                                </div>

                                <!-- Column 15: Component Achievement -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_component_achievement">
                                        <label class="form-check-label" for="predefined_component_achievement">Component Achievement</label>
                                    </div>
                                </div>

                                <!-- Column 16: Status -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_status">
                                        <label class="form-check-label" for="predefined_status">Status</label>
                                    </div>
                                </div>

                                <!-- Column 17: PMU Remarks -->
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="predefined_pmu_remarks">
                                        <label class="form-check-label" for="predefined_pmu_remarks">PMU Remarks</label>
                                    </div>
                                </div>
                            </div>
                        </div>


                        <!-- KPI Administration - Access Configuration Columns -->
                        <div class="column-settings" id="kpi_admin_access_columns" style="display: none;">
                            <h6 class="mb-3">KPI Administration - Access Configuration Columns</h6>
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="access_no" checked disabled>
                                        <label class="form-check-label" for="access_no">No</label>
                                        <span class="badge bg-secondary ms-1" title="Required column">Required</span>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="access_division">
                                        <label class="form-check-label" for="access_division">Division</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="access_section">
                                        <label class="form-check-label" for="access_section">Section</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="access_unit_office">
                                        <label class="form-check-label" for="access_unit_office">Unit/Office</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="access_name">
                                        <label class="form-check-label" for="access_name">Name</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="access_email">
                                        <label class="form-check-label" for="access_email">Email</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="access_roles">
                                        <label class="form-check-label" for="access_roles">Roles</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="access_access">
                                        <label class="form-check-label" for="access_access">Access</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="access_lastaccess">
                                        <label class="form-check-label" for="access_lastaccess">Last Access</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="access_action" checked disabled>
                                        <label class="form-check-label" for="access_action">Action</label>
                                        <span class="badge bg-secondary ms-1" title="Required column">Required</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- KPI Administration - Operational Audit Trail Columns -->
                        <div class="column-settings" id="kpi_admin_audit_columns" style="display: none;">
                            <h6 class="mb-3">KPI Administration - Operational Audit Trail Columns</h6>
                            <div class="row">
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="audit_no" checked disabled>
                                        <label class="form-check-label" for="audit_no">No</label>
                                        <span class="badge bg-secondary ms-1" title="Required column">Required</span>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="audit_staff_id">
                                        <label class="form-check-label" for="audit_staff_id">Staff ID</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="audit_staff_name">
                                        <label class="form-check-label" for="audit_staff_name">Staff Name</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="audit_division">
                                        <label class="form-check-label" for="audit_division">Division</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="audit_section">
                                        <label class="form-check-label" for="audit_section">Section</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="audit_unit_office">
                                        <label class="form-check-label" for="audit_unit_office">Unit/Office</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="audit_module">
                                        <label class="form-check-label" for="audit_module">Module</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="audit_datetime">
                                        <label class="form-check-label" for="audit_datetime">Date and Time</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="audit_year">
                                        <label class="form-check-label" for="audit_year">Year</label>
                                    </div>
                                </div>
                                <div class="col-md-3 mb-3">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" id="audit_transaction_log">
                                        <label class="form-check-label" for="audit_transaction_log">Transaction Log</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="alert alert-info mt-3" id="noTableSelected">
                            <i class="bx bx-info-circle me-2"></i>Please select a KPI module to configure default column settings.
                        </div>

                        <div class="alert alert-success mt-3" id="saveSuccess" style="display: none;">
                            <i class="bx bx-check-circle me-2"></i>Column settings saved successfully!
                        </div>

                        <!-- Save button moved to bottom right -->
                        <div class="d-flex justify-content-end mt-4">
                            <button type="button" class="btn btn-primary" id="saveColumnSettings">Save Settings</button>
                        </div>
                    </div>
                </div>

                <!-- Indicator Configuration Section -->
                <div class="card mb-4">
                    <!--<div class="card-header bg-success text-white">-->
                    <div class="card-header bg-primary text-white" style="color: white;">
                        <h5 class="mb-0" style="color: white;">Indicator Configuration</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="list-group list-group-flush">
                            <!-- KPI Indicator Duration Setup Link -->
                            <a href="javascript:void(0);" onclick="showDurationSetup()" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                <div>KPI Propose Indicator Duration Setup</div>
                                <i class="bx bx-chevron-right"></i>
                            </a>

                            <!-- KPI Indicator Duration Setup Section -->
                            <div id="indicatorDurationSetup" class="row mt-4" style="display: none;">
                                <div class="col-12">
                                    <div class="card mb-4">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-center mb-4">
                                                <h5 class="card-title mb-0">KPI Indicator Duration Setup</h5>
                                            </div>

                                            <!-- Note Section -->
                                            <div class="alert alert-info mb-4" role="alert">
                                                <i class="bx bx-info-circle me-2"></i>
                                                <strong>NOTE:</strong> Duration setup for new year indicator.
                                            </div>

                                            <!-- Duration Setup Form -->
                                            <form id="durationSetupForm" method="POST" action="{{ url('/kpi-configuration/duration-setup') }}">
                                                @csrf
                                                <div class="row mb-3">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label for="startYear" class="form-label">KPI Indicator for the Year <span class="text-danger">*</span></label>
                                                            <select class="form-select" id="startYear" name="startYear" required>
                                                                <option value="">Select year</option>
                                                                <option value="2023">2023</option>
                                                                <option value="2024">2024</option>
                                                                <option value="2025">2025</option>
                                                                <option value="2026" selected>2026</option>
                                                                <option value="2027">2027</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row mb-3">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label for="startDate" class="form-label">Start Date <span class="text-danger">*</span></label>
                                                            <div class="input-group">
                                                                <input type="text" class="form-control datepicker" id="startDate" name="startDate"
                                                                    placeholder="Select date" required>
                                                                <span class="input-group-text"><i class="bx bx-calendar"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row mb-3">
                                                    <div class="col-md-6">
                                                        <div class="mb-3">
                                                            <label for="endDate" class="form-label">End Date <span class="text-danger">*</span></label>
                                                            <div class="input-group">
                                                                <input type="text" class="form-control datepicker" id="endDate" name="endDate"
                                                                    placeholder="Select date" required>
                                                                <span class="input-group-text"><i class="bx bx-calendar"></i></span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="d-flex justify-content-end mt-4">
                                                    <button type="submit" class="btn btn-primary">Save</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- KPI Indicator Type -->
                            <a href="javascript:void(0);" onclick="toggleKpiIndicatorType()" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                <div>KPI Indicator Type</div>
                                <i class="bx bx-chevron-right"></i>
                            </a>

                            <!-- KPI Indicator Type Section -->
                            <div class="row mt-4" id="kpiIndicatorTypeSection" style="display: none;">
                                <div class="col-12">
                                    <div class="card mb-4">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-center mb-4">
                                                <h5 class="card-title mb-0">KPI Indicator Types</h5>

                                            </div>

                                            <div class="table-responsive">
                                                <table class="table table-bordered">
                                                    <thead class="table-light">
                                                        <tr>
                                                            <th style="width: 80px;">TYPE</th>
                                                            <th>KPI INDICATOR DESCRIPTION</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>1</td>
                                                            <td>KPI data is manually added in the achivement count field.</td>
                                                        </tr>
                                                        <tr>
                                                            <td>2</td>
                                                            <td>KPI data ia automatically added in the achievement count field.</td>
                                                        </tr>
                                                        <tr>
                                                            <td>3</td>
                                                            <td>KPI data is manually added based on the Excel Template provided and later convert into an Achievement Table. Achievement count will be auto calculated.</td>
                                                        </tr>
                                                        <tr>
                                                            <td>4</td>
                                                            <td>KPI data is manually added in the Achievement Table. Achievement count will be auto calculated.</td>
                                                        </tr>
                                                        <tr>
                                                            <td>5</td>
                                                            <td>KPI data is automatically added in the Achievement Table where data is pulled from other internal systems. Achievement count will be auto calculated.</td>
                                                        </tr>
                                                        <tr>
                                                            <td>6</td>
                                                            <td>KPI data is pulled from other internal systems and certain data is manually added in the Achievement Table. Achievement count will be auto calculated.</td>
                                                        </tr>

                                                    </tbody>
                                                </table>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Notification for KPI Proposed Indicator -->
                            <a href="javascript:void(0);" onclick="toggleKpiProposedIndicator()" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                <div>Notification to Submit Endorsed KPI Indicator</div>
                                <i class="bx bx-chevron-right"></i>
                            </a>

                            <!-- KPI Proposed Indicator Notification Detail Section -->
                            <div class="row mt-4" id="kpiProposedIndicatorDetail" style="display: none;">
                                <div class="col-12">
                                    <div class="card mb-4">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-center mb-4">
                                                <h5 class="card-title mb-0">Notification to Submit Endorsed KPI Indicator</h5>

                                            </div>

                                            <form id="kpiProposedIndicatorForm" method="POST" action="{{ url('/kpi-configuration/proposed-indicator') }}">
                                                @csrf
                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="proposedDateTime" class="form-label">Notification Date & Time <span class="text-danger">*</span></label>
                                                            <div class="d-flex align-items-center">
                                                                <input type="datetime-local" class="form-control" id="proposedDateTime" name="proposedDateTime"
                                                                    required value="" style="max-width: 350px;">
                                                                <div class="d-flex align-items-center ms-auto">
                                                                    <span class="me-2" style="margin-top: -2px;">Disable</span>
                                                                    <div class="form-check form-switch mx-1">
                                                                        <input class="form-check-input" type="checkbox" id="toggleProposedEmailConfig" checked>
                                                                    </div>
                                                                    <span class="ms-2" style="margin-top: -2px;">Enable</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="proposedEmailTo" class="form-label">To <span class="text-danger">*</span></label>
                                                            <input type="text" class="form-control" id="proposedEmailTo" name="emailTo"
                                                                placeholder="Enter email addresses separated by semicolon"
                                                                value="{{ $proposedEmailTo ?? '' }}" required>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="proposedEmailTitle" class="form-label">Email Subject <span class="text-danger">*</span></label>
                                                            <input type="text" class="form-control" id="proposedEmailTitle" name="emailTitle"
                                                                placeholder="Enter email subject"
                                                                value="{{ $proposedEmailTitle ?? '' }}" required>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="proposedEmailContent" class="form-label">Email Content <span class="text-danger">*</span></label>
                                                            <div id="proposedEmailContentEditor">
                                                                <div class="card">
                                                                    <div class="card-body p-2">
                                                                        <div class="d-flex justify-content-start align-items-center mb-2">
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-bold"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-italic"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-underline"></i></button>
                                                                            <div class="dropdown me-1">
                                                                                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                                                                    Headings
                                                                                </button>
                                                                                <ul class="dropdown-menu">
                                                                                    <li><a class="dropdown-item" href="#">Heading 1</a></li>
                                                                                    <li><a class="dropdown-item" href="#">Heading 2</a></li>
                                                                                    <li><a class="dropdown-item" href="#">Heading 3</a></li>
                                                                                </ul>
                                                                            </div>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ul"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ol"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary"><i class="bx bx-align-middle"></i></button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <textarea class="form-control" id="proposedEmailContent" name="emailContent" rows="12" required>{{ $proposedEmailContent ?? '' }}</textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="d-flex justify-content-end mt-4">
                                                    <button type="button" class="btn btn-secondary me-2" onclick="revertProposedContent()">Revert Content</button>
                                                    <button type="submit" class="btn btn-primary me-2">Save</button>
                                                    <button type="button" class="btn btn-success" onclick="sendProposedEmail()">Send</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <a href="javascript:void(0);" onclick="toggleFinalKpiNotification()" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                <div>Reminder to Submit Endorsed KPI Indicator</div>
                                <i class="bx bx-chevron-right"></i>
                            </a>
                        </div>

                        <!-- Final KPI Notification Detail Section -->
                        <div class="row mt-4" id="finalKpiNotificationDetail" style="display: none;">
                            <div class="col-12">
                                <div class="card mb-4">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between align-items-center mb-4">
                                            <h5 class="card-title mb-0">Reminder to Submit Endorsed KPI Indicator</h5>
                                        </div>

                                        <form id="finalKpiNotificationForm" method="POST" action="/kpi-configuration/final-kpi-notification">

                                            <div class="row mb-3">
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <div class="d-flex align-items-center justify-content-end">
                                                            <span class="me-2" style="margin-top: -2px;">Disable</span>
                                                            <div class="form-check form-switch mx-1">
                                                                <input class="form-check-input" type="checkbox" id="toggleFinalKpiEmailConfig" checked onchange="toggleFinalKpiNotificationConfig()">
                                                            </div>
                                                            <span class="ms-2" style="margin-top: -2px;">Enable</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Duration Selection - Only visible when enabled -->
                                            <div class="row mb-3" id="finalKpiDurationSection">
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="finalKpiDurationSelect" class="form-label">Duration of Current Year <span class="text-danger">*</span></label>
                                                        <select class="form-select duration-selector" id="finalKpiDurationSelect" name="duration" onchange="updateFinalKpiNotificationTable()" required>
                                                            <option value="">Select Duration</option>
                                                            <option value="quarterly">Quarterly</option>
                                                            <option value="annually">Annually</option>
                                                            <option value="bi-annually">Bi-annually</option>
                                                            <option value="g3">G3 (Every 4 months)</option>
                                                            <option value="g6">G6 (Every 2 months)</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                            


                                            <!-- Dynamic Notification Table -->
                                            <div id="finalKpiNotificationTableContainer" style="display: none;">
                                                <div class="notification-table">
                                                    <h6 class="mb-3">Reminder Schedule</h6>
                                                    <div class="table-responsive">
                                                        <table class="table table-bordered" id="finalKpiNotificationTable">
                                                            <thead>
                                                                <tr>
                                                                    <th>QUARTER/MONTH GROUP</th>
                                                                    <th>REMINDER DATE</th>
                                                                    <th>ACTION</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody id="finalKpiNotificationTableBody">
                                                                <!-- Dynamic content will be inserted here -->
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Reminder Time - Added under Duration -->
                                            <div class="row mb-3" id="finalKpiNotificationTimeSection">
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="proposedTime" class="form-label">Reminder Time <span class="text-danger">*</span></label>
                                                        <input type="time" class="form-control" id="proposedTime" name="proposedTime"
                                                            required value="" style="max-width: 350px;">
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="row mb-3">
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="finalKpiEmailTitle" class="form-label">Subject <span class="text-danger">*</span></label>
                                                        <input type="text" class="form-control" id="finalKpiEmailTitle" name="emailTitle"
                                                            placeholder="Enter subject" required value="">
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Email Content Section -->
                                            <div class="row mb-3">
                                                <div class="col-md-12">
                                                    <div class="mb-3">
                                                        <label for="finalKpiEmailContent" class="form-label">Content <span class="text-danger">*</span></label>
                                                        <div id="finalKpiEmailContentEditor">
                                                            <div class="card">
                                                                <div class="card-body p-2">
                                                                    <div class="d-flex justify-content-start align-items-center mb-2">
                                                                        <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-bold"></i></button>
                                                                        <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-italic"></i></button>
                                                                        <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-underline"></i></button>
                                                                        <div class="dropdown me-1">
                                                                            <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                                                                Headings
                                                                            </button>
                                                                            <ul class="dropdown-menu">
                                                                                <li><a class="dropdown-item" href="#">Heading 1</a></li>
                                                                                <li><a class="dropdown-item" href="#">Heading 2</a></li>
                                                                                <li><a class="dropdown-item" href="#">Heading 3</a></li>
                                                                            </ul>
                                                                        </div>
                                                                        <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ul"></i></button>
                                                                        <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ol"></i></button>
                                                                        <button type="button" class="btn btn-sm btn-outline-secondary"><i class="bx bx-align-middle"></i></button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <textarea class="form-control" id="finalKpiEmailContent" name="emailContent" rows="12" required placeholder="Enter email content here...">{{ $finalKpiEmailContent ?? '' }}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>



                                            <!-- Form Action Buttons -->
                                            <div class="d-flex justify-content-end mt-4">
                                                <button type="button" class="btn btn-secondary me-2" onclick="revertFinalKpiContent()">Revert Content</button>
                                                <button type="submit" class="btn btn-primary me-2">Save</button>
                                                <button type="button" class="btn btn-success" onclick="sendFinalKpiEmail()">Send</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Achievement Configuration Section -->
                <div class="card mb-4">
                    <div class="card-header bg-primary text-white" style="color: white;">
                        <h5 class="mb-0" style="color: white;">Achievement Configuration</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="list-group list-group-flush">
                            <a href="javascript:void(0);" onclick="toggleAchievementVerification()" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                <div>Notification to Submit KPI Achievement</div>
                                <i class="bx bx-chevron-right"></i>
                            </a>

                            <!-- Achievement Verification Notification Detail Section -->
                            <div class="row mt-4" id="achievementVerificationDetail" style="display: none;">
                                <div class="col-12">
                                    <div class="card mb-4">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-center mb-4">
                                                <h5 class="card-title mb-0">Notification to Submit KPI Achievement</h5>
                                            </div>

                                            <form id="achievementVerificationForm" method="POST" action="{{ url('/kpi-configuration/achievement-verification') }}">
                                                @csrf
                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="verificationDate" class="form-label">Notification Date & Time <span class="text-danger">*</span></label>
                                                            <div class="d-flex align-items-center">
                                                                <input type="datetime-local" class="form-control" id="verificationDate" name="verificationDate"
                                                                    required value="{{ $verificationDate ?? '' }}" style="max-width: 350px;">
                                                                <div class="d-flex align-items-center ms-auto">
                                                                    <span class="me-2" style="margin-top: -2px;">Disable</span>
                                                                    <div class="form-check form-switch mx-1">
                                                                        <input class="form-check-input" type="checkbox" id="toggleVerificationEmailConfig" checked>
                                                                    </div>
                                                                    <span class="ms-2" style="margin-top: -2px;">Enable</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="verificationEmailTo" class="form-label">To <span class="text-danger">*</span></label>
                                                            <input type="text" class="form-control" id="verificationEmailTo" name="emailTo"
                                                                placeholder="Enter email addresses separated by semicolon"
                                                                value="{{ $verificationEmailTo ?? '' }}" required>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="verificationEmailTitle" class="form-label">Email Subject <span class="text-danger">*</span></label>
                                                            <input type="text" class="form-control" id="verificationEmailTitle" name="emailTitle"
                                                                placeholder="Enter email subject"
                                                                value="{{ $verificationEmailTitle ?? '' }}" required>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="verificationEmailContent" class="form-label">Email Content <span class="text-danger">*</span></label>
                                                            <div id="verificationEmailContentEditor">
                                                                <div class="card">
                                                                    <div class="card-body p-2">
                                                                        <div class="d-flex justify-content-start align-items-center mb-2">
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-bold"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-italic"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-underline"></i></button>
                                                                            <div class="dropdown me-1">
                                                                                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                                                                    Headings
                                                                                </button>
                                                                                <ul class="dropdown-menu">
                                                                                    <li><a class="dropdown-item" href="#">Heading 1</a></li>
                                                                                    <li><a class="dropdown-item" href="#">Heading 2</a></li>
                                                                                    <li><a class="dropdown-item" href="#">Heading 3</a></li>
                                                                                </ul>
                                                                            </div>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ul"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ol"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary"><i class="bx bx-align-middle"></i></button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <textarea class="form-control" id="verificationEmailContent" name="emailContent" rows="12" required>{{ $verificationEmailContent ?? '' }}</textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="d-flex justify-content-end mt-4">
                                                    <button type="button" class="btn btn-secondary me-2" onclick="revertVerificationContent()">Revert Content</button>
                                                    <button type="submit" class="btn btn-primary me-2">Save</button>
                                                    <button type="button" class="btn btn-success" onclick="sendVerificationEmail()">Send</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Reminder for KPI Achievement Submission Due Date -->
                            <a href="javascript:void(0);" onclick="showReminderCard()" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                <div>Reminder to Submit KPI Achievement</div>
                                <i class="bx bx-chevron-right"></i>
                            </a>

                            <!-- KPI Achievement Notification Detail Section -->
                            <div class="row mt-4" id="kpiReminderNotificationDetail" style="display: none;">
                                <div class="col-12">
                                    <div class="card mb-4">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-center mb-4">
                                                <h5 class="card-title mb-0">Reminder to Submit KPI Achievement</h5>
                                            </div>

                                            <form id="achievementKpiNotificationForm" method="POST" action="{{ url('/kpi-configuration/achievement-verification') }}">
                                                @csrf

                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <div class="d-flex align-items-center justify-content-end">
                                                                <span class="me-2" style="margin-top: -2px;">Disable</span>
                                                                <div class="form-check form-switch mx-1">
                                                                    <input class="form-check-input" type="checkbox" id="toggleAchievementKpiEmailConfig" checked onchange="toggleAchievementKpiNotificationConfig()">
                                                                </div>
                                                                <span class="ms-2" style="margin-top: -2px;">Enable</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Duration Selection - Only visible when enabled -->
                                                <div class="row mb-3" id="achievementKpiDurationSection">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="achievementKpiDurationSelect" class="form-label">Duration of Current Year <span class="text-danger">*</span></label>
                                                            <select class="form-select duration-selector" id="achievementKpiDurationSelect" name="duration" onchange="updateAchievementKpiNotificationTable()" required>
                                                                <option value="">Select Duration</option>
                                                                <option value="quarterly">Quarterly</option>
                                                                <option value="annually">Annually</option>
                                                                <option value="bi-annually">Bi-annually</option>
                                                                <option value="g3">G3 (Every 4 months)</option>
                                                                <option value="g6">G6 (Every 2 months)</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>

                                               

                                                <!-- Dynamic Notification Table -->
                                                <div id="achievementKpiNotificationTableContainer" style="display: none;">
                                                    <div class="notification-table">
                                                        <h6 class="mb-3">Reminder Schedule</h6>
                                                        <div class="table-responsive">
                                                            <table class="table table-bordered" id="achievementKpiNotificationTable">
                                                                <thead>
                                                                    <tr>
                                                                        <th>QUARTER/MONTH GROUP</th>
                                                                        <th>REMINDER DATE</th>
                                                                        <th>ACTION</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody id="achievementKpiNotificationTableBody">
                                                                    <!-- Dynamic content will be inserted here -->
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>

                                                 <!-- Reminder Time - Added under Duration -->
                                                <div class="row mb-3" id="achievementKpiNotificationTimeSection">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="achievementKpiTime" class="form-label">Reminder Time <span class="text-danger">*</span></label>
                                                            <input type="time" class="form-control" id="achievementKpiTime" name="achievementKpiTime"
                                                                required value="" style="max-width: 350px;">
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="achievementKpiEmailTitle" class="form-label">Subject <span class="text-danger">*</span></label>
                                                            <input type="text" class="form-control" id="achievementKpiEmailTitle" name="emailTitle"
                                                                placeholder="Enter subject" required value="">
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Email Content Section -->
                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="achievementKpiEmailContent" class="form-label">Content <span class="text-danger">*</span></label>
                                                            <div id="achievementKpiEmailContentEditor">
                                                                <div class="card">
                                                                    <div class="card-body p-2">
                                                                        <div class="d-flex justify-content-start align-items-center mb-2">
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-bold"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-italic"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-underline"></i></button>
                                                                            <div class="dropdown me-1">
                                                                                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                                                                    Headings
                                                                                </button>
                                                                                <ul class="dropdown-menu">
                                                                                    <li><a class="dropdown-item" href="#">Heading 1</a></li>
                                                                                    <li><a class="dropdown-item" href="#">Heading 2</a></li>
                                                                                    <li><a class="dropdown-item" href="#">Heading 3</a></li>
                                                                                </ul>
                                                                            </div>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ul"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ol"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary"><i class="bx bx-align-middle"></i></button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <textarea class="form-control" id="achievementKpiEmailContent" name="emailContent" rows="12" required placeholder="Enter email content here...">{{ $achievementKpiEmailContent ?? '' }}</textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                              

                                                <!-- Dynamic Notification Table -->
                                                <div id="achievementKpiNotificationTableContainer" style="display: none;">
                                                    <div class="notification-table">
                                                        <h6 class="mb-3">Notification Schedule</h6>
                                                        <div class="table-responsive">
                                                            <table class="table table-bordered" id="achievementKpiNotificationTable">
                                                                <thead>
                                                                    <tr>
                                                                        <th>QUARTER/MONTH GROUP</th>
                                                                        <th>REMINDER DATE</th>
                                                                        <th>ACTION</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody id="achievementKpiNotificationTableBody">
                                                                    <!-- Dynamic content will be inserted here -->
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="d-flex justify-content-end mt-4">
                                                    <button type="button" class="btn btn-secondary me-2" onclick="revertAchievementContent()">Revert Content</button>
                                                    <button type="submit" class="btn btn-primary me-2">Save</button>
                                                    <button type="button" class="btn btn-success" onclick="sendAchievementEmail()">Send</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <!-- Reminder for Under Achieve Indicator -->
                            <a href="javascript:void(0);" onclick="showUnderAchieveCard()" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                <div>Notification to Verify KPI Achievement</div>
                                <i class="bx bx-chevron-right"></i>
                            </a>

                            <!-- Reminder for Duedate Achievement Verification Detail Section (Hidden by default) -->
                            <div class="row mt-4" id="achievementVerificationReminderDetail" style="display: none;">
                                <div class="col-12">
                                    <div class="card mb-4">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-center mb-4">
                                                <h5 class="card-title mb-0">Notification to Verify KPI Achievement</h5>
                                            </div>

                                            <form id="achievementVerificationReminderForm" method="POST" action="{{ url('/kpi-configuration/verification-reminder') }}">
                                                @csrf
                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="verificationReminderDate" class="form-label">Reminder Date & Time <span class="text-danger">*</span></label>
                                                            <div class="d-flex align-items-center">
                                                                <input type="datetime-local" class="form-control" id="verificationReminderDate" name="verificationReminderDate"
                                                                    required value="{{ $verificationReminderDate ?? '' }}" style="max-width: 350px;">
                                                                <div class="d-flex align-items-center ms-auto">
                                                                    <span class="me-2" style="margin-top: -2px;">Disable</span>
                                                                    <div class="form-check form-switch mx-1">
                                                                        <input class="form-check-input" type="checkbox" id="toggleVerificationReminderEmailConfig" checked>
                                                                    </div>
                                                                    <span class="ms-2" style="margin-top: -2px;">Enable</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="verificationReminderEmailTo" class="form-label">To <span class="text-danger">*</span></label>
                                                            <input type="text" class="form-control" id="verificationReminderEmailTo" name="verificationEmailTo"
                                                                placeholder="Enter email addresses separated by semicolon"
                                                                value="{{ $verificationReminderEmailTo ?? '' }}" required>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="verificationReminderEmailTitle" class="form-label">Email Subject <span class="text-danger">*</span></label>
                                                            <input type="text" class="form-control" id="verificationReminderEmailTitle" name="verificationEmailTitle"
                                                                placeholder="Enter email subject"
                                                                value="{{ $verificationReminderEmailTitle ?? '' }}" required>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row mb-3">
                                                    <div class="col-md-12">
                                                        <div class="mb-3">
                                                            <label for="verificationReminderEmailContent" class="form-label">Email Content <span class="text-danger">*</span></label>
                                                            <div id="verificationReminderEmailContentEditor">
                                                                <div class="card">
                                                                    <div class="card-body p-2">
                                                                        <div class="d-flex justify-content-start align-items-center mb-2">
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-bold"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-italic"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-underline"></i></button>
                                                                            <div class="dropdown me-1">
                                                                                <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                                                                    Headings
                                                                                </button>
                                                                                <ul class="dropdown-menu">
                                                                                    <li><a class="dropdown-item" href="#">Heading 1</a></li>
                                                                                    <li><a class="dropdown-item" href="#">Heading 2</a></li>
                                                                                    <li><a class="dropdown-item" href="#">Heading 3</a></li>
                                                                                </ul>
                                                                            </div>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ul"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ol"></i></button>
                                                                            <button type="button" class="btn btn-sm btn-outline-secondary"><i class="bx bx-align-middle"></i></button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <textarea class="form-control" id="verificationReminderEmailContent" name="verificationEmailContent" rows="12" required>{{ $verificationReminderEmailContent ?? '' }}</textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="d-flex justify-content-end mt-4">
                                                    <button type="button" class="btn btn-secondary me-2" onclick="revertVerificationReminderContent()">Revert Content</button>
                                                    <button type="submit" class="btn btn-primary me-2">Save</button>
                                                    <button type="button" class="btn btn-success" onclick="sendVerificationReminderEmail()">Send</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <a href="javascript:void(0);" onclick="reminderVerifyKpiAchievement()" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                <div>Reminder to Verify KPI Achievement</div>
                                <i class="bx bx-chevron-right"></i>
                            </a>

                            <!-- Reminder to Verify KPI Achievement Detail Section -->
                            <div class="row mt-4" id="reminderSubmitKpiAchievement" style="display: none;">
                                <div class="col-12">
                                    <div class="card mb-4">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-center mb-4">
                                                <h5 class="card-title mb-0">Reminder to Verify KPI Achievement</h5>
                                            </div>

                                            <form id="reminderVerifyKpiForm" method="POST" action="{{ url('/kpi-configuration/reminder-verify-kpi-achievement') }}">






                                                <form id="reminderVerifyKpiForm" method="POST" action="{{ url('/kpi-configuration/reminder-verify-kpi-achievement') }}">
                                                    @csrf

                                                    <div class="row mb-3">
                                                        <div class="col-md-12">
                                                            <div class="mb-3">
                                                                <div class="d-flex align-items-center justify-content-end">
                                                                    <span class="me-2" style="margin-top: -2px;">Disable</span>
                                                                    <div class="form-check form-switch mx-1">
                                                                        <input class="form-check-input" type="checkbox" id="toggleReminderVerifyKpiConfig" checked onchange="toggleReminderVerifyKpiNotificationConfig()">
                                                                    </div>
                                                                    <span class="ms-2" style="margin-top: -2px;">Enable</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- Duration Selection - Only visible when enabled -->
                                                    <div class="row mb-3" id="reminderVerifyKpiDurationSection">
                                                        <div class="col-md-12">
                                                            <div class="mb-3">
                                                                <label for="reminderVerifyKpiDurationSelect" class="form-label">Duration of Current Year <span class="text-danger">*</span></label>
                                                                <select class="form-select duration-selector" id="reminderVerifyKpiDurationSelect" name="duration" onchange="updateReminderVerifyKpiNotificationTable()" required>
                                                                    <option value="">Select Duration</option>
                                                                    <option value="quarterly">Quarterly</option>
                                                                    <option value="annually">Annually</option>
                                                                    <option value="bi-annually">Bi-annually</option>
                                                                    <option value="g3">G3 (Every 4 months)</option>
                                                                    <option value="g6">G6 (Every 2 months)</option>
                                                                </select>
                                                            </div>
                                                        </div>
                                                    </div>


                                                    <!-- Dynamic Notification Table -->
                                                    <div id="reminderVerifyKpiNotificationTableContainer" style="display: none;">
                                                        <div class="notification-table">
                                                            <h6 class="mb-3">Reminder Schedule</h6>
                                                            <div class="table-responsive">
                                                                <table class="table table-bordered" id="reminderVerifyKpiNotificationTable">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>QUARTER/MONTH GROUP</th>
                                                                            <th>REMINDER DATE</th>
                                                                            <th>ACTION</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody id="reminderVerifyKpiNotificationTableBody">
                                                                        <!-- Dynamic content will be inserted here -->
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>

                                                     <!-- Reminder Time - Added under Duration -->
                                                    <div class="row mb-3" id="reminderVerifyKpiNotificationTimeSection">
                                                        <div class="col-md-12">
                                                            <div class="mb-3">
                                                                <label for="reminderVerifyKpiTime" class="form-label">Reminder Time <span class="text-danger">*</span></label>
                                                                <input type="time" class="form-control" id="reminderVerifyKpiTime" name="reminderVerifyKpiTime"
                                                                    required value="" style="max-width: 350px;">
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row mb-3">
                                                        <div class="col-md-12">
                                                            <div class="mb-3">
                                                                <label for="reminderVerifyKpiEmailTitle" class="form-label">Subject <span class="text-danger">*</span></label>
                                                                <input type="text" class="form-control" id="reminderVerifyKpiEmailTitle" name="emailTitle"
                                                                    placeholder="Enter subject" required value="">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- Email Content Section -->
                                                    <div class="row mb-3">
                                                        <div class="col-md-12">
                                                            <div class="mb-3">
                                                                <label for="reminderVerifyKpiEmailContent" class="form-label">Email Content <span class="text-danger">*</span></label>
                                                                <div id="reminderVerifyKpiEmailContentEditor">
                                                                    <div class="card">
                                                                        <div class="card-body p-2">
                                                                            <div class="d-flex justify-content-start align-items-center mb-2">
                                                                                <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-bold"></i></button>
                                                                                <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-italic"></i></button>
                                                                                <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-underline"></i></button>
                                                                                <div class="dropdown me-1">
                                                                                    <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                                                                        Headings
                                                                                    </button>
                                                                                    <ul class="dropdown-menu">
                                                                                        <li><a class="dropdown-item" href="#">Heading 1</a></li>
                                                                                        <li><a class="dropdown-item" href="#">Heading 2</a></li>
                                                                                        <li><a class="dropdown-item" href="#">Heading 3</a></li>
                                                                                    </ul>
                                                                                </div>
                                                                                <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ul"></i></button>
                                                                                <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ol"></i></button>
                                                                                <button type="button" class="btn btn-sm btn-outline-secondary"><i class="bx bx-align-middle"></i></button>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <textarea class="form-control" id="reminderVerifyKpiEmailContent" name="emailContent" rows="12" required placeholder="Enter email content here...">{{ $reminderVerifyKpiEmailContent ?? '' }}</textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                   
                                                    <!-- Dynamic Notification Table -->
                                                    <div id="reminderVerifyKpiNotificationTableContainer" style="display: none;">
                                                        <div class="notification-table">
                                                            <h6 class="mb-3">Notification Schedule</h6>
                                                            <div class="table-responsive">
                                                                <table class="table table-bordered" id="reminderVerifyKpiNotificationTable">
                                                                    <thead>
                                                                        <tr>
                                                                            <th>QUARTER/MONTH GROUP</th>
                                                                            <th>REMINDER DATE</th>
                                                                            <th>ACTION</th>
                                                                        </tr>
                                                                    </thead>
                                                                    <tbody id="reminderVerifyKpiNotificationTableBody">
                                                                        <!-- Dynamic content will be inserted here -->
                                                                    </tbody>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- Form Action Buttons -->
                                                    <div class="d-flex justify-content-end mt-4">
                                                        <button type="button" class="btn btn-secondary me-2" onclick="revertVerifyKpiContent()">Revert Content</button>
                                                        <button type="submit" class="btn btn-primary me-2">Save</button>
                                                        <button type="button" class="btn btn-success" onclick="sendVerifyKpiEmail()">Send</button>
                                                    </div>
                                                </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Reminder Modal -->
    <div class="modal fade" id="editReminderModal" tabindex="-1" aria-labelledby="editReminderModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editReminderModalLabel">Edit Reminder to Submit Endorsed KPI Indicator</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="editReminderForm">
                        <div class="mb-3">
                            <label for="quarterMonthGroup" class="form-label">Quarter/Month Group:</label>
                            <input type="text" class="form-control" id="quarterMonthGroup" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="reminderDate" class="form-label">Reminder Date:</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="reminderDate" placeholder="DD/MM/YYYY">
                                <span class="input-group-text"><i class="bx bx-calendar"></i></span>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Reset</button>
                    <button type="button" class="btn btn-primary" onclick="saveReminderEdit()">Save</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Configuration data for different duration types - specific to Final KPI
        const finalKpiDurationConfigs = {
            quarterly: [{
                    period: 'Q1',
                    dates: '31/03/2022'
                },
                {
                    period: 'Q2',
                    dates: '29/06/2022'
                },
                {
                    period: 'Q3',
                    dates: '30/09/2022'
                },
                {
                    period: 'Q4',
                    dates: '21/12/2022'
                }
            ],
            annually: [{
                period: '1 (January - December)',
                dates: '15/12/2022'
            }],
            'bi-annually': [{
                    period: '1 (January - June)',
                    dates: '20/06/2022'
                },
                {
                    period: '2 (July - December)',
                    dates: '21/12/2022'
                }
            ],
            g3: [{
                    period: '1 (January - April)',
                    dates: '20/04/2022'
                },
                {
                    period: '2 (May - August)',
                    dates: '21/08/2022'
                },
                {
                    period: '3 (September - December)',
                    dates: '21/12/2022'
                }
            ],
            g6: [{
                    period: '1 (January - February)',
                    dates: '18/02/2022'
                },
                {
                    period: '2 (March - April)',
                    dates: '20/04/2022'
                },
                {
                    period: '3 (May - June)',
                    dates: '20/06/2022'
                },
                {
                    period: '4 (July - August)',
                    dates: '21/08/2022'
                },
                {
                    period: '5 (September - October)',
                    dates: '21/10/2022'
                },
                {
                    period: '6 (November - December)',
                    dates: '21/12/2022'
                }
            ]
        };

        // Store current editing information
        let currentEditIndex = null;
        let currentEditRowElement = null;

        // Toggle function specific to Final KPI notification
        function toggleFinalKpiNotificationConfig() {
            const toggle = document.getElementById('toggleFinalKpiEmailConfig');
            const durationSection = document.getElementById('finalKpiDurationSection');
            const tableContainer = document.getElementById('finalKpiNotificationTableContainer');

            if (toggle.checked) {
                durationSection.style.display = 'block';
            } else {
                durationSection.style.display = 'none';
                tableContainer.style.display = 'none';
                document.getElementById('finalKpiDurationSelect').value = '';
            }
        }

        // Update notification table function specific to Final KPI
        function updateFinalKpiNotificationTable() {
            const durationSelect = document.getElementById('finalKpiDurationSelect');
            const tableContainer = document.getElementById('finalKpiNotificationTableContainer');
            const tableBody = document.getElementById('finalKpiNotificationTableBody');

            const selectedDuration = durationSelect.value;

            if (selectedDuration && finalKpiDurationConfigs[selectedDuration]) {
                const config = finalKpiDurationConfigs[selectedDuration];

                // Clear existing rows
                tableBody.innerHTML = '';

                // Add new rows
                config.forEach((item, index) => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${item.period}</td>
                        <td>
                            <input type="date" class="form-control" name="reminder_dates[]" value="${convertToDateInput(item.dates)}">
                        </td>
                        <td>
                            <button type="button" class="btn btn-sm btn-outline-primary" onclick="editFinalKpiReminder(${index})">
                                <i class="bx bx-edit"></i>
                            </button>
                        </td>
                    `;
                    tableBody.appendChild(row);
                });

                tableContainer.style.display = 'block';
            } else {
                tableContainer.style.display = 'none';
            }
        }

        // Helper function to convert date format from DD/MM/YYYY to YYYY-MM-DD
        function convertToDateInput(dateStr) {
            const parts = dateStr.split('/');
            if (parts.length === 3) {
                return `${parts[2]}-${parts[1].padStart(2, '0')}-${parts[0].padStart(2, '0')}`;
            }
            return '';
        }

        // Helper function to convert date format from YYYY-MM-DD to DD/MM/YYYY
        function convertFromDateInput(dateStr) {
            const parts = dateStr.split('-');
            if (parts.length === 3) {
                return `${parts[2]}/${parts[1]}/${parts[0]}`;
            }
            return '';
        }

        // Edit reminder function specific to Final KPI
        function editFinalKpiReminder(index) {
            const durationSelect = document.getElementById('finalKpiDurationSelect');
            const selectedDuration = durationSelect.value;

            if (selectedDuration && finalKpiDurationConfigs[selectedDuration]) {
                const config = finalKpiDurationConfigs[selectedDuration][index];
                const tableRow = document.getElementById('finalKpiNotificationTableBody').children[index];
                const dateInput = tableRow.querySelector('input[type="date"]');

                // Store current editing information
                currentEditIndex = index;
                currentEditRowElement = tableRow;

                // Populate modal with current data
                document.getElementById('quarterMonthGroup').value = config.period;
                document.getElementById('reminderDate').value = convertFromDateInput(dateInput.value);

                // Show modal
                const modal = new bootstrap.Modal(document.getElementById('editReminderModal'));
                modal.show();
            }
        }

        // Save reminder edit function
        function saveReminderEdit() {
            const reminderDateInput = document.getElementById('reminderDate');
            const newDate = reminderDateInput.value;

            if (newDate && currentEditRowElement) {
                // Convert DD/MM/YYYY to YYYY-MM-DD format for date input
                const convertedDate = convertToDateInput(newDate);

                // Update the date input in the table
                const dateInput = currentEditRowElement.querySelector('input[type="date"]');
                dateInput.value = convertedDate;

                // Update the configuration data
                const durationSelect = document.getElementById('finalKpiDurationSelect');
                const selectedDuration = durationSelect.value;
                if (selectedDuration && finalKpiDurationConfigs[selectedDuration] && currentEditIndex !== null) {
                    finalKpiDurationConfigs[selectedDuration][currentEditIndex].dates = newDate;
                }

                // Close modal
                const modal = bootstrap.Modal.getInstance(document.getElementById('editReminderModal'));
                modal.hide();

                // Reset editing variables
                currentEditIndex = null;
                currentEditRowElement = null;

                // Show success message
                alert('Reminder date updated successfully!');
            } else {
                alert('Please enter a valid date in DD/MM/YYYY format.');
            }
        }

        // Placeholder functions for buttons
        function revertFinalKpiContent() {
            if (confirm('Are you sure you want to revert the content?')) {
                document.getElementById('finalKpiNotificationForm').reset();
                document.getElementById('finalKpiNotificationTableContainer').style.display = 'none';
            }
        }

        function sendFinalKpiEmail() {
            if (confirm('Are you sure you want to send the email?')) {
                // Add your email sending logic here
                alert('Email sent successfully!');
            }
        }

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            toggleFinalKpiNotificationConfig();
        });

        // Add date formatting for the modal input
        document.getElementById('reminderDate').addEventListener('blur', function() {
            let value = this.value.replace(/\D/g, ''); // Remove non-digits
            if (value.length >= 8) {
                value = value.substring(0, 8);
                this.value = value.substring(0, 2) + '/' + value.substring(2, 4) + '/' + value.substring(4, 8);
            }
        });
    </script>



 
<!-- Edit Reminder Modal -->
    <div class="modal fade" id="editReminderVerifyKpiModal" tabindex="-1" aria-labelledby="editReminderVerifyKpiModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editReminderVerifyKpiModalLabel">Edit Reminder to Verify KPI Achievement</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="editReminderVerifyKpiForm">
                        <div class="mb-3">
                            <label for="verifyKpiQuarterMonthGroup" class="form-label">Quarter/Month Group:</label>
                            <input type="text" class="form-control" id="verifyKpiQuarterMonthGroup" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="verifyKpiReminderDate" class="form-label">Reminder Date:</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="verifyKpiReminderDate" placeholder="DD/MM/YYYY">
                                <span class="input-group-text"><i class="bx bx-calendar"></i></span>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Reset</button>
                    <button type="button" class="btn btn-primary" onclick="saveReminderVerifyKpiEdit()">Save</button>
                </div>
            </div>
        </div>
    </div>

<!-- Achievement KPI Edit Modal -->
<div class="modal fade" id="editAchievementKpiModal" tabindex="-1" aria-labelledby="editAchievementKpiModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editAchievementKpiModalLabel">Edit Reminder to Submit KPI Achievement</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="editAchievementKpiForm">
                    <div class="mb-3">
                        <label for="achievementKpiQuarterMonthGroup" class="form-label">Quarter/Month Group:</label>
                        <input type="text" class="form-control" id="achievementKpiQuarterMonthGroup" readonly>
                    </div>
                    <div class="mb-3">
                        <label for="achievementKpiReminderDate" class="form-label">Reminder Date:</label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="achievementKpiReminderDate" placeholder="DD/MM/YYYY">
                            <span class="input-group-text"><i class="bx bx-calendar"></i></span>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Reset</button>
                <button type="button" class="btn btn-primary" onclick="saveAchievementKpiEdit()">Save</button>
            </div>
        </div>
    </div>
</div>

    <script>
        // Achievement KPI Notification Functions
        // Store current editing information for Achievement KPI
        let currentAchievementKpiEditIndex = null;
        let currentAchievementKpiEditRowElement = null;

        // Toggle function specific to Achievement KPI notification
        function toggleAchievementKpiNotificationConfig() {
            const toggle = document.getElementById('toggleAchievementKpiEmailConfig');
            const durationSection = document.getElementById('achievementKpiDurationSection');
            const tableContainer = document.getElementById('achievementKpiNotificationTableContainer');

            if (toggle.checked) {
                durationSection.style.display = 'block';
            } else {
                durationSection.style.display = 'none';
                tableContainer.style.display = 'none';
                document.getElementById('achievementKpiDurationSelect').value = '';
            }
        }

        // Update notification table function specific to Achievement KPI
        function updateAchievementKpiNotificationTable() {
            const durationSelect = document.getElementById('achievementKpiDurationSelect');
            const tableContainer = document.getElementById('achievementKpiNotificationTableContainer');
            const tableBody = document.getElementById('achievementKpiNotificationTableBody');

            const selectedDuration = durationSelect.value;

            if (selectedDuration && achievementKpiDurationConfigs[selectedDuration]) {
                const config = achievementKpiDurationConfigs[selectedDuration];

                // Clear existing rows
                tableBody.innerHTML = '';

                // Add new rows
                config.forEach((item, index) => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                <td>${item.period}</td>
                <td>
                    <input type="date" class="form-control" name="achievement_reminder_dates[]" value="${convertToDateInput(item.dates)}">
                </td>
                <td>
                    <button type="button" class="btn btn-sm btn-outline-primary" onclick="editAchievementKpiReminder(${index})">
                        <i class="bx bx-edit"></i>
                    </button>
                </td>
            `;
                    tableBody.appendChild(row);
                });

                tableContainer.style.display = 'block';
            } else {
                tableContainer.style.display = 'none';
            }
        }

        // Edit reminder function specific to Achievement KPI
        function editAchievementKpiReminder(index) {
            const durationSelect = document.getElementById('achievementKpiDurationSelect');
            const selectedDuration = durationSelect.value;

            if (selectedDuration && achievementKpiDurationConfigs[selectedDuration]) {
                const config = achievementKpiDurationConfigs[selectedDuration][index];
                const tableRow = document.getElementById('achievementKpiNotificationTableBody').children[index];
                const dateInput = tableRow.querySelector('input[type="date"]');

                // Store current editing information
                currentAchievementKpiEditIndex = index;
                currentAchievementKpiEditRowElement = tableRow;

                // Populate modal with current data
                document.getElementById('achievementKpiQuarterMonthGroup').value = config.period;
                document.getElementById('achievementKpiReminderDate').value = convertFromDateInput(dateInput.value);

                // Show modal
                const modal = new bootstrap.Modal(document.getElementById('editAchievementKpiModal'));
                modal.show();
            }
        }

        // Save reminder edit function for Achievement KPI
        function saveAchievementKpiEdit() {
            const reminderDateInput = document.getElementById('achievementKpiReminderDate');
            const newDate = reminderDateInput.value;

            if (newDate && currentAchievementKpiEditRowElement) {
                // Convert DD/MM/YYYY to YYYY-MM-DD format for date input
                const convertedDate = convertToDateInput(newDate);

                // Update the date input in the table
                const dateInput = currentAchievementKpiEditRowElement.querySelector('input[type="date"]');
                dateInput.value = convertedDate;

                // Update the configuration data
                const durationSelect = document.getElementById('achievementKpiDurationSelect');
                const selectedDuration = durationSelect.value;
                if (selectedDuration && achievementKpiDurationConfigs[selectedDuration] && currentAchievementKpiEditIndex !== null) {
                    achievementKpiDurationConfigs[selectedDuration][currentAchievementKpiEditIndex].dates = newDate;
                }

                // Close modal
                const modal = bootstrap.Modal.getInstance(document.getElementById('editAchievementKpiModal'));
                modal.hide();

                // Reset editing variables
                currentAchievementKpiEditIndex = null;
                currentAchievementKpiEditRowElement = null;

                // Show success message
                alert('Reminder date updated successfully!');
            } else {
                alert('Please enter a valid date in DD/MM/YYYY format.');
            }
        }

        // Placeholder functions for Achievement KPI buttons
        function revertAchievementKpiContent() {
            if (confirm('Are you sure you want to revert the content?')) {
                document.getElementById('achievementKpiNotificationForm').reset();
                document.getElementById('achievementKpiNotificationTableContainer').style.display = 'none';
                // Reset toggle state
                document.getElementById('toggleAchievementKpiEmailConfig').checked = true;
                toggleAchievementKpiNotificationConfig();
            }
        }

        function sendAchievementKpiEmail() {
            const form = document.getElementById('achievementKpiNotificationForm');
            const toggle = document.getElementById('toggleAchievementKpiEmailConfig');

            // Check if notifications are enabled
            if (!toggle.checked) {
                alert('Notifications are currently disabled. Please enable them first.');
                return;
            }

            // Basic form validation
            const emailTitle = document.getElementById('achievementKpiEmailTitle').value.trim();
            const duration = document.getElementById('achievementKpiDurationSelect').value;

            if (!emailTitle) {
                alert('Please enter an email subject.');
                return;
            }

            if (!duration) {
                alert('Please select a duration.');
                return;
            }

            if (confirm('Are you sure you want to send the email?')) {
                // Add your email sending logic here
                alert('Achievement KPI notification email sent successfully!');
            }
        }

        // Initialize Achievement KPI notification config on page load
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize the toggle state for Achievement KPI
            if (document.getElementById('toggleAchievementKpiEmailConfig')) {
                toggleAchievementKpiNotificationConfig();
            }

            // Add date formatting for the Achievement KPI modal input (if modal exists)
            const achievementKpiDateInput = document.getElementById('achievementKpiReminderDate');
            if (achievementKpiDateInput) {
                achievementKpiDateInput.addEventListener('blur', function() {
                    let value = this.value.replace(/\D/g, ''); // Remove non-digits
                    if (value.length >= 8) {
                        value = value.substring(0, 8);
                        this.value = value.substring(0, 2) + '/' + value.substring(2, 4) + '/' + value.substring(4, 8);
                    }
                });
            }
        });
    </script>









    <!-- Edit Reminder Modal for Achievement KPI -->
    <div class="modal fade" id="editAchievementReminderModal" tabindex="-1" aria-labelledby="editAchievementReminderModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editAchievementReminderModalLabel">EDIT REMINDER FOR KPI ACHIEVEMENT SUBMISSION</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="editAchievementReminderForm">
                        <div class="mb-3">
                            <label for="achievementQuarterMonthGroup" class="form-label">Quarter/Month Group:</label>
                            <input type="text" class="form-control" id="achievementQuarterMonthGroup" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="achievementReminderDate" class="form-label">Reminder Date:</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="achievementReminderDate" placeholder="DD/MM/YYYY">
                                <span class="input-group-text"><i class="bx bx-calendar"></i></span>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Reset</button>
                    <button type="button" class="btn btn-primary" onclick="saveAchievementReminderEdit()">Save</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Reminder Modal -->
    <div class="modal fade" id="editReminderVerifyKpiModal" tabindex="-1" aria-labelledby="editReminderVerifyKpiModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="editReminderVerifyKpiModalLabel">Edit Reminder to Verify KPI Achievement</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="editReminderVerifyKpiForm">
                        <div class="mb-3">
                            <label for="verifyKpiQuarterMonthGroup" class="form-label">Quarter/Month Group:</label>
                            <input type="text" class="form-control" id="verifyKpiQuarterMonthGroup" readonly>
                        </div>
                        <div class="mb-3">
                            <label for="verifyKpiReminderDate" class="form-label">Reminder Date:</label>
                            <div class="input-group">
                                <input type="text" class="form-control" id="verifyKpiReminderDate" placeholder="DD/MM/YYYY">
                                <span class="input-group-text"><i class="bx bx-calendar"></i></span>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Reset</button>
                    <button type="button" class="btn btn-primary" onclick="saveReminderVerifyKpiEdit()">Save</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Main toggle functions for menu items
        function toggleAchievementVerification() {
            const detail = document.getElementById('achievementVerificationDetail');
            detail.style.display = detail.style.display === 'none' ? 'block' : 'none';
        }

        function showReminderCard() {
            const detail = document.getElementById('kpiReminderNotificationDetail');
            detail.style.display = detail.style.display === 'none' ? 'block' : 'none';
        }

        function showUnderAchieveCard() {
            const detail = document.getElementById('achievementVerificationReminderDetail');
            detail.style.display = detail.style.display === 'none' ? 'block' : 'none';
        }

        function reminderVerifyKpiAchievement() {
            const detail = document.getElementById('reminderSubmitKpiAchievement');
            detail.style.display = detail.style.display === 'none' ? 'block' : 'none';
        }

        // Button functions for first section
        function revertVerificationContent() {
            if (confirm('Are you sure you want to revert the content?')) {
                document.getElementById('achievementVerificationForm').reset();
            }
        }

        function sendVerificationEmail() {
            if (confirm('Are you sure you want to send the email?')) {
                alert('Email sent successfully!');
            }
        }

        function revertVerificationReminderContent() {
            if (confirm('Are you sure you want to revert the content?')) {
                document.getElementById('achievementVerificationReminderForm').reset();
            }
        }

        function sendVerificationReminderEmail() {
            if (confirm('Are you sure you want to send the email?')) {
                alert('Email sent successfully!');
            }
        }

        // Configuration data for different duration types - specific to Achievement KPI
        const achievementKpiDurationConfigs = {
            quarterly: [{
                    period: 'Q1',
                    dates: '31/03/2022'
                },
                {
                    period: 'Q2',
                    dates: '29/06/2022'
                },
                {
                    period: 'Q3',
                    dates: '30/09/2022'
                },
                {
                    period: 'Q4',
                    dates: '21/12/2022'
                }
            ],
            annually: [{
                period: '1 (January - December)',
                dates: '15/12/2022'
            }],
            'bi-annually': [{
                    period: '1 (January - June)',
                    dates: '20/06/2022'
                },
                {
                    period: '2 (July - December)',
                    dates: '21/12/2022'
                }
            ],
            g3: [{
                    period: '1 (January - April)',
                    dates: '20/04/2022'
                },
                {
                    period: '2 (May - August)',
                    dates: '21/08/2022'
                },
                {
                    period: '3 (September - December)',
                    dates: '21/12/2022'
                }
            ],
            g6: [{
                    period: '1 (January - February)',
                    dates: '18/02/2022'
                },
                {
                    period: '2 (March - April)',
                    dates: '20/04/2022'
                },
                {
                    period: '3 (May - June)',
                    dates: '20/06/2022'
                },
                {
                    period: '4 (July - August)',
                    dates: '21/08/2022'
                },
                {
                    period: '5 (September - October)',
                    dates: '21/10/2022'
                },
                {
                    period: '6 (November - December)',
                    dates: '21/12/2022'
                }
            ]
        };

        // Add this configuration data after the achievementKpiDurationConfigs
        const reminderVerifyKpiDurationConfigs = {
            quarterly: [{
                    period: 'Q1',
                    dates: '31/03/2022'
                },
                {
                    period: 'Q2',
                    dates: '29/06/2022'
                },
                {
                    period: 'Q3',
                    dates: '30/09/2022'
                },
                {
                    period: 'Q4',
                    dates: '21/12/2022'
                }
            ],
            annually: [{
                period: '1 (January - December)',
                dates: '15/12/2022'
            }],
            'bi-annually': [{
                    period: '1 (January - June)',
                    dates: '20/06/2022'
                },
                {
                    period: '2 (July - December)',
                    dates: '21/12/2022'
                }
            ],
            g3: [{
                    period: '1 (January - April)',
                    dates: '20/04/2022'
                },
                {
                    period: '2 (May - August)',
                    dates: '21/08/2022'
                },
                {
                    period: '3 (September - December)',
                    dates: '21/12/2022'
                }
            ],
            g6: [{
                    period: '1 (January - February)',
                    dates: '18/02/2022'
                },
                {
                    period: '2 (March - April)',
                    dates: '20/04/2022'
                },
                {
                    period: '3 (May - June)',
                    dates: '20/06/2022'
                },
                {
                    period: '4 (July - August)',
                    dates: '21/08/2022'
                },
                {
                    period: '5 (September - October)',
                    dates: '21/10/2022'
                },
                {
                    period: '6 (November - December)',
                    dates: '21/12/2022'
                }
            ]
        };

        // Store current editing information for Achievement KPI
        let currentAchievementEditIndex = null;
        // Store current editing information
        let currentVerifyKpiEditIndex = null;
        let currentVerifyKpiEditRowElement = null;

        // Toggle function specific to Reminder Verify KPI Achievement notification
        function toggleReminderVerifyKpiNotificationConfig() {
            const toggle = document.getElementById('toggleReminderVerifyKpiConfig');
            const durationSection = document.getElementById('reminderVerifyKpiDurationSection');
            const tableContainer = document.getElementById('reminderVerifyKpiNotificationTableContainer');

            if (toggle.checked) {
                durationSection.style.display = 'block';
            } else {
                durationSection.style.display = 'none';
                tableContainer.style.display = 'none';
                document.getElementById('reminderVerifyKpiDurationSelect').value = '';
            }
        }

        // Update notification table function specific to Reminder Verify KPI Achievement
        function updateReminderVerifyKpiNotificationTable() {
            const durationSelect = document.getElementById('reminderVerifyKpiDurationSelect');
            const tableContainer = document.getElementById('reminderVerifyKpiNotificationTableContainer');
            const tableBody = document.getElementById('reminderVerifyKpiNotificationTableBody');

            const selectedDuration = durationSelect.value;

            if (selectedDuration && reminderVerifyKpiDurationConfigs[selectedDuration]) {
                const config = reminderVerifyKpiDurationConfigs[selectedDuration];

                // Clear existing rows
                tableBody.innerHTML = '';

                // Add new rows
                config.forEach((item, index) => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${item.period}</td>
                        <td>
                            <input type="date" class="form-control" name="reminder_dates[]" value="${convertToDateInput(item.dates)}">
                        </td>
                        <td>
                            <button type="button" class="btn btn-sm btn-outline-primary" onclick="editReminderVerifyKpiReminder(${index})">
                                <i class="bx bx-edit"></i>
                            </button>
                        </td>
                    `;
                    tableBody.appendChild(row);
                });

                tableContainer.style.display = 'block';
            } else {
                tableContainer.style.display = 'none';
            }
        }

        // Helper function to convert date format from DD/MM/YYYY to YYYY-MM-DD
        function convertToDateInput(dateStr) {
            const parts = dateStr.split('/');
            if (parts.length === 3) {
                return `${parts[2]}-${parts[1].padStart(2, '0')}-${parts[0].padStart(2, '0')}`;
            }
            return '';
        }

        // Helper function to convert date format from YYYY-MM-DD to DD/MM/YYYY
        function convertFromDateInput(dateStr) {
            const parts = dateStr.split('-');
            if (parts.length === 3) {
                return `${parts[2]}/${parts[1]}/${parts[0]}`;
            }
            return '';
        }

        // Edit reminder function specific to Reminder Verify KPI Achievement
        function editReminderVerifyKpiReminder(index) {
            const durationSelect = document.getElementById('reminderVerifyKpiDurationSelect');
            const selectedDuration = durationSelect.value;

            if (selectedDuration && reminderVerifyKpiDurationConfigs[selectedDuration]) {
                const config = reminderVerifyKpiDurationConfigs[selectedDuration][index];
                const tableRow = document.getElementById('reminderVerifyKpiNotificationTableBody').children[index];
                const dateInput = tableRow.querySelector('input[type="date"]');

                // Store current editing information
                currentVerifyKpiEditIndex = index;
                currentVerifyKpiEditRowElement = tableRow;

                // Populate modal with current data
                document.getElementById('verifyKpiQuarterMonthGroup').value = config.period;
                document.getElementById('verifyKpiReminderDate').value = convertFromDateInput(dateInput.value);

                // Show modal
                const modal = new bootstrap.Modal(document.getElementById('editReminderVerifyKpiModal'));
                modal.show();
            }
        }

        // Save reminder edit function
        function saveReminderVerifyKpiEdit() {
            const reminderDateInput = document.getElementById('verifyKpiReminderDate');
            const newDate = reminderDateInput.value;

            if (newDate && currentVerifyKpiEditRowElement) {
                // Convert DD/MM/YYYY to YYYY-MM-DD format for date input
                const convertedDate = convertToDateInput(newDate);

                // Update the date input in the table
                const dateInput = currentVerifyKpiEditRowElement.querySelector('input[type="date"]');
                dateInput.value = convertedDate;

                // Update the configuration data
                const durationSelect = document.getElementById('reminderVerifyKpiDurationSelect');
                const selectedDuration = durationSelect.value;
                if (selectedDuration && reminderVerifyKpiDurationConfigs[selectedDuration] && currentVerifyKpiEditIndex !== null) {
                    reminderVerifyKpiDurationConfigs[selectedDuration][currentVerifyKpiEditIndex].dates = newDate;
                }

                // Close modal
                const modal = bootstrap.Modal.getInstance(document.getElementById('editReminderVerifyKpiModal'));
                modal.hide();

                // Reset editing variables
                currentVerifyKpiEditIndex = null;
                currentVerifyKpiEditRowElement = null;

                // Show success message
                alert('Reminder date updated successfully!');
            } else {
                alert('Please enter a valid date in DD/MM/YYYY format.');
            }
        }

        // Placeholder functions for buttons
        function revertReminderVerifyKpiContent() {
            if (confirm('Are you sure you want to revert the content?')) {
                document.getElementById('reminderVerifyKpiForm').reset();
                document.getElementById('reminderVerifyKpiNotificationTableContainer').style.display = 'none';
            }
        }

        function sendReminderVerifyKpiEmail() {
            if (confirm('Are you sure you want to send the email?')) {
                // Add your email sending logic here
                alert('Email sent successfully!');
            }
        }

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            toggleReminderVerifyKpiNotificationConfig();
        });

        // Add date formatting for the modal input
        document.getElementById('verifyKpiReminderDate').addEventListener('blur', function() {
            let value = this.value.replace(/\D/g, ''); // Remove non-digits
            if (value.length >= 8) {
                value = value.substring(0, 8);
                this.value = value.substring(0, 2) + '/' + value.substring(2, 4) + '/' + value.substring(4, 8);
            }
        });
    </script>


    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    <script>
        function toggleAchievementVerification() {
            const detail = document.getElementById('achievementVerificationDetail');
            detail.style.display = detail.style.display === 'none' ? 'block' : 'none';
        }

        function showReminderCard() {
            const detail = document.getElementById('kpiReminderNotificationDetail');
            detail.style.display = detail.style.display === 'none' ? 'block' : 'none';
        }

        function showUnderAchieveCard() {
            const detail = document.getElementById('achievementVerificationReminderDetail');
            detail.style.display = detail.style.display === 'none' ? 'block' : 'none';
        }

        function reminderVerifyKpiAchievement() {
            const detail = document.getElementById('reminderSubmitKpiAchievement');
            detail.style.display = detail.style.display === 'none' ? 'block' : 'none';
        }

        function revertVerificationContent() {
            if (confirm('Are you sure you want to revert the content?')) {
                document.getElementById('achievementVerificationForm').reset();
            }
        }

        function sendVerificationEmail() {
            if (confirm('Are you sure you want to send the email?')) {
                alert('Email sent successfully!');
            }
        }

        function revertVerificationReminderContent() {
            if (confirm('Are you sure you want to revert the content?')) {
                document.getElementById('achievementVerificationReminderForm').reset();
            }
        }

        function sendVerificationReminderEmail() {
            if (confirm('Are you sure you want to send the email?')) {
                alert('Email sent successfully!');
            }
        }
    </script>
    <script>
document.addEventListener('DOMContentLoaded', function () {
    const radios = document.querySelectorAll('input[name="durationType"]');
    const quarterlyTable = document.getElementById('quarterlyTable');
    const annuallyTable = document.getElementById('annuallyTable');
    const biAnnuallyTable = document.getElementById('biAnnuallyTable');

    function toggleTables(value) {
        quarterlyTable.style.display = 'none';
        annuallyTable.style.display = 'none';
        biAnnuallyTable.style.display = 'none';

        if (value === 'quarterly') {
            quarterlyTable.style.display = 'block';
        } else if (value === 'annually') {
            annuallyTable.style.display = 'block';
        } else if (value === 'bi-annually') {
            biAnnuallyTable.style.display = 'block';
        }
    }

    radios.forEach(radio => {
        radio.addEventListener('change', () => toggleTables(radio.value));
    });

    const defaultRadio = document.querySelector('input[name="durationType"]:checked');
    if (defaultRadio) toggleTables(defaultRadio.value);
});
</script>
<script>
  function saveColor(colorName) {
    if (colorName === 'Green') {
      const color = document.getElementById('colorInputGreen').value;
      document.getElementById('colorPreviewGreen').style.backgroundColor = color;
      document.getElementById('colorLabelGreen').textContent = color;
    }

    // Kalau nak guna untuk warna lain: boleh tambah else if di sini
  }
</script>
