<!-- Final KPI Notification Detail Section -->
<div class="row mt-4" id="finalKpiNotificationDetail" style="display: none;">
  <div class="col-12">
    <div class="card mb-4">
      <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-4">
          <h5 class="card-title mb-0">Notification for Reminder Key in Endorsed KPI Indicator</h5>
          
        </div>

        <form id="finalKpiNotificationForm" method="POST" action="{{ url('/kpi-configuration/final-kpi-notification') }}">
          @csrf
          <div class="row mb-3">
            <div class="col-md-12">
              <div class="mb-3">
                <label for="finalKpiDate" class="form-label">Notification Date <span class="text-danger">*</span></label>
                <div class="d-flex align-items-center">
                  <div class="input-group" style="max-width: 300px;">
                    <input type="text" class="form-control datepicker" id="finalKpiDate" name="finalKpiDate"
                      placeholder="Select date" required value="{{ $finalKpiDate ?? '' }}">
                    <span class="input-group-text"><i class="bx bx-calendar"></i></span>
                  </div>
                  <div class="form-check form-switch ms-auto">
                    <input class="form-check-input" type="checkbox" id="toggleFinalKpiEmailConfig" checked>
                    <label class="form-check-label" for="toggleFinalKpiEmailConfig">Enable/Disable</label>
                  </div>
                </div>
              </div>
            </div>
          </div>

          <div class="row mb-3">
            <div class="col-md-12">
              <div class="mb-3">
                <label for="finalKpiEmailTo" class="form-label">To <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="finalKpiEmailTo" name="emailTo"
                  placeholder="Enter email addresses separated by semicolon"
                  value="{{ $finalKpiEmailTo ?? '' }}" required>
              </div>
            </div>
          </div>

          <div class="row mb-3">
            <div class="col-md-12">
              <div class="mb-3">
                <label for="finalKpiEmailTitle" class="form-label">Email Subject <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="finalKpiEmailTitle" name="emailTitle"
                  placeholder="Enter email subject"
                  value="{{ $finalKpiEmailTitle ?? '' }}" required>
              </div>
            </div>
          </div>

          <div class="row mb-3">
            <div class="col-md-12">
              <div class="mb-3">
                <label for="finalKpiEmailContent" class="form-label">Email Content <span class="text-danger">*</span></label>
                <div id="finalKpiEmailContentEditor">
                  <div class="card">
                    <div class="card-body p-2">
                      <div class="d-flex justify-content-start align-items-center mb-2">
                        <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-bold"></i></button>
                        <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-italic"></i></button>
                        <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-underline"></i></button>
                        <div class="dropdown me-1">
                          <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            Headings
                          </button>
                          <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#">Heading 1</a></li>
                            <li><a class="dropdown-item" href="#">Heading 2</a></li>
                            <li><a class="dropdown-item" href="#">Heading 3</a></li>
                          </ul>
                        </div>
                        <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ul"></i></button>
                        <button type="button" class="btn btn-sm btn-outline-secondary me-1"><i class="bx bx-list-ol"></i></button>
                        <button type="button" class="btn btn-sm btn-outline-secondary"><i class="bx bx-align-middle"></i></button>
                      </div>
                    </div>
                  </div>
                  <textarea class="form-control" id="finalKpiEmailContent" name="emailContent" rows="12" required>{{ $finalKpiEmailContent ?? '' }}</textarea>
                </div>
              </div>
            </div>
          </div>

          <div class="d-flex justify-content-end mt-4">
            <button type="button" class="btn btn-secondary me-2" onclick="revertFinalKpiContent()">Revert Content</button>
            <button type="submit" class="btn btn-primary me-2">Save</button>
            <button type="button" class="btn btn-success" onclick="sendFinalKpiEmail()">Send</button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>