    <style>
        /* Unified container styling for both form and results */
        .unified-container {
            background-color: white;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            margin-bottom: 20px;
            width: 100%;
            box-sizing: border-box;
        }

        /* Form specific styling */
        .form-section {
            padding: 30px;
        }

        /* Results accordion styling */
        .results-section {
            padding: 0;
        }

        .results-section .accordion {
            border-radius: 8px;
            overflow: hidden;
        }

        .results-section .accordion-item:first-child {
            border-top: none;
        }

        .results-section .accordion-item:last-child {
            border-bottom: none;
        }

        /* Ensure both containers have the same visual appearance */
        .container-wrapper {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 15px;
        }

        /* Table styling improvements */
        .table-responsive {
            border-radius: 6px;
            overflow: hidden;
        }

        /* Button group spacing */
        .btn-group .btn {
            margin-right: 5px;
        }

        .btn-group .btn:last-child {
            margin-right: 0;
        }

        /* Card hover effects */
        .card {
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        /* Form element focus effects */
        .form-select:focus,
        .form-control:focus {
            transform: translateY(-1px);
            box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .form-section {
                padding: 20px;
            }
            
            .btn-group {
                flex-wrap: wrap;
                gap: 5px;
            }
        }
    </style>
</head>
<body class="">
    <div class="container-wrapper py-4">
        
        <!-- FILTER FORM SECTION -->
            <div class="unified-container">
                <div class="form-section">
                    <!-- First Row: Division, Section, Unit/Office -->
                    <div class="row g-3 mb-3">
                        <div class="col-md-4">
                            <label for="division" class="form-label">Division</label>
                            <select class="form-select" id="division">
                                <option selected>Please Select</option>
                                <option>CEO'S Office</option>
                                <option>Management Services</option>
                                <option>EXPORTER PROMOTION AND MARKET ACCESS</option>
                                <option>Strategic Planning</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="section" class="form-label">Section</label>
                            <select class="form-select" id="section">
                                <option selected>Please Select</option>
                                <option>ASEAN & Oceania</option>
                                <option value>Central, West, South Asia & Africa Section</option>
                                <option value=>China & Northeast Asia</option>
                                <option value=>Construction & Business Services</option>
                                <option value=>Coordination & Monitoring</option>
                                <option value=>Corporate Management</option>
                                <option value=>Customised Programme</option>
                                <option value=>Development Assistance</option>
                                <option value=>Digital Trade</option>
                                <option value=>Electrical & Electronics, ICT, Machinery & Equipment</option>
                                <option value=>Europe & Americas</option>
                                <option value=>Export Academy</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="unit" class="form-label">Unit/Office</label>
                            <select class="form-select" id="unit">
                                <option value="">Please select</option>
                                <option value="unit1">Account</option>
                                <option value="unit2">Administration</option>
                                <option value="unit3">Application System Management Unit</option>
                                <option value="unit4">Asset Management</option>
                                <option value="unit5">Business Information Centre (BIC)</option>
                                <option value="unit6">Competency & Talent Development</option>
                                <option value="unit7">Corporate Communication</option>
                                <option value="unit8">Digital Services</option>
                                <option value="unit9">eCommerce Ecosystem</option>
                                <option value="unit10">Exporters Advisory & Training (EATU)</option>
                                <option value="unit11">Facility Management</option>
                                <option value="unit12">Finance</option>
                                <option value="unit13">Human Resource Management</option>
                                <option value="unit14">ICT Operation & Support</option>
                                <option value="unit15">Integrity</option>
                                <option value="unit16">Internal Audit</option>
                                <option value="unit19">International Collaboration</option>
                                <option value="unit20">Johor</option>
                                <option value="unit21">Market Development</option>
                                <option value="unit22">Micro, Small and Medium Enterprises (MSME)</option>
                                <option value="unit23">Mid Tier</option>
                                <option value="unit24">MO - BUDAPEST</option>
                                <option value="unit25">MO - BUENOS AIRES</option>
                                <option value="unit26">MO - DOHA</option>
                                <option value="unit27">MO - HANOI</option>
                                <option value="unit28">MO - KARACHI</option>
                                <option value="unit29">MO - KIEV</option>
                                <option value="unit30">MO - MEDAN</option>
                                <option value="unit31">MO - NAIROBI</option>
                                <option value="unit32">MO - OSAKA</option>
                                <option value="unit33">MO - PHNOM PENH</option>
                                <option value="unit34">MO - TASHKENT</option>
                                <option value="unit35">MyTRADE Digital</option>
                                <option value="unit36">N/A</option>
                                <option value="unit37">Network & ICT Security Unit</option>
                                <option value="unit38">Organisational Planning & Transformation</option>
                                <option value="unit39">Penang</option>
                                <option value="unit40">Perfomance Monitoring</option>
                                <option value="unit41">Procurement</option>
                                <option value="unit42">Revenue Generation</option>
                                <option value="unit43">Sabah</option>
                                <option value="unit44">Sarawak</option>
                                <option value="unit45">Strategic Coordination</option>
                                <option value="unit46">Strategic Development</option>
                                <option value="unit47">TC - ALMATY</option>
                                <option value="unit48">TC - BANGKOK</option>
                                <option value="unit49">TC - BEIJING</option>
                                <option value="unit50">TC - CAIRO</option>
                                <option value="unit51">TC - CHENGDU</option>
                                <option value="unit52">TC - CHENNAI</option>
                                <option value="unit53">TC - DUBAI</option>
                                <option value="unit54">TC - FRANKFURT</option>
                                <option value="unit55">TC - GUANGZHOU</option>
                                <option value="unit56">TC - HO CHI MINH CITY</option>
                                <option value="unit57">TC - HONG KONG</option>
                                <option value="unit58">TC - ISTANBUL</option>
                                <option value="unit59">TC - JAKARTA</option>
                                <option value="unit60">TC - JEDDAH</option>
                                <option value="unit61">TC - JOHANNESBURG</option>
                                <option value="unit62">TC - LAGOS</option>
                                <option value="unit63">TC - LONDON</option>
                                <option value="unit64">TC - LOS ANGELES</option>
                                <option value="unit65">TC - MANILA</option>
                                <option value="unit66">TC - MELBOURNE</option>
                                <option value="unit67">TC - MEXICO CITY</option>
                                <option value="unit68">TC - MIAMI</option>
                                <option value="unit69">TC - MILAN</option>
                                <option value="unit70">TC - MOSCOW</option>
                                <option value="unit71">TC - MUMBAI</option>
                                <option value="unit72">TC - NEW YORK</option>
                                <option value="unit73">TC - PARIS</option>
                                <option value="unit74">TC - ROTTERDAM</option>
                                <option value="unit75">TC - SANTIAGO</option>
                                <option value="unit76">TC - SAO PAULO</option>
                                <option value="unit77">TC - SEOUL</option>
                                <option value="unit78">TC - SHANGHAI</option>
                                <option value="unit79">TC - SINGAPORE</option>
                                <option value="unit80">TC - TAIPEI</option>
                                <option value="unit81">TC - TOKYO</option>
                                <option value="unit82">TC - WARSAW</option>
                                <option value="unit83">TC - YANGON</option>
                                <option value="unit84">Terengganu</option>
                                <option value="unit85">Trade Ananlysis</option>
                                <option value="unit86">Trade Publication</option>
                                <option value="unit87">Trade Statistic</option>
                            </select>
                        </div>
                    </div>

                    <!-- Second Row: Category, Indicator -->
                    <div class="row g-3 mb-3">
                        <div class="col-md-6">
                            <label for="category" class="form-label">Category</label>
                            <select class="form-select" id="category">
                                <option selected>Please Select</option>
                                <option>Customer</option>
                                <option>Finance</option>
                                <option>People</option>
                                <option>Process</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="indicator" class="form-label">Indicator</label>
                            <select class="form-select" id="indicator">
                                <option selected>Please Select</option>
                                <option>Type 1</option>
                                <option>Type 2</option>
                                <option>Type 3</option>
                            </select>
                        </div>
                    </div>

                    <!-- Third Row: Year From, Year To, Duration From -->
                    <div class="row g-3 mb-3">
                        <div class="col-md-4">
                            <label for="yearFrom" class="form-label">Year From</label>
                            <input type="text" class="form-control" id="yearFrom" placeholder="From" />
                        </div>
                        <div class="col-md-4">
                            <label for="yearTo" class="form-label">Year To</label>
                            <input type="text" class="form-control" id="yearTo" placeholder="To" />
                        </div>
                        <div class="col-md-4">
                            <label for="durationFrom" class="form-label">Duration From</label>
                            <select class="form-select" id="durationFrom">
                                <option selected>Please Select</option>
                                <option>Quarterly-Q1</option>
                                <option>Quarterly-Q2</option>
                                <option>Quarterly-Q3</option>
                                <option>Quarterly-Q4</option>
                            </select>
                        </div>
                    </div>

                    <!-- Fourth Row: Duration To, Report Title -->
                    <div class="row g-3 mb-3">
                        <div class="col-md-4">
                            <label for="durationTo" class="form-label">Duration To</label>
                            <select class="form-select" id="durationTo">
                                <option selected>Please Select</option>
                                <option>Quarterly-Q1</option>
                                <option>Quarterly-Q2</option>
                                <option>Quarterly-Q3</option>
                                <option>Quarterly-Q4</option>
                            </select>
                        </div>
                        <div class="col-md-8">
                            <label for="reportTitle" class="form-label">Report Title</label>
                            <select class="form-select" id="reportTitle">
                                <option>Please Select</option>
                                <option value="1">Analysis on Submission on Articles from Market Desks</option>
                                <option value="2">Analysis on Submission of Success Stories from TCs, Regional Offices & Desks</option>
                                <option value="3">Annual Export Revenue</option>
                                <option value="4">Budget & Expenses</option>
                                <option value="5">Companies by Sectors</option>
                                <option value="6">Enquiries Received & Answered</option>
                                <option value="7">Export Sales</option>
                                <option value="8">Export Sales from Market Immersion Programme (RM Million)</option>
                                <option value="9">Exporters Development Programmes Achievement by Programme Type</option>
                                <option value="10">Follow-up - Realised Sales from INSP conjunction with major exhibitions in Malaysia</option>
                                <option value="11">Increase in new registration in MER</option>
                                <option value="12">Initiatives implemented by MATRADE</option>
                                <option value="13">Literacy & outreach programme</option>
                                <option value="14">No. Companies Assisted (Local/Foreign)</option>
                                <option value="15">No. MEEC Exhibitors</option>
                                <option value="16">No. of BIC Users</option>
                                <option value="17">No of Companies</option>
                                <option value="18">No of Exporters Trained</option>
                                <option value="19">No of Participating Companies</option>
                                <option value="20">No of Programme</option>
                                <option value="21">No of Training programme stastitics</option>
                                <option value="22">Performance Indicators and Achievements</option>
                                <option value="23">Project Value</option>
                                <option value="24">Total Companies (Wave 1-x) based on Sectorial Desk</option>
                                <option value="25">Strategic Development Unit Achievements</option>
                                <option value="26">Strengthening Industry Database: Malaysian Exporters Registry (MER): Summary</option>
                                <option value="27">Strengthening Industry Database: Foreign Importers Database Summary</option>
                                <option value="28">Strengthening Industry Database: Foreign Importers Database TC Offices with less than 25% Achievements</option>
                                <option value="29">Strengthening Industry Database: Malaysian Exporters Registry (MER) by Regional/State Office</option>
                                <option value="30">Strengthening Industry Database: Malaysian Exporters Registry (MER) by Section</option>
                                <option value="31">Strengthening Industry Database: Update on Malaysian Companies Abroad Database</option>
                                <option value="32">Summary of Realised Sales from Export Promotion Programmes</option>
                                <option value="33">Trade & Market Intelligence Reports</option>
                                <option value="34">Usage of BIC Ref. Material</option>
                            </select>
                        </div>
                    </div>

                    <!-- Fifth Row: Search/Reset Buttons -->
                    <div class="row g-3 mb-0">
                        <div class="col-md-12 d-flex justify-content-end gap-2">
                             <button type="button" class="btn btn-primary" id="searchBtn">
                                <i class=""></i>Search
                            </button>
                           <button type="button" class="btn btn-secondary" id="resetBtn">
                                <i class=""></i>Reset
                            </button>
                           
                        </div>
                    </div>
                </div>
            </div>

        <!-- SEPARATOR -->
        <hr class="my-4" style="border-top: 2px solid #dee2e6;">