@php
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
$containerNav = $containerNav ?? 'container-fluid';
$navbarDetached = ($navbarDetached ?? '');
@endphp

<!-- Custom Styles -->
<!-- Custom Styles -->
<style>
  #layout-navbar {
    margin-top: 0 !important;
    padding-top: 0 !important;
    top: 0 !important;
    z-index: 1050;
    position: fixed;
    width: calc(100% - 250px); /* Default with sidebar */
    background-color: #004b87 !important;
    border-radius: 0 !important;
    transition: all 0.3s ease;
  }

  .container-fluid {
    padding-top: 0 !important;
  }

  .dropdown-menu.notifications {
    width: 360px;
    max-height: 400px;
    overflow-y: auto;
  }

  .notifications .notification-item {
    padding: 10px 15px;
    border-bottom: 1px solid #f0f0f0;
  }

  .notifications .notification-item:last-child {
    border-bottom: none;
  }

  .notifications .notification-item:hover {
    background-color: #f6f6f6;
  }

  /* Sidebar and page layout */
  .layout-page {
    margin-left: 250px;
    padding-left: 0 !important;
    width: calc(100% - 250px) !important;
    transition: all 0.3s ease;
  }

  .layout-menu {
    transition: all 0.3s ease;
  }

  #layout-navbar {
    transition: all 0.3s ease;
  }

  /* Toggle sidebar collapse */
  body.sidebar-collapsed .layout-menu {
    margin-left: -250px !important;
  }

  body.sidebar-collapsed .layout-page {
    margin-left: 0 !important;
    width: 100% !important;
    padding-left: 0 !important;
  }

  body.sidebar-collapsed #layout-navbar {
    width: 100% !important;
  }
</style>


<!-- Navbar -->
@if(isset($navbarDetached) && $navbarDetached == 'navbar-detached')
<nav class="layout-navbar {{ $containerNav }} navbar navbar-expand-xl {{ $navbarDetached }} align-items-center bg-navbar-theme" id="layout-navbar">
@endif

@if(isset($navbarDetached) && $navbarDetached == '')
<nav class="layout-navbar navbar navbar-expand-xl align-items-center bg-navbar-theme" id="layout-navbar">
  <div class="{{ $containerNav }}">
@endif

  <!-- Brand -->
  @if(isset($navbarFull))
  <div class="navbar-brand app-brand demo d-none d-xl-flex py-0 me-4">
    <a href="{{ url('/') }}" class="app-brand-link gap-2">
      <span class="app-brand-logo demo">@include('_partials.macros',["width"=>25,"withbg"=>'var(--bs-primary)'])</span>
      <span class="app-brand-text demo menu-text fw-bold text-heading">{{ config('variables.templateName') }}</span>
    </a>
  </div>
  @endif

  <!-- Menu toggle -->
  @if(!isset($navbarHideToggle))
  <div class="layout-menu-toggle navbar-nav align-items-xl-center me-4 me-xl-0">
    <a class="nav-item nav-link px-0 me-xl-6" href="javascript:void(0)">
      <i class="bx bx-menu bx-md text-white"></i>
    </a>
  </div>
  @endif

  <div class="navbar-nav-right d-flex align-items-center" id="navbar-collapse">
    <ul class="navbar-nav flex-row align-items-center ms-auto">

      <!-- Notification Icon & Dropdown -->
      <li class="nav-item dropdown me-3 position-relative">
        <a class="nav-link dropdown-toggle text-white" href="#" id="notifDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
          <i class="bx bx-bell fs-5"></i>
          <span class="position-absolute top-0 start-100 translate-middle p-1 bg-danger border border-light rounded-circle">
            <span class="visually-hidden">New alerts</span>
          </span>
        </a>

        <ul class="dropdown-menu dropdown-menu-end shadow notifications" aria-labelledby="notifDropdown" style="width: 400px;">
          <li class="px-3 pt-2 pb-1 d-flex justify-content-between align-items-center">
            <h6 class="mb-0">Notification</h6>
            <a href="#" class="text-primary small">Clear</a>
          </li>
          <li><hr class="dropdown-divider my-1"></li>

          <!-- INDICATOR CONFIG -->
          <li class="notification-item">
            <a href="#" class="dropdown-item d-flex align-items-start gap-2">
              <i class="bx bx-check-circle text-primary mt-1"></i>
              <div>
                <div>Notification to Submit Endorsed KPI Indicator</div>
                <small class="text-muted">1 week ago</small>
              </div>
            </a>
          </li>
          <li class="notification-item">
            <a href="#" class="dropdown-item d-flex align-items-start gap-2">
              <i class="bx bx-bell text-warning mt-1"></i>
              <div>
                <div>Reminder to Submit Endorsed KPI Indicator</div>
                <small class="text-muted">2 week ago</small>
              </div>
            </a>
          </li>
          <li><hr class="dropdown-divider my-1"></li>

          <!-- ACHIEVEMENT CONFIG -->
          <li class="notification-item">
            <a href="#" class="dropdown-item d-flex align-items-start gap-2">
              <i class="bx bx-check-circle text-primary mt-1"></i>
              <div>
                <div>Notification to Submit KPI Achievement</div>
                <small class="text-muted">3 week ago</small>
              </div>
            </a>
          </li>
          <li class="notification-item">
            <a href="#" class="dropdown-item d-flex align-items-start gap-2">
              <i class="bx bx-bell text-warning mt-1"></i>
              <div>
                <div>Reminder to Submit KPI Achievement</div>
                <small class="text-muted">1 month ago</small>
              </div>
            </a>
          </li>
          <li class="notification-item">
            <a href="#" class="dropdown-item d-flex align-items-start gap-2">
              <i class="bx bx-envelope text-info mt-1"></i>
              <div>
                <div>Notification to Verify KPI Achievement</div>
                <small class="text-muted">1 week ago</small>
              </div>
            </a>
          </li>
          <li class="notification-item">
            <a href="#" class="dropdown-item d-flex align-items-start gap-2">
              <i class="bx bx-bell-ring text-danger mt-1"></i>
              <div>
                <div>Reminder to Verify KPI Achievement</div>
                <small class="text-muted">2 hari yang lepas</small>
              </div>
            </a>
          </li>
        </ul>
      </li>

      <!-- Hi, User -->
      <li class="nav-item me-2 d-none d-sm-block">
        <span class="text-white fw-semibold">Hi, {{ Auth::user()->name ?? 'Syafiq' }}</span>
      </li>

      <!-- User Avatar -->
      <li class="nav-item navbar-dropdown dropdown-user dropdown">
        <a class="nav-link dropdown-toggle hide-arrow p-0" href="javascript:void(0);" data-bs-toggle="dropdown">
          <div>
            <img src="{{ asset('assets/img/avatars/userprofile.jpg') }}" alt class="w-px-40 h-auto rounded-circle">
          </div>
        </a>
        <ul class="dropdown-menu dropdown-menu-end">
          <li class="dropdown-item text-center">
            <div class="d-flex justify-content-center mb-2">
              <div class="avatar avatar-online">
                <img src="{{ asset('assets/img/avatars/userprofile.jpg') }}" alt class="w-px-60 h-auto rounded-circle">
              </div>
            </div>
            <h6 class="mb-0">{{ Auth::user()->name ?? 'Syafiq Kyle' }}</h6>
            <small class="text-muted d-block">
              <i class="bx bx-envelope me-1"></i>{{ Auth::user()->email ?? 'syafiq@example.com' }}
            </small>
          </li>
          <li><div class="dropdown-divider my-1"></div></li>
          <li class="dropdown-item">
            <label for="roleSelect" class="form-label mb-1">Role</label>
            <select id="roleSelect" class="form-select form-select-sm">
              <option selected>{{ Auth::user()->role ?? 'PMU Admin' }}</option>
              <option>IT Admin</option>
              <option>MATRADE Employee</option>
            </select>
          </li>
          <li class="dropdown-item text-center mt-2">
            <form action="{{ route('logout') }}" method="POST">
              @csrf
              <button type="submit" class="btn btn-sm btn-outline-primary w-100">Sign Out</button>
            </form>
          </li>
        </ul>
      </li>
    </ul>
  </div>

@if(!isset($navbarDetached))
  </div>
@endif
</nav>
<!-- / Navbar -->

<!-- Sidebar toggle logic -->
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const toggleBtn = document.querySelector('.layout-menu-toggle a');
    const body = document.body;

    // Mulakan dengan sidebar terbuka
    body.classList.remove('sidebar-collapsed');

    // Toggle sidebar
    toggleBtn?.addEventListener('click', function () {
      body.classList.toggle('sidebar-collapsed');
    });
  });
</script>
