<div class="modal fade" id="addNewModal" tabindex="-1" aria-labelledby="addNewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
    <div class="modal-content">
        <div class="modal-header">
        <h5 class="modal-title" id="addNewModalLabel">Add New Indicator</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>

        <div class="modal-body">
        <form id="newIndicatorForm" method="POST" action="{{ route('new-indicator.store') }}">
            {!! csrf_field() !!}

            <div class="mb-3 row">
                <label for="division" class="col-sm-3 col-form-label">Division</label>
                <div class="col-sm-9">
                    <select class="form-select" id="division" name="division">
                        <option value=""> Please Select </option>
                        <option value="ceo">CEO OFFICE</option>
                        <option value="exports">EXPORTS PROMOTION & MARKET ACCESS DIVISION</option>
                        <option value="management">MANAGEMENT SERVICES DIVISION</option>
                    </select>
                </div>
            </div>

            <div class="mb-3 row">
                <label for="section" class="col-sm-3 col-form-label">Section</label>
                <div class="col-sm-9">
                    <select class="form-select" id="section" name="section">
                    <option value=""> Please Select </option>
                    <option value="ceo">CEO OFFICE</option>
                    <option value="exports">EXPORTS PROMOTION & MARKET ACCESS DIVISION</option>
                    <option value="management">MANAGEMENT SERVICES DIVISION</option>
                    </select>
                </div>
            </div>

            <div class="mb-3 row">
                <label for="unit" class="col-sm-3 col-form-label">Unit/Office</label>
                <div class="col-sm-9">
                    <select class="form-select" id="unit" name="unit">
                    <option value=""> Please Select </option>
                    <option value="ceo">CEO OFFICE</option>
                    <option value="exports">EXPORTS PROMOTION & MARKET ACCESS DIVISION</option>
                    <option value="management">MANAGEMENT SERVICES DIVISION</option>
                    </select>
                </div>
            </div>

            <div class="mb-3 row">
                <label for="year" class="col-sm-3 col-form-label">Year</label>
                <div class="col-sm-9">
                    <input type="number" class="form-control" id="year" name="year">
                </div>
            </div>

            <div class="mb-3 row">
                <label for="indicator" class="col-sm-3 col-form-label">Indicator</label>
                <div class="col-sm-9">
                    <input type="text" class="form-control" id="indicator" name="indicator">
                </div>
            </div>

            <div class="mb-3 row">
            <label for="indicator_type" class="col-sm-3 col-form-label">Indicator Type</label>
            <div class="col-sm-9">
                <select class="form-select" id="kpi_indicator_type_id_m" name="kpi_indicator_type_id">
                    <option value="" disabled selected>Select Indicator Type</option>
                    @foreach ($indicator_type_list as $item)
                        <option value="{{ $item->kpi_indicator_type_id }}" data-definition="{{ $item->indicator_type_description }}">
                            {{ formatType($item->indicator_type) }}</option>
                    @endforeach
                </select>
            </div>
            </div>

            <!-- Textarea for Indicator Type Definition -->
            <div class="row mb-3">
                <label class="col-md-3 col-form-label">Indicator Type Definition</label>
                <div class="col-md-9">
                    <textarea class="form-control" id="indicator_type_def_m" name="indicator_type_def" rows="3" readonly></textarea>
                </div>
            </div>

            <div class="mb-3 row">
                <label for="submission" class="col-sm-3 col-form-label">Submission</label>
                <div class="col-sm-9">
                    <select class="form-select" id="submission" name="submission">
                        <option value=""> Please Select </option>
                        <option value="anually">Annually</option>
                        <option value="quarter">Quarterly</option>
                        <option value="bi_anually">Bi-Annually</option>
                    </select>
                </div>
            </div>

            <div class="mb-3 row">
                <label for="annual_target" class="col-sm-3 col-form-label">Annual Target</label>
                <div class="col-sm-9">
                    <input type="text" class="form-control" id="annual_target" name="annual_target">
                </div>
            </div>

            <div class="mb-3 row">
                <label for="metric" class="col-sm-3 col-form-label">Metric</label>
                <div class="col-sm-9">
                    <select class="form-select" id="metric" name="metric">
                        <option value=""> Please Select </option>
                        <option value="activity">Activity</option>
                        <option value="article">Article</option>
                        <option value="booklet">Booklet</option>
                        <option value="company">Company</option>
                        <option value="enquiry">Enquiry</option>
                        <option value="event">Event</option>
                        <option value="exam">Exam</option>
                        <option value="followers">Followers</option>
                        <option value="media_coverage">Media Coverage</option>
                        <option value="meeting">Meeting</option>
                        <option value="percentage">Percentage</option>
                        <option value="phase">Phase</option>
                        <option value="press_releases">Press Releases</option>
                        <option value="profiles">Profiles</option>
                        <option value="programme">Programme</option>
                        <option value="publication">Publication</option>
                        <option value="release">Release</option>
                        <option value="report">Report</option>
                        <option value="rm">RM</option>
                        <option value="story">Story</option>
                        <option value="time">Time</option>
                        <option value="unit">Unit</option>
                        <option value="update">Update</option>
                    </select>
                </div>
            </div>

            <div class="mb-3 row">
                <label for="category" class="col-sm-3 col-form-label">Category</label>
                <div class="col-sm-9">
                    <select class="form-select" id="category" name="category">
                        <option value=""> Please Select </option>
                        <option value="customer">Customer</option>
                        <option value="finance">Finance</option>
                        <option value="people">People</option>
                        <option value="process">Process</option>
                    </select>
                </div>
            </div>

            <div class="mb-3 row">
                <label for="output_outcome" class="col-sm-3 col-form-label">Output/Outcome</label>
                <div class="col-sm-9">
                        <select class="form-select" id="output_outcome" name="output_outcome">
                        <option value=""> Please Select </option>
                        <option value="output">Output</option>
                        <option value="outcome">Outcome</option>
                        <option value="process">Process</option>
                    </select>
                </div>
            </div>

            <div class="mb-3 row">
                <label for="component_achievement" class="col-sm-3 col-form-label">Component Achievement</label>
                <div class="col-sm-9">
                    <select class="form-select" id="component_achievement" name="component_achievement">
                        <option value=""> Please Select </option>
                        <option value="promotion">Export Promotion</option>
                        <option value="development">Exporters Development</option>
                        <option value="na">N/A</option>
                    </select>
                </div>
            </div>

        </div>

        <div class="modal-footer">
        <button type="submit" class="btn btn-primary">Save</button>
        <button type="reset" class="btn btn-secondary">Reset</button>
        </div>
        </form>
    </div>
    </div>
</div>

<script>
    document.getElementById('kpi_indicator_type_id_m').addEventListener('change', function() {
        const selectedOption = this.options[this.selectedIndex];
        const definition = selectedOption.getAttribute('data-definition') || '';
        console.log('Selected Definition:', definition); // For debugging
        document.getElementById('indicator_type_def_m').value = definition;
    });
</script>