<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$allowedLangs = ['ms', 'en'];
$app          = Factory::getApplication();
$reqLang      = strtolower((string) $app->input->get('lang', '', 'cmd'));
$cookieLang   = strtolower((string) $app->input->cookie->getString('site_lang', ''));
$langKey      = in_array($reqLang, $allowedLangs, true) ? $reqLang : (in_array($cookieLang, $allowedLangs, true) ? $cookieLang : 'ms');

$photo = '';
if (!empty($director['photo']) && is_string($director['photo']) && is_file(JPATH_ROOT . '/' . ltrim($director['photo'], '/'))) {
    $photo = Uri::root() . ltrim($director['photo'], '/');
}
$name = $director['name'] ?? '';
$position = ($langKey === 'en') ? ($director['position_en'] ?? '') : ($director['position_ms'] ?? '');
$tenure   = ($langKey === 'en') ? ($director['tenure_en'] ?? '') : ($director['tenure_ms'] ?? '');
?>
<div class="pengarahprofile-card">
    <div class="pengarahprofile-photo">
        <?php if ($photo) : ?>
            <img src="<?php echo htmlspecialchars($photo, ENT_QUOTES, 'UTF-8'); ?>" alt="<?php echo htmlspecialchars((string) $name, ENT_QUOTES, 'UTF-8'); ?>">
        <?php else : ?>
            <div class="pengarahprofile-initial"><?php echo htmlspecialchars((string) ($director['initial'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></div>
        <?php endif; ?>
    </div>
    <div class="pengarahprofile-info">
        <h3><?php echo htmlspecialchars((string) $name, ENT_QUOTES, 'UTF-8'); ?></h3>
        <p><?php echo htmlspecialchars((string) $position, ENT_QUOTES, 'UTF-8'); ?></p>
        <?php if ($tenure !== '') : ?>
            <div class="pengarahprofile-badge"><?php echo htmlspecialchars((string) $tenure, ENT_QUOTES, 'UTF-8'); ?></div>
        <?php endif; ?>
        <?php if (!empty($director['email'])) : ?>
            <p><a href="mailto:<?php echo htmlspecialchars($director['email'], ENT_QUOTES, 'UTF-8'); ?>"><?php echo htmlspecialchars($director['email'], ENT_QUOTES, 'UTF-8'); ?></a></p>
        <?php endif; ?>
        <?php if (!empty($director['phone'])) : ?>
            <p><?php echo htmlspecialchars($director['phone'], ENT_QUOTES, 'UTF-8'); ?></p>
        <?php endif; ?>
    </div>
</div>

<style>
.pengarahprofile-card { border:1px solid #e5e7eb; background:#fff; padding:16px; display:grid; grid-template-columns: 160px 1fr; gap:16px; align-items:start; }
.pengarahprofile-photo { width:160px; height:160px; border:1px solid #e5e7eb; overflow:hidden; display:flex; align-items:center; justify-content:center; }
.pengarahprofile-photo img { width:100%; height:100%; object-fit:cover; object-position:top; }
.pengarahprofile-initial { width:100%; height:100%; display:flex; align-items:center; justify-content:center; background:#003c5d; color:#fff; font-size:32px; font-weight:700; }
.pengarahprofile-info h3 { margin:0 0 6px; color:#003c5d; font-size:20px; }
.pengarahprofile-info p { margin:0 0 6px; color:#4b5563; }
.pengarahprofile-badge { display:inline-block; border:1px solid #003c5d; color:#003c5d; background:rgba(0,60,93,0.06); padding:4px 8px; margin:6px 0; font-size:12px; }
</style>
