<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_staffdirectory
 */

defined('_JEXEC') or die;

use Joomla\CMS\Helper\ModuleHelper;

$entries = [];

// Pengarah entry
$pengarahName = (string) ($params->get('pengarah_name') ?? '');
if ($pengarahName !== '') {
    $entries[] = [
        'label' => 'Pengarah',
        'name' => $pengarahName,
        'position_ms' => (string) ($params->get('pengarah_position_ms') ?? ''),
        'position_en' => (string) ($params->get('pengarah_position_en') ?? ''),
        'email' => (string) ($params->get('pengarah_email') ?? ''),
        'phone' => (string) ($params->get('pengarah_phone') ?? ''),
        'photo' => (string) ($params->get('pengarah_photo') ?? ''),
        'initial' => (string) ($params->get('pengarah_initial') ?? ''),
    ];
}

// Staff 1..20
for ($i = 1; $i <= 20; $i++) {
    $name = (string) ($params->get("staff{$i}_name") ?? '');
    if ($name === '') {
        continue;
    }
    $entries[] = [
        'label' => "Staff {$i}",
        'name' => $name,
        'position_ms' => (string) ($params->get("staff{$i}_position_ms") ?? ''),
        'position_en' => (string) ($params->get("staff{$i}_position_en") ?? ''),
        'email' => (string) ($params->get("staff{$i}_email") ?? ''),
        'phone' => (string) ($params->get("staff{$i}_phone") ?? ''),
        'photo' => (string) ($params->get("staff{$i}_photo") ?? ''),
        'initial' => (string) ($params->get("staff{$i}_initial") ?? ''),
    ];
}

$staff = $entries;

require ModuleHelper::getLayoutPath('mod_staffdirectory', $params->get('layout', 'default'));
