<?php
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

$allowedLangs = ['ms', 'en'];
$app          = Factory::getApplication();
$reqLang      = strtolower((string) $app->input->get('lang', '', 'cmd'));
$cookieLang   = strtolower((string) $app->input->cookie->getString('site_lang', ''));
$langKey      = in_array($reqLang, $allowedLangs, true) ? $reqLang : (in_array($cookieLang, $allowedLangs, true) ? $cookieLang : 'ms');
?>
<div class="staffdirectory-grid">
    <?php foreach ($staff as $item) : ?>
        <?php
        $photo    = '';
        if (!empty($item['photo']) && is_string($item['photo']) && is_file(JPATH_ROOT . '/' . ltrim($item['photo'], '/'))) {
            $photo = Uri::root() . ltrim($item['photo'], '/');
        }
        $name   = $item['name'] ?? '';
        $pos    = ($langKey === 'en') ? ($item['position_en'] ?? '') : ($item['position_ms'] ?? '');
        $label  = $item['label'] ?? '';
        ?>
        <div class="staff-card">
            <?php if ($label) : ?>
                <div class="staff-label"><?php echo htmlspecialchars((string) $label, ENT_QUOTES, 'UTF-8'); ?></div>
            <?php endif; ?>
            <div class="staff-photo">
                <?php if ($photo) : ?>
                    <img src="<?php echo htmlspecialchars($photo, ENT_QUOTES, 'UTF-8'); ?>" alt="<?php echo htmlspecialchars((string) $name, ENT_QUOTES, 'UTF-8'); ?>">
                <?php else : ?>
                    <div class="staff-initial"><?php echo htmlspecialchars((string) ($item['initial'] ?? ''), ENT_QUOTES, 'UTF-8'); ?></div>
                <?php endif; ?>
            </div>
            <div class="staff-info">
                <h3><?php echo htmlspecialchars((string) $name, ENT_QUOTES, 'UTF-8'); ?></h3>
                <p><?php echo htmlspecialchars((string) $pos, ENT_QUOTES, 'UTF-8'); ?></p>
                <?php if (!empty($item['email']) && is_string($item['email'])) : ?>
                    <p><a href="mailto:<?php echo htmlspecialchars($item['email'], ENT_QUOTES, 'UTF-8'); ?>"><?php echo htmlspecialchars($item['email'], ENT_QUOTES, 'UTF-8'); ?></a></p>
                <?php endif; ?>
                <?php if (!empty($item['phone']) && is_string($item['phone'])) : ?>
                    <p><?php echo htmlspecialchars($item['phone'], ENT_QUOTES, 'UTF-8'); ?></p>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<style>
    .staffdirectory-grid { display: grid; gap: 16px; grid-template-columns: repeat(auto-fit, minmax(240px, 1fr)); }
    .staff-card { border: 1px solid #e5e7eb; background: #ffffff; padding: 16px; text-align: center; position: relative; }
    .staff-label { position: absolute; top: 8px; left: 8px; padding: 4px 8px; background: #003c5d; color: #fff; font-size: 11px; text-transform: uppercase; letter-spacing: 0.05em; }
    .staff-photo { width: 160px; height: 160px; margin: 16px auto 12px; border: 1px solid #e5e7eb; overflow: hidden; display: flex; align-items: center; justify-content: center; }
    .staff-photo img { width: 100%; height: 100%; object-fit: cover; object-position: top; }
    .staff-initial { width: 100%; height: 100%; background: #003c5d; color: #ffffff; display: flex; align-items: center; justify-content: center; font-size: 32px; font-weight: 700; }
    .staff-info h3 { margin: 0 0 6px; color: #003c5d; font-size: 18px; }
    .staff-info p { margin: 0 0 6px; color: #4b5563; font-size: 14px; }
</style>
