<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\Jkkp6Request;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Illuminate\Support\Str; // ✅ Required for Str::uuid()

/**
 * Class Jkkp6CrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class Jkkp6CrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\Jkkp6::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/jkkp6');
        CRUD::setEntityNameStrings('jkkp6', 'jkkp6s');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
// CRUD::column('ulid_jkkp6');
CRUD::column('maklumat_pekerja');
CRUD::column('maklumat_jabatan');
CRUD::column('maklumat_nama');
CRUD::column('status');

        /**
         * Columns can be defined using the fluent syntax:
         * - CRUD::column('price')->type('number');
         */
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        CRUD::setValidation(Jkkp6Request::class);

CRUD::field('ulid_jkkp6')->type('hidden')->value(Str::uuid());
CRUD::field('maklumat_pekerja');
CRUD::field('maklumat_jabatan');
CRUD::field('maklumat_nama');
CRUD::field('maklumat_jawatan_2');
CRUD::field('maklumat_notelefon');
CRUD::field('tarikh_kemalangan')->type('date');
CRUD::field('masa_kemalangan')->type('time');
CRUD::field('tempat_kemalangan');
CRUD::field('status')->type('select_from_array')->options([
    'draft' => 'Draft',
    'submitted' => 'Submitted',
    'approved' => 'Approved'
]);


        /**
         * Fields can be defined using the fluent syntax:
         * - CRUD::field('price')->type('number');
         */
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
}
