<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class Jkkp6Request extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        // only allow updates if the user is logged in
        return backpack_auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
{
    return [
        'ulid_jkkp6' => 'required|uuid',
        'maklumat_pekerja' => 'required|string|max:255',
        'maklumat_jabatan' => 'required|string|max:255',
        'maklumat_nama' => 'required|string|max:255',
        'maklumat_jawatan_2' => 'required|string|max:255',
        'maklumat_notelefon' => 'required|string|max:20',
        'tarikh_kemalangan' => 'required|date',
        'masa_kemalangan' => 'required',
        'tempat_kemalangan' => 'required|string',
        'status' => 'required|in:draft,submitted,approved',
    ];
}


    /**
     * Get the validation attributes that apply to the request.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            //
        ];
    }

    /**
     * Get the validation messages that apply to the request.
     *
     * @return array
     */
    public function messages()
    {
        return [
            //
        ];
    }
}
