<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::create('jkkp6s', function (Blueprint $table) {
        $table->id();
        $table->uuid('ulid_jkkp6');
        $table->string('maklumat_pekerja');
        $table->string('maklumat_jabatan');
        $table->string('maklumat_nama');
        $table->string('maklumat_jawatan_2');
        $table->string('maklumat_notelefon', 20);
        $table->date('tarikh_kemalangan');
        $table->time('masa_kemalangan');
        $table->string('tempat_kemalangan');
        $table->enum('status', ['draft', 'submitted', 'approved']);
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jkkp6s');
    }
};
