<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::create('jkkp6', function (Blueprint $table) {
        $table->id();
        $table->uuid('ulid_jkkp6')->unique();
        $table->string('maklumat_pekerja')->nullable();
        $table->string('maklumat_jabatan')->nullable();
        $table->string('maklumat_nama')->nullable();
        $table->string('maklumat_jawatan_2')->nullable();
        $table->string('maklumat_notelefon')->nullable();
        $table->date('tarikh_kemalangan')->nullable();
        $table->time('masa_kemalangan')->nullable();
        $table->string('tempat_kemalangan')->nullable();
        $table->enum('status', ['draft', 'submitted', 'approved'])->default('draft');
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('jkkp6');
    }
};
