<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class UsersTableSeeder extends Seeder
{
    public function run(): void
    {
        // Delete existing users to avoid duplicates (optional)
        User::truncate();

        // Create multiple users with different roles
        $users = [
            [
                'id_pengguna' => 'PJ001',
                'name' => 'Penyelia Jabatan',
                'email' => 'pj@example.com',
                'password' => Hash::make('password'), // default password
                'user_role' => 'pj',
            ],
            [
                'id_pengguna' => 'KKP001',
                'name' => 'Unit KKP',
                'email' => 'kkp@example.com',
                'password' => Hash::make('password'),
                'user_role' => 'kkp',
            ],
            [
                'id_pengguna' => 'KJSK001',
                'name' => 'Unit Kesihatan',
                'email' => 'kjsk@example.com',
                'password' => Hash::make('password'),
                'user_role' => 'kjsk',
            ],
            [
                'id_pengguna' => 'INS001',
                'name' => 'Unit Insurans',
                'email' => 'ins@example.com',
                'password' => Hash::make('password'),
                'user_role' => 'ins',
            ],
            [
                'id_pengguna' => 'PKP001',
                'name' => 'Pengarah Khidmat',
                'email' => 'pkp@example.com',
                'password' => Hash::make('password'),
                'user_role' => 'pkp',
            ],
            [
                'id_pengguna' => 'KJ001',
                'name' => 'Ketua Jabatan',
                'email' => 'kj@example.com',
                'password' => Hash::make('password'),
                'user_role' => 'kj',
            ],
            [
                'id_pengguna' => 'ADMIN001',
                'name' => 'Pentadbir',
                'email' => 'admin@example.com',
                'password' => Hash::make('admin123'),
                'user_role' => 'pentadbir',
            ],
        ];

        foreach ($users as $user) {
            User::create($user);
        }
    }
}
