@extends(backpack_view('blank'))

@php
    use Carbon\Carbon;

    $statusColors = [
        'Baharu'        => 'bg-blue',
        'Dalam Proses'  => 'bg-purple',
        'Disemak'       => 'bg-pink',
        'Lulus Semakan' => 'bg-yellow',
        'Kes Tutup'     => 'bg-blue',
    ];
@endphp

@section('content')
  @php
    $titleDashboard = $role === 'pj'
        ? 'JKKP6 - PEMBERITAHUAN MENGENAI KEMALANGAN/KEJADIAN BERBAHAYA'
        : 'PEMBERITAHUAN MENGENAI KEMALANGAN/KEJADIAN BERBAHAYA';

    $boxTitleMap = [
        'pj'   => 'Senarai Pekerja',
        'kkp'  => 'Senarai Pekerja - Peringkat KKP',
        'ins'  => 'Senarai Pekerja - Peringkat Insuran',
        'kjsk' => 'Senarai Pekerja - Peringkat Kesihatan',
        'pkp'  => 'Senarai Pekerja - Peringkat PKP',
        'kj'   => 'Senarai Pekerja - Peringkat Ketua Jabatan/Unit',
    ];

    $boxTitle = $boxTitleMap[$role] ?? 'Senarai Pekerja';
@endphp

<h4 class="fw-bold" style="font-size: 20px;">
    {{ $titleDashboard }}
</h4>

   @if ($role === 'pj')
    <div class="d-flex justify-content-end mb-3">
        <a href="#"
           class="btn rounded-pill text-white disabled"
           style="background-color: #487FFF; border-color: #487FFF; pointer-events: none; opacity: 0.6;">
            + Aduan Baharu
        </a>
    </div>
@endif

    </div>

  @if ($role === 'kkp')
    <div class="row mb-4">
        @php
            $statusSummary = [
                'Kes Tutup' => [
                    'count' => $jkkpItems->where('status', 'Kes Tutup')->count(),
                    'color' => '#6D7AFF',
                    'image' => 'kestutup.svg',
                ],
                'Dalam Proses' => [
                    'count' => $jkkpItems->where('status', 'Dalam Proses')->count(),
                    'color' => '#C760FF',
                    'image' => 'dalamproses.png',
                ],
                'Disemak' => [
                    'count' => $jkkpItems->where('status', 'Disemak')->count(),
                    'color' => '#FF51C5',
                    'image' => 'disemak.png',
                ],
                'Lulus Semakan' => [
                    'count' => $jkkpItems->where('status', 'Lulus Semakan')->count(),
                    'color' => '#FFD900',
                    'image' => 'lulussemakan.png',
                ],
            ];
        @endphp

        @foreach($statusSummary as $label => $data)
            <div class="col-md-3 mb-3">
                <div class="card shadow-sm rounded-4 p-3" style="background: linear-gradient(to right, {{ $data['color'] }}, #FFFFFF);">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div style="font-size: 16px; color: black;">{{ $label }}</div>
                            <div style="font-size: 24px; font-weight: bold; color: black;">
                                {{ $data['count'] }}
                            </div>
                        </div>
                        <img src="{{ asset('images/' . $data['image']) }}" alt="{{ $label }}" style="width: 80px; height: 80px;">
                    </div>
                </div>
            </div>
        @endforeach
        </div>

        {{-- Chart --}}
        <div class="card mb-4 p-3 rounded-4 border-0 shadow-sm" style="width: 500px;">
            <h5 class="fw-semibold mb-3" style="font-size: 18px;">Jumlah Laporan</h5>
            <div class="d-flex align-items-center gap-4">
                <canvas id="laporanChart" width="200" height="100"></canvas>
                <div>
                    <p class="mb-1" style="color: #000000;"><strong>Keseluruhan:</strong> {{ $total }}</p>
                    <p class="mb-1" style="color: #000000;"><strong>Belum Selesai:</strong> {{ $belum }}</p>
                    <p class="mb-1" style="color: #000000;"><strong>Selesai:</strong> {{ $selesai }}</p>

                </div>
            </div>
        </div>
    @endif

    {{-- Data Table --}}
    <div class="card p-4 shadow-sm border-0 rounded-4">
<h5 class="fw-semibold mb-3" style="font-size: 18px;">{{ $boxTitle }}</h5>

        <form method="GET" id="filter-form">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    Show
                    <select name="per_page" class="form-select d-inline-block w-auto mx-1" onchange="this.form.submit()">
                        @foreach([10, 25, 50] as $num)
                            <option value="{{ $num }}" {{ request('per_page') == $num ? 'selected' : '' }}>{{ $num }}</option>
                        @endforeach
                    </select>
                    entries
                </div>

                <div class="d-flex gap-2">
                    <select name="status" class="form-select w-auto" onchange="this.form.submit()">
                        <option value="">All Status</option>
                        @foreach($allowedStatuses as $statusOption)
                            <option value="{{ $statusOption }}" {{ request('status') == $statusOption ? 'selected' : '' }}>
                                {{ $statusOption }}
                            </option>
                        @endforeach
                    </select>

                    <input type="search" name="search" class="form-control" placeholder="Search"
                           value="{{ request('search') }}"
                           onkeydown="if(event.key === 'Enter') this.form.submit();">
                </div>
            </div>
        </form>

        <table class="table table-hover align-middle">
            <thead>
                <tr>
                    <th><input type="checkbox" id="check-all" onclick="toggleCheckboxes(this)"></th>
                    <th>S.L</th>
                    <th>No. Pekerja</th>
                    <th>Nama</th>
                    <th>Jabatan</th>
                    <th>Tarikh Terima</th>
                    <th>Tarikh Kemaskini</th>
                    <th>Status</th>
                    <th class="text-center">Action</th>
                </tr>
            </thead>
            <tbody>
                @forelse($jkkpItems as $item)
                    @php
                        $status = $item->status ?? 'Baharu';
                        $badgeClass = $statusColors[$status] ?? 'bg-secondary';
                    @endphp
                    <tr>
                        <td>
                            <input type="checkbox" class="row-checkbox" name="selected_items[]" value="{{ $item->id_jkkp6 }}">
                        </td>
                        <td>{{ $loop->iteration + ($jkkpItems->currentPage() - 1) * $jkkpItems->perPage() }}</td>
                        <td>{{ $item->maklumat_pekerja }}</td>
                        <td>{{ $item->maklumat_nama }}</td>
                        <td>{{ $item->maklumat_jabatan }}</td>
                        <td>{{ Carbon::parse($item->created_date)->format('d M Y') }}</td>
                        <td>{{ Carbon::parse($item->updated_date)->format('d M Y') }}</td>
                        <td><span class="badge {{ $badgeClass }}">{{ $status }}</span></td>
                        {{-- <td class="d-flex gap-2 justify-content-center">
                            <a href="{{ backpack_url('jkkp6/' . $item->id_jkkp6 . '/show') }}" class="btn btn-sm btn-outline-primary rounded-circle" title="Lihat">
                                <i class="la la-eye"></i>
                            </a>
                            <a href="{{ backpack_url('jkkp6/' . $item->id_jkkp6 . '/edit') }}" class="btn btn-sm btn-outline-success rounded-circle" title="Kemaskini">
                                <i class="la la-edit"></i>
                            </a>
                            <form method="POST" action="{{ backpack_url('jkkp6/' . $item->id_jkkp6) }}" onsubmit="return confirm('Padam rekod ini?');">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-sm btn-outline-danger rounded-circle" title="Padam">
                                    <i class="la la-trash"></i>
                                </button>
                            </form>
                        </td> --}}

<td class="d-flex gap-2 justify-content-center">
    {{-- View (always visible) --}}
    <a href="{{ backpack_url('jkkp6/' . $item->id_jkkp6 . '/show') }}" title="Lihat">
        <img src="{{ asset('images/view.svg') }}" alt="View" width="24" height="24">
    </a>

    {{-- Edit (always visible) --}}
    <a href="{{ backpack_url('jkkp6/' . $item->id_jkkp6 . '/edit') }}" title="Kemaskini">
        <img src="{{ asset('images/edit.svg') }}" alt="Edit" width="24" height="24">
    </a>

    {{-- Delete (only for PJ) --}}
    @if ($role === 'pj')
        <form method="POST" action="{{ backpack_url('jkkp6/' . $item->id_jkkp6) }}" onsubmit="return confirm('Padam rekod ini?');">
            @csrf
            @method('DELETE')
            <button type="submit" title="Padam" style="border: none; background: none; padding: 0;">
                <img src="{{ asset('images/delete.svg') }}" alt="Delete" width="24" height="24">
            </button>
        </form>
    @endif

    {{-- PDF Download based on role and status --}}
    @php
        $showPdf = false;
        if (
            ($role === 'kkp' && $item->status === 'Kes Tutup') ||
            ($role === 'jksk' && $item->status === 'Kes Tutup') ||
            ($role === 'pkp' && $item->status === 'Kes Tutup') ||
            ($role === 'kj' && $item->status === 'Kes Tutup') ||
            ($role === 'ins' && $item->status === 'Disemak')
        ) {
            $showPdf = true;
        }
    @endphp

    @if ($showPdf)
        {{-- <a href="{{ route('jkkp6.pdf', $item->id_jkkp6) }}" target="_blank" title="Muat Turun PDF"> --}}
            <img src="{{ asset('images/download.svg') }}" alt="PDF" width="24" height="24">
        </a>
    @endif
</td>

                        
                    </tr>
                @empty
                    <tr><td colspan="8" class="text-center">Tiada rekod dijumpai.</td></tr>
                @endforelse
            </tbody>
        </table>

        <div class="d-flex justify-content-end mt-3">
            {!! $jkkpItems->links() !!}
        </div>
    </div>
@endsection

@push('after_styles')
    <link rel="stylesheet" href="{{ asset('css/custom.css') }}">
@endpush

@push('after_scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx = document.getElementById('laporanChart').getContext('2d');
    const laporanChart = new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: ['Selesai', 'Belum Selesai'],
            datasets: [{
                data: [{{ $selesai }}, {{ $belum }}],
                backgroundColor: ['#28a745', '#FFA500'], // green, orange
                cutout: '70%',
                borderWidth: 0
            }]
        },
        options: {
            responsive: false,
            rotation: -90,
            circumference: 180,
            plugins: {
                legend: { display: false }
            }
        }
    });
</script>
@endpush
