<?php

use Illuminate\Support\Facades\Route;

// --------------------------
// Custom Backpack Routes
// --------------------------
// This route file is loaded automatically by Backpack\Base.
// Routes you generate using Backpack\Generators will be placed here.

Route::group([
    'prefix'     => config('backpack.base.route_prefix', 'admin'),
    'middleware' => array_merge(
        (array) config('backpack.base.web_middleware', 'web'),
        (array) config('backpack.base.middleware_key', 'admin')
    ),
    'namespace'  => 'App\Http\Controllers\Admin',
], function () {
    // Custom admin routes
    Route::crud('jkkp6', 'Jkkp6CrudController');

    // ✅ Custom dashboard routes - MUST be inside this group
    // Route::get('dashboard-pj', fn() => view('dashboard.pj'))->name('dashboard.pj');
    // Route::get('dashboard-kkp', fn() => view('dashboard.kkp'))->name('dashboard.kkp');
    // Route::get('dashboard-kjsk', fn() => view('dashboard.kjsk'))->name('dashboard.kjsk');
    // Route::get('dashboard-ins', fn() => view('dashboard.ins'))->name('dashboard.ins');
    // Route::get('dashboard-pkp', fn() => view('dashboard.pkp'))->name('dashboard.pkp');
    // Route::get('dashboard-kj', fn() => view('dashboard.kj'))->name('dashboard.kj');

Route::get('dashboard', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');

});
