<?php
    use Carbon\Carbon;

    $statusColors = [
        'Baharu'        => 'bg-blue',
        'Dalam Proses'  => 'bg-purple',
        'Disemak'       => 'bg-pink',
        'Lulus Semakan' => 'bg-yellow',
        'Kes Tutup'     => 'bg-blue',
    ];
?>

<?php $__env->startSection('content'); ?>
  <?php
    $titleDashboard = $role === 'pj'
        ? 'JKKP6 - PEMBERITAHUAN MENGENAI KEMALANGAN/KEJADIAN BERBAHAYA'
        : 'PEMBERITAHUAN MENGENAI KEMALANGAN/KEJADIAN BERBAHAYA';

    $boxTitleMap = [
        'pj'   => 'Senarai Pekerja',
        'kkp'  => 'Senarai Pekerja - Peringkat KKP',
        'ins'  => 'Senarai Pekerja - Peringkat Insuran',
        'kjsk' => 'Senarai Pekerja - Peringkat Kesihatan',
        'pkp'  => 'Senarai Pekerja - Peringkat PKP',
        'kj'   => 'Senarai Pekerja - Peringkat Ketua Jabatan/Unit',
    ];

    $boxTitle = $boxTitleMap[$role] ?? 'Senarai Pekerja';
?>

<h4 class="fw-bold" style="font-size: 20px;">
    <?php echo e($titleDashboard); ?>

</h4>

   <?php if($role === 'pj'): ?>
    <div class="d-flex justify-content-end mb-3">
        <a href="#"
           class="btn rounded-pill text-white disabled"
           style="background-color: #487FFF; border-color: #487FFF; pointer-events: none; opacity: 0.6;">
            + Aduan Baharu
        </a>
    </div>
<?php endif; ?>

    </div>

  <?php if($role === 'kkp'): ?>
    <div class="row mb-4">
        <?php
            $statusSummary = [
                'Kes Tutup' => [
                    'count' => $jkkpItems->where('status', 'Kes Tutup')->count(),
                    'color' => '#6D7AFF',
                    'image' => 'kestutup.svg',
                ],
                'Dalam Proses' => [
                    'count' => $jkkpItems->where('status', 'Dalam Proses')->count(),
                    'color' => '#C760FF',
                    'image' => 'dalamproses.png',
                ],
                'Disemak' => [
                    'count' => $jkkpItems->where('status', 'Disemak')->count(),
                    'color' => '#FF51C5',
                    'image' => 'disemak.png',
                ],
                'Lulus Semakan' => [
                    'count' => $jkkpItems->where('status', 'Lulus Semakan')->count(),
                    'color' => '#FFD900',
                    'image' => 'lulussemakan.png',
                ],
            ];
        ?>

        <?php $__currentLoopData = $statusSummary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-3 mb-3">
                <div class="card shadow-sm rounded-4 p-3" style="background: linear-gradient(to right, <?php echo e($data['color']); ?>, #FFFFFF);">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <div style="font-size: 16px; color: black;"><?php echo e($label); ?></div>
                            <div style="font-size: 24px; font-weight: bold; color: black;">
                                <?php echo e($data['count']); ?>

                            </div>
                        </div>
                        <img src="<?php echo e(asset('images/' . $data['image'])); ?>" alt="<?php echo e($label); ?>" style="width: 80px; height: 80px;">
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        
        <div class="card mb-4 p-3 rounded-4 border-0 shadow-sm" style="width: 500px;">
            <h5 class="fw-semibold mb-3" style="font-size: 18px;">Jumlah Laporan</h5>
            <div class="d-flex align-items-center gap-4">
                <canvas id="laporanChart" width="200" height="100"></canvas>
                <div>
                    <p class="mb-1" style="color: #000000;"><strong>Keseluruhan:</strong> <?php echo e($total); ?></p>
                    <p class="mb-1" style="color: #000000;"><strong>Belum Selesai:</strong> <?php echo e($belum); ?></p>
                    <p class="mb-1" style="color: #000000;"><strong>Selesai:</strong> <?php echo e($selesai); ?></p>

                </div>
            </div>
        </div>
    <?php endif; ?>

    
    <div class="card p-4 shadow-sm border-0 rounded-4">
<h5 class="fw-semibold mb-3" style="font-size: 18px;"><?php echo e($boxTitle); ?></h5>

        <form method="GET" id="filter-form">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    Show
                    <select name="per_page" class="form-select d-inline-block w-auto mx-1" onchange="this.form.submit()">
                        <?php $__currentLoopData = [10, 25, 50]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $num): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($num); ?>" <?php echo e(request('per_page') == $num ? 'selected' : ''); ?>><?php echo e($num); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    entries
                </div>

                <div class="d-flex gap-2">
                    <select name="status" class="form-select w-auto" onchange="this.form.submit()">
                        <option value="">All Status</option>
                        <?php $__currentLoopData = $allowedStatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statusOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($statusOption); ?>" <?php echo e(request('status') == $statusOption ? 'selected' : ''); ?>>
                                <?php echo e($statusOption); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>

                    <input type="search" name="search" class="form-control" placeholder="Search"
                           value="<?php echo e(request('search')); ?>"
                           onkeydown="if(event.key === 'Enter') this.form.submit();">
                </div>
            </div>
        </form>

        <table class="table table-hover align-middle">
            <thead>
                <tr>
                    <th><input type="checkbox" id="check-all" onclick="toggleCheckboxes(this)"></th>
                    <th>S.L</th>
                    <th>No. Pekerja</th>
                    <th>Nama</th>
                    <th>Jabatan</th>
                    <th>Tarikh Terima</th>
                    <th>Tarikh Kemaskini</th>
                    <th>Status</th>
                    <th class="text-center">Action</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $jkkpItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $status = $item->status ?? 'Baharu';
                        $badgeClass = $statusColors[$status] ?? 'bg-secondary';
                    ?>
                    <tr>
                        <td>
                            <input type="checkbox" class="row-checkbox" name="selected_items[]" value="<?php echo e($item->id_jkkp6); ?>">
                        </td>
                        <td><?php echo e($loop->iteration + ($jkkpItems->currentPage() - 1) * $jkkpItems->perPage()); ?></td>
                        <td><?php echo e($item->maklumat_pekerja); ?></td>
                        <td><?php echo e($item->maklumat_nama); ?></td>
                        <td><?php echo e($item->maklumat_jabatan); ?></td>
                        <td><?php echo e(Carbon::parse($item->created_date)->format('d M Y')); ?></td>
                        <td><?php echo e(Carbon::parse($item->updated_date)->format('d M Y')); ?></td>
                        <td><span class="badge <?php echo e($badgeClass); ?>"><?php echo e($status); ?></span></td>
                        

<td class="d-flex gap-2 justify-content-center">
    
    <a href="<?php echo e(backpack_url('jkkp6/' . $item->id_jkkp6 . '/show')); ?>" title="Lihat">
        <img src="<?php echo e(asset('images/view.svg')); ?>" alt="View" width="24" height="24">
    </a>

    
    <a href="<?php echo e(backpack_url('jkkp6/' . $item->id_jkkp6 . '/edit')); ?>" title="Kemaskini">
        <img src="<?php echo e(asset('images/edit.svg')); ?>" alt="Edit" width="24" height="24">
    </a>

    
    <?php if($role === 'pj'): ?>
        <form method="POST" action="<?php echo e(backpack_url('jkkp6/' . $item->id_jkkp6)); ?>" onsubmit="return confirm('Padam rekod ini?');">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <button type="submit" title="Padam" style="border: none; background: none; padding: 0;">
                <img src="<?php echo e(asset('images/delete.svg')); ?>" alt="Delete" width="24" height="24">
            </button>
        </form>
    <?php endif; ?>

    
    <?php
        $showPdf = false;
        if (
            ($role === 'kkp' && $item->status === 'Kes Tutup') ||
            ($role === 'jksk' && $item->status === 'Kes Tutup') ||
            ($role === 'pkp' && $item->status === 'Kes Tutup') ||
            ($role === 'kj' && $item->status === 'Kes Tutup') ||
            ($role === 'ins' && $item->status === 'Disemak')
        ) {
            $showPdf = true;
        }
    ?>

    <?php if($showPdf): ?>
        
            <img src="<?php echo e(asset('images/download.svg')); ?>" alt="PDF" width="24" height="24">
        </a>
    <?php endif; ?>
</td>

                        
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="8" class="text-center">Tiada rekod dijumpai.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>

        <div class="d-flex justify-content-end mt-3">
            <?php echo $jkkpItems->links(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('after_styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/custom.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('after_scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx = document.getElementById('laporanChart').getContext('2d');
    const laporanChart = new Chart(ctx, {
        type: 'doughnut',
        data: {
            labels: ['Selesai', 'Belum Selesai'],
            datasets: [{
                data: [<?php echo e($selesai); ?>, <?php echo e($belum); ?>],
                backgroundColor: ['#28a745', '#FFA500'], // green, orange
                cutout: '70%',
                borderWidth: 0
            }]
        },
        options: {
            responsive: false,
            rotation: -90,
            circumference: 180,
            plugins: {
                legend: { display: false }
            }
        }
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make(backpack_view('blank'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/poweritx/public_html/mykkp.poweritx.my/resources/views/dashboard/index.blade.php ENDPATH**/ ?>