<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Login - MYKKP</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500&display=swap" rel="stylesheet" />
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="h-screen flex">

    <!-- Left Side - Logo & Info -->
    <div class="w-1/2 bg-blue-800 text-white flex flex-col justify-center items-center p-10">
        <img src="<?php echo e(asset('images/logo.png')); ?>" alt="MBI Logo" class="w-72 mb-6" />
        <p class="text-center mt-10">
            SISTEM PELAPORAN KES SIASAT KEMALANGAN MAJLIS BANDARAYA IPOH
        </p>
    </div>

    <!-- Right Side - Login Form -->
    <div class="w-1/2 bg-gray-50 flex flex-col justify-center px-20">

        <h2 class="text-3xl font-bold mb-6 text-gray-900">Log Masuk</h2>

        <?php if(session('status')): ?>
            <div class="mb-4 text-green-600 text-sm">
                <?php echo e(session('status')); ?>

            </div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('backpack.auth.login')); ?>">
            <?php echo csrf_field(); ?>

            <!-- Username / Email Field -->
            <div class="mb-4">
               <label for="id_pengguna" class="block mb-1 font-medium text-gray-700">
    ID Pengguna
</label>
<input
    id="id_pengguna"
    name="id_pengguna"
    type="text"
    value="<?php echo e(old('id_pengguna')); ?>"
                    required
                    autofocus
                    class="w-full border border-gray-300 rounded px-4 py-3 focus:outline-none focus:ring-2 focus:ring-blue-500 <?php $__errorArgs = [$username];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                />
                <?php $__errorArgs = [$username];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-600 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Password Field -->
            <div class="mb-4">
                <label for="password" class="block mb-1 font-medium text-gray-700">
                    <?php echo e(trans('backpack::base.password')); ?>

                </label>
                <input
                    id="password"
                    name="password"
                    type="password"
                    required
                    class="w-full border border-gray-300 rounded px-4 py-3 focus:outline-none focus:ring-2 focus:ring-blue-500 <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> border-red-500 <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                />
                <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <p class="text-red-600 text-sm mt-1"><?php echo e($message); ?></p>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>

            <!-- Remember Me Checkbox -->
            <div class="mb-6 flex items-center">
                <input
                    id="remember"
                    name="remember"
                    type="checkbox"
                    class="mr-2"
                />
                <label for="remember" class="text-gray-700 text-sm"><?php echo e(trans('backpack::base.remember_me')); ?></label>
            </div>

            <!-- Submit Button -->
            <button
                type="submit"
                class="w-full bg-blue-600 text-white py-3 rounded hover:bg-blue-700 transition"
            >
                <?php echo e(trans('backpack::base.login')); ?>

            </button>
        </form>

        <!-- Password Reset & Register Links -->
        <div class="mt-6 flex justify-between text-sm">
            <?php if(backpack_users_have_email() && backpack_email_column() == 'email' && config('backpack.base.setup_password_recovery_routes', true)): ?>
                <a href="<?php echo e(route('backpack.auth.password.reset')); ?>" class="text-blue-600 hover:underline">Forgot your password?</a>
            <?php endif; ?>

            <?php if(config('backpack.base.registration_open')): ?>
                <a href="<?php echo e(route('backpack.auth.register')); ?>" class="text-blue-600 hover:underline">Register</a>
            <?php endif; ?>
        </div>

    </div>

</body>
</html>
<?php /**PATH C:\laragon\www\MYKKP\vendor/backpack/theme-tabler/resources/views/auth/login/illustration.blade.php ENDPATH**/ ?>