<?php

namespace Backpack\CRUD\app\Http\Controllers\Auth;

use Backpack\CRUD\app\Library\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;

class LoginController extends Controller
{
    use AuthenticatesUsers {
        logout as defaultLogout;
    }

    protected $data = [];

    public function __construct()
    {
        $guard = backpack_guard_name();

        $this->middleware("guest:$guard", ['except' => 'logout']);

        // Default path after login/logout
        $this->loginPath = backpack_url('login');
        $this->redirectAfterLogout = backpack_url('login');
    }

    /**
     * Return custom username for authentication.
     * This uses config value (e.g., 'id_pengguna')
     *
     * @return string
     */
    public function username()
    {
        return backpack_authentication_column(); // this uses 'id_pengguna' from config
    }

    /**
     * Redirect users after login based on role.
     *
     * @return string
     */
// public function redirectTo()
// {
//     $user = backpack_auth()->user();

//     return match ($user->user_role) {
//         'pj'         => backpack_url('dashboard-pj'),
//         'kkp'        => backpack_url('dashboard-kkp'),
//         'kjsk'       => backpack_url('dashboard-kjsk'),
//         'ins'        => backpack_url('dashboard-ins'),
//         'pkp'        => backpack_url('dashboard-pkp'),
//         'kj'         => backpack_url('dashboard-kj'),
//         'pentadbir'  => backpack_url('dashboard-admin'),
//         // default      => backpack_url('dashboard'), // fallback
//     };
//     }

public function redirectTo()
{
    return backpack_url('dashboard');
}


    /**
     * The user has logged out of the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return mixed
     */
    protected function loggedOut(Request $request)
    {
        return redirect($this->redirectAfterLogout);
    }

    /**
     * Get the guard to be used during logout.
     *
     * @return \Illuminate\Contracts\Auth\StatefulGuard
     */
    protected function guard()
    {
        return backpack_auth();
    }
}
