<?php


function formatDateRangeDisplay($date_range)
{
    $duration_labels = [
        'Q1' => 'Q1 (January - March)',
        'Q2' => 'Q2 (April - June)',
        'Q3' => 'Q3 (July - September)',
        'Q4' => 'Q4 (October - December)',
        'H1' => 'H1 (January - June)',
        'H2' => 'H2 (July - December)',
        'F'  => 'F (January - December)',
    ];

    $year_from = $date_range->year_from ?? '';
    $duration_from_key = $date_range->duration_from ?? 'F';
    $duration_from = $duration_labels[$duration_from_key] ?? $duration_from_key;

    $year_to = $date_range->year_to ?? '';
    $duration_to_key = $date_range->duration_to ?? 'F';
    $duration_to = $duration_labels[$duration_to_key] ?? $duration_to_key;

    return "<strong>Year From:</strong> {$year_from} Duration From: {$duration_from} || <strong>Year To:</strong> {$year_to} Duration To: {$duration_to}";
}

function formatDivision($division)
{
    $labels = [
        'ceo' => 'CEO OFFICE',
        'exports' => 'EXPORTS PROMOTION & MARKET ACCESS DIVISION',
        'management' => 'MANAGEMENT SERVICES DIVISION',
    ];
    $division_name = $labels[$division] ?? $division;
    return $division_name;
}

function formatType($type)
{
    $labels = [
        '1' => 'Type 1',
        '2' => 'Type 2',
        '3' => 'Type 3',
        '4' => 'Type 4',
        '5' => 'Type 5',
        '6' => 'Type 6'
    ];
    $type_name = $labels[$type] ?? $type;
    return $type_name;
}

function formatSubmission($submission)
{
    $labels = [
        'anually' => 'Annually',
        'quarter' => 'Quarterly',
        'bi_anually' => 'Bi-Annually',
    ];
    $submission_name = $labels[$submission] ?? $submission;
    return $submission_name;
}

function formatMetric($metric)
{
    $labels = [
        'activity' => 'Activity',
        'article' => 'Article',
        'booklet' => 'Booklet',
        'company' => 'Company',
        'enquiry' => 'Enquiry',
        'event' => 'Event',
        'exam' => 'Exam',
        'followers' => 'Followers',
        'media_coverage' => 'Media Coverage',
        'meeting' => 'Meeting',
        'percentage' => 'Percentage',
        'phase' => 'Phase',
        'press_releases' => 'Press Releases',
        'profiles' => 'Profiles',
        'programme' => 'Programme',
        'publication' => 'Publication',
        'release' => 'Release',
        'report' => 'Report',
        'rm' => 'RM',
        'story' => 'Story',
        'time' => 'Time',
        'unit' => 'Unit',
        'update' => 'Update'
    ];
    $metric_name = $labels[$metric] ?? $metric;
    return $metric_name;
}

function formatCategory($category)
{
    $labels = [
        'customer' => 'Customer',
        'finance' => 'Finance',
        'people' => 'People',
        'process' => 'Process',
    ];
    $category_name = $labels[$category] ?? $category;
    return $category_name;
}

function formatOutputOutcome($output_outcome)
{
    $labels = [
        'output' => 'Output',
        'outcome' => 'Outcome',
        'process' => 'Process',
    ];
    $output_outcome_name = $labels[$output_outcome] ?? $output_outcome;
    return $output_outcome_name;
}

function formatComponentAchv($component_achv)
{
    $labels = [
        'promotion' => 'Export Promotion',
        'development' => 'Exporters Development',
    ];
    $component_achv_name = $labels[$component_achv] ?? $component_achv;
    return $component_achv_name;
}