<?php

namespace App\Http\Controllers\pages;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\Indicator\IndicatorService;
use Validator;

class AccountSettingsNotifications extends Controller
{
  private function indicatorService()
  {
    return new IndicatorService();
  }

  public function index(Request $request)
  { 
    $year = $request->select_year ?? (date('Y') - 1);
    $indicator_list_previous = $this->indicatorService()->getIndicatorListPrevious($year);
    $indicator_list_draft = $this->indicatorService()->getIndicatorListDraft();
    $indicator_type_list = $this->indicatorService()->getIndicatorTypeList();
    return view('content.pages.pages-account-settings-notifications', compact(
      'indicator_list_draft',
      'indicator_list_previous',
      'indicator_type_list'
    ));
  }

  public function storeIndicator(Request $request)
  {
    dd($request->all());
    $validator = Validator::make($request->all(), [
        'division' => 'required',
        'section' => 'required',
        'unit' => 'required',
        'year' => 'required',
        'indicator' => 'required',
        'kpi_indicator_type_id' => 'required',
        //'indicator_type_def' => 'required',
        'annual_target' => 'required',
        'category' => 'required',
        'output_outcome' => 'required',
        'submission' => 'required',
        'metric' => 'required',
        'component_achievement' => 'required',
    ]);

    if($validator->fails()) {
        //return $validator->errors();
        //return redirect()->back()->withErrors(['Indicator is not saved successfully!'], $validator->errors());
        return redirect()->back()->withErrors($validator->errors()
                ->add('error', 'Indicator is not saved successfully!'));
    }

    $result = $this->indicatorService()->storeIndicator($request);
    return redirect()->back()->with('success', 'Indicator saved successfully!');
  }

  public function storeSubmitIndicator(Request $request)
  {
    $result = $this->indicatorService()->storeSubmitIndicator($request);
    return redirect()->back()->with('success', 'Indicator submitted successfully!');
  }

  public function updateIndicator(Request $request)
  { 
    
    $validator = Validator::make($request->all(), [
        'division_e' => 'required',
        'section_e' => 'required',
        'unit_e' => 'required',
        'year_e' => 'required',
        'indicator_e' => 'required',
        'kpi_indicator_type_id_e' => 'required',
        //'indicator_type_def_e' => 'required',
        'annual_target_e' => 'required',
        'category_e' => 'required',
        'output_outcome_e' => 'required',
        'submission_e' => 'required',
        'metric_e' => 'required',
        'component_achievement_e' => 'required',
        'kpi_achievement_id_e' => 'required'
    ]);

    if($validator->fails()) {
        //return redirect()->back()->withErrors(['Indicator is not updated successfully!'], $validator->errors());
        return redirect()->back()->withErrors($validator->errors()
                ->add('error', 'Indicator is not updated successfully!'));
    }

    $result = $this->indicatorService()->updateIndicator($request);
    return redirect()->back()->with('success', 'Indicator updated successfully!');
  }

  public function copyIndicator(Request $request)
  {
    $selected = $request->input('selected', []);
    if (empty($selected)) {
        return redirect()->back()->withErrors(['error' => 'No indicators selected for copying.']);
    }

    $result = $this->indicatorService()->copyIndicator($request);
    return redirect()->back()->with('success', 'Selected indicators copied successfully!');
  }

}
