@extends('layouts/contentNavbarLayout')

@section('title', 'KPI Achievement - Type 3')

@section('content')
<br>
<div class="container my-4">
  <div class="card">
    <div class="card-header">
      <h4 class="mb-0">Achievement Details (Type 3)</h4>
    </div>
    <div class="card-body">
      <!-- Maklumat KPI -->
      <table class="table table-bordered">
        <tbody>
          <tr><th class="w-50 fw-bold">Indicator :</th><td>Companies Assisted</td></tr>
          <tr><th class="fw-bold">Submission :</th><td>As per quarterly</td></tr>
          <tr><th class="fw-bold">Annual Target :</th><td>50</td></tr>
          <tr><th class="fw-bold">Metric :</th><td>Enquiries</td></tr>
          <tr><th class="fw-bold">Achievement Count :</th><td>100</td></tr>
          <tr>
            <th class="fw-bold">Remarks by PMU Admin :</th>
            <td>
              <input type="text" class="form-control" id="achievementInputSaved" value="" placeholder="Enter your remark...">
              <button type="button" class="btn btn-info btn-sm mt-2" id="addRemarkBtn">+ Add Remark</button>
            </td>
          </tr>
        </tbody>
      </table>

      <br>

      <!-- History Button -->
      <div class="d-flex justify-content-end mb-2">
        <button type="button" class="btn btn-outline-secondary">
          <i class="bx bx-history"></i> History
        </button>
      </div>

      <!-- File Upload Section -->
      <div class="mt-4">
        <h5>UPLOAD TEMPLATE FILE</h5>
        <table class="table">
          <thead>
            <tr><th>No</th><th>File/Attachment</th></tr>
          </thead>
          <tbody>
            <tr><td colspan="3" class="text-center">No data available in table</td></tr>
          </tbody>
        </table>
      </div>

      <!-- Achievement Summary Update -->
      <div class="mt-4">
        <h5>ACHIEVEMENT SUMMARY UPDATE</h5>
        <table class="table table-bordered">
        <thead class="table-light">
          <tr><th>Staff Name</th><th>Date</th></tr></thead>
          <tbody>
            <tr><td>Nurashiqen Shafiqah Jimmy Kayting</td><td>2023-12-29 10:29:56</td></tr>
            <tr><td>Nurashiqen Shafiqah Jimmy Kayting</td><td>2023-12-29 13:42:40</td></tr>
          </tbody>
        </table>
      </div>

      <!-- Sub Component -->
      <div class="mt-4">
        <h5>SUB COMPONENT</h5>
        <div class="form-check">
          <input class="form-check-input" type="radio" name="sub_component" value="companies" id="companies">
          <label class="form-check-label" for="companies">No. of companies assisted</label>
        </div>
        <div class="form-check">
          <input class="form-check-input" type="radio" name="sub_component" value="programmes" id="programmes">
          <label class="form-check-label" for="programmes">No. of programmes</label>
        </div>
        <div class="form-check">
          <input class="form-check-input" type="radio" name="sub_component" value="sales" id="sales">
          <label class="form-check-label" for="sales">No. of export sales</label>
        </div>
        <div class="form-check">
          <input class="form-check-input" type="radio" name="sub_component" value="none" id="none">
          <label class="form-check-label" for="none">None</label>
        </div>
      </div>
    </div>

    <!-- Footer Button -->
    <div class="card-footer d-flex justify-content-end gap-2">
      <button type="button" class="btn btn-primary">Accept</button>
      <button type="button" class="btn btn-danger">Reject</button>
      <a href="{{ url()->previous() }}" class="btn btn-secondary">Back</a>
    </div>
  </div>
</div>
@endsection

<script>
  document.addEventListener('DOMContentLoaded', function () {
    const rejectionModal = new bootstrap.Modal(document.getElementById('rejectionModal'));

    // Handle Accept/Reject radio buttons
    document.querySelectorAll('.decision-radio').forEach(function (radio) {
      radio.addEventListener('change', function () {
        const rowId = this.dataset.row;
        const remarkCell = document.getElementById(pmu-remark-${rowId});

        if (this.value === 'reject') {
          document.getElementById('currentRowId').value = rowId;
          document.getElementById('modalRejectionRemark').value = '';
          rejectionModal.show();
        }

        // Show/hide PMU remark column
        if (this.value === 'accept') {
          remarkCell.style.display = 'none';
          remarkCell.setAttribute('data-visible', 'false');
        } else if (this.value === 'reject') {
          remarkCell.style.display = '';
          remarkCell.setAttribute('data-visible', 'true');
        }
      });
    });

    // Save button in modal
    document.getElementById('saveRejectionRemarkBtn').addEventListener('click', function () {
      const rowId = document.getElementById('currentRowId').value;
      const remark = document.getElementById('modalRejectionRemark').value.trim();

      if (remark === '') {
        alert('Please enter a remark before saving.');
        return;
      }

      const remarkCell = document.getElementById(pmu-remark-${rowId});
      const remarkText = remarkCell.querySelector('.remark-text');
      const editBtn = remarkCell.querySelector('.editRemarkBtn');

      remarkText.textContent = remark;
      editBtn.style.display = 'inline-block';
      remarkCell.style.display = ''; // make sure it appears
      remarkCell.setAttribute('data-visible', 'true');

      rejectionModal.hide();
    });

    // Edit button
    document.querySelectorAll('.editRemarkBtn').forEach(function (btn) {
      btn.addEventListener('click', function () {
        const rowId = this.dataset.row;
        const remarkCell = document.getElementById(pmu-remark-${rowId});
        const existingRemark = remarkCell.querySelector('.remark-text').textContent.trim();

        document.getElementById('currentRowId').value = rowId;
        document.getElementById('modalRejectionRemark').value = existingRemark;
        rejectionModal.show();
      });
    });
  });
</script>