{{-- @extends('layouts.blank')

@section('title', 'Login - KPI Management System')

@section('page-style')
<style>
  body {
    margin: 0;
    padding: 0;
    height: 100vh;
    /* Background gradient using your specified Pantone colors */
    background: linear-gradient(to bottom, #0e3e99 0%, #f9872d 100%);
    /* Pantone 7687C (C:100 M:86 Y:15 K:3) to Pantone 1495C (M:50 Y:100) */
    display: flex;
    align-items: center;
    justify-content: center;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  }

  .login-container {
    width: 400px;
    background-color: white;
    border-radius: 10px;
    padding: 30px;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    text-align: center;
  }

  .logo-container {
    margin-bottom: 20px;
  }

  .logo {
    max-width: 200px; /* Increased from 120px to 200px */
    height: auto;
    margin: 0 auto; /* Centers the image */
  }

  .system-title {
    font-size: 24px;
    font-weight: bold;
    color: #0e3e99;
    margin: 15px 0;
  }

  .ministry-title {
    font-size: 14px;
    font-weight: bold;
    margin-bottom: 25px;
    color: #333;
  }

  .form-group {
    margin-bottom: 20px;
  }

  .form-control {
    width: 100%;
    padding: 12px 15px;
    font-size: 16px;
    border: 1px solid #ddd;
    border-radius: 5px;
    box-sizing: border-box;
  }

  .btn-login {
    width: 100%;
    padding: 12px;
    background-color: #f9872d;
    color: white;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 16px;
    font-weight: bold;
    transition: background-color 0.3s;
  }

  .btn-login:hover {
    background-color: #e07725;
  }

  .register-link {
    margin-top: 20px;
    color: #0e3e99;
    text-decoration: none;
    display: inline-block;
    font-size: 14px;
  }

  .register-link:hover {
    text-decoration: underline;
  }
</style>
@endsection

@section('content')
<div class="login-container">
  <div class="logo-container">
    <img src="{{ asset('assets/img/logo/logo_matrade.png') }}" alt="MATRADE Logo" class="logo">
  </div>

  <div class="system-title">KPI MANAGEMENT SYSTEM</div>

  <form method="POST" action="{{ route('login.post') }}">
    @csrf
    <div class="form-group">
      <input type="text" class="form-control" id="name" name="name" placeholder="USERNAME" required>
    </div>

    <div class="form-group">
      <input type="password" class="form-control" id="password" name="password" placeholder="PASSWORD" required>
    </div>

    @if($errors->any())
    <div class="alert alert-danger" style="color: red; margin-bottom: 15px; font-size: 14px;">
      {{ $errors->first() }}
    </div>
    @endif

    <button type="submit" class="btn-login">LOGINN</button>
  </form>

  {{-- <a href="{{ route('auth-register-basic') }}" class="register-link">No account? Register</a> --}
</div>
@endsection --}}

@extends('layouts.blank')

@section('title', 'Login - KPI Management System')

@section('page-style')
<style>
  body {
    margin: 0;
    padding: 0;
    height: 100vh;
    background: linear-gradient(to bottom, #0e3e99 0%, #f9872d 100%);
    display: flex;
    align-items: center;
    justify-content: center;
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  }

  .login-container {
    width: 400px;
    background-color: white;
    border-radius: 10px;
    padding: 30px;
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
    text-align: center;
  }

  .logo-container {
    margin-bottom: 20px;
  }

  .logo {
    max-width: 200px;
    height: auto;
    margin: 0 auto;
  }

  .system-title {
    font-size: 24px;
    font-weight: bold;
    color: #0e3e99;
    margin: 15px 0;
  }

  .ministry-title {
    font-size: 14px;
    font-weight: bold;
    margin-bottom: 25px;
    color: #333;
  }

  .form-group {
    margin-bottom: 20px;
  }

  .form-control {
    width: 100%;
    padding: 12px 15px;
    font-size: 16px;
    border: 1px solid #ddd;
    border-radius: 5px;
    box-sizing: border-box;
  }

  .btn-login, .btn-sso {
    width: 100%;
    padding: 12px;
    color: white;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 16px;
    font-weight: bold;
    transition: background-color 0.3s;
    margin-top: 10px;
  }

  .btn-login {
    background-color: #f9872d;
  }

  .btn-login:hover {
    background-color: #e07725;
  }

  .btn-sso {
    background-color: #0e3e99;
  }

  .btn-sso:hover {
    background-color: #0b2f73;
  }

  .register-link {
    margin-top: 20px;
    color: #0e3e99;
    text-decoration: none;
    display: inline-block;
    font-size: 14px;
  }

  .register-link:hover {
    text-decoration: underline;
  }
</style>
@endsection

@section('content')
<div class="login-container">
  <div class="logo-container">
    <img src="{{ asset('assets/img/logo/logo_matrade.png') }}" alt="MATRADE Logo" class="logo">
  </div>

  <div class="system-title">KPI MANAGEMENT SYSTEM LOGIN atikah</div>

  <!-- Normal Login Form -->
  <form method="POST" action="{{ route('login.post') }}">
    @csrf
    <div class="form-group">
      <input type="text" class="form-control" id="name" name="name" placeholder="USERNAME" required>
    </div>

    <div class="form-group">
      <input type="password" class="form-control" id="password" name="password" placeholder="PASSWORD" required>
    </div>

    @if($errors->any())
    <div class="alert alert-danger" style="color: red; margin-bottom: 15px; font-size: 14px;">
      {{ $errors->first() }}
    </div>
    @endif

    <button type="submit" class="btn-login">LOGIN</button>
  </form>

  <!-- SSO Login Button -->
  <button type="button" id="ssoBtn" class="btn-sso">LOGIN WITH SSO</button>

  <!-- Hidden SSO Form -->
  {{-- <form id="ssoForm" class="sso_login_form" method="POST" action="sso/index.php"> --}}
    <form id="ssoForm" method="POST" action="{{ route('sso.start') }}">
    <input type="hidden" id="browser_width" name="browser_width" value="">
    <input type="hidden" id="browser_height" name="browser_height" value="">
    <input type="hidden" id="user_uuid" name="user_uuid" value="">
  </form>
</div>

<!-- Scripts for SSO -->
<script src="common/assets/global/plugins/jquery.min.js"></script>
<script src="common/assets/global/plugins/clientjs/client.min.js"></script>
<script>
  document.getElementById("ssoBtn").addEventListener("click", function () {
      var clientJS = new ClientJS();
      var user_uuid = clientJS.getFingerprint();

      $('#user_uuid').val(user_uuid);
      $('#browser_width').val($(window).width());
      $('#browser_height').val($(window).height());

      $('#ssoForm').submit();
  });
</script>
@endsection
