@extends('layouts/contentNavbarLayout')

@section('title', 'KPI Achievement')

@section('content')
<br>
<div class="container-fluid my-4 px-3">
  <div class="card mx-auto" style="max-width: 98%;">
    <div class="card-header">
      <h4 class="mb-0">Manage Indicator Type 6</h4>
    </div>

    <div class="card-body">
      <!-- START: Indicator Details Section -->
      <div class="mb-4">

        <!-- Division Info -->
        <div class="row mb-3">
          <div class="col-md-4">
            <label class="form-label">Division:</label>
            <input type="text" class="form-control" value="TRANSFORMATION & DIGITAL TRADE DIVISION" readonly>
          </div>
          <div class="col-md-4">
            <label class="form-label">Section:</label>
            <input type="text" class="form-control" value="DIGITAL TRADE" readonly>
          </div>
          <div class="col-md-4">
            <label class="form-label">Unit / Offices:</label>
            <input type="text" class="form-control" value="eCOMMERCE ECOSYSTEM" readonly>
          </div>
        </div>

        <!-- Indicator Table -->
        <div class="table-responsive mb-4">
          <table class="table table-bordered text-center small align-middle">
            <thead class="table-light">
              <tr>
                <th>Indicator</th>
                <th>Indicator Description</th>
                <th>Submission</th>
                <th>Annual Target</th>
                <th>Metric</th>
                <th>Category</th>
                <th>Output/Outcome</th>
                <th>Component Achievement</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>Success stories</td>
                <td style="text-align: justify;">Presentation slide describing MATRADE's contribution towards exports

Report on exporters' achievement, sales and  facilitation/assistance provided by TC/MATRADE in dealing with Malaysian companies.

Storytelling perspective :

i) HQ to focus on Malaysian co. (supply side)

     * From non-exporting to exporting (must be supported with details of foreign buyers and 
       actual export values equivalent or more than RM10,000);

     * Increase in number of export market (must be supported with detail of foreign buyer 
       and actual export values equivalent or more than RM10,000); and

     * Increase in ACTUAL export revenue. (Recommendations: MATRADE should be seen as  
       a close buddy to exporters rather than on touch and go basis or analysing company’s  
       profit and loss/ financial statement).

ii) TC/ MO will focus on foreign buyers (demand side)

Quantitative (Export sales value)-Actual sales

Qualitative

      * MoU/MoA (with contractual value equivalent or more than RM10,000)

      * Establishment of Office/ Company Abroad (subject to the actual export value (of 
         Malaysian products) or income repatriation to Malaysia being equivalent or more than  
         RM10,000)

      * Note: Among things to be included in the success story slide are details on assistance   
      provided, nature of the business/ establishment and the amount of income repatriated to   
      Malaysia.

      * Appointment of Local Distributor  (subject to contractual value of annual purchase  
         equivalent or more than RM10,000)

Source: MyDocument - Collection > Success Stories</td>
                <td>Quarterly</td>
                <td>4</td>
                <td>Story</td>
                <td>Customer</td>
                <td>Output</td>
                <td>Exporters Development</td>
              </tr>
            </tbody>
          </table>
        </div>

        <!-- Query Input -->
        <p class="fw-semibold">Query:</p>
        <div class="mb-3">
          <textarea id="sqlEditor4" class="form-control" rows="10" style="background-color: #1e1e1e; color: #fff; font-family: monospace;"></textarea>
        </div>
        <div class="text-end mb-4">
          <button type="button" class="btn btn-primary">Test Query</button>
        </div>

        <!-- Achievement Table -->
        <div class="table-responsive">
          <table class="table table-bordered align-middle text-center small">
            <thead class="table-light">
              <tr>
                <th>Year</th>
                <th>Quarter/Month Group</th>
                <th>Achievement Count</th>
              </tr>
            </thead>
            <tbody>
              <tr>
                <td>
                  <input type="text" class="form-control text-center" value="2024" readonly>
                </td>
                <td>
                  <input type="text" class="form-control text-center" placeholder="Q1 / Jan">
                </td>
                <td>
                  <input type="text" class="form-control text-center" placeholder="">
                </td>
              </tr>
            </tbody>
          </table>
        </div>

      </div>
      <!-- END: Indicator Details Section -->

      <div class="d-flex justify-content-end gap-2">
        <button type="button" class="btn btn-primary">Save</button>
      </div>
    </div> <!-- end card-body -->
  </div> <!-- end card -->
</div> <!-- end container -->
@endsection
