<!-- Bootstrap JS (for full Bootstrap features) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
  // ===== Utility Functions =====

  // Hide all detail sections
  function hideAllSections() {
    const sections = [
      'durationSetupDetail',
      'percentageTargetDetail',
      'indicatorDurationSetup',
      'kpiProposedIndicatorDetail',
      'finalKpiNotificationDetail',
      'achievementVerificationDetail',
      'kpiIndicatorTypeSection',
      'kpiReminderNotificationDetail',
      'achievementVerificationReminderDetail',
      'reminderCardSection',
      'reminderUnderAchieveSection',
      'columnDefaultSettingSection',
      'kpiCategorySection',
      'reminderSubmitKpiAchievement',
      'reminderVerifyKpiAchievement',
      'underAchieveSection'
    ];

    sections.forEach(sectionId => {
      const section = document.getElementById(sectionId);
      if (section) {
        section.style.display = 'none';
      }
    });
  }

  // Show a specific section and hide all others
  function showSection(sectionId) {
    // First hide all sections
    hideAllSections();

    // Then show the requested section
    const section = document.getElementById(sectionId);
    if (section) {
      section.style.display = 'block';
      // Scroll to the section
      section.scrollIntoView({
        behavior: 'smooth'
      });
      return true;
    } else {
      console.error(`Section with ID '${sectionId}' not found`);
      return false;
    }
  }

  // Reset chevron icons to default state
  function resetChevrons() {
    const chevrons = document.querySelectorAll('.list-group-item i.bx');
    chevrons.forEach(icon => {
      icon.classList.remove('bx-chevron-down');
      icon.classList.add('bx-chevron-right');
    });
  }

  // Toggle chevron icon
  function toggleChevron(linkElement) {
    const icon = linkElement.querySelector('i.bx');
    if (icon) {
      if (icon.classList.contains('bx-chevron-right')) {
        icon.classList.remove('bx-chevron-right');
        icon.classList.add('bx-chevron-down');
      } else {
        icon.classList.remove('bx-chevron-down');
        icon.classList.add('bx-chevron-right');
      }
    }
  }

  // Initialize date pickers
  function initializeDatepickers() {
    const datepickers = document.querySelectorAll('.datepicker');
    if (datepickers.length > 0 && typeof flatpickr === 'function') {
      flatpickr('.datepicker', {
        dateFormat: 'Y-m-d',
        allowInput: true
      });
    }
  }

  // ===== Column Default Settings Functions =====

  // Modified toggleColumnDefaultSection function
  function toggleColumnDefaultSection(element) {
    // Reset active state and chevrons for all items
    document.querySelectorAll('.list-group-item').forEach(function(item) {
      item.classList.remove('active');
      // Remove any custom background color
      item.style.backgroundColor = '';
      // Reset text color to default
      item.style.color = '';
      // Reset font styling
      item.style.fontWeight = '';
    });
    resetChevrons();

    // Set active state and toggle chevron for clicked item
    element.classList.add('active');
    // Use consistent styling with other toggles (no custom background)
    element.style.backgroundColor = '';
    // Ensure text color remains black/default like other toggles
    element.style.color = '';
    toggleChevron(element);

    // Show the selected section
    showSection('columnDefaultSettingSection');

    // Load column settings only when section is shown
    loadSavedColumnSettings();

    // If no module selected, select the first one
    const moduleSelect = document.getElementById('kpiModuleSelect');
    if (moduleSelect && (moduleSelect.value === "" || !moduleSelect.value)) {
      moduleSelect.selectedIndex = 1;
      showTableColumns();
    }
  }

  // Modified toggleSection function for consistency
  function toggleSection(element, sectionId) {
    // Reset active state and chevrons for all items
    document.querySelectorAll('.list-group-item').forEach(function(item) {
      item.classList.remove('active');
      // Remove any custom background color
      item.style.backgroundColor = '';
      // Reset text color to default
      item.style.color = '';
      // Reset font styling
      item.style.fontWeight = '';
    });
    resetChevrons();

    // Set active state and toggle chevron for clicked item
    element.classList.add('active');
    // Use consistent styling (no custom background)
    element.style.backgroundColor = '';
    // Ensure text color remains the default
    element.style.color = '';
    toggleChevron(element);

    // Show the selected section
    showSection(sectionId);
  }

  // Modified resetChevrons to also reset styling
  function resetChevrons() {
    const chevrons = document.querySelectorAll('.list-group-item i.bx');
    chevrons.forEach(icon => {
      icon.classList.remove('bx-chevron-down');
      icon.classList.add('bx-chevron-right');
    });
  }

  // Function to show the selected table's columns
  function showTableColumns() {
    const selectedModule = document.getElementById('kpiModuleSelect').value;

    // Hide all column settings sections
    document.querySelectorAll('.column-settings').forEach(function(element) {
      element.style.display = 'none';
    });

    // Hide no table selected alert
    document.getElementById('noTableSelected').style.display = 'none';

    // Hide success message if visible
    document.getElementById('saveSuccess').style.display = 'none';

    // Show the selected table's column settings
    if (selectedModule && selectedModule !== '') {
      const tableColumns = document.getElementById(selectedModule + '_columns');
      if (tableColumns) {
        tableColumns.style.display = 'block';

        // Add select all / deselect all buttons if not already present
        if (!tableColumns.querySelector('.select-buttons')) {
          const buttonRow = document.createElement('div');
          buttonRow.className = 'row mb-3 select-buttons';
          buttonRow.innerHTML = `
          <div class="col-12">
            <button type="button" class="btn btn-outline-primary btn-sm me-2 select-all-btn">Select All</button>
            <button type="button" class="btn btn-outline-secondary btn-sm deselect-all-btn">Deselect All</button>
          </div>
        `;
          tableColumns.insertBefore(buttonRow, tableColumns.firstChild.nextSibling);

          // Add event listeners
          tableColumns.querySelector('.select-all-btn').addEventListener('click', function() {
            selectAllColumns(tableColumns, true);
          });

          tableColumns.querySelector('.deselect-all-btn').addEventListener('click', function() {
            selectAllColumns(tableColumns, false);
          });
        }
      }
    } else {
      // Show "no table selected" message
      document.getElementById('noTableSelected').style.display = 'block';
    }
  }

  // Function to select all or deselect all columns
  function selectAllColumns(tableSection, select) {
    const checkboxes = tableSection.querySelectorAll('input[type="checkbox"]:not([disabled])');
    checkboxes.forEach(function(checkbox) {
      checkbox.checked = select;
    });
  }

  // Function to initialize select all buttons for each table
  function initSelectAllButtons() {
    document.querySelectorAll('.column-settings').forEach(function(tableSection) {
      if (!tableSection.querySelector('.select-buttons')) {
        const buttonRow = document.createElement('div');
        buttonRow.className = 'row mb-3 select-buttons';
        buttonRow.innerHTML = `
          <div class="col-12">
            <button type="button" class="btn btn-outline-primary btn-sm me-2 select-all-btn">Select All</button>
            <button type="button" class="btn btn-outline-secondary btn-sm deselect-all-btn">Deselect All</button>
          </div>
        `;
        tableSection.insertBefore(buttonRow, tableSection.firstChild.nextSibling);

        // Add event listeners
        tableSection.querySelector('.select-all-btn').addEventListener('click', function() {
          selectAllColumns(tableSection, true);
        });

        tableSection.querySelector('.deselect-all-btn').addEventListener('click', function() {
          selectAllColumns(tableSection, false);
        });
      }
    });
  }

  // Function to save column settings
  function saveColumnSettings() {
    const selectedModule = document.getElementById('kpiModuleSelect').value;

    if (!selectedModule || selectedModule === '') {
      alert('Please select a KPI module first.');
      return;
    }

    const tableColumns = document.getElementById(selectedModule + '_columns');
    if (!tableColumns) return;

    const settings = {
      module: selectedModule,
      columns: {}
    };

    // Get all checkboxes in the selected table
    const checkboxes = tableColumns.querySelectorAll('input[type="checkbox"]');
    checkboxes.forEach(function(checkbox) {
      settings.columns[checkbox.id] = checkbox.checked;
    });

    // Save settings to localStorage (for demonstration)
    // In production, you would send this to the server
    localStorage.setItem('columnSettings_' + selectedModule, JSON.stringify(settings));

    // Send to server using AJAX
    saveColumnSettingsToServer(settings);
  }

  // Function to save settings to server
  function saveColumnSettingsToServer(settings) {
    // Show loading state
    const saveButton = document.getElementById('saveColumnSettings');
    const originalText = saveButton.textContent;
    saveButton.textContent = 'Saving...';
    saveButton.disabled = true;

    // Using fetch API to send data to server
    fetch('/kpi-admin/save-column-settings', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify(settings)
      })
      .then(response => response.json())
      .then(data => {
        // Show success message
        document.getElementById('saveSuccess').style.display = 'block';

        // Reset button state
        saveButton.textContent = originalText;
        saveButton.disabled = false;

        // Auto-hide success message after 3 seconds
        setTimeout(function() {
          document.getElementById('saveSuccess').style.display = 'none';
        }, 3000);
      })
      .catch(error => {
        console.error('Error saving column settings:', error);
        alert('An error occurred while saving column settings. Please try again.');

        // Reset button state
        saveButton.textContent = originalText;
        saveButton.disabled = false;
      });
  }

  // Function to load saved column settings
  function loadSavedColumnSettings() {
    // Try to load from localStorage first (for demo purposes)
    loadFromLocalStorage();

    // Then load from server (this would override localStorage in production)
    loadColumnSettingsFromServer();
  }

  // Function to load settings from localStorage
  function loadFromLocalStorage() {
    document.querySelectorAll('.column-settings').forEach(function(tableSection) {
      const moduleId = tableSection.id.replace('_columns', '');
      const savedSettings = localStorage.getItem('columnSettings_' + moduleId);

      if (savedSettings) {
        try {
          const settings = JSON.parse(savedSettings);

          // Apply saved settings to checkboxes
          for (const columnId in settings.columns) {
            const checkbox = document.getElementById(columnId);
            if (checkbox && !checkbox.disabled) {
              checkbox.checked = settings.columns[columnId];
            }
          }
        } catch (error) {
          console.error('Error parsing saved settings:', error);
        }
      }
    });
  }

  // Function to load settings from server
  function loadColumnSettingsFromServer() {
    fetch('/kpi-admin/get-column-settings', {
        method: 'GET',
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        }
      })
      .then(response => response.json())
      .then(data => {
        if (data && data.settings) {
          // Apply settings for each module
          for (const moduleId in data.settings) {
            const settings = data.settings[moduleId];
            const tableColumns = document.getElementById(moduleId + '_columns');

            if (tableColumns) {
              // Apply saved settings to checkboxes
              for (const columnId in settings.columns) {
                const checkbox = document.getElementById(columnId);
                if (checkbox && !checkbox.disabled) {
                  checkbox.checked = settings.columns[columnId];
                }
              }
            }
          }
        }
      })
      .catch(error => {
        console.error('Error loading column settings:', error);
      });
  }

  // ===== Debug Functions =====

  // Debug utility function to help identify display issues
  function debugElementDisplay(elementId) {
    const element = document.getElementById(elementId);

    console.log(`=== Debug for ${elementId} ===`);
    if (element) {
      console.log('Element exists:', true);
      console.log('Display style:', element.style.display);
      console.log('Computed style display:', window.getComputedStyle(element).display);
      console.log('Element dimensions:', element.offsetWidth, 'x', element.offsetHeight);
      console.log('Parent element:', element.parentElement.tagName, element.parentElement.id);
      console.log('Classes:', element.className);
    } else {
      console.log('Element does not exist');
    }
    console.log('=== End Debug ===');

    return element !== null;
  }

  // Add this function to your JavaScript file
  function debugAchievementVerification() {
    console.log('=== Debug Achievement Verification ===');

    // Check if element exists
    const element = document.getElementById('achievementVerificationDetail');
    console.log('Element exists:', element !== null);

    if (element) {
      // Log current display status
      console.log('Current display value:', element.style.display);
      console.log('Computed display value:', window.getComputedStyle(element).display);

      // Log element dimensions
      console.log('Offset height:', element.offsetHeight);
      console.log('Offset width:', element.offsetWidth);

      // Log parent container
      console.log('Parent element:', element.parentElement.tagName, element.parentElement.id);

      // Check if the element is within the viewport
      const rect = element.getBoundingClientRect();
      console.log('Element position:', rect);
      console.log('Is in viewport:',
        rect.top >= 0 &&
        rect.left >= 0 &&
        rect.bottom <= (window.innerHeight || document.documentElement.clientHeight) &&
        rect.right <= (window.innerWidth || document.documentElement.clientWidth)
      );
    }

    // Check if the toggle function exists
    console.log('toggleAchievementVerification function exists:', typeof toggleAchievementVerification === 'function');

    console.log('=== End Debug ===');
  }

  // ===== Toggle Functions =====

  // Toggle Duration Setup Section
  function toggleDurationSetup() {
    console.log('toggleDurationSetup called');
    const link = document.querySelector('a[onclick="toggleDurationSetup()"]');
    toggleSection(link, 'durationSetupDetail');
  }

  // Updated togglePercentageTarget function
  function togglePercentageTarget() {
    console.log('togglePercentageTarget called');
    const link = document.querySelector('a[onclick="togglePercentageTarget()"]');
    toggleSection(link, 'percentageTargetDetail');
  }

  // Show KPI Indicator Duration Setup
  function showDurationSetup() {
    console.log('showDurationSetup called');
    const link = document.querySelector('a[onclick="showDurationSetup()"]');
    toggleSection(link, 'indicatorDurationSetup');

    // Reinitialize datepickers
    initializeDatepickers();
  }


  // Toggle KPI Proposed Indicator Notification
  function toggleKpiProposedIndicator() {
    console.log('toggleKpiProposedIndicator called');
    const link = document.querySelector('a[onclick="toggleKpiProposedIndicator()"]');
    toggleSection(link, 'kpiProposedIndicatorDetail');

    // Initialize datepicker if needed
    if (typeof flatpickr === 'function' && document.getElementById('proposedDate')) {
      flatpickr('#proposedDate', {
        dateFormat: 'Y-m-d',
        allowInput: true
      });
    }
  }

  // Toggle Final KPI Notification
  // Update toggleFinalKpiNotification
  function toggleFinalKpiNotification() {
    console.log('toggleFinalKpiNotification called');
    const link = document.querySelector('a[onclick="toggleFinalKpiNotification()"]');
    toggleSection(link, 'finalKpiNotificationDetail');
  }

  // Update toggleAchievementVerification
  function toggleAchievementVerification() {
    console.log('toggleAchievementVerification called');
    const link = document.querySelector('a[onclick="toggleAchievementVerification()"]');
    toggleSection(link, 'achievementVerificationDetail');
  }

  function toggleKpiIndicatorType() {
    console.log('toggleKpiIndicatorType called');
    const link = document.querySelector('a[onclick="toggleKpiIndicatorType()"]');
    toggleSection(link, 'kpiIndicatorTypeSection');
  }

  // Show Reminder Card
  function showReminderCard() {
    console.log('showReminderCard called');
    const link = document.querySelector('a[onclick="showReminderCard()"]');
    toggleSection(link, 'kpiReminderNotificationDetail');
    
 }

  // Show Reminder Card
  function reminderVerifyKpiAchievement() {
    console.log('reminderVerifyKpiAchievement called');
    const link = document.querySelector('a[onclick="reminderVerifyKpiAchievement()"]');
    toggleSection(link, 'reminderSubmitKpiAchievement');

    // Initialize datepicker
    if (typeof flatpickr === 'function' && document.getElementById('reminderDate')) {
      flatpickr('#reminderDate', {
        dateFormat: 'Y-m-d',
        allowInput: true
      });
    }
  }

  // Show Under Achieve Card
  function showUnderAchieveCard() {
    console.log('showUnderAchieveCard called');
    const link = document.querySelector('a[onclick="showUnderAchieveCard()"]');
    toggleSection(link, 'achievementVerificationReminderDetail');

    // Initialize datepicker
    if (typeof flatpickr === 'function' && document.getElementById('verificationReminderDate')) {
      flatpickr('#verificationReminderDate', {
        dateFormat: 'Y-m-d',
        allowInput: true
      });
    }
  }

  // Toggle KPI Category Section
  function toggleKpiCategorySection() {
    console.log('toggleKpiCategorySection called');
    const link = document.querySelector('a[onclick="toggleKpiCategorySection()"]');
    toggleSection(link, 'kpiCategorySection'); // Changed from 'kpiCategoryDetail' to match your HTML
  }

  // ===== Email & Form Functions =====

  // Revert Final KPI Content
  function revertFinalKpiContent() {
    if (confirm('Are you sure you want to revert the changes?')) {
      // Revert to the original content if available
      const emailContent = document.getElementById('finalKpiEmailContent');
      if (emailContent) {
        emailContent.value = '{{ $finalKpiEmailContent ?? "" }}';
      }
    }
  }

  // Send Final KPI Email
  function sendFinalKpiEmail() {
    // Show confirmation modal if available
    const confirmationModal = document.getElementById('confirmationModal');
    if (confirmationModal && typeof bootstrap !== 'undefined') {
      new bootstrap.Modal(confirmationModal).show();

      // Set the action for the proceed button
      const btnProceed = document.getElementById('btnProceed');
      if (btnProceed) {
        btnProceed.onclick = function() {
          // Close the modal
          bootstrap.Modal.getInstance(confirmationModal).hide();

          // Show success modal
          const successModal = document.getElementById('successModal');
          if (successModal) {
            new bootstrap.Modal(successModal).show();
          } else {
            alert('Email has been sent successfully!');
          }
        };
      }
    } else {
      // Simple confirmation if modal not available
      if (confirm('Are you sure you want to send this notification email?')) {
        alert('Email has been sent successfully!');
      }
    }
  }

  // Send Email with confirmation
  function sendEmail() {
    // Show confirmation modal
    var confirmationModal = new bootstrap.Modal(document.getElementById('confirmationModal'));
    confirmationModal.show();

    // Set the action for the proceed button
    document.getElementById('btnProceed').onclick = function() {
      var confirmationModal = bootstrap.Modal.getInstance(document.getElementById('confirmationModal'));
      confirmationModal.hide();

      // Show success modal
      var successModal = new bootstrap.Modal(document.getElementById('successModal'));
      successModal.show();
    };
  }

  // Send Verification Email
  function sendVerificationEmail() {
    sendEmail();
  }

  // Send Verification Reminder Email with Confirmation
function sendVerificationReminderEmail() {
  // Show confirmation modal if available
  const confirmationModal = document.getElementById('confirmationModal');
  if (confirmationModal && typeof bootstrap !== 'undefined') {
    new bootstrap.Modal(confirmationModal).show();

    // Set the action for the proceed button
    const btnProceed = document.getElementById('btnProceed');
    if (btnProceed) {
      btnProceed.onclick = function() {
        // Close the modal
        bootstrap.Modal.getInstance(confirmationModal).hide();

        // Submit the form or perform the send action
        const reminderForm = document.getElementById('achievementVerificationReminderForm');
        if (reminderForm) {
          reminderForm.submit();
        } else {
          // Alternative: Show success message if no form to submit
          const successModal = document.getElementById('successModal');
          if (successModal) {
            new bootstrap.Modal(successModal).show();
          } else {
            alert('Verification reminder email has been sent successfully!');
          }
        }
      };
    }
  } else {
    // Simple confirmation if modal not available
    if (confirm('Are you sure you want to send this verification reminder email?')) {
      const reminderForm = document.getElementById('achievementVerificationReminderForm');
      if (reminderForm) {
        reminderForm.submit();
      } else {
        alert('Verification reminder email has been sent successfully!');
      }
    }
  }
}

// Send Reminder Email with Confirmation
function sendReminderEmail() {
  // Show confirmation modal if available
  const confirmationModal = document.getElementById('confirmationModal');
  if (confirmationModal && typeof bootstrap !== 'undefined') {
    new bootstrap.Modal(confirmationModal).show();

    // Set the action for the proceed button
    const btnProceed = document.getElementById('btnProceed');
    if (btnProceed) {
      btnProceed.onclick = function() {
        // Close the modal
        bootstrap.Modal.getInstance(confirmationModal).hide();

        // Submit the form or perform the send action
        const reminderForm = document.getElementById('kpiReminderNotificationForm');
        if (reminderForm) {
          reminderForm.submit();
        } else {
          // Alternative: Show success message if no form to submit
          const successModal = document.getElementById('successModal');
          if (successModal) {
            new bootstrap.Modal(successModal).show();
          } else {
            alert('Reminder email has been sent successfully!');
          }
        }
      };
    }
  } else {
    // Simple confirmation if modal not available
    if (confirm('Are you sure you want to send this reminder email?')) {
      const reminderForm = document.getElementById('kpiReminderNotificationForm');
      if (reminderForm) {
        reminderForm.submit();
      } else {
        alert('Reminder email has been sent successfully!');
      }
    }
  }
}

  // Toggle Email Configuration
  function toggleEmailConfiguration() {
    const toggleCheckbox = document.getElementById('toggleEmailConfig');
    if (toggleCheckbox) {
      const configFields = document.querySelectorAll('#kpiProposedNotificationForm input:not(#toggleEmailConfig), #kpiProposedNotificationForm textarea, #kpiProposedNotificationForm select');
      const isEnabled = toggleCheckbox.checked;

      configFields.forEach(field => {
        field.disabled = !isEnabled;
      });

      // Update the label text based on state
      const label = document.querySelector('label[for="toggleEmailConfig"]');
      if (label) {
        label.textContent = `Click ${isEnabled ? 'Disable' : 'Enable'}/Enable to ${isEnabled ? 'disable' : 'enable'} the email configuration content.`;
      }
    }
  }

  // Revert Proposed Content
  function revertProposedContent() {
    if (confirm('Are you sure you want to revert the changes?')) {
      // Revert to the original content if available
      const emailContent = document.getElementById('proposedEmailContent');
      if (emailContent) {
        emailContent.value = '{{ $proposedEmailContent ?? "" }}';
      }
    }
  }

  // Send Proposed Email
  function sendProposedEmail() {
    // Show confirmation modal if available
    const confirmationModal = document.getElementById('confirmationModal');
    if (confirmationModal && typeof bootstrap !== 'undefined') {
      new bootstrap.Modal(confirmationModal).show();

      // Set the action for the proceed button
      const btnProceed = document.getElementById('btnProceed');
      if (btnProceed) {
        btnProceed.onclick = function() {
          // Submit the form
          document.getElementById('kpiProposedIndicatorForm').submit();
        };
      }
    } else {
      // Simple confirmation if modal not available
      if (confirm('Are you sure you want to send this notification email?')) {
        document.getElementById('kpiProposedIndicatorForm').submit();
      }
    }
  }

  // ===== Modal Functions =====

  // Show Edit Modal for target percentage
  function showEditModal(color, quarter, percentageValue) {
    document.getElementById('editId').value = color + '-' + quarter;
    document.getElementById('editYear').value = document.getElementById('selectYear').value;
    document.getElementById('editTargetPercentage').value = percentageValue.replace(/[^0-9.]/g, '');
    const editModal = new bootstrap.Modal(document.getElementById('editTargetModal'));
    editModal.show();
  }

  // Open Edit Modal for reminder
  function openEditModal(monthGroup, reminderDate) {
    document.getElementById('editMonthGroup').value = monthGroup;
    document.getElementById('editReminderDate').value = reminderDate;
    document.getElementById('dateError').classList.add('d-none');

    const modalElement = document.getElementById('editReminderModal');
    const modal = new bootstrap.Modal(modalElement);
    modal.show();

    document.getElementById('editReminderDate').focus();
  }

  // Open Under Achieve Edit Modal
  function openUnderAchieveEditModal(monthGroup, reminderDate) {
    document.getElementById('editUnderAchieveMonthGroup').value = monthGroup;
    document.getElementById('editUnderAchieveReminderDate').value = reminderDate;
    document.getElementById('underAchieveDateError').classList.add('d-none');
    new bootstrap.Modal(document.getElementById('editUnderAchieveModal')).show();
    document.getElementById('editUnderAchieveReminderDate').focus();
  }

  // Reset Under Achieve Form
  function resetUnderAchieveForm() {
    document.getElementById('editUnderAchieveReminderDate').value = '';
    document.getElementById('underAchieveDateError').classList.add('d-none');
  }

  // Save Under Achieve Reminder
  function saveUnderAchieveReminder() {
    const selectedDate = new Date(document.getElementById('editUnderAchieveReminderDate').value);
    const today = new Date();
    today.setHours(0, 0, 0, 0);

    if (selectedDate < today) {
      document.getElementById('underAchieveDateError').classList.remove('d-none');
      return;
    }

    alert('Reminder saved for ' + document.getElementById('editUnderAchieveMonthGroup').value + ': ' + selectedDate.toLocaleDateString());
    bootstrap.Modal.getInstance(document.getElementById('editUnderAchieveModal')).hide();
  }

  // ===== Table Functions =====

  // Show reminder table based on type
  function showReminderTable(value) {
    const tables = ['quarterly', 'annually', 'biannually', 'g3', 'g6'];
    tables.forEach(type => {
      const table = document.getElementById('table-' + type);
      if (table) {
        table.style.display = (value === type) ? 'block' : 'none';
      }
    });
  }

  // Show under achieve table based on type
  function showUnderAchieveTable(value) {
    const types = ['quarterly', 'annually', 'biannually', 'g3', 'g6'];
    types.forEach(type => {
      const table = document.getElementById('underachieve-table-' + type);
      if (table) {
        table.style.display = (type === value) ? 'block' : 'none';
      }
    });
  }

  // ===== Document Ready =====

  // Main initialization when document is ready
  document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM Content Loaded');

    // Debug: Log all sections to check if they exist
    const sections = [
      'durationSetupDetail',
      'percentageTargetDetail',
      'indicatorDurationSetup',
      'kpiProposedIndicatorDetail',
      'achievementVerificationDetail',
      'kpiIndicatorTypeSection',
      'kpiReminderNotificationDetail',
      'reminderSubmitKpiAchievement',
      'achievementVerificationReminderDetail'
    ];

    sections.forEach(section => {
      console.log(`Section ${section} exists: ${document.getElementById(section) !== null}`);
    });

    // Hide all sections initially
    hideAllSections();

    // Initialize datepickers
    initializeDatepickers();

    // Set up event listeners for links if they're using class selectors instead of onclick attributes
    const proposedIndicatorLink = document.querySelector('a[href="javascript:void(0);"].list-group-item:nth-child(4)');
    if (proposedIndicatorLink) {
      proposedIndicatorLink.addEventListener('click', toggleKpiProposedNotification);
    }

    // KPI Indicator Type toggle
    const kpiIndicatorTypeLink = document.getElementById('toggleKpiIndicatorType');
    if (kpiIndicatorTypeLink) {
      kpiIndicatorTypeLink.addEventListener('click', toggleKpiIndicatorType);
    }

    // Toggle Email Config
    const toggleEmailConfigCheckbox = document.getElementById('toggleEmailConfig');
    if (toggleEmailConfigCheckbox) {
      toggleEmailConfigCheckbox.addEventListener('change', toggleEmailConfiguration);
    }

    // Reset button
    const resetButton = document.getElementById('resetButton');
    if (resetButton) {
      resetButton.addEventListener('click', function() {
        const form = document.getElementById('durationSetupForm');
        if (form) form.reset();
      });
    }

    // Quarterly vs Monthly radio toggle
    const quarterlyRadio = document.getElementById('quarterly');
    const groupOfMonthRadio = document.getElementById('groupOfMonth');

    if (quarterlyRadio && document.getElementById('quarterlyTable') && document.getElementById('groupMonthOptions')) {
      quarterlyRadio.addEventListener('change', function() {
        document.getElementById('quarterlyTable').style.display = 'block';
        document.getElementById('groupMonthOptions').style.display = 'none';
      });

      if (groupOfMonthRadio) {
        groupOfMonthRadio.addEventListener('change', function() {
          document.getElementById('quarterlyTable').style.display = 'none';
          document.getElementById('groupMonthOptions').style.display = 'block';
        });
      }

      // Initial display
      if (quarterlyRadio.checked) {
        document.getElementById('quarterlyTable').style.display = 'block';
        document.getElementById('groupMonthOptions').style.display = 'none';
      } else if (groupOfMonthRadio && groupOfMonthRadio.checked) {
        document.getElementById('quarterlyTable').style.display = 'none';
        document.getElementById('groupMonthOptions').style.display = 'block';
      }
    }

    // Form submission handling with jQuery if available
    if (typeof $ === 'function') {
      $('#kpiProposedNotificationForm').on('submit', function(e) {
        e.preventDefault(); // Prevent default form submission

        // Show confirmation modal
        var confirmationModal = new bootstrap.Modal(document.getElementById('confirmationModal'));
        confirmationModal.show();
      });

      // Handle proceed button click
      $('#btnProceed').on('click', function() {
        // Hide confirmation modal
        var confirmationModal = bootstrap.Modal.getInstance(document.getElementById('confirmationModal'));
        confirmationModal.hide();

        // Submit the form via AJAX
        $.ajax({
          url: $('#kpiProposedNotificationForm').attr('action'),
          type: 'POST',
          data: $('#kpiProposedNotificationForm').serialize(),
          success: function(response) {
            // Show success modal
            var successModal = new bootstrap.Modal(document.getElementById('successModal'));
            successModal.show();
          },
          error: function(error) {
            // Handle error if needed
            console.error('Error:', error);
          }
        });
      });

      // Reset form when success modal is closed
      $('#successModal').on('hidden.bs.modal', function() {
        // Reset form or redirect if needed
        $('#kpiProposedNotificationForm')[0].reset();
      });
    }

    // Find all revert buttons in reminder sections and attach event handlers
  const revertReminderBtn = document.querySelector('#kpiReminderNotificationDetail .btn-secondary[value="Revert"]');
  if (revertReminderBtn) {
    revertReminderBtn.onclick = revertReminderContent;
  }

  const revertVerificationReminderBtn = document.querySelector('#achievementVerificationReminderDetail .btn-secondary[value="Revert"]');
  if (revertVerificationReminderBtn) {
    revertVerificationReminderBtn.onclick = revertVerificationReminderContent;
  }

  // Find all send buttons in reminder sections and attach event handlers
  const sendReminderBtn = document.querySelector('#kpiReminderNotificationDetail .btn-primary[value="Send"]');
  if (sendReminderBtn) {
    sendReminderBtn.onclick = sendReminderEmail;
  }

  const sendVerificationReminderBtn = document.querySelector('#achievementVerificationReminderDetail .btn-primary[value="Send"]');
  if (sendVerificationReminderBtn) {
    sendVerificationReminderBtn.onclick = sendVerificationReminderEmail;
  }

    // Add debug click handlers
    document.querySelectorAll('.list-group-item').forEach(item => {
      console.log('Adding click debug for', item.textContent.trim());

      item.addEventListener('click', function() {
        console.log('Clicked menu item:', this.textContent.trim());
      });
    });
  });

  // Revert Proposed Content - Minimal version
  function revertProposedContent() {
    if (confirm('Are you sure you want to revert the changes?')) {
      // Revert to the original content if available
      const emailContent = document.getElementById('proposedEmailContent');
      if (emailContent) {
        emailContent.value = '{{ $proposedEmailContent ?? "" }}';
      }
    }
  }

  // Send Proposed Email - Minimal version
  function sendProposedEmail() {
    // Show confirmation modal if available
    const confirmationModal = document.getElementById('confirmationModal');
    if (confirmationModal && typeof bootstrap !== 'undefined') {
      new bootstrap.Modal(confirmationModal).show();

      // Set the action for the proceed button
      const btnProceed = document.getElementById('btnProceed');
      if (btnProceed) {
        btnProceed.onclick = function() {
          // Submit the form
          document.getElementById('kpiProposedIndicatorForm').submit();
        };
      }
    } else {
      // Simple confirmation if modal not available
      if (confirm('Are you sure you want to send this notification email?')) {
        document.getElementById('kpiProposedIndicatorForm').submit();
      }
    }
  }

  //baruadd

  // ===== Standardized Close Button Implementation =====

  // ===== Improved Close Button Implementation (Top Button Only) =====

  // 1. First, add this general function to your script file
  function addCloseButtonToSection(sectionId) {
    const section = document.getElementById(sectionId);
    if (!section) {
      console.warn(`Section with ID ${sectionId} not found`);
      return;
    }

    // Check if a close button already exists
    if (section.querySelector('.standard-close-btn')) return;

    // Find the card header or create a container for the close button
    let headerContainer = section.querySelector('.card-header') ||
      section.querySelector('.card-body > .d-flex') ||
      section.querySelector('.card-body');

    if (!headerContainer) {
      console.warn(`No suitable header container found in section ${sectionId}`);
      return;
    }

    // If we found the card body but not a flex container, we need to create one
    if (headerContainer.classList.contains('card-body') && !headerContainer.querySelector('.d-flex')) {
      // Find the title element
      const titleElement = headerContainer.querySelector('.card-title') ||
        headerContainer.querySelector('h5') ||
        headerContainer.querySelector('h4');

      if (titleElement) {
        // Create a flex container
        const flexContainer = document.createElement('div');
        flexContainer.className = 'd-flex justify-content-between align-items-center mb-4';

        // Move the title inside the flex container
        titleElement.parentNode.insertBefore(flexContainer, titleElement);
        flexContainer.appendChild(titleElement);

        // Update the headerContainer to be the flex container
        headerContainer = flexContainer;
      }
    }

    // Create close button
    const closeButton = document.createElement('button');
    closeButton.type = 'button';
    closeButton.className = 'btn-close standard-close-btn';
    closeButton.setAttribute('aria-label', 'Close');

    // Directly attach event listener instead of using onclick
    closeButton.addEventListener('click', function() {
      console.log(`Closing section: ${sectionId}`);
      // Directly hide the section
      section.style.display = 'none';

      // Reset active state and chevrons for all items
      document.querySelectorAll('.list-group-item').forEach(function(item) {
        item.classList.remove('active');
        item.style.backgroundColor = '';
        item.style.color = '';
        item.style.fontWeight = '';
      });

      // Reset all chevrons
      resetChevrons();
    });

    // Add the close button to the header
    headerContainer.appendChild(closeButton);

    // Remove this line to prevent adding bottom close button
    // addBottomCloseButton(section);
  }

  // 2. Helper function for bottom close button - keep it in case you need it later
  // This function won't be called anymore
  function addBottomCloseButton(section) {
    // Check if a bottom close button already exists
    if (section.querySelector('.bottom-close-btn')) return;

    const cardBody = section.querySelector('.card-body');
    if (!cardBody) return;

    // Create bottom button container
    const bottomButtonContainer = document.createElement('div');
    bottomButtonContainer.className = 'text-end mt-3';

    // Create close button
    const closeButton = document.createElement('button');
    closeButton.type = 'button';
    closeButton.className = 'btn btn-secondary bottom-close-btn';
    closeButton.textContent = 'Close';

    // Directly attach event listener
    closeButton.addEventListener('click', function() {
      console.log(`Closing section from bottom button: ${section.id}`);
      // Hide the section
      section.style.display = 'none';

      // Reset active state and chevrons
      document.querySelectorAll('.list-group-item').forEach(function(item) {
        item.classList.remove('active');
        item.style.backgroundColor = '';
        item.style.color = '';
        item.style.fontWeight = '';
      });

      resetChevrons();
    });

    // Add button to container
    bottomButtonContainer.appendChild(closeButton);

    // Add to end of card body
    cardBody.appendChild(bottomButtonContainer);
  }

  // 3. Function to initialize all close buttons
  function initializeAllCloseButtons() {
    console.log('Initializing all close buttons');

    const sections = [
      'durationSetupDetail',
      'percentageTargetDetail',
      'indicatorDurationSetup',
      'kpiProposedIndicatorDetail',
      'finalKpiNotificationDetail',
      'achievementVerificationDetail',
      'kpiIndicatorTypeSection',
      'kpiReminderNotificationDetail',
      'achievementVerificationReminderDetail',
      'reminderCardSection',
      'reminderUnderAchieveSection',
      'columnDefaultSettingSection',
      'kpiCategorySection',
      'reminderSubmitKpiAchievement',
      'underAchieveSection'
    ];

    sections.forEach(sectionId => {
      addCloseButtonToSection(sectionId);
    });

    console.log('Close buttons initialization complete');
  }

  // 4. Call this function when the DOM is loaded
  document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM loaded, initializing close buttons');

    // Wait a short time to ensure all other scripts have had time to fully initialize
    setTimeout(function() {
      initializeAllCloseButtons();
    }, 500);
  });

  // Revert Reminder Content Function
function revertReminderContent() {
  if (confirm('Are you sure you want to revert the changes?')) {
    // Revert to the original content if available
    const emailContent = document.getElementById('reminderEmailContent');
    if (emailContent) {
      emailContent.value = '{{ $reminderEmailContent ?? "" }}';
    }
  }
}

// Send Reminder Email with Confirmation
function sendReminderEmail() {
  // Show confirmation modal if available
  const confirmationModal = document.getElementById('confirmationModal');
  if (confirmationModal && typeof bootstrap !== 'undefined') {
    new bootstrap.Modal(confirmationModal).show();

    // Set the action for the proceed button
    const btnProceed = document.getElementById('btnProceed');
    if (btnProceed) {
      btnProceed.onclick = function() {
        // Close the modal
        bootstrap.Modal.getInstance(confirmationModal).hide();

        // Submit the form or perform the send action
        const reminderForm = document.getElementById('kpiReminderNotificationForm');
        if (reminderForm) {
          reminderForm.submit();
        } else {
          // Alternative: Show success message if no form to submit
          const successModal = document.getElementById('successModal');
          if (successModal) {
            new bootstrap.Modal(successModal).show();
          } else {
            alert('Reminder email has been sent successfully!');
          }
        }
      };
    }
  } else {
    // Simple confirmation if modal not available
    if (confirm('Are you sure you want to send this reminder email?')) {
      const reminderForm = document.getElementById('kpiReminderNotificationForm');
      if (reminderForm) {
        reminderForm.submit();
      } else {
        alert('Reminder email has been sent successfully!');
      }
    }
  }
}

// Revert Verification Reminder Content
function revertVerificationReminderContent() {
  if (confirm('Are you sure you want to revert the changes?')) {
    // Revert to the original content if available
    const emailContent = document.getElementById('verificationReminderEmailContent');
    if (emailContent) {
      emailContent.value = '{{ $verificationReminderEmailContent ?? "" }}';
    }
  }
}

// Send Verification Reminder Email with Confirmation
function sendVerificationReminderEmail() {
  // Show confirmation modal if available
  const confirmationModal = document.getElementById('confirmationModal');
  if (confirmationModal && typeof bootstrap !== 'undefined') {
    new bootstrap.Modal(confirmationModal).show();

    // Set the action for the proceed button
    const btnProceed = document.getElementById('btnProceed');
    if (btnProceed) {
      btnProceed.onclick = function() {
        // Close the modal
        bootstrap.Modal.getInstance(confirmationModal).hide();

        // Submit the form or perform the send action
        const reminderForm = document.getElementById('achievementVerificationReminderForm');
        if (reminderForm) {
          reminderForm.submit();
        } else {
          // Alternative: Show success message if no form to submit
          const successModal = document.getElementById('successModal');
          if (successModal) {
            new bootstrap.Modal(successModal).show();
          } else {
            alert('Verification reminder email has been sent successfully!');
          }
        }
      };
    }
  } else {
    // Simple confirmation if modal not available
    if (confirm('Are you sure you want to send this verification reminder email?')) {
      const reminderForm = document.getElementById('achievementVerificationReminderForm');
      if (reminderForm) {
        reminderForm.submit();
      } else {
        alert('Verification reminder email has been sent successfully!');
      }
    }
  }
}

// ===== Save Confirmation Functions =====

// ===== Save Confirmation Functions =====

// Save KPI Proposed Email with Confirmation
function saveProposedEmail(event) {
  // Prevent default form submission
  if (event) event.preventDefault();
  
  // Show confirmation dialog
  if (confirm('Are you sure you want to save the email?')) {
    // Submit the form or save the content
    const proposedForm = document.getElementById('kpiProposedIndicatorForm');
    if (proposedForm) {
      // Add a hidden field to indicate this is a save action, not a send action
      let saveActionField = proposedForm.querySelector('input[name="action"]');
      if (!saveActionField) {
        saveActionField = document.createElement('input');
        saveActionField.type = 'hidden';
        saveActionField.name = 'action';
        proposedForm.appendChild(saveActionField);
      }
      saveActionField.value = 'save';
      
      // Submit the form
      proposedForm.submit();
    }
  }
  return false; // Prevent any default action
}

// Save Final KPI Email with Confirmation
function saveFinalKpiEmail(event) {
  // Prevent default form submission
  if (event) event.preventDefault();
  
  // Show confirmation dialog
  if (confirm('Are you sure you want to save the email?')) {
    // Submit the form or save the content
    const finalKpiForm = document.getElementById('finalKpiNotificationForm');
    if (finalKpiForm) {
      // Add a hidden field to indicate this is a save action, not a send action
      let saveActionField = finalKpiForm.querySelector('input[name="action"]');
      if (!saveActionField) {
        saveActionField = document.createElement('input');
        saveActionField.type = 'hidden';
        saveActionField.name = 'action';
        finalKpiForm.appendChild(saveActionField);
      }
      saveActionField.value = 'save';
      
      // Submit the form
      finalKpiForm.submit();
    }
  }
  return false; // Prevent any default action
}

// Save Reminder Email with Confirmation
function saveReminderEmail(event) {
  // Prevent default form submission
  if (event) event.preventDefault();
  
  // Show confirmation dialog
  if (confirm('Are you sure you want to save the email?')) {
    // Submit the form or save the content
    const reminderForm = document.getElementById('kpiReminderNotificationForm');
    if (reminderForm) {
      // Add a hidden field to indicate this is a save action, not a send action
      let saveActionField = reminderForm.querySelector('input[name="action"]');
      if (!saveActionField) {
        saveActionField = document.createElement('input');
        saveActionField.type = 'hidden';
        saveActionField.name = 'action';
        reminderForm.appendChild(saveActionField);
      }
      saveActionField.value = 'save';
      
      // Submit the form
      reminderForm.submit();
    }
  }
  return false; // Prevent any default action
}

// Save Verification Email with Confirmation
function saveVerificationEmail(event) {
  // Prevent default form submission
  if (event) event.preventDefault();
  
  // Show confirmation dialog
  if (confirm('Are you sure you want to save the email?')) {
    // Submit the form or save the content
    const verificationForm = document.getElementById('achievementVerificationForm');
    if (verificationForm) {
      // Add a hidden field to indicate this is a save action, not a send action
      let saveActionField = verificationForm.querySelector('input[name="action"]');
      if (!saveActionField) {
        saveActionField = document.createElement('input');
        saveActionField.type = 'hidden';
        saveActionField.name = 'action';
        verificationForm.appendChild(saveActionField);
      }
      saveActionField.value = 'save';
      
      // Submit the form
      verificationForm.submit();
    }
  }
  return false; // Prevent any default action
}

// Save Verification Reminder Email with Confirmation
function saveVerificationReminderEmail(event) {
  // Prevent default form submission
  if (event) event.preventDefault();
  
  // Show confirmation dialog
  if (confirm('Are you sure you want to save the email?')) {
    // Submit the form or save the content
    const reminderForm = document.getElementById('achievementVerificationReminderForm');
    if (reminderForm) {
      // Add a hidden field to indicate this is a save action, not a send action
      let saveActionField = reminderForm.querySelector('input[name="action"]');
      if (!saveActionField) {
        saveActionField = document.createElement('input');
        saveActionField.type = 'hidden';
        saveActionField.name = 'action';
        reminderForm.appendChild(saveActionField);
      }
      saveActionField.value = 'save';
      
      // Submit the form
      reminderForm.submit();
    }
  }
  return false; // Prevent any default action
}

// Document ready function to attach event listeners to save buttons
document.addEventListener('DOMContentLoaded', function() {
  console.log('Attaching save button handlers...');
  
  // For KPI Proposed Indicator
  const saveProposedBtns = document.querySelectorAll('#kpiProposedIndicatorDetail .btn-success[value="Save"], #kpiProposedIndicatorDetail button:contains("Save")');
  saveProposedBtns.forEach(btn => {
    console.log('Found proposed save button:', btn);
    btn.addEventListener('click', saveProposedEmail);
    // Remove any existing onclick attribute
    btn.removeAttribute('onclick');
  });
  
  // Alternative method if the button text contains "Save"
  const proposedButtons = document.querySelectorAll('#kpiProposedIndicatorDetail button, #kpiProposedIndicatorDetail input[type="button"], #kpiProposedIndicatorDetail input[type="submit"]');
  proposedButtons.forEach(btn => {
    if (btn.textContent.trim() === 'Save' || btn.value === 'Save') {
      console.log('Found proposed save button (text match):', btn);
      btn.addEventListener('click', saveProposedEmail);
      btn.removeAttribute('onclick');
    }
  });
  
  // For Final KPI Notification
  const saveFinalKpiBtns = document.querySelectorAll('#finalKpiNotificationDetail .btn-success[value="Save"], #finalKpiNotificationDetail button:contains("Save")');
  saveFinalKpiBtns.forEach(btn => {
    console.log('Found final KPI save button:', btn);
    btn.addEventListener('click', saveFinalKpiEmail);
    btn.removeAttribute('onclick');
  });
  
  // Alternative method for Final KPI
  const finalKpiButtons = document.querySelectorAll('#finalKpiNotificationDetail button, #finalKpiNotificationDetail input[type="button"], #finalKpiNotificationDetail input[type="submit"]');
  finalKpiButtons.forEach(btn => {
    if (btn.textContent.trim() === 'Save' || btn.value === 'Save') {
      console.log('Found final KPI save button (text match):', btn);
      btn.addEventListener('click', saveFinalKpiEmail);
      btn.removeAttribute('onclick');
    }
  });
  
  // For KPI Reminder Notification
  const saveReminderBtns = document.querySelectorAll('#kpiReminderNotificationDetail .btn-success[value="Save"], #kpiReminderNotificationDetail button:contains("Save")');
  saveReminderBtns.forEach(btn => {
    console.log('Found reminder save button:', btn);
    btn.addEventListener('click', saveReminderEmail);
    btn.removeAttribute('onclick');
  });
  
  // Alternative method for Reminder
  const reminderButtons = document.querySelectorAll('#kpiReminderNotificationDetail button, #kpiReminderNotificationDetail input[type="button"], #kpiReminderNotificationDetail input[type="submit"]');
  reminderButtons.forEach(btn => {
    if (btn.textContent.trim() === 'Save' || btn.value === 'Save') {
      console.log('Found reminder save button (text match):', btn);
      btn.addEventListener('click', saveReminderEmail);
      btn.removeAttribute('onclick');
    }
  });
  
  // For Achievement Verification
  const saveVerificationBtns = document.querySelectorAll('#achievementVerificationDetail .btn-success[value="Save"], #achievementVerificationDetail button:contains("Save")');
  saveVerificationBtns.forEach(btn => {
    console.log('Found verification save button:', btn);
    btn.addEventListener('click', saveVerificationEmail);
    btn.removeAttribute('onclick');
  });
  
  // Alternative method for Verification
  const verificationButtons = document.querySelectorAll('#achievementVerificationDetail button, #achievementVerificationDetail input[type="button"], #achievementVerificationDetail input[type="submit"]');
  verificationButtons.forEach(btn => {
    if (btn.textContent.trim() === 'Save' || btn.value === 'Save') {
      console.log('Found verification save button (text match):', btn);
      btn.addEventListener('click', saveVerificationEmail);
      btn.removeAttribute('onclick');
    }
  });
  
  // For Achievement Verification Reminder
  const saveVerificationReminderBtns = document.querySelectorAll('#achievementVerificationReminderDetail .btn-success[value="Save"], #achievementVerificationReminderDetail button:contains("Save")');
  saveVerificationReminderBtns.forEach(btn => {
    console.log('Found verification reminder save button:', btn);
    btn.addEventListener('click', saveVerificationReminderEmail);
    btn.removeAttribute('onclick');
  });
  
  // Alternative method for Verification Reminder
  const verificationReminderButtons = document.querySelectorAll('#achievementVerificationReminderDetail button, #achievementVerificationReminderDetail input[type="button"], #achievementVerificationReminderDetail input[type="submit"]');
  verificationReminderButtons.forEach(btn => {
    if (btn.textContent.trim() === 'Save' || btn.value === 'Save') {
      console.log('Found verification reminder save button (text match):', btn);
      btn.addEventListener('click', saveVerificationReminderEmail);
      btn.removeAttribute('onclick');
    }
  });
  
  // Debug: Log all buttons found
  setTimeout(() => {
    console.log('All save buttons in notification sections:');
    document.querySelectorAll('[id$="Detail"] button, [id$="Detail"] input[type="button"], [id$="Detail"] input[type="submit"]').forEach(btn => {
      if (btn.textContent.trim() === 'Save' || btn.value === 'Save') {
        console.log('Save button:', btn, 'Parent:', btn.closest('[id$="Detail"]')?.id);
      }
    });
  }, 1000);
});

// Method 1: Change your HTML buttons to prevent default form submission
// Replace your current save buttons with this pattern:
// <button type="button" class="btn btn-primary me-2 save-btn">Save</button>

// Method 2: If you can't change the HTML, add this script to handle the buttons properly
document.addEventListener('DOMContentLoaded', function() {
  console.log('Setting up save button handlers...');
  
  // Find all forms that might need confirmation for saving
  const formIds = [
    'kpiProposedIndicatorForm', 
    'finalKpiNotificationForm', 
    'kpiReminderNotificationForm', 
    'achievementVerificationForm', 
    'achievementVerificationReminderForm'
  ];
  
  formIds.forEach(formId => {
    const form = document.getElementById(formId);
    if (form) {
      console.log(`Found form: ${formId}`);
      
      // Add form submit event handler
      form.addEventListener('submit', function(event) {
        // Find save buttons in this form
        const saveButtons = form.querySelectorAll('button[type="submit"]');
        
        // If the clicked button was a save button (text content is "Save")
        if (event.submitter && event.submitter.textContent.trim() === 'Save') {
          event.preventDefault(); // Stop the form from submitting
          
          // Show confirmation dialog
          if (confirm('Are you sure you want to save this email?')) {
            // Add hidden field to indicate save action
            let actionField = form.querySelector('input[name="action"]');
            if (!actionField) {
              actionField = document.createElement('input');
              actionField.type = 'hidden';
              actionField.name = 'action';
              form.appendChild(actionField);
            }
            actionField.value = 'save';
            
            // Now submit the form
            form.submit();
          }
        }
      });
      
      // Also add direct click handlers to save buttons as a fallback
      const saveButtons = form.querySelectorAll('button[type="submit"]');
      saveButtons.forEach(button => {
        if (button.textContent.trim() === 'Save') {
          console.log(`Found save button in ${formId}`, button);
          button.addEventListener('click', function(event) {
            event.preventDefault();
            if (confirm('Are you sure you want to save this email?')) {
              // Add hidden field for action
              let actionField = form.querySelector('input[name="action"]');
              if (!actionField) {
                actionField = document.createElement('input');
                actionField.type = 'hidden';
                actionField.name = 'action';
                form.appendChild(actionField);
              }
              actionField.value = 'save';
              
              // Submit the form
              form.submit();
            }
          });
        }
      });
    }
  });
});


</script>