@extends('layouts/contentNavbarLayout')

@section('title', 'Operational Audit Trail')

@push('head')
<link href="https://cdnjs.cloudflare.com/ajax/libs/boxicons/2.1.4/css/boxicons.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.10.0/font/bootstrap-icons.min.css">
@endpush

@section('content')

@php
$breadcrumbs = [
['label' => 'Dashboard', 'url' => route('dashboard-analytics')],
['label' => 'KPI Administration'],
['label' => 'Operational Audit Trail']
];
@endphp

@include('layouts.partials.page-header', [
'title' => 'Operational Audit Trail',
'slot' => view('layouts.partials.breadcrumb', compact('breadcrumbs'))->render()
])

<style>
    /* ADD THESE SORTING STYLES */
    .sortable-header {
        cursor: pointer;
        position: relative;
        user-select: none;
        padding-right: 25px !important;
    }

    .sortable-header:hover {
        background-color: #f8f9fa;
    }

    .sort-icon {
        position: absolute;
        right: 8px;
        top: 50%;
        transform: translateY(-50%);
        font-size: 12px;
        color: #6c757d;
        transition: color 0.2s;
    }

    .sort-icon.active {
        color: #0d6efd;
    }
</style>
<div class="card">
    <div class="card-body">
        <form id="audit-filter-form">
            <!-- Date and Time Range Row -->
            <div class="row mb-3">
                <div class="col-md-3 mb-3">
                    <label for="datetime-from" class="form-label">Start Date and Time</label>
                    <input type="datetime-local" class="form-control" id="datetime-from" name="datetime_from" value="2022-06-15T00:00">
                </div>
                <div class="col-md-3 mb-3">
                    <label for="datetime-to" class="form-label">End Date and Time</label>
                    <input type="datetime-local" class="form-control" id="datetime-to" name="datetime_to" value="2022-06-15T23:59">
                </div>
                <div class="col-md-6 mb-3">
                    <label for="staff-name" class="form-label">Staff Name</label>
                    <select class="form-select" id="staff-name" name="staff_name">
                        <option value="All" selected>All</option>
                        <option value="bai">MUHAMMAD BAIHAQI BIN BUKHORI</option>
                        <option value="siddiq">MUHAMMAD SIDDIQ BIN SAIDIN</option>
                        <option value="admin">IRMS Super Admin</option>
                        <option value="ahmad">AHMAD RASHID BIN HASSAN</option>
                        <option value="sarah">SARAH BINTI ABDULLAH</option>
                        <option value="faiz">FAIZ HAKIM BIN OMAR</option>
                        <option value="lisa">LISA TAN WEI LING</option>
                    </select>
                </div>
            </div>

            <!-- Division and Section Row -->
            <div class="row mb-3">
                <div class="col-md-4 mb-3">
                    <label for="division" class="form-label">Division</label>
                    <select class="form-select" id="division" name="division">
                        <option value="All" selected>All</option>
                        <option value="MANAGEMENT SERVICES DIVISION">MANAGEMENT SERVICES DIVISION</option>
                        <option value="FINANCE DIVISION">FINANCE DIVISION</option>
                        <option value="HUMAN RESOURCES DIVISION">HUMAN RESOURCES DIVISION</option>
                        <option value="IT DIVISION">INFORMATION TECHNOLOGY DIVISION</option>
                        <option value="OPERATIONS DIVISION">OPERATIONS DIVISION</option>
                        <option value="LEGAL DIVISION">LEGAL & COMPLIANCE DIVISION</option>
                    </select>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="section" class="form-label">Section</label>
                    <select class="form-select" id="section" name="section">
                        <option value="All" selected>All</option>
                        <option value="FACILITY MANAGEMENT SECTION">FACILITY MANAGEMENT SECTION</option>
                        <option value="PROCUREMENT SECTION">PROCUREMENT SECTION</option>
                        <option value="ADMINISTRATION SECTION">ADMINISTRATION SECTION</option>
                        <option value="ACCOUNTS SECTION">ACCOUNTS SECTION</option>
                        <option value="PAYROLL SECTION">PAYROLL SECTION</option>
                        <option value="RECRUITMENT SECTION">RECRUITMENT SECTION</option>
                        <option value="SYSTEM ADMINISTRATION SECTION">SYSTEM ADMINISTRATION SECTION</option>
                    </select>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="unit-office" class="form-label">Unit/Office</label>
                    <select class="form-select" id="unit-office" name="unit_office">
                        <option value="All" selected>All</option>
                        <option value="ASSET MANAGEMENT UNIT">ASSET MANAGEMENT UNIT</option>
                        <option value="MAINTENANCE UNIT">MAINTENANCE UNIT</option>
                        <option value="SECURITY UNIT">SECURITY UNIT</option>
                        <option value="BUDGET PLANNING UNIT">BUDGET PLANNING UNIT</option>
                        <option value="AUDIT UNIT">INTERNAL AUDIT UNIT</option>
                        <option value="TRAINING UNIT">TRAINING & DEVELOPMENT UNIT</option>
                        <option value="HELPDESK UNIT">IT HELPDESK UNIT</option>
                    </select>
                </div>
            </div>

            <!-- Transaction Type and Module Row -->
            <div class="row mb-4">
                <div class="col-md-4 mb-3">
                    <label for="transaction-type" class="form-label">Transaction Type</label>
                    <select class="form-select" id="transaction-type" name="transaction_type">
                        <option value="All" selected>All</option>
                        <option value="LOGIN">Login</option>
                        <option value="LOGOUT">Logout</option>
                        <option value="CREATE">Create Record</option>
                        <option value="UPDATE">Update Record</option>
                        <option value="DELETE">Delete Record</option>
                        <option value="VIEW">View Record</option>
                        <option value="EXPORT">Export Data</option>
                        <option value="IMPORT">Import Data</option>
                        <option value="APPROVE">Approve Transaction</option>
                        <option value="REJECT">Reject Transaction</option>
                    </select>
                </div>
                <div class="col-md-4 mb-3">
                    <label for="module-name" class="form-label">Module Name</label>
                    <select class="form-select" id="module-name" name="module_name">
                        <option value="All" selected>All</option>
                        <option value="LOGIN_LOGOUT">Login/Logout</option>
                        <option value="USER_MANAGEMENT">User Management</option>
                        <option value="ASSET_MANAGEMENT">Asset Management</option>
                        <option value="FINANCIAL_MANAGEMENT">Financial Management</option>
                        <option value="HR_MANAGEMENT">HR Management</option>
                        <option value="PROCUREMENT">Procurement</option>
                        <option value="REPORTING">Reporting</option>
                        <option value="SYSTEM_ADMIN">System Administration</option>
                        <option value="DOCUMENT_MANAGEMENT">Document Management</option>
                        <option value="WORKFLOW">Workflow Management</option>
                    </select>
                </div>
                <div class="col-md-4 d-flex align-items-end">
                    <button type="button" class="btn btn-primary me-2" id="search-btn">
                        <i class=""></i>Search
                    </button>
                    <button type="reset" class="btn btn-secondary" id="reset-btn">
                        <i class=""></i>Reset
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card mt-3">
    <div class="card-body">
        <div class="d-flex justify-content-between mb-3">
            <div class="d-flex align-items-center">
                <span class="me-2">Show</span>
                <select class="form-select form-select-sm" id="entries-select" style="width: 70px">
                    <option value="10" selected>10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
                <span class="ms-2">Entries</span>
            </div>
            <div>
                <button class="btn btn-primary btn-sm" id="column-display-btn" data-bs-toggle="modal" data-bs-target="#columnSelectorModal">
                    <i class="bx bx-columns me-1"></i> Modify Column
                </button>
                <!-- Sync -->
                <button class="btn btn-success btn-sm">
                    <i class="bx bx-sync me-1"></i> Sync
                </button>
                <button class="btn btn-info btn-sm" id="print-btn">
                    <i class="bx bx-printer me-1"></i> Print
                </button>
                <div class="btn-group">
                    <button class="btn btn-danger btn-sm dropdown-toggle" type="button" id="exportDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bx bx-download me-1"></i> Export
                    </button>
                    <ul class="dropdown-menu" aria-labelledby="exportDropdown">
                        <li><a class="dropdown-item" href="#">EXCEL</a></li>
                        <li><a class="dropdown-item" href="#">PDF</a></li>
                        <li><a class="dropdown-item" href="#">WORD</a></li>
                        <li><a class="dropdown-item" href="#">JPG</a></li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered" id="auditTable">
                <thead class="table-light">
                    <tr>

                        <th data-column="itemno" data-type="number" class="sortable-header">
                            ITEM NO
                            <i class="bi bi-arrow-down-up sort-icon"></i>
                        </th>
                        <th data-column="staffid" data-type="text" class="sortable-header">
                            STAFF ID
                            <i class="bi bi-arrow-down-up sort-icon"></i>
                        </th>
                        <th data-column="staffname" data-type="text" class="sortable-header">
                            STAFF NAME
                            <i class="bi bi-arrow-down-up sort-icon"></i>
                        </th>
                        <th data-column="division" data-type="text" class="sortable-header">
                            DIVISION
                            <i class="bi bi-arrow-down-up sort-icon"></i>
                        </th>
                        <th data-column="section" data-type="text" class="sortable-header">
                            SECTION
                            <i class="bi bi-arrow-down-up sort-icon"></i>
                        </th>
                        <th data-column="unitoffice" data-type="text" class="sortable-header">
                            UNIT/OFFICE
                            <i class="bi bi-arrow-down-up sort-icon"></i>
                        </th>
                        <th data-column="module" data-type="text" class="sortable-header">
                            MODULE
                            <i class="bi bi-arrow-down-up sort-icon"></i>
                        </th>
                        <th data-column="datetime" data-type="text" class="sortable-header">
                            DATE & TIME
                            <i class="bi bi-arrow-down-up sort-icon"></i>
                        </th>
                        <th data-column="year" data-type="number" class="sortable-header">
                            YEAR
                            <i class="bi bi-arrow-down-up sort-icon"></i>
                        </th>
                        <th data-column="transactionlog">TRANSACTION LOG</th>
                    </tr>
                </thead>
                <tbody>
                    <!-- Static sample data matching the example in the image -->
                    <!-- Static sample data with varied content -->
                    <tr>
                        <td>1</td>
                        <td>MSF12</td>
                        <td>MUHAMMAD BAIHAQI BIN BUKHORI</td>
                        <td>MANAGEMENT SERVICES DIVISION</td>
                        <td>FACILITY MANAGEMENT SECTION</td>
                        <td>ASSET MANAGEMENT UNIT</td>
                        <td>Login/Logout</td>
                        <td>15/06/2022 01:30 AM</td>
                        <td>2022</td>
                        <td class="text-center">
                            <button class="btn btn-sm btn-icon" onclick="showTransactionLog(1)">
                                <i class="bx bx-show text-primary"></i>
                            </button>
                        </td>
                    </tr>
                    <tr>
                        <td>2</td>
                        <td>FIN05</td>
                        <td>AHMAD RASHID BIN HASSAN</td>
                        <td>FINANCE DIVISION</td>
                        <td>ACCOUNTS SECTION</td>
                        <td>BUDGET PLANNING UNIT</td>
                        <td>Financial Management</td>
                        <td>15/06/2022 08:15 AM</td>
                        <td>2022</td>
                        <td class="text-center">
                            <button class="btn btn-sm btn-icon" onclick="showTransactionLog(2)">
                                <i class="bx bx-show text-primary"></i>
                            </button>
                        </td>
                    </tr>
                    <tr>
                        <td>3</td>
                        <td>HR03</td>
                        <td>SARAH BINTI ABDULLAH</td>
                        <td>HUMAN RESOURCES DIVISION</td>
                        <td>RECRUITMENT SECTION</td>
                        <td>TRAINING & DEVELOPMENT UNIT</td>
                        <td>HR Management</td>
                        <td>15/06/2022 09:45 AM</td>
                        <td>2022</td>
                        <td class="text-center">
                            <button class="btn btn-sm btn-icon" onclick="showTransactionLog(3)">
                                <i class="bx bx-show text-primary"></i>
                            </button>
                        </td>
                    </tr>
                    <tr>
                        <td>4</td>
                        <td>IT07</td>
                        <td>FAIZ HAKIM BIN OMAR</td>
                        <td>INFORMATION TECHNOLOGY DIVISION</td>
                        <td>SYSTEM ADMINISTRATION SECTION</td>
                        <td>IT HELPDESK UNIT</td>
                        <td>System Administration</td>
                        <td>15/06/2022 10:20 AM</td>
                        <td>2022</td>
                        <td class="text-center">
                            <button class="btn btn-sm btn-icon" onclick="showTransactionLog(4)">
                                <i class="bx bx-show text-primary"></i>
                            </button>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-between align-items-center mt-3">
            <div>
                Showing 1 to 10 of 20 Entries (filtered from 19 total entries)
            </div>
            <nav aria-label="Page navigation">
                <ul class="pagination">
                    <li class="page-item">
                        <a class="page-link" href="#" aria-label="Previous">
                            <span aria-hidden="true">&laquo;</span>
                        </a>
                    </li>
                    <li class="page-item active"><a class="page-link" href="#">1</a></li>
                    <li class="page-item"><a class="page-link" href="#">2</a></li>
                    <li class="page-item">
                        <a class="page-link" href="#" aria-label="Next">
                            <span aria-hidden="true">&raquo;</span>
                        </a>
                    </li>
                </ul>
            </nav>
        </div>
    </div>
</div>

<!-- Transaction Log Modal -->
<div class="modal fade" id="transactionLogModal" tabindex="-1" aria-labelledby="transactionLogModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="transactionLogModalLabel">Transaction Log</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body" id="transaction-log-details">
                <!-- Transaction log details will be loaded here -->
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Column Selector Modal -->
<div class="modal fade" id="columnSelectorModal" tabindex="-1" aria-labelledby="columnSelectorModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="columnSelectorModalLabel">Modify Column - List of Operational Audit Trail Columns</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body column-selector-modal">
                <p>Select columns to display:</p>
                <!-- ITEM NO (disable & required) -->
                <div class="form-check">
                <input class="form-check-input column-toggle" type="checkbox" id="itemnoColumn" data-column="itemno" checked disabled>
                <label class="form-check-label" for="itemnoColumn">
                    Item No
                </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input column-toggle" type="checkbox" id="staffidColumn" data-column="staffid" checked>
                    <label class="form-check-label" for="staffidColumn">
                        Staff ID
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input column-toggle" type="checkbox" id="staffnameColumn" data-column="staffname" checked>
                    <label class="form-check-label" for="staffnameColumn">
                        Staff Name
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input column-toggle" type="checkbox" id="divisionColumn" data-column="division" checked>
                    <label class="form-check-label" for="divisionColumn">
                        Division
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input column-toggle" type="checkbox" id="sectionColumn" data-column="section" checked>
                    <label class="form-check-label" for="sectionColumn">
                        Section
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input column-toggle" type="checkbox" id="unitofficeColumn" data-column="unitoffice" checked>
                    <label class="form-check-label" for="unitofficeColumn">
                        Unit/Office
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input column-toggle" type="checkbox" id="moduleColumn" data-column="module" checked>
                    <label class="form-check-label" for="moduleColumn">
                        Module
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input column-toggle" type="checkbox" id="datetimeColumn" data-column="datetime" checked>
                    <label class="form-check-label" for="datetimeColumn">
                        Date & Time
                    </label>
                </div>
                <div class="form-check">
                    <input class="form-check-input column-toggle" type="checkbox" id="yearColumn" data-column="year" checked>
                    <label class="form-check-label" for="yearColumn">
                        Year
                    </label>
                </div>
                <!-- TRANSACTION LOG (disable & required) -->
                <div class="form-check">
                <input class="form-check-input column-toggle" type="checkbox" id="transactionlogColumn" data-column="transactionlog" checked disabled>
                <label class="form-check-label" for="transactionlogColumn">
                    Transaction Log
                </label>
                </div>
            </div>
            <div class="modal-footer justify-content-end">
            <button type="button" class="btn btn-primary btn-sm" onclick="selectAllColumns()">Select All</button>
            <button type="button" class="btn btn-secondary btn-sm" onclick="deselectAllColumns()">Deselect All</button>
            <button type="button" class="btn btn-success btn-sm" onclick="applyColumnSettings()">Apply</button>
          </div>
        </div>
    </div>
</div>

@endsection

@section('page-script')
<script>
$(document).ready(function () {
  initializeColumnDisplay();

  // Pastikan kolum yang disimpan di localStorage digunakan bila reload
  applySavedColumnSettings();
});

// Fungsi: Simpan dan apply tetapan semasa
function applyColumnSettings() {
  const prefs = {};

  $('.column-toggle').each(function () {
    const col = $(this).data('column');
    const show = $(this).is(':checked');

    prefs[col] = show;

    toggleColumnVisibility(col, show);
  });

  localStorage.setItem('auditTableColumnPreferences', JSON.stringify(prefs));
  $('#columnSelectorModal').modal('hide');
}

// Fungsi: Guna semula tetapan yang disimpan
function applySavedColumnSettings() {
  const prefs = JSON.parse(localStorage.getItem('auditTableColumnPreferences') || '{}');

  $('.column-toggle').each(function () {
    const col = $(this).data('column');
    const isRequired = $(this).is(':disabled');

    if (prefs[col] !== undefined && !isRequired) {
      $(this).prop('checked', prefs[col]);
    }

    toggleColumnVisibility(col, prefs[col] ?? true);
  });
}

// Fungsi: Sembunyikan / tunjuk kolum
function toggleColumnVisibility(column, visible) {
  const table = $('#auditTable');
  const index = table.find(`th[data-column="${column}"]`).index();

  if (index === -1) return;

  const method = visible ? 'show' : 'hide';

  table.find(`th[data-column="${column}"]`)[method]();
  table.find('tbody tr').each(function () {
    $(this).find('td').eq(index)[method]();
  });
}

// Fungsi: Select semua checkbox (kecuali yang required/disabled)
function selectAllColumns() {
  $('.column-toggle').each(function () {
    if (!this.disabled) this.checked = true;
  });
}

// Fungsi: Deselect semua checkbox (kecuali yang required/disabled)
function deselectAllColumns() {
  $('.column-toggle').each(function () {
    if (!this.disabled) this.checked = false;
  });
}

// Fungsi: Init semasa load
function initializeColumnDisplay() {
  // Inject styling jika belum
  if (!document.getElementById('column-display-style')) {
    const style = document.createElement('style');
    style.id = 'column-display-style';
    style.innerHTML = `.hidden-column { display: none !important; }`;
    document.head.appendChild(style);
  }
}
</script>
@endsection

