@extends('layouts/contentNavbarLayout')
@section('title', 'KPI Configuration')
@section('content')

@php
  $breadcrumbs = [
    ['label' => 'Dashboard', 'url' => route('dashboard-analytics')],
    ['label' => 'KPI Administration'],
    ['label' => 'KPI Configuration']
  ];
@endphp

@include('layouts.partials.page-header', [
  'title' => 'KPI Configuration',
  'slot' => view('layouts.partials.breadcrumb', compact('breadcrumbs'))->render()
])

  <!-- Main KPI Configuration Options -->
  @include('content.kpiAdmin.partials.config.main-options')

  <!-- Configuration Detail Sections -->
  @include('content.kpiAdmin.partials.config.configure-duration-setup')
  @include('content.kpiAdmin.partials.config.percentage-target')
  @include('content.kpiAdmin.partials.config.kpi-category')
  @include('content.kpiAdmin.partials.config.column-default-setting')
  @include('content.kpiAdmin.partials.config.kpi-indicator-duration-setup')
  @include('content.kpiAdmin.partials.config.kpi-indicator-type')
  @include('content.kpiAdmin.partials.config.noti-kpi-proposed-indicator')
  @include('content.kpiAdmin.partials.config.noti-final-kpi')
  @include('content.kpiAdmin.partials.config.noti-achievement-verification')
  @include('content.kpiAdmin.partials.config.reminder-kpi-submission')
  @include('content.kpiAdmin.partials.config.reminder-duedate-achievement')
  @include('content.kpiAdmin.partials.config.reminder-verify-achievement')

  <!-- Modals -->
  @include('content.kpiAdmin.partials.modals.edit-target-modal')
  @include('content.kpiAdmin.partials.modals.confirmation-modal')
  @include('content.kpiAdmin.partials.modals.success-modal')

  <!-- Include your JavaScript file -->
  @include('content.kpiAdmin.js.kpi-admin-config')

  <!-- Bootstrap JS (for full Bootstrap features) -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>


  @endsection
