
  <!-- Duration Setup Detail Section (Hidden by default) -->
  <div class="row mt-4" id="durationSetupDetail" style="display: none;">
    <div class="col-12">
      <div class="card mb-4">
        <div class="card-body">
          <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="card-title mb-0">Configure Duration Setup</h5>
          </div>

          <form id="durationSetupForm" method="POST" action="{{ url('/kpi-configuration/duration-setup') }}">
            @csrf

            <div class="row mb-4">
              <label for="year" class="col-md-2 col-form-label">Duration Type for Year:</label>
              <div class="col-md-4">
                <select class="form-select" id="year" name="year">
                  <option value="2024" selected>2024</option>
                  <option value="2025">2025</option>
                  <option value="2026">2026</option>
                </select>
              </div>
            </div>

            <div class="row mb-4">
              <div class="col-md-4">
                <div class="form-check mb-2">
                  <input class="form-check-input" type="radio" name="durationType" id="quarterly" value="quarterly" checked>
                  <label class="form-check-label" for="quarterly">
                    Quarterly
                  </label>
                </div>
                <div class="form-check">
                  <input class="form-check-input" type="radio" name="durationType" id="groupOfMonth" value="groupOfMonth">
                  <label class="form-check-label" for="groupOfMonth">
                    Group of Month
                  </label>
                </div>
              </div>
            </div>

            <!-- Group of Month Options (Hidden by default) -->
            <div id="groupMonthOptions" >
              <div class="row mb-4">
                <label for="groupType" class="col-md-2 col-form-label">Group Type:</label>
                <div class="col-md-4">
                  <select class="form-select" id="groupType" name="groupType">
                    <option value="Annually">Annually</option>
                    <option value="Bi-Annually">Bi-Annually</option>
                  </select>
                </div>
              </div>

              <!-- <div id="othersGroupOption" class="row mb-4">
                <div class="col-md-4 offset-md-2">
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="groupSize" id="g3" value="G3" checked>
                    <label class="form-check-label" for="g3">G3</label>
                  </div>
                  <div class="form-check form-check-inline">
                    <input class="form-check-input" type="radio" name="groupSize" id="g6" value="G6">
                    <label class="form-check-label" for="g6">G6</label>
                  </div>
                </div>
              </div> -->

              <div class="table-responsive mb-4" id="groupMonthTable">
                <table class="table table-bordered">
                  <thead class="table-light">
                    <tr>
                      <th class="text-uppercase">MONTH GROUP</th>
                      <th class="text-uppercase">START MONTH</th>
                      <th class="text-uppercase">END MONTH</th>
                    </tr>
                  </thead>
                  <tbody>
                    <tr>
                      <td>1</td>
                      <td>January</td>
                      <td>
                        <select class="form-select" name="end_month_1">
                          <option>April</option>
                          <option>May</option>
                          <option>June</option>
                          <option>July</option>
                          <option>August</option>
                        </select>
                      </td>
                    </tr>
                    <tr>
                      <td>2</td>
                      <td>May</td>
                      <td>
                        <select class="form-select" name="end_month_2">
                          <option>August</option>
                          <option>September</option>
                          <option>October</option>
                          <option>November</option>
                        </select>
                      </td>
                    </tr>
                    <tr>
                      <td>3</td>
                      <td>September</td>
                      <td>
                        <select class="form-select" name="end_month_3">
                          <option>December</option>
                          <option>January</option>
                          <option>February</option>
                        </select>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>

            <div class="table-responsive mb-4" id="quarterlyTable">
              <table class="table table-bordered">
                <thead class="table-light">
                  <tr>
                    <th class="text-uppercase">QUARTER</th>
                    <th class="text-uppercase">START DATE</th>
                    <th class="text-uppercase">END DATE</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td>Q1 (January - March)</td>
                    <td>01/01/2024</td>
                    <td>31/03/2024</td>
                  </tr>
                  <tr>
                    <td>Q2 (April - June)</td>
                    <td>01/04/2024</td>
                    <td>30/06/2024</td>
                  </tr>
                  <tr>
                    <td>Q3 (July - September)</td>
                    <td>01/07/2024</td>
                    <td>30/09/2024</td>
                  </tr>
                  <tr>
                    <td>Q4 (October - December)</td>
                    <td>01/10/2024</td>
                    <td>31/12/2024</td>
                  </tr>
                </tbody>
              </table>
            </div>

            <div class="d-flex justify-content-end">
              <button type="submit" class="btn btn-primary">Save</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  <script>
  document.addEventListener('DOMContentLoaded', function () {
    const quarterlyRadio = document.getElementById('quarterly');
    const groupOfMonthRadio = document.getElementById('groupOfMonth');

    function toggleDurationTables() {
      const isQuarterly = quarterlyRadio.checked;
      document.getElementById('quarterlyTable').style.display = isQuarterly ? 'block' : 'none';
      document.getElementById('groupMonthOptions').style.display = isQuarterly ? 'none' : 'block';
    }

    quarterlyRadio.addEventListener('change', toggleDurationTables);
    groupOfMonthRadio.addEventListener('change', toggleDurationTables);

    // Initial load
    toggleDurationTables();
  });
</script>
