<!-- JavaScript to control table visibility -->
<script>
  function toggleTable(tableId) {
    const table = document.getElementById(tableId);
    if (table) {
      table.style.display = (table.style.display === 'none') ? 'block' : 'none';
    }
  }

  // Wait for the document to be fully loaded
  document.addEventListener('DOMContentLoaded', function() {
    // Get the apply button
    const applyButton = document.getElementById('applyColumnSettings');
    
    // Add click event listener to the apply button
    applyButton.addEventListener('click', function() {
      // Column mappings (data-column attribute to column index, 0-based)
      const columnMap = {
        'no': 0,
        'indicator': 1,
        'description': 2,
        'metric': 3,
        'annual-target': 4,
        'q1-achievement': 5,
        'achievement-percent': 6,
        'remarks': 7
      };
      
      // Get all column toggle checkboxes
      const toggles = document.querySelectorAll('.column-toggle');
      
      // Loop through each toggle
      toggles.forEach(function(toggle) {
        // Get the column name from data-column attribute
        const columnName = toggle.getAttribute('data-column');
        const columnIndex = columnMap[columnName];
        
        // Get all table cells in that column (add 1 because CSS selectors are 1-based)
        const cells = document.querySelectorAll(`table th:nth-child(${columnIndex + 1}), table td:nth-child(${columnIndex + 1})`);
        
        // Show or hide based on checkbox state
        cells.forEach(function(cell) {
          cell.style.display = toggle.checked ? '' : 'none';
        });
      });
    });
  });

  function toggleTable(tableId) {
    const table = document.getElementById(tableId);
    if (table.style.display === 'none' || table.style.display === '') {
        table.style.display = 'block';
    } else {
        table.style.display = 'none';
    }
}

  function selectAllColumns() {
    document.querySelectorAll('.column-toggle').forEach(cb => {
      if (!cb.disabled) cb.checked = true;
    });
  }

  function deselectAllColumns() {
    document.querySelectorAll('.column-toggle').forEach(cb => {
      if (!cb.disabled) cb.checked = false;
    });
  }
</script>

<script>
  function printTableById(id) {
    var original = document.getElementById(id);
    var clone = original.cloneNode(true);

    var buttonGroup = clone.querySelector('.btn-group');
    if (buttonGroup) {
      buttonGroup.remove();
    }

    var printWindow = window.open('', '', 'height=600,width=800');
    printWindow.document.write('<html><head><title>Print</title>');
    printWindow.document.write('<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">');
    printWindow.document.write('</head><body>');
    printWindow.document.write(clone.innerHTML);
    printWindow.document.write('</body></html>');
    printWindow.document.close();
    printWindow.print();
  }
</script>

<script>
  function exportTable(format) {
    alert("Exporting as: " + format.toUpperCase());
    // Here you can add your actual export logic
    // e.g., convert table to Excel or PDF using libraries like SheetJS, jsPDF, etc.
  }
</script>

<!-- Include Bootstrap JS (optional) -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.3/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
