@extends('layouts/contentNavbarLayout')
@section('title', 'Reporting - Forms')
@section('content')

@php
  $breadcrumbs = [
    ['label' => 'Dashboard', 'url' => route('dashboard-analytics')],
    ['label' => 'KPI Reporting'],
    ['label' => 'Ad-hoc Report'],
    
  ];
@endphp

@include('layouts.partials.page-header', [
  'title' => 'Ad-hoc Report',
  'slot' => view('layouts.partials.breadcrumb', compact('breadcrumbs'))->render()
])
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.10.0/font/bootstrap-icons.min.css">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>

<!--<div class="row">
  <div class="col-12 d-flex justify-content-between align-items-center">
    <h4 class="fw-bold py-2 mb-3">View Report</h4>
    <a href="{{ route('kpiReport-create') }}" class="btn btn-primary">Create Report</a>
  </div>-->

      <style>
        /* Unified container styling for both form and results */
        .unified-container {
            background-color: white;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            margin-bottom: 20px;
            width: 100%;
            box-sizing: border-box;
        }

        /* Form specific styling */
        .form-section {
            padding: 30px;
        }

        /* Results accordion styling */
        .results-section {
            padding: 0;
        }

        .results-section .accordion {
            border-radius: 8px;
            overflow: hidden;
        }

        .results-section .accordion-item:first-child {
            border-top: none;
        }

        .results-section .accordion-item:last-child {
            border-bottom: none;
        }

        /* Ensure both containers have the same visual appearance */
        .container-wrapper {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 15px;
        }

        /* Table styling improvements */
        .table-responsive {
            border-radius: 6px;
            overflow: hidden;
        }

        /* Button group spacing */
        .btn-group .btn {
            margin-right: 5px;
        }

        .btn-group .btn:last-child {
            margin-right: 0;
        }

        /* Card hover effects */
        .card {
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }

        /* Form element focus effects */
        .form-select:focus,
        .form-control:focus {
            transform: translateY(-1px);
            box-shadow: 0 0 0 0.2rem rgba(13, 110, 253, 0.25);
        }

        /* Responsive adjustments */
        @media (max-width: 768px) {
            .form-section {
                padding: 20px;
            }
            
            .btn-group {
                flex-wrap: wrap;
                gap: 5px;
            }
        }
    </style>
</head>
<body class="">
    <div class="container-wrapper py-4">
        
        <!-- FILTER FORM SECTION -->
            <div class="unified-container">
                <div class="form-section">
                    <!-- First Row: Division, Section, Unit/Office -->
                    <div class="row g-3 mb-3">
                        <div class="col-md-4">
                            <label for="division" class="form-label">Division</label>
                            <select class="form-select" id="division">
                                <option selected>Please Select</option>
                                <option>CEO'S Office</option>
                                <option>Management Services</option>
                                <option>EXPORTER PROMOTION AND MARKET ACCESS</option>
                                <option>Strategic Planning</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="section" class="form-label">Section</label>
                            <select class="form-select" id="section">
                                <option selected>Please Select</option>
                                <option>ASEAN & Oceania</option>
                                <option value>Central, West, South Asia & Africa Section</option>
                                <option value=>China & Northeast Asia</option>
                                <option value=>Construction & Business Services</option>
                                <option value=>Coordination & Monitoring</option>
                                <option value=>Corporate Management</option>
                                <option value=>Customised Programme</option>
                                <option value=>Development Assistance</option>
                                <option value=>Digital Trade</option>
                                <option value=>Electrical & Electronics, ICT, Machinery & Equipment</option>
                                <option value=>Europe & Americas</option>
                                <option value=>Export Academy</option>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="unit" class="form-label">Unit/Office</label>
                            <select class="form-select" id="unit">
                                <option value="">Please select</option>
                                <option value="unit1">Account</option>
                                <option value="unit2">Administration</option>
                                <option value="unit3">Application System Management</option>
                                <option value="unit4">Asset Management</option>
                                <option value="unit5">Business Information Centre (BIC)</option>
                                <option value="unit6">Competency & Talent Development</option>
                                <option value="unit7">Corporate Communication</option>
                                <option value="unit8">Digital Services</option>
                                <option value="unit9">eCommerce Ecosystem</option>
                                <option value="unit10">Exporters Advisory & Training (EATU)</option>
                                <option value="unit11">Facility Management</option>
                                <option value="unit12">Finance</option>
                                <option value="unit13">Human Resource Management</option>
                                <option value="unit14">ICT Operation & Support</option>
                                <option value="unit15">Integrity</option>
                                <option value="unit16">Internal Audit</option>
                                <option value="unit19">International Collaboration</option>
                                <option value="unit20">Johor</option>
                                <option value="unit21">Market Development</option>
                                <option value="unit22">Micro, Small and Medium Enterprises (MSME)</option>
                                <option value="unit23">Mid Tier</option>
                                <option value="unit24">MO - BUDAPEST</option>
                                <option value="unit25">MO - BUENOS AIRES</option>
                                <option value="unit26">MO - DOHA</option>
                                <option value="unit27">MO - HANOI</option>
                                <option value="unit28">MO - KARACHI</option>
                                <option value="unit29">MO - KIEV</option>
                                <option value="unit30">MO - MEDAN</option>
                                <option value="unit31">MO - NAIROBI</option>
                                <option value="unit32">MO - OSAKA</option>
                                <option value="unit33">MO - PHNOM PENH</option>
                                <option value="unit34">MO - TASHKENT</option>
                                <option value="unit35">MyTRADE Digital</option>
                                <option value="unit36">N/A</option>
                                <option value="unit37">Network & ICT Security Unit</option>
                                <option value="unit38">Organisational Planning & Transformation</option>
                                <option value="unit39">Penang</option>
                                <option value="unit40">Perfomance Monitoring</option>
                                <option value="unit41">Procurement</option>
                                <option value="unit42">Revenue Generation</option>
                                <option value="unit43">Sabah</option>
                                <option value="unit44">Sarawak</option>
                                <option value="unit45">Strategic Coordination</option>
                                <option value="unit46">Strategic Development</option>
                                <option value="unit47">TC - ALMATY</option>
                                <option value="unit48">TC - BANGKOK</option>
                                <option value="unit49">TC - BEIJING</option>
                                <option value="unit50">TC - CAIRO</option>
                                <option value="unit51">TC - CHENGDU</option>
                                <option value="unit52">TC - CHENNAI</option>
                                <option value="unit53">TC - DUBAI</option>
                                <option value="unit54">TC - FRANKFURT</option>
                                <option value="unit55">TC - GUANGZHOU</option>
                                <option value="unit56">TC - HO CHI MINH CITY</option>
                                <option value="unit57">TC - HONG KONG</option>
                                <option value="unit58">TC - ISTANBUL</option>
                                <option value="unit59">TC - JAKARTA</option>
                                <option value="unit60">TC - JEDDAH</option>
                                <option value="unit61">TC - JOHANNESBURG</option>
                                <option value="unit62">TC - LAGOS</option>
                                <option value="unit63">TC - LONDON</option>
                                <option value="unit64">TC - LOS ANGELES</option>
                                <option value="unit65">TC - MANILA</option>
                                <option value="unit66">TC - MELBOURNE</option>
                                <option value="unit67">TC - MEXICO CITY</option>
                                <option value="unit68">TC - MIAMI</option>
                                <option value="unit69">TC - MILAN</option>
                                <option value="unit70">TC - MOSCOW</option>
                                <option value="unit71">TC - MUMBAI</option>
                                <option value="unit72">TC - NEW YORK</option>
                                <option value="unit73">TC - PARIS</option>
                                <option value="unit74">TC - ROTTERDAM</option>
                                <option value="unit75">TC - SANTIAGO</option>
                                <option value="unit76">TC - SAO PAULO</option>
                                <option value="unit77">TC - SEOUL</option>
                                <option value="unit78">TC - SHANGHAI</option>
                                <option value="unit79">TC - SINGAPORE</option>
                                <option value="unit80">TC - TAIPEI</option>
                                <option value="unit81">TC - TOKYO</option>
                                <option value="unit82">TC - WARSAW</option>
                                <option value="unit83">TC - YANGON</option>
                                <option value="unit84">Terengganu</option>
                                <option value="unit85">Trade Ananlysis</option>
                                <option value="unit86">Trade Publication</option>
                                <option value="unit87">Trade Statistic</option>
                            </select>
                        </div>
                    </div>

                    <!-- Second Row: Category, Indicator -->
                    <div class="row g-3 mb-3">
                        <div class="col-md-6">
                            <label for="category" class="form-label">Category</label>
                            <select class="form-select" id="category">
                                <option selected>Please Select</option>
                                <option>Customer</option>
                                <option>Finance</option>
                                <option>People</option>
                                <option>Process</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="indicator" class="form-label">Indicator</label>
                            <select class="form-select" id="indicator">
                                <option selected>Please Select</option>
                                <option>Type 1</option>
                                <option>Type 2</option>
                                <option>Type 3</option>
                            </select>
                        </div>
                    </div>

                    <!-- Third Row: Year From, Year To, Duration From -->
                    <div class="row g-3 mb-3">
                        <div class="col-md-4">
                            <label for="yearFrom" class="form-label">Year From</label>
                            <input type="text" class="form-control" id="yearFrom" placeholder="From" />
                        </div>
                        <div class="col-md-4">
                            <label for="yearTo" class="form-label">Year To</label>
                            <input type="text" class="form-control" id="yearTo" placeholder="To" />
                        </div>
                        <div class="col-md-4">
                            <label for="durationFrom" class="form-label">Duration From</label>
                            <select class="form-select" id="durationFrom">
                                <option selected>Please Select</option>
                                <option>Quarterly-Q1</option>
                                <option>Quarterly-Q2</option>
                                <option>Quarterly-Q3</option>
                                <option>Quarterly-Q4</option>
                            </select>
                        </div>
                    </div>

                    <!-- Fourth Row: Duration To, Report Title -->
                    <div class="row g-3 mb-3">
                        <div class="col-md-4">
                            <label for="durationTo" class="form-label">Duration To</label>
                            <select class="form-select" id="durationTo">
                                <option selected>Please Select</option>
                                <option>Quarterly-Q1</option>
                                <option>Quarterly-Q2</option>
                                <option>Quarterly-Q3</option>
                                <option>Quarterly-Q4</option>
                            </select>
                        </div>
                        <div class="col-md-8">
                            <label for="reportTitle" class="form-label">Report Title</label>
                            <select class="form-select" id="reportTitle">
                                <option>Please Select</option>
                                <option value="1">Analysis on Submission on Articles from Market Desks</option>
                                <option value="2">Analysis on Submission of Success Stories from TCs, Regional Offices & Desks</option>
                                <option value="3">Annual Export Revenue</option>
                                <option value="4">Budget & Expenses</option>
                                <option value="5">Companies by Sectors</option>
                                <option value="6">Enquiries Received & Answered</option>
                                <option value="7">Export Sales</option>
                                <option value="8">Export Sales from Market Immersion Programme (RM Million)</option>
                                <option value="9">Exporters Development Programmes Achievement by Programme Type</option>
                                <option value="10">Follow-up - Realised Sales from INSP conjunction with major exhibitions in Malaysia</option>
                                <option value="11">Increase in new registration in MER</option>
                                <option value="12">Initiatives implemented by MATRADE</option>
                                <option value="13">Literacy & outreach programme</option>
                                <option value="14">No. Companies Assisted (Local/Foreign)</option>
                                <option value="15">No. MEEC Exhibitors</option>
                                <option value="16">No. of BIC Users</option>
                                <option value="17">No of Companies</option>
                                <option value="18">No of Exporters Trained</option>
                                <option value="19">No of Participating Companies</option>
                                <option value="20">No of Programme</option>
                                <option value="21">No of Training programme stastitics</option>
                                <option value="22">Performance Indicators and Achievements</option>
                                <option value="23">Project Value</option>
                                <option value="24">Total Companies (Wave 1-x) based on Sectorial Desk</option>
                                <option value="25">Strategic Development Unit Achievements</option>
                                <option value="26">Strengthening Industry Database: Malaysian Exporters Registry (MER): Summary</option>
                                <option value="27">Strengthening Industry Database: Foreign Importers Database Summary</option>
                                <option value="28">Strengthening Industry Database: Foreign Importers Database TC Offices with less than 25% Achievements</option>
                                <option value="29">Strengthening Industry Database: Malaysian Exporters Registry (MER) by Regional/State Office</option>
                                <option value="30">Strengthening Industry Database: Malaysian Exporters Registry (MER) by Section</option>
                                <option value="31">Strengthening Industry Database: Update on Malaysian Companies Abroad Database</option>
                                <option value="32">Summary of Realised Sales from Export Promotion Programmes</option>
                                <option value="33">Trade & Market Intelligence Reports</option>
                                <option value="34">Usage of BIC Ref. Material</option>
                            </select>
                        </div>
                    </div>

                    <!-- Fifth Row: Search/Reset Buttons -->
                    <div class="row g-3 mb-0">
                        <div class="col-md-12 d-flex justify-content-end gap-2">
                          <button type="button" class="btn btn-primary" id="searchBtn">
                                <i class=""></i>Search
                            </button>
                            <button type="button" class="btn btn-secondary" id="resetBtn">
                                <i class=""></i>Reset
                            </button>
                            
                        </div>
                    </div>
                </div>
            </div>

        <!-- SEPARATOR -->
        <hr class="my-4" style="border-top: 2px solid #dee2e6;">
    <!-- Add controls above the table -->
    <!-- <div class="d-flex justify-content-between align-items-center p-3">
      <div class="d-flex align-items-center">
        <label class="me-2">Show</label>
        <select class="form-select form-select-sm me-2" style="width: 70px;">
          <option value="10">10</option>
          <option value="25">25</option>
          <option value="50">50</option>
          <option value="100">100</option>
        </select>
        <span>entries</span>
      </div>
      <!-- Display Columns Button -->
      <!-- <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#columnSelectorModal">
        <i class="bx bx-columns"></i> Display Columns
      </button>
    </div>
    <div class="table-responsive text-nowrap">
      <table class="table table-hover" id="reportTable">
        <thead>
          <tr>
            <th data-column="id">ID <i class="bx bx-sort"></i></th>
            <th data-column="title">Title <i class="bx bx-sort"></i></th>
            <th data-column="subtitle">Subtitle <i class="bx bx-sort"></i></th>
            <th data-column="remark">Remark <i class="bx bx-sort"></i></th>
            <th data-column="type">Type <i class="bx bx-sort"></i></th>
            <th data-column="updated">Updated <i class="bx bx-sort"></i></th>
            <th data-column="action">Action <i class="bx bx-sort"></i></th>
          </tr>
        </thead>
        <tbody class="table-border-bottom-0">
          <tr>
            <td>KPI-RPT-AHR-95</td>
            <td>Success Stories of PMU</td>
            <td>For 2021</td>
            <td></td>
            <td>Table</td>
            <td>14/06/2022</td>
            <td>
              <div class="d-flex gap-2">
                <button type="button" class="btn btn-sm btn-info view-btn">
                  <i class="bx bx-show"></i> View
                </button>
                <button type="button" class="btn btn-sm btn-success share-btn">
                  <i class="bx bx-share-alt"></i> Share
                </button>
                <button type="button" class="btn btn-sm btn-danger remove-btn">
                  <i class="bx bx-trash"></i> Remove
                </button>
              </div>
            </td>
          </tr>
          <tr>
            <td>KPI-RPT-AHR-100</td>
            <td>Predefined Template Report</td>
            <td>Tahun</td>
            <td></td>
            <td>Table</td>
            <td>23/06/2022</td>
            <td>
              <div class="d-flex gap-2">
                <button type="button" class="btn btn-sm btn-info view-btn">
                  <i class="bx bx-show"></i> View
                </button>
                <button type="button" class="btn btn-sm btn-success share-btn">
                  <i class="bx bx-share-alt"></i> Share
                </button>
                <button type="button" class="btn btn-sm btn-danger remove-btn">
                  <i class="bx bx-trash"></i> Remove
                </button>
              </div>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- REMOVED Section -->
<!-- <div class="tab-section mt-3 d-none" id="removed-section">
  <div class="card">
    <div class="table-responsive text-nowrap">
      <table class="table table-hover">
      <thead>
  <tr>
    <th>ID <i class="bx bx-sort"></i></th>
    <th>Title <i class="bx bx-sort"></i></th>
    <th>Subtitle <i class="bx bx-sort"></i></th>
    <th>Remark <i class="bx bx-sort"></i></th>
    <th>Type <i class="bx bx-sort"></i></th>
    <th>Updated <i class="bx bx-sort"></i></th>
    <th>Action <i class="bx bx-sort"></i></th>
  </tr>
</thead>
        <tbody>
          <tr>
            <td>KPI-RPT-AHR-177</td>
            <td>dsadasd</td>
            <td>sdsasad dasdas</td>
            <td></td>
            <td>Table</td>
            <td>15/08/2022</td>
            <td>
              <button class="btn btn-sm btn-primary">Activate</button>
            </td>
          </tr>
          <tr>
            <td>KPI-RPT-AHR-178</td>
            <td>Indicator - Achievement : Sample Pie Chart</td>
            <td>TBU (Year 2020-2021)</td>
            <td></td>
            <td>Pie</td>
            <td>15/08/2022</td>
            <td>
              <button class="btn btn-sm btn-primary">Activate</button>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
</div>

  <!-- Report View Modal -->
  <!-- <div class="modal fade" id="reportViewModal" tabindex="-1" aria-labelledby="reportViewModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="reportViewModalLabel">SUCCESS STORIES OF PMU</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <!-- Report Header -->
          <!-- <div class="text-center mb-4">
            <h4 class="fw-bold">SUCCESS STORIES OF PMU</h4>
            <p class="text-muted">For 2021</p>
          </div>

          <!-- Report Controls -->
       <!--  <div class="d-flex justify-content-end gap-2 mb-4">
            <button class="btn btn-secondary btn-sm" id="printReport">
              <i class="bx bx-printer"></i> Print
            </button>
            <div class="dropdown">
              <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="exportDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                <i class="bx bx-export"></i> Export
              </button>
              <ul class="dropdown-menu" aria-labelledby="exportDropdown">
                <li><a class="dropdown-item" href="#">PDF</a></li>
                <li><a class="dropdown-item" href="#">Excel</a></li>
                <li><a class="dropdown-item" href="#">CSV</a></li>
              </ul>
            </div>
            <div class="dropdown">
              <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="annotationDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                <i class="bx bx-comment"></i> Annotation
              </button>
              <ul class="dropdown-menu" aria-labelledby="annotationDropdown">
                <li><a class="dropdown-item" href="#">Add Note</a></li>
                <li><a class="dropdown-item" href="#">View Notes</a></li>
              </ul>
            </div>
          </div>

          <!-- Column Selector Modal for Report Table -->
<!-- <div class="modal fade" id="columnSelectorModal" tabindex="-1" aria-labelledby="columnSelectorModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="columnSelectorModalLabel">Display Columns</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body column-selector-modal">
        <p>Select columns to display:</p>
        <div class="form-check">
          <input class="form-check-input column-toggle" type="checkbox" id="idColumn" data-column="id" checked>
          <label class="form-check-label" for="idColumn">
            ID
          </label>
        </div>
        <div class="form-check">
          <input class="form-check-input column-toggle" type="checkbox" id="titleColumn" data-column="title" checked>
          <label class="form-check-label" for="titleColumn">
            Title
          </label>
        </div>
        <div class="form-check">
          <input class="form-check-input column-toggle" type="checkbox" id="subtitleColumn" data-column="subtitle" checked>
          <label class="form-check-label" for="subtitleColumn">
            Subtitle
          </label>
        </div>
        <div class="form-check">
          <input class="form-check-input column-toggle" type="checkbox" id="remarkColumn" data-column="remark" checked>
          <label class="form-check-label" for="remarkColumn">
            Remark
          </label>
        </div>
        <div class="form-check">
          <input class="form-check-input column-toggle" type="checkbox" id="typeColumn" data-column="type" checked>
          <label class="form-check-label" for="typeColumn">
            Type
          </label>
        </div>
        <div class="form-check">
          <input class="form-check-input column-toggle" type="checkbox" id="updatedColumn" data-column="updated" checked>
          <label class="form-check-label" for="updatedColumn">
            Updated
          </label>
        </div>
        <div class="form-check">
          <input class="form-check-input column-toggle" type="checkbox" id="actionColumn" data-column="action" checked>
          <label class="form-check-label" for="actionColumn">
            Action
          </label>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="button" class="btn btn-primary" id="applyColumnSettings" data-bs-dismiss="modal">Apply</button>
      </div>
    </div>
  </div>
</div>

          <!-- Report Table -->
        <!-- <div class="table-responsive">
            <table class="table table-striped table-bordered">
              <thead class="table-light">
                <tr>
                  <th rowspan="2" class="align-middle">#</th>
                  <th rowspan="2" class="align-middle">Programme</th>
                  <th colspan="2" class="text-center">Exporter</th>
                  <th rowspan="2" class="text-center align-middle">Exporter Performance</th>
                  <th colspan="2" class="text-center">Activities</th>
                  <th rowspan="2" class="text-center align-middle">Activities Performance</th>
                </tr>
                <tr>
                  <th class="text-center">Target</th>
                  <th class="text-center">Achievement</th>
                  <th class="text-center">Target</th>
                  <th class="text-center">Achievement</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td>1</td>
                  <td>RW:EDP</td>
                  <td class="text-center">16</td>
                  <td class="text-center">1</td>
                  <td class="text-center">6</td>
                  <td class="text-center">16</td>
                  <td class="text-center">1</td>
                  <td class="text-center">6</td>
                </tr>
                <tr>
                  <td>2</td>
                  <td>e-TRADE</td>
                  <td class="text-center">20</td>
                  <td class="text-center">5</td>
                  <td class="text-center">25</td>
                  <td class="text-center">20</td>
                  <td class="text-center">5</td>
                  <td class="text-center">25</td>
                </tr>
                <tr>
                  <td>3</td>
                  <td>LCSMEFP</td>
                  <td class="text-center">16</td>
                  <td class="text-center">4</td>
                  <td class="text-center">25</td>
                  <td class="text-center">16</td>
                  <td class="text-center">4</td>
                  <td class="text-center">25</td>
                </tr>
                <tr>
                  <td>4</td>
                  <td>MOC</td>
                  <td class="text-center">16</td>
                  <td class="text-center">4</td>
                  <td class="text-center">25</td>
                  <td class="text-center">16</td>
                  <td class="text-center">4</td>
                  <td class="text-center">25</td>
                </tr>
                <tr>
                  <td>5</td>
                  <td>Mid-Tier</td>
                  <td class="text-center">16</td>
                  <td class="text-center">4</td>
                  <td class="text-center">25</td>
                  <td class="text-center">16</td>
                  <td class="text-center">4</td>
                  <td class="text-center">25</td>
                </tr>
                <tr>
                  <td>6</td>
                  <td>Mid-Tier Ramp Up</td>
                  <td class="text-center">16</td>
                  <td class="text-center">4</td>
                  <td class="text-center">25</td>
                  <td class="text-center">16</td>
                  <td class="text-center">4</td>
                  <td class="text-center">25</td>
                </tr>
                <tr>
                  <td>7</td>
                  <td>SEF</td>
                  <td class="text-center">16</td>
                  <td class="text-center">4</td>
                  <td class="text-center">25</td>
                  <td class="text-center">16</td>
                  <td class="text-center">4</td>
                  <td class="text-center">25</td>
                </tr>
              </tbody>
            </table>
          </div>


          <!-- Pagination -->
         <!--  <div class="d-flex justify-content-between align-items-center mt-3">
            <div>
              Showing 1 to 7 of 7 entries
            </div>
            <div>
              <nav aria-label="Page navigation">
                <ul class="pagination pagination-sm">
                  <li class="page-item disabled">
                    <a class="page-link" href="#" aria-label="Previous">
                      <span aria-hidden="true">&laquo;</span>
                    </a>
                  </li>
                  <li class="page-item active"><a class="page-link" href="#">1</a></li>
                  <li class="page-item disabled">
                    <a class="page-link" href="#" aria-label="Next">
                      <span aria-hidden="true">&raquo;</span>
                    </a>
                  </li>
                </ul>
              </nav>
            </div>
          </div>

          <!-- Modal Footer -->
          <!-- <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            <button type="button" class="btn btn-secondary" id="modifyReportBtn">Modify Report</button>

            <!-- Save Report Dropdown -->
           <!--  <div class="dropdown">
              <button class="btn btn-primary dropdown-toggle" type="button" id="saveReportBtn" data-bs-toggle="dropdown" aria-expanded="false">
                Save Report
              </button>
              <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="saveReportBtn">
                <li><a class="dropdown-item" href="#" id="saveExisting">Save Report</a></li>
                <li><a class="dropdown-item" href="#" id="saveNew">Save As New Report</a></li>
              </ul>
            </div>
          </div>

          <!-- Timestamp -->
          <!-- <div class="text-end mt-3">
            <small class="text-muted">DATA AS OF 22 JUN 2022, 17:40 PM</small>
          </div>

        </div>
      </div>
    </div>
  </div>

  <!-- Chart Section -->
  <!-- <div class="row mt-4">
    <div class="col-12">
      <div class="card">
        <div class="card-header">
          <h5 class="card-title">Chart</h5>
        </div>
        <div class="card-body">
          <canvas id="reportChart" style="min-height: 300px;"></canvas>
        </div>
      </div>
    </div>
  </div>

  <!-- Action Buttons -->
  <!-- <div class="row mt-3 mb-4">
    <div class="col-12 text-end">
      <button type="button" class="btn btn-secondary">Modify Report</button>
      <button type="button" class="btn btn-primary">Save Report</button>
    </div>
  </div>

  
  <!-- Modify Report Modal -->
  <!-- <div class="modal fade" id="modifyReportModal" tabindex="-1" aria-labelledby="modifyReportModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="modifyReportModalLabel">Modify Ad-Hoc Report</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form id="modifyReportForm">
            <!-- First Section: Division, Section, Unit -->
            <!-- <div class="row mb-3">
              <div class="col-md-4">
                <label for="modifyDivision" class="form-label">Division <span class="text-danger">*</span></label>
                <div class="input-group">
                  <input type="text" class="form-control" id="modifyDivision" name="division" value="STRATEGIC PLANNING DIVISION" readonly>
                  <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"></button>
                  <button class="btn btn-outline-secondary clear-input" type="button" data-target="modifyDivision">
                    <i class="bx bx-x"></i>
                  </button>
                  <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="#">STRATEGIC PLANNING DIVISION</a></li>
                    <li><a class="dropdown-item" href="#">EXPORTS PROMOTION & MARKET ACCESS DIVISION</a></li>
                    <li><a class="dropdown-item" href="#">INTERNATIONAL TRADE DIVISION</a></li>
                  </ul>
                </div>
              </div>
              <div class="col-md-4">
                <label for="modifySection" class="form-label">Section <span class="text-danger">*</span></label>
                <div class="input-group">
                  <input type="text" class="form-control" id="modifySection" name="section" value="COORDINATION AND MONITORING SECTION" readonly>
                  <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"></button>
                  <button class="btn btn-outline-secondary clear-input" type="button" data-target="modifySection">
                    <i class="bx bx-x"></i>
                  </button>
                  <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="#">COORDINATION AND MONITORING SECTION</a></li>
                    <li><a class="dropdown-item" href="#">CHINA & NORTHEAST ASIA SECTION</a></li>
                    <li><a class="dropdown-item" href="#">ASEAN SECTION</a></li>
                  </ul>
                </div>
              </div>
              <div class="col-md-4">
                <label for="modifyUnit" class="form-label">Unit <span class="text-danger">*</span></label>
                <div class="input-group">
                  <input type="text" class="form-control" id="modifyUnit" name="unit" value="PERFORMANCE MONITORING UNIT" readonly>
                  <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"></button>
                  <button class="btn btn-outline-secondary clear-input" type="button" data-target="modifyUnit">
                    <i class="bx bx-x"></i>
                  </button>
                  <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="#">PERFORMANCE MONITORING UNIT</a></li>
                    <li><a class="dropdown-item" href="#">UNIT A</a></li>
                    <li><a class="dropdown-item" href="#">UNIT B</a></li>
                  </ul>
                </div>
              </div>
            </div>

            <!-- Second Section: Report Type, Date Range -->
         <!--  <div class="row mb-3">
              <div class="col-md-12">
                <label for="modifyReportType" class="form-label">Report Type / Query Mapping <span class="text-danger">*</span></label>
                <div class="input-group">
                  <input type="text" class="form-control" id="modifyReportType" name="reportType" value="PREDEFINED - [ Remark: List of programme- 2 ]" readonly>
                  <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"></button>
                  <button class="btn btn-outline-secondary clear-input" type="button" data-target="modifyReportType">
                    <i class="bx bx-x"></i>
                  </button>
                  <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="#">PREDEFINED - [ Remark: List of programme- 2 ]</a></li>
                    <li><a class="dropdown-item" href="#">CUSTOM - [ Remark: Market analysis ]</a></li>
                  </ul>
                </div>
              </div>
            </div>

            <div class="row mb-3">
              <div class="col-md-3">
                <label for="modifyStartYear" class="form-label">Start Year</label>
                <input type="number" class="form-control" id="modifyStartYear" name="startYear" value="2021">
              </div>
              <div class="col-md-3">
                <label for="modifyEndYear" class="form-label">End Year</label>
                <input type="number" class="form-control" id="modifyEndYear" name="endYear" value="2021">
              </div>
              <div class="col-md-3">
                <label for="modifyStartMonth" class="form-label">Start Group of Month</label>
                <select class="form-select" id="modifyStartMonth" name="startMonth">
                  <option value="1" selected>1</option>
                  <option value="2">2</option>
                  <option value="3">3</option>
                  <option value="4">4</option>
                </select>
              </div>
              <div class="col-md-3">
                <label for="modifyEndMonth" class="form-label">End Group of Month</label>
                <select class="form-select" id="modifyEndMonth" name="endMonth">
                  <option value="1">1</option>
                  <option value="2">2</option>
                  <option value="3">3</option>
                  <option value="4" selected>4</option>
                </select>
              </div>
            </div>

            <!-- Third Section: Indicators -->
         <!--  <div class="row mb-3">
              <div class="col-md-4">
                <label for="modifyExportIndicator" class="form-label">Exporter Indicator</label>
                <div class="input-group">
                  <span class="input-group-text"><i class="bx bx-x"></i></span>
                  <input type="text" class="form-control" id="modifyExportIndicator" name="exporterIndicator" value="Success Stories">
                  <button class="btn btn-outline-secondary" type="button">
                    <i class="bx bx-x"></i>
                  </button>
                </div>
              </div>
              <div class="col-md-4">
                <label for="modifyStatus" class="form-label">Status</label>
                <div class="input-group">
                  <input type="text" class="form-control" id="modifyStatus" name="status" value="Endorsed" readonly>
                  <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false"></button>
                  <button class="btn btn-outline-secondary clear-input" type="button" data-target="modifyStatus">
                    <i class="bx bx-x"></i>
                  </button>
                  <ul class="dropdown-menu">
                    <li><a class="dropdown-item" href="#">Draft</a></li>
                    <li><a class="dropdown-item" href="#">Endorsed</a></li>
                    <li><a class="dropdown-item" href="#">Completed</a></li>
                  </ul>
                </div>
              </div>
              <div class="col-md-4">
                <label for="modifyActivitiesIndicator" class="form-label">Activities Indicator</label>
                <div class="input-group">
                  <span class="input-group-text"><i class="bx bx-x"></i></span>
                  <input type="text" class="form-control" id="modifyActivitiesIndicator" name="activitiesIndicator" value="Success Stories">
                  <button class="btn btn-outline-secondary" type="button">
                    <i class="bx bx-x"></i>
                  </button>
                </div>
              </div>
            </div>

            <div class="row mb-3">
              <div class="col-md-4">
                <label for="modifyBudgetIndicator" class="form-label">Budget Indicator</label>
                <div class="input-group">
                  <span class="input-group-text"><i class="bx bx-x"></i></span>
                  <input type="text" class="form-control" id="modifyBudgetIndicator" name="budgetIndicator" value="Success Stories">
                  <button class="btn btn-outline-secondary" type="button">
                    <i class="bx bx-x"></i>
                  </button>
                </div>
              </div>
              <div class="col-md-4">
                <label for="modifyType" class="form-label">Type <span class="text-danger">*</span></label>
                <select class="form-select" id="modifyType" name="type">
                  <option value="Table" selected>Table</option>
                  <option value="Chart">Chart</option>
                  <option value="Both">Both</option>
                </select>
              </div>
            </div>

            <!-- Data Table Section -->
          <!-- <h5 class="mt-4 mb-3">Data</h5>
            <div class="table-responsive mb-3">
              <table class="table table-bordered">
                <thead>
                  <tr>
                    <th>Data</th>
                    <th width="80">Use</th>
                    <th width="120">Direction</th>
                    <th width="80">Split</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td>No</td>
                    <td class="text-center"><input type="checkbox" class="form-check-input data-use-checkbox" checked></td>
                    <td>
                      <select class="form-select direction-select">
                        <option value="Row" selected>Row</option>
                        <option value="Column">Column</option>
                      </select>
                    </td>
                    <td class="text-center"><input type="checkbox" class="form-check-input"></td>
                  </tr>
                  <tr>
                    <td>Programme</td>
                    <td class="text-center"><input type="checkbox" class="form-check-input data-use-checkbox" checked></td>
                    <td>
                      <select class="form-select direction-select">
                        <option value="Row" selected>Row</option>
                        <option value="Column">Column</option>
                      </select>
                    </td>
                    <td class="text-center"><input type="checkbox" class="form-check-input"></td>
                  </tr>
                  <tr>
                    <td>Exporter Target</td>
                    <td class="text-center"><input type="checkbox" class="form-check-input data-use-checkbox" checked></td>
                    <td>
                      <select class="form-select direction-select">
                        <option value="Row" selected>Row</option>
                        <option value="Column">Column</option>
                      </select>
                    </td>
                    <td class="text-center"><input type="checkbox" class="form-check-input"></td>
                  </tr>
                  <tr>
                    <td>Exporter Achievement</td>
                    <td class="text-center"><input type="checkbox" class="form-check-input data-use-checkbox" checked></td>
                    <td>
                      <select class="form-select direction-select">
                        <option value="Row" selected>Row</option>
                        <option value="Column">Column</option>
                      </select>
                    </td>
                    <td class="text-center"><input type="checkbox" class="form-check-input"></td>
                  </tr>
                </tbody>
              </table>
            </div>

            <!-- Title Section -->
           <!--  <div class="row mb-3">
              <div class="col-md-12">
                <label for="modifyTitle" class="form-label">Title <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="modifyTitle" name="title" value="Success Stories of PMU">
              </div>
            </div>

            <div class="row mb-3">
              <div class="col-md-12">
                <label for="modifySubTitle" class="form-label">Sub-Title <span class="text-danger">*</span></label>
                <input type="text" class="form-control" id="modifySubTitle" name="subTitle" value="For 2021">
              </div>
            </div>

            <div class="row mb-3">
              <div class="col-md-12">
                <label for="modifyRemark" class="form-label">Remark [ Optional ]</label>
                <textarea class="form-control" id="modifyRemark" name="remark" rows="3"></textarea>
              </div>
            </div>
          </form>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-primary" id="saveModifiedReport">Modify</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>-->

   <style>
        .hidden-column {
            display: none !important;
        }
        .table-responsive {
            overflow-x: auto;
        }
        .btn-group .btn {
            margin-right: 5px;
        }
        .accordion-button:not(.collapsed) {
            background-color: #e7f3ff;
        }
        .card:hover {
            background-color: #f8f9fa;
            cursor: pointer;
        }
        .bi-chevron-right, .bi-chevron-down {
            transition: transform 0.2s;
        }
        .export-notification {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1050;
            min-width: 300px;
        }
    </style>
</head>
<body>
    <!-- Export notification area -->
    <div id="exportNotification" class="export-notification"></div>

    <div class="container-fluid py-4">
        <!-- RESULTS SECTION -->
        <div class="unified-container">
            <div class="results-section">
                <div class="accordion" id="divisionsAccordion">

                    <!-- First Division: MANAGEMENT SERVICES DIVISION -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                MANAGEMENT SERVICES DIVISION
                            </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse" aria-labelledby="headingOne" data-bs-parent="#divisionsAccordion">
                            <div class="accordion-body p-0">
                                <!-- Nested Accordion for Sections -->
                                <div class="accordion" id="sectionsAccordionOne">
                                    <div class="accordion-item border-0">
                                        <h2 class="accordion-header" id="headingOneOne">
                                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOneOne" aria-expanded="false" aria-controls="collapseOneOne">
                                                FACILITY MANAGEMENT SECTION
                                            </button>
                                        </h2>
                                        <div id="collapseOneOne" class="accordion-collapse collapse" aria-labelledby="headingOneOne" data-bs-parent="#sectionsAccordionOne">
                                            <div class="accordion-body">
                                                <!-- ASSET MANAGEMENT UNIT Card -->
                                                <div class="card mb-2" onclick="toggleTable('assetManagementTable')">
                                                    <div class="card-body d-flex justify-content-between align-items-center">
                                                        <div>ASSET MANAGEMENT UNIT</div>
                                                        <div><i class="bi bi-chevron-right"></i></div>
                                                    </div>
                                                </div>

                                                <!-- ASSET MANAGEMENT UNIT Table (initially hidden) -->
                                                <div id="assetManagementTable" style="display:none; margin-top: 20px;">
                                                    <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
                                                        <h5>Asset Management Unit Performance - Q1 2025</h5>
                                                        <div class="btn-group">
                                                           <button class="btn btn-primary btn-sm" onclick="openColumnModal()">
    <i class="bx bx-columns me-1"></i> Modify Column
</button>
                                                           <button class="btn btn-info btn-sm" onclick="printTable()">
    <i class="bx bx-printer me-1"></i> Print
</button>
                                                            <div class="btn-group">
                                                                <div class="dropdown">
   <button type="button" class="btn btn-danger btn-sm dropdown-toggle" data-bs-toggle="dropdown">
    <i class="bx bx-download me-1"></i> Export
</button>
    <ul class="dropdown-menu">
                                                                    <li><h6 class="dropdown-header">CHOOSE AN OPTION:</h6></li>
                                                                    <li><a class="dropdown-item" href="#" onclick="exportTable('excel', 'mainTable')"><i class="bi bi-file-earmark-excel me-2"></i>EXCEL</a></li>
                                                                    <li><a class="dropdown-item" href="#" onclick="exportTable('pdf', 'mainTable')"><i class="bi bi-file-earmark-pdf me-2"></i>PDF</a></li>
                                                                    <li><a class="dropdown-item" href="#" onclick="exportTable('word', 'mainTable')"><i class="bi bi-file-earmark-word me-2"></i>WORD</a></li>
                                                                    <li><a class="dropdown-item" href="#" onclick="exportTable('jpg', 'mainTable')"><i class="bi bi-image me-2"></i>JPG</a></li>
                                                                </ul>
                                                            </div>
                                                           <div class="dropdown">
   <button class="btn btn-success btn-sm dropdown-toggle" data-bs-toggle="dropdown">
    <i class="bx bx-edit me-1"></i> Annotation
</button>
    <ul class="dropdown-menu">
                                                                    <li><a class="dropdown-item" href="#">Start Annotate</a></li>
                                                                    <li><a class="dropdown-item" href="#">Download Annotated</a></li>
                                                                    <li><a class="dropdown-item" href="#">Stop Annotation</a></li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="table-responsive">
                                                        <table class="table table-bordered " id="mainTable">
                                                            <thead class="table-light">
                                                                <tr>
                                                                    <th data-column="no" class="sortable-header" onclick="sortTable('mainTable', 0, 'number')">
            No.
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="year" class="sortable-header" onclick="sortTable('mainTable', 1, 'number')">
            Year
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="division" class="sortable-header" onclick="sortTable('mainTable', 2, 'text')">
            Division
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="section" class="sortable-header" onclick="sortTable('mainTable', 3, 'text')">
            Section
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="unit-office" class="sortable-header" onclick="sortTable('mainTable', 4, 'text')">
            Unit/Office
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="indicator" class="sortable-header" onclick="sortTable('mainTable', 5, 'text')">
            Indicator
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="description" class="sortable-header" onclick="sortTable('mainTable', 6, 'text')">
            Description
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="metric" class="sortable-header" onclick="sortTable('mainTable', 7, 'text')">
            Metric
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="annual-target" class="sortable-header" onclick="sortTable('mainTable', 8, 'number')">
            Annual Target
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="indicator-type" class="sortable-header" onclick="sortTable('mainTable', 9, 'text')">
            Indicator Type
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="indicator-type-definition" class="sortable-header" onclick="sortTable('mainTable', 10, 'text')">
            Indicator Type Definition
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="category" class="sortable-header" onclick="sortTable('mainTable', 11, 'text')">
            Category
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="component-achievement" class="sortable-header" onclick="sortTable('mainTable', 12, 'number')">
            Component Achievement
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="output-outcome" class="sortable-header" onclick="sortTable('mainTable', 13, 'text')">
            Output/Outcome
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="submission" class="sortable-header" onclick="sortTable('mainTable', 14, 'text')">
            Submission
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="status" class="sortable-header" onclick="sortTable('mainTable', 15, 'text')">
            Status
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th data-column="pmu-remarks" class="sortable-header" onclick="sortTable('mainTable', 16, 'text')">
            PMU Remarks
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <tr>
                                                                    <td data-column="no">1</td>
                                                                    <td data-column="year">2024</td>
                                                                    <td data-column="division">Operations</td>
                                                                    <td data-column="section">Maintenance</td>
                                                                    <td data-column="unit-office">Asset Management</td>
                                                                    <td data-column="indicator">Asset Maintenance</td>
                                                                    <td data-column="description">Total maintenance tasks resolved</td>
                                                                    <td data-column="metric">Tasks Completed</td>
                                                                    <td data-column="annual-target">300</td>
                                                                    <td data-column="indicator-type">Efficiency</td>
                                                                    <td data-column="indicator-type-definition">Measure of operational efficiency</td>
                                                                    <td data-column="category">Operations</td>
                                                                    <td data-column="component-achievement">75</td>
                                                                    <td data-column="output-outcome">Output</td>
                                                                    <td data-column="submission">Q1 2024</td>
                                                                    <td data-column="status"><span class="badge bg-warning">Ongoing</span></td>
                                                                    <td data-column="pmu-remarks">25% completion - accelerating</td>
                                                                </tr>
                                                                <tr>
                                                                    <td data-column="no">2</td>
                                                                    <td data-column="year">2024</td>
                                                                    <td data-column="division">Quality Assurance</td>
                                                                    <td data-column="section">Audit</td>
                                                                    <td data-column="unit-office">Asset Management</td>
                                                                    <td data-column="indicator">Asset Audit</td>
                                                                    <td data-column="description">Audited vs. planned assets</td>
                                                                    <td data-column="metric">Audit Percentage</td>
                                                                    <td data-column="annual-target">100</td>
                                                                    <td data-column="indicator-type">Quality</td>
                                                                    <td data-column="indicator-type-definition">Quality assurance metric</td>
                                                                    <td data-column="category">Compliance</td>
                                                                    <td data-column="component-achievement">40</td>
                                                                    <td data-column="output-outcome">Output</td>
                                                                    <td data-column="submission">Q1 2024</td>
                                                                    <td data-column="status"><span class="badge bg-info">In Progress</span></td>
                                                                    <td data-column="pmu-remarks">40% completion - on track</td>
                                                                </tr>
                                                                <tr>
                                                                    <td data-column="no">3</td>
                                                                    <td data-column="year">2024</td>
                                                                    <td data-column="division">Finance</td>
                                                                    <td data-column="section">Budget</td>
                                                                    <td data-column="unit-office">Finance Department</td>
                                                                    <td data-column="indicator">Cost Savings</td>
                                                                    <td data-column="description">Total cost reduction achieved</td>
                                                                    <td data-column="metric">Currency (RM)</td>
                                                                    <td data-column="annual-target">50,000</td>
                                                                    <td data-column="indicator-type">Financial</td>
                                                                    <td data-column="indicator-type-definition">Financial performance indicator</td>
                                                                    <td data-column="category">Finance</td>
                                                                    <td data-column="component-achievement">12,500</td>
                                                                    <td data-column="output-outcome">Outcome</td>
                                                                    <td data-column="submission">Q1 2024</td>
                                                                    <td data-column="status"><span class="badge bg-success">Achieved</span></td>
                                                                    <td data-column="pmu-remarks">25% of annual target in Q1</td>
                                                                </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Second Division: EXPORTER PROMOTION -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                EXPORTER PROMOTION AND MARKET ACCESS DIVISION
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#divisionsAccordion">
                            <div class="accordion-body p-0">
                                <div class="accordion" id="sectionsAccordionTwo">
                                    <div class="accordion-item border-0">
                                        <h2 class="accordion-header" id="headingTwoOne">
                                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwoOne" aria-expanded="false" aria-controls="collapseTwoOne">
                                                ELECTRICAL & ELECTRONICS, ICT, MACHINERY SECTION
                                            </button>
                                        </h2>
                                        <div id="collapseTwoOne" class="accordion-collapse collapse" aria-labelledby="headingTwoOne" data-bs-parent="#sectionsAccordionTwo">
                                            <div class="accordion-body">
                                                <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
                                                    <h5>E&E, ICT, MACHINERY SECTION - Q1 2025</h5>
                                                    <div class="btn-group">
   <button class="btn btn-primary btn-sm" onclick="openColumnModal()">
    <i class="bx bx-columns me-1"></i> Modify Column
</button>
    <button class="btn btn-info btn-sm" onclick="printTable()">
    <i class="bx bx-printer me-1"></i> Print
</button>
    <div class="dropdown">
        <button type="button" class="btn btn-danger btn-sm dropdown-toggle" data-bs-toggle="dropdown">
    <i class="bx bx-download me-1"></i> Export
</button>
        <ul class="dropdown-menu">
            <li><h6 class="dropdown-header">CHOOSE AN OPTION:</h6></li>
            <li><a class="dropdown-item" href="#" onclick="exportTable('excel', 'exporterTable')"><i class="bi bi-file-earmark-excel me-2"></i>EXCEL</a></li>
            <li><a class="dropdown-item" href="#" onclick="exportTable('pdf', 'exporterTable')"><i class="bi bi-file-earmark-pdf me-2"></i>PDF</a></li>
            <li><a class="dropdown-item" href="#" onclick="exportTable('word', 'exporterTable')"><i class="bi bi-file-earmark-word me-2"></i>WORD</a></li>
            <li><a class="dropdown-item" href="#" onclick="exportTable('jpg', 'exporterTable')"><i class="bi bi-image me-2"></i>JPG</a></li>
        </ul>
    </div>
    <div class="dropdown">
       <button class="btn btn-success btn-sm dropdown-toggle" data-bs-toggle="dropdown">
    <i class="bx bx-edit me-1"></i> Annotation
</button>
        <ul class="dropdown-menu">
            <li><a class="dropdown-item" href="#">Start Annotate</a></li>
            <li><a class="dropdown-item" href="#">Download Annotated</a></li>
            <li><a class="dropdown-item" href="#">Stop Annotation</a></li>
        </ul>
    </div>
</div>
                                                </div>

                                                <div class="table-responsive">
                                                    <table class="table table-bordered table-" id="exporterTable">
                                                        <thead class="table-light">
                                                            <tr>
                                                                <th class="sortable-header" onclick="sortTable('exporterTable', 0, 'number')">
            No.
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="sortable-header" onclick="sortTable('exporterTable', 1, 'text')">
            Indicator
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="sortable-header" onclick="sortTable('exporterTable', 2, 'text')">
            Description
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="sortable-header" onclick="sortTable('exporterTable', 3, 'number')">
            Target
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="sortable-header" onclick="sortTable('exporterTable', 4, 'number')">
            Achievement
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="sortable-header" onclick="sortTable('exporterTable', 5, 'text')">
            Percentage
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="sortable-header" onclick="sortTable('exporterTable', 6, 'text')">
            Remarks
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr>
                                                                <td>1</td>
                                                                <td>Export Support</td>
                                                                <td>Company export facilitation</td>
                                                                <td>50</td>
                                                                <td>12</td>
                                                                <td>24%</td>
                                                                <td>In progress</td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Third Division: TRANSFORMATION -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                TRANSFORMATION AND DIGITAL TRADE DIVISION
                            </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#divisionsAccordion">
                            <div class="accordion-body">
                                <div class="card mb-2" onclick="toggleTable('transformationTable')">
                                    <div class="card-body d-flex justify-content-between align-items-center">
                                        <div>DIGITAL TRANSFORMATION UNIT</div>
                                        <div><i class="bi bi-chevron-right"></i></div>
                                    </div>
                                </div>

                                <div id="transformationTable" style="display:none; margin-top: 20px;">
                                    <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
                                        <h5>Digital Transformation - Q1 2025</h5>
                                        <div class="btn-group">
   <button class="btn btn-primary btn-sm" onclick="openColumnModal()">
    <i class="bx bx-columns me-1"></i> Modify Column
</button>
    <button class="btn btn-info btn-sm" onclick="printTable()">
    <i class="bx bx-printer me-1"></i> Print
</button>
    <div class="dropdown">
        <button type="button" class="btn btn-danger btn-sm dropdown-toggle" data-bs-toggle="dropdown">
    <i class="bx bx-download me-1"></i> Export
</button>
        <ul class="dropdown-menu">
            <li><h6 class="dropdown-header">CHOOSE AN OPTION:</h6></li>
            <li><a class="dropdown-item" href="#" onclick="exportTable('excel', 'transformationTableData')"><i class="bi bi-file-earmark-excel me-2"></i>EXCEL</a></li>
            <li><a class="dropdown-item" href="#" onclick="exportTable('pdf', 'transformationTableData')"><i class="bi bi-file-earmark-pdf me-2"></i>PDF</a></li>
            <li><a class="dropdown-item" href="#" onclick="exportTable('word', 'transformationTableData')"><i class="bi bi-file-earmark-word me-2"></i>WORD</a></li>
            <li><a class="dropdown-item" href="#" onclick="exportTable('jpg', 'transformationTableData')"><i class="bi bi-image me-2"></i>JPG</a></li>
        </ul>
    </div>
    <div class="dropdown">
       <button class="btn btn-success btn-sm dropdown-toggle" data-bs-toggle="dropdown">
    <i class="bx bx-edit me-1"></i> Annotation
</button>
        <ul class="dropdown-menu">
            <li><a class="dropdown-item" href="#">Start Annotate</a></li>
            <li><a class="dropdown-item" href="#">Download Annotated</a></li>
            <li><a class="dropdown-item" href="#">Stop Annotation</a></li>
        </ul>
    </div>
</div>
</div>

                                    <div class="table-responsive">
                                        <table class="table table-bordered table-" id="transformationTableData">
                                            <thead class="table-light">
                                                <tr>
                                                    <th class="sortable-header" onclick="sortTable('transformationTableData', 0, 'number')">
            No.
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="sortable-header" onclick="sortTable('transformationTableData', 1, 'text')">
            Initiative
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="sortable-header" onclick="sortTable('transformationTableData', 2, 'text')">
            Progress
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="sortable-header" onclick="sortTable('transformationTableData', 3, 'text')">
            Status
            <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>1</td>
                                                    <td>Digital Platform Development</td>
                                                    <td>75%</td>
                                                    <td><span class="badge bg-success">On Track</span></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

<!-- Column Selector Modal for Report Table -->
<div class="modal fade" id="columnSelectorModal" tabindex="-1" aria-labelledby="columnSelectorModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="columnSelectorModalLabel">Modify Column - List of Reporting Columns</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body column-selector-modal">
        <p>Select columns to display:</p>
        
        <!-- Row 1 -->
        <div class="row">
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="noColumn" data-column="no" checked disabled>
              <label class="form-check-label" for="noColumn">
                No
              </label>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="yearColumn" data-column="year" checked>
              <label class="form-check-label" for="yearColumn">
                Year
              </label>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="divisionColumn" data-column="division" checked>
              <label class="form-check-label" for="divisionColumn">
                Division
              </label>
            </div>
          </div>
        </div>

        <!-- Row 2 -->
        <div class="row">
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="sectionColumn" data-column="section" checked>
              <label class="form-check-label" for="sectionColumn">
                Section
              </label>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="unitOfficeColumn" data-column="unit-office" checked>
              <label class="form-check-label" for="unitOfficeColumn">
                Unit/Office
              </label>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="indicatorColumn" data-column="indicator" checked>
              <label class="form-check-label" for="indicatorColumn">
                Indicator
              </label>
            </div>
          </div>
        </div>

        <!-- Row 3 -->
        <div class="row">
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="descriptionColumn" data-column="description" checked>
              <label class="form-check-label" for="descriptionColumn">
                Description
              </label>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="metricColumn" data-column="metric" checked>
              <label class="form-check-label" for="metricColumn">
                Metric
              </label>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="annualTargetColumn" data-column="annual-target" checked>
              <label class="form-check-label" for="annualTargetColumn">
                Annual Target
              </label>
            </div>
          </div>
        </div>

        <!-- Row 4 -->
        <div class="row">
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="indicatorTypeColumn" data-column="indicator-type" checked>
              <label class="form-check-label" for="indicatorTypeColumn">
                Indicator Type
              </label>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="indicatorTypeDefinitionColumn" data-column="indicator-type-definition" checked>
              <label class="form-check-label" for="indicatorTypeDefinitionColumn">
                Indicator Type Definition
              </label>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="categoryColumn" data-column="category" checked>
              <label class="form-check-label" for="categoryColumn">
                Category
              </label>
            </div>
          </div>
        </div>

        <!-- Row 5 -->
        <div class="row">
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="componentAchievementColumn" data-column="component-achievement" checked>
              <label class="form-check-label" for="componentAchievementColumn">
                Component Achievement
              </label>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="outputOutcomeColumn" data-column="output-outcome" checked>
              <label class="form-check-label" for="outputOutcomeColumn">
                Output/Outcome
              </label>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="submissionColumn" data-column="submission" checked>
              <label class="form-check-label" for="submissionColumn">
                Submission
              </label>
            </div>
          </div>
        </div>

        <!-- Row 6 -->
        <div class="row">
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="statusColumn" data-column="status" checked>
              <label class="form-check-label" for="statusColumn">
                Status
              </label>
            </div>
          </div>
          <div class="col-md-4">
            <div class="form-check">
              <input class="form-check-input column-toggle" type="checkbox" id="pmuRemarksColumn" data-column="pmu-remarks" checked>
              <label class="form-check-label" for="pmuRemarksColumn">
                PMU Remarks
              </label>
            </div>
          </div>
        </div>

      </div>
          <div class="modal-footer justify-content-end">
            <button type="button" class="btn btn-primary btn-sm" onclick="selectAllColumns()">Select All</button>
            <button type="button" class="btn btn-secondary btn-sm" onclick="deselectAllColumns()">Deselect All</button>
            <button type="button" class="btn btn-success btn-sm" id="applyColumnSettings" data-bs-dismiss="modal">Apply</button>
          </div>
    </div>
  </div>
</div>


  @endsection

  @section('page-script')
  <script>
    $(function() {
      // Store table in a global variable so it's accessible to all functions
      window.reportTable = $('#reportTable').DataTable({
        data: [
          [1, 'SUCCESS STORIES OF PMU', 'For 2021', 'Completed', 'Annual Report', '2022-06-22', ''],
          [2, 'Market Analysis', 'China Region', 'In progress', 'Analytical', '2025-04-10', ''],
          [3, 'ASEAN Trade Summary', 'Regional Analysis', 'Final Review', 'Annual', '2025-03-28', '']
        ],
        columns: [{
            title: 'ID'
          },
          {
            title: 'Title'
          },
          {
            title: 'Subtitle'
          },
          {
            title: 'Remark'
          },
          {
            title: 'Type'
          },
          {
            title: 'Updated'
          },
          {
  title: 'Action',
  render: function(data, type, row) {
    return `
  <div class="d-flex gap-2">
   <button type="button" class="btn btn-sm btn-info view-report"
data-bs-toggle="modal" data-bs-target="#reportViewModal"
data-id="1" data-title="Q1 2025 Report" data-subtitle="Export Statistics">
<i class="bx bx-show"></i> View
</button>
    <button type="button" class="btn btn-sm btn-success share-btn" data-id="${row[0]}" data-title="${row[1]}">
      <i class="bx bx-share-alt"></i> Share
    </button>
    <button type="button" class="btn btn-sm btn-danger remove-btn" data-id="${row[0]}" data-title="${row[1]}">
      <i class="bx bx-trash"></i> Remove
    </button>
  </div>`;
  }
}
        ]
      });

      // Chart.js
      if (document.getElementById('reportChart')) {
        const ctx = document.getElementById('reportChart').getContext('2d');
        new Chart(ctx, {
          type: 'bar',
          data: {
            labels: ['Jan', 'Feb', 'Mar'],
            datasets: [{
              label: 'Reports',
              data: [5, 10, 8],
              backgroundColor: ['#3c8dbc', '#00c0ef', '#f39c12']
            }]
          }
        });
      }

      // View Report - handle data updates in modal when it's shown
      $('#reportViewModal').on('show.bs.modal', function(event) {
        var button = $(event.relatedTarget); // Button that triggered the modal
        var id = button.data('id');
        var title = button.data('title');
        var subtitle = button.data('subtitle');

        // Update the modal's content
        var modal = $(this);
        modal.find('.modal-title').text(title);
        modal.find('.modal-body h4.fw-bold').text(title);
        modal.find('.modal-body p.text-muted').text(subtitle);

        console.log("Modal showing for report ID:", id, "Title:", title);
      });

      // Remove Report
      $(document).on('click', '.remove-btn', function() {
        var row = window.reportTable.row($(this).closest('tr'));
        var data = row.data();
        if (!data) return;

        if (confirm(`Are you sure you want to remove report: ${data[1]} (ID: ${data[0]})?`)) {
          row.remove().draw();
        }
      });

      // Share Report
$(document).on('click', '.share-btn', function() {
  var reportId = $(this).data('id');
  var reportTitle = $(this).data('title');
  
  // You can implement your share functionality here
  // For example, open a modal, copy link to clipboard, send email, etc.
  alert(`Share functionality for report: ${reportTitle} (ID: ${reportId})`);
  
  // Example: Copy a shareable link to clipboard
  // var shareLink = `${window.location.origin}/reports/view/${reportId}`;
  // navigator.clipboard.writeText(shareLink);
});

      // Print
      $('#printReport').click(() => window.print());

      // Modify
      $('#modifyReportBtn').click(() => {
        alert('Modify report functionality would go here');
        bootstrap.Modal.getInstance(document.getElementById('reportViewModal')).hide();
      });

      // Save
      $('#saveReportBtn').click(() => {
        alert('Save report functionality would go here');
      });

      // Dropdown links prevent default
      $('.dropdown-item').click(e => e.preventDefault());
    });

    $(document).ready(function() {
      $('.view-btn').on('click', function() {
        $('#reportViewModal').modal('show');
      });
    });

    $(function() {
      // Handle dropdown item clicks for all dropdowns in the modify report modal
      $('#modifyReportModal').on('click', '.dropdown-item', function(e) {
        e.preventDefault();
        const target = $(this).closest('.input-group').find('input');
        target.val($(this).data('value') || $(this).text());
      });

      // Handle clear buttons for all inputs in the modify report modal
      $('#modifyReportModal').on('click', '.clear-input', function() {
        const targetId = $(this).data('target');
        $('#' + targetId).val('');
      });

      // Initialization function for when the page loads
      function initModifyReportModal() {
        // This function can set default values or perform other initialization
        console.log('Modify Report Modal initialized');

        // You can set default values here if needed
        // $('#modifyDivision').val('DEFAULT DIVISION');
      }

      // Call initialization when the document is ready
      initModifyReportModal();

      // Additional handling for when the modal is about to be shown
      $('#modifyReportModal').on('show.bs.modal', function(event) {
        // You can prefill the form with data from the report being modified
        const button = $(event.relatedTarget);
        const reportId = button.data('id');

        if (reportId) {
          // Here you would typically load the report data from an API
          console.log('Loading report data for ID:', reportId);

          // For demo purposes, we're using hardcoded data
          // In a real implementation, you would fetch this data from your backend
        }
      });

      // Form submission handling for the modify form
      $('#saveModifiedReport').click(function() {
        // Trigger form validation
        if (!$('#modifyReportForm')[0].checkValidity()) {
          // If the form is not valid, trigger HTML5 validation
          $('#modifyReportForm')[0].reportValidity();
          return;
        }

        // If valid, collect form data and submit
        const formData = {};
        $('#modifyReportForm').serializeArray().forEach(function(item) {
          formData[item.name] = item.value;
        });

        // Add data from the data table
        formData.dataColumns = [];
        $('#modifyReportModal table tbody tr').each(function() {
          const checkbox = $(this).find('.data-use-checkbox')[0];
          if (checkbox && checkbox.checked) {
            formData.dataColumns.push({
              name: $(this).find('td:first').text(),
              direction: $(this).find('.direction-select').val(),
              split: $(this).find('td:last input')[0].checked
            });
          }
        });

        console.log('Saving modified report:', formData);

        // Here you would send the data to your backend API
        // For demo purposes, we'll just show a success message

        // Close the modal
        $('#modifyReportModal').modal('hide');

        // Show success message
        alert('Report modified successfully!');
      });
    });

    // Add this to your existing JavaScript code
    $(document).ready(function() {
      // Handle click on the Modify Report button in the View modal
      $('#modifyReportBtn').on('click', function() {
        // Hide the view modal
        $('#reportViewModal').modal('hide');

        // Show the modify modal
        setTimeout(function() {
          $('#modifyReportModal').modal('show');
        }, 500); // Small delay to allow the first modal to close
      });

      // Save modified report
      $('#saveModifiedReport').on('click', function() {
        // Validate form
        if (!$('#modifyReportForm')[0].checkValidity()) {
          $('#modifyReportForm')[0].reportValidity();
          return;
        }

        // Collect form data
        const formData = {};
        $('#modifyReportForm').serializeArray().forEach(function(item) {
          formData[item.name] = item.value;
        });

        // Get data table selections
        formData.columns = [];
        $('#modifyReportModal table tbody tr').each(function() {
          const checkbox = $(this).find('.data-use-checkbox')[0];
          if (checkbox && checkbox.checked) {
            formData.columns.push({
              name: $(this).find('td:first').text(),
              direction: $(this).find('.direction-select').val(),
              split: $(this).find('td:last input')[0].checked
            });
          }
        });

        console.log('Saving modified report:', formData);

        // Here you would typically send data to your backend API
        // For demo purposes, just show a success message
        alert('Report modified successfully!');

        // Close the modal
        $('#modifyReportModal').modal('hide');

        // Optional: Update the report in the table
        updateReportInTable(formData);
      });

      // Helper function to update the report in the table
      function updateReportInTable(formData) {
        // This would update the report in the DataTable
        // Find the row with the matching ID and update it
        const table = window.reportTable;
        const rows = table.rows().data();

        for (let i = 0; i < rows.length; i++) {
          if (rows[i][0] == 1) { // Assuming the first report has ID 1
            table.row(i).data([
              rows[i][0],
              formData.title,
              formData.subTitle,
              formData.remark || '',
              formData.type,
              new Date().toISOString().split('T')[0], // Today's date
              rows[i][6] // Keep the action buttons as is
            ]).draw();
            break;
          }
        }
      }
    });

    $(document).ready(function() {
      // Initialize DataTable for removed reports
      window.removedReportsTable = $('#removedReportsTable').DataTable({
        data: [
          ['KPI-RPT-AHR-177', 'dasdaad', 'scfsdfasf dasdsa', '', 'Table', '15/08/2022', ''],
          ['KPI-RPT-AHR-178', 'Indicator - Achievement : Sample Pie Chart', 'TBU (Year 2020-2021)', '', 'Pie', '15/08/2022', '']
        ],
        columns: [{
            title: 'ID'
          },
          {
            title: 'Title'
          },
          {
            title: 'Subtitle'
          },
          {
            title: 'Remark'
          },
          {
            title: 'Type'
          },
          {
            title: 'Updated'
          },
          {
            title: 'Action',
            render: function(data, type, row) {
              return `<button type="button" class="btn btn-sm btn-primary activate-btn" data-id="${row[0]}">
                    Activate
                  </button>`;
            }
          }
        ]
      });

      // Handle tab switching
      $('.nav-tabs .nav-link').on('click', function(e) {
        e.preventDefault();
        // Remove active class from all tabs
        $('.nav-tabs .nav-link').removeClass('active');
        // Add active class to clicked tab
        $(this).addClass('active');

        // Hide all tab content
        $('.tab-content').hide();

        // Show the appropriate tab content
        if ($(this).text().trim() === 'ACTIVE') {
          $('#activeReportsContent').show();
          $('#removedReportsContent').hide();
        } else if ($(this).text().trim() === 'REMOVED') {
          $('#activeReportsContent').hide();
          $('#removedReportsContent').show();
        }
      });

      // Handle activate button click
      $(document).on('click', '.activate-btn', function() {
        const reportId = $(this).data('id');
        const reportTitle = $(this).closest('tr').find('td:eq(1)').text();

        if (confirm(`Are you sure you want to activate report: ${reportTitle} (ID: ${reportId})?`)) {
          // Here you would send an AJAX request to activate the report
          // For demo, we'll just remove it from the removed table
          window.removedReportsTable.row($(this).closest('tr')).remove().draw();

          // You might want to also add it to the active reports table
          // This would require additional code to get all the report data
        }
      });
    });

    <!-- Script for Tab Switching -->

  document.querySelectorAll('#statusTabs .nav-link').forEach(tab => {
    tab.addEventListener('click', function (e) {
      e.preventDefault();

      // Update active tab class
      document.querySelectorAll('#statusTabs .nav-link').forEach(t => t.classList.remove('active'));
      this.classList.add('active');

      // Hide all tab sections
      document.querySelectorAll('.tab-section').forEach(section => section.classList.add('d-none'));

      // Show selected section
      const targetId = this.getAttribute('data-target');
      document.getElementById(targetId).classList.remove('d-none');
    });
  });

 $(document).ready(function() {
  // Clear division selection
  $('#clearDivision').on('click', function() {
    // Create an empty option if it doesn't exist
    if ($('#division option[value=""]').length === 0) {
      $('#division').prepend('<option value=""></option>');
    }
    // Select the empty option
    $('#division').val('').change();
  });
  
  // Clear section selection
  $('#clearSection').on('click', function() {
    if ($('#section option[value=""]').length === 0) {
      $('#section').prepend('<option value=""></option>');
    }
    $('#section').val('').change();
  });
  
  // Clear unit selection
  $('#clearUnit').on('click', function() {
    if ($('#unit option[value=""]').length === 0) {
      $('#unit').prepend('<option value=""></option>');
    }
    $('#unit').val('').change();
  });
});

// This file contains the implementation for the column display selector functionality

// Function to toggle tables
function toggleTable(tableId) {
  const table = document.getElementById(tableId);
  if (table) {
    table.style.display = table.style.display === 'none' ? 'block' : 'none';
  }
}

// Function to print a specific table by ID
function printTableById(tableId) {
  const printContents = document.getElementById(tableId).outerHTML;
  const originalContents = document.body.innerHTML;
  
  document.body.innerHTML = `
    <html>
      <head>
        <title>Print</title>
        <style>
          table { width: 100%; border-collapse: collapse; }
          th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
          th { background-color: #f2f2f2; }
        </style>
      </head>
      <body>${printContents}</body>
    </html>
  `;
  
  window.print();
  document.body.innerHTML = originalContents;
}

// Function to export table
function exportTable(format) {
  // Placeholder function for export functionality
  alert(`Exporting as ${format}...`);
  // In a real implementation, this would handle exporting to various formats
}

// Column display selector functionality
document.addEventListener('DOMContentLoaded', function() {
  // Add column display button to all table control groups
  const tableControlGroups = document.querySelectorAll('.btn-group');
  
  tableControlGroups.forEach(group => {
    // Create column display button and add it after the Print button
    const printButton = group.querySelector('button[onclick*="printTableById"]');
    if (printButton) {
      const displayButton = document.createElement('button');
      displayButton.className = 'btn btn-secondary btn-sm';
      displayButton.textContent = 'Columns';
      displayButton.setAttribute('data-bs-toggle', 'modal');
      displayButton.setAttribute('data-bs-target', '#columnSelectorModal');
      
      // Insert the display button after the print button
      printButton.parentNode.insertBefore(displayButton, printButton.nextSibling);
      
      // Store the table ID in the button's data attribute
      const tableId = printButton.getAttribute('onclick').match(/printTableById\('([^']+)'\)/)[1];
      displayButton.setAttribute('data-table-id', tableId);
    }
  });
  
  // Handle applying column selections
  document.getElementById('applyColumnSettings')?.addEventListener('click', function() {
    // Get the table ID from the button that opened the modal
    const tableId = document.querySelector('[data-bs-target="#columnSelectorModal"][data-table-id]')?.getAttribute('data-table-id');
    if (!tableId) return;
    
    const table = document.getElementById(tableId);
    if (!table) return;
    
    // Get all checked/unchecked columns
    const checkboxes = document.querySelectorAll('.column-toggle');
    
    checkboxes.forEach(checkbox => {
      const columnIndex = getColumnIndexByName(table, checkbox.getAttribute('data-column'));
      if (columnIndex !== -1) {
        const display = checkbox.checked ? '' : 'none';
        
        // Update header cells
        const headerCells = table.querySelectorAll('thead th');
        if (columnIndex < headerCells.length) {
          headerCells[columnIndex].style.display = display;
        }
        
        // Update all row cells in that column
        const rows = table.querySelectorAll('tbody tr');
        rows.forEach(row => {
          const cells = row.querySelectorAll('td');
          if (columnIndex < cells.length) {
            cells[columnIndex].style.display = display;
          }
        });
      }
    });
  });
  
  // Helper function to get column index by name
  function getColumnIndexByName(table, columnName) {
    const headerCells = table.querySelectorAll('thead th');
    for (let i = 0; i < headerCells.length; i++) {
      const headerText = headerCells[i].textContent.trim().toLowerCase();
      if (headerText.includes(columnName.toLowerCase())) {
        return i;
      }
    }
    return -1;
  }
  
  // Populate modal checkboxes dynamically when a column button is clicked
  document.addEventListener('click', function(e) {
    // Check if the clicked element is a column display button
    if (e.target.matches('[data-bs-target="#columnSelectorModal"]')) {
      const tableId = e.target.getAttribute('data-table-id');
      const table = document.getElementById(tableId);
      
      if (table) {
        // Get table headers
        const headers = table.querySelectorAll('thead th');
        
        // Clear existing checkboxes
        const modalBody = document.querySelector('.column-selector-modal');
        modalBody.innerHTML = '<p>Select columns to display:</p>';
        
        // Create checkbox for each header
        headers.forEach((header, index) => {
          const headerText = header.textContent.trim();
          const cleanId = headerText.toLowerCase().replace(/[^a-z0-9]/g, '');
          
          const checkboxDiv = document.createElement('div');
          checkboxDiv.className = 'form-check';
          
          const checkbox = document.createElement('input');
          checkbox.className = 'form-check-input column-toggle';
          checkbox.type = 'checkbox';
          checkbox.id = `${cleanId}Column`;
          checkbox.setAttribute('data-column', headerText);
          checkbox.checked = header.style.display !== 'none';
          
          const label = document.createElement('label');
          label.className = 'form-check-label';
          label.htmlFor = `${cleanId}Column`;
          label.textContent = headerText;
          
          checkboxDiv.appendChild(checkbox);
          checkboxDiv.appendChild(label);
          modalBody.appendChild(checkboxDiv);
        });
      }
    }
  });
});


//javascript yg di ambil dri predefined

  // Toggle table visibility
        function toggleTable(tableId) {
            const table = document.getElementById(tableId);
            const chevronContainer = table.parentElement.querySelector('.card-body');
            const chevron = chevronContainer ? chevronContainer.querySelector('.bi-chevron-right, .bi-chevron-down') : null;
            
            if (table.style.display === 'none' || table.style.display === '') {
                table.style.display = 'block';
                if (chevron) {
                    chevron.className = chevron.className.replace('bi-chevron-right', 'bi-chevron-down');
                }
            } else {
                table.style.display = 'none';
                if (chevron) {
                    chevron.className = chevron.className.replace('bi-chevron-down', 'bi-chevron-right');
                }
            }
        }

        // Open column selector modal
        function openColumnModal() {
            // Assuming you have a modal with this ID in your other file
            const modal = new bootstrap.Modal(document.getElementById('columnSelectorModal'));
            modal.show();
        }

        // Column visibility management - FIXED VERSION
        function applyColumnVisibility() {
            const checkboxes = document.querySelectorAll('.column-toggle');
            const table = document.getElementById('mainTable');
            
            if (!table || checkboxes.length === 0) {
                // If no checkboxes exist, show all columns by default
                return;
            }
            
            checkboxes.forEach(checkbox => {
                const columnName = checkbox.dataset.column;
                const isVisible = checkbox.checked;
                
                // Find all elements with matching data-column attribute
                const elements = table.querySelectorAll(`[data-column="${columnName}"]`);
                
                elements.forEach(element => {
                    if (isVisible) {
                        element.classList.remove('hidden-column');
                        element.style.display = ''; // Reset display property
                    } else {
                        // Don't hide the "No" column as it's required
                        if (columnName !== 'no') {
                            element.classList.add('hidden-column');
                        }
                    }
                });
            });
        }

        // Select all columns
        function selectAllColumns() {
            const checkboxes = document.querySelectorAll('.column-toggle');
            checkboxes.forEach(checkbox => {
                checkbox.checked = true;
            });
        }

        // Deselect all columns (except required ones)
        function deselectAllColumns() {
            const checkboxes = document.querySelectorAll('.column-toggle');
            checkboxes.forEach(checkbox => {
                if (checkbox.dataset.column !== 'no') { // Keep "No" column checked
                    checkbox.checked = false;
                }
            });
        }

        // Apply column settings
        function applyColumnSettings() {
            applyColumnVisibility();
        }

        // Export functions
        function exportTable(format) {
            alert(`Exporting table as ${format.toUpperCase()}...`);
        }

        function printTable() {
            window.print();
        }

        // Form element focus effects
        document.querySelectorAll('.form-select, .form-control').forEach(element => {
            element.addEventListener('focus', function() {
                this.style.transform = 'translateY(-1px)';
            });
            
            element.addEventListener('blur', function() {
                this.style.transform = 'translateY(0)';
            });
        });

        // Initialize on page load - ENSURE ALL COLUMNS ARE VISIBLE BY DEFAULT
        document.addEventListener('DOMContentLoaded', function() {
            // Make sure all columns are visible initially
            const table = document.getElementById('mainTable');
            if (table) {
                const allColumns = table.querySelectorAll('[data-column]');
                allColumns.forEach(element => {
                    element.classList.remove('hidden-column');
                    element.style.display = ''; // Ensure display is not set to none
                });
            }
            
            // Only apply column visibility if checkboxes exist
            const checkboxes = document.querySelectorAll('.column-toggle');
            if (checkboxes.length > 0) {
                applyColumnVisibility();
            }
        });

        // Event listeners for modal controls (if they exist)
        document.addEventListener('DOMContentLoaded', function() {
            const selectAllBtn = document.getElementById('selectAllColumns');
            const deselectAllBtn = document.getElementById('deselectAllColumns');
            const applyBtn = document.getElementById('applyColumnSettings');
            const noColumnCheckbox = document.getElementById('noColumn');

            if (selectAllBtn) {
                selectAllBtn.addEventListener('click', selectAllColumns);
            }

            if (deselectAllBtn) {
                deselectAllBtn.addEventListener('click', deselectAllColumns);
            }

            if (applyBtn) {
                applyBtn.addEventListener('click', applyColumnSettings);
            }

            // Prevent unchecking the required "No" column
            if (noColumnCheckbox) {
                noColumnCheckbox.addEventListener('change', function() {
                    if (!this.checked) {
                        this.checked = true;
                        alert('The "No" column is required and cannot be unchecked.');
                    }
                });
            }
        });

            // ADD THESE SORTING FUNCTIONS
    let sortDirections = {}; // Track sort direction for each column

    function sortTable(tableId, columnIndex, dataType) {
        const table = document.getElementById(tableId);
        const tbody = table.querySelector('tbody');
        const rows = Array.from(tbody.querySelectorAll('tr'));
        const header = table.querySelector(`thead th:nth-child(${columnIndex + 1})`);
        const sortIcon = header.querySelector('.sort-icon');
        
        // Clear other active sort icons
        table.querySelectorAll('.sort-icon').forEach(icon => {
            if (icon !== sortIcon) {
                icon.classList.remove('active');
                icon.className = 'bi bi-arrow-down-up sort-icon';
            }
        });
        
        // Determine sort direction
        const sortKey = `${tableId}_${columnIndex}`;
        const currentDirection = sortDirections[sortKey] || 'asc';
        const newDirection = currentDirection === 'asc' ? 'desc' : 'asc';
        sortDirections[sortKey] = newDirection;
        
        // Update sort icon
        sortIcon.classList.add('active');
        sortIcon.className = newDirection === 'asc' ? 
            'bi bi-arrow-up sort-icon active' : 
            'bi bi-arrow-down sort-icon active';
        
        // Sort rows
        rows.sort((a, b) => {
            const aCell = a.cells[columnIndex];
            const bCell = b.cells[columnIndex];
            
            let aValue = aCell.textContent.trim();
            let bValue = bCell.textContent.trim();
            
            // Handle status badges - extract text content
            if (aCell.querySelector('.badge')) {
                aValue = aCell.querySelector('.badge').textContent.trim();
            }
            if (bCell.querySelector('.badge')) {
                bValue = bCell.querySelector('.badge').textContent.trim();
            }
            
            // Convert to appropriate data type
            if (dataType === 'number') {
                // Remove commas and convert to number
                aValue = parseFloat(aValue.replace(/,/g, '')) || 0;
                bValue = parseFloat(bValue.replace(/,/g, '')) || 0;
                
                if (newDirection === 'asc') {
                    return aValue - bValue;
                } else {
                    return bValue - aValue;
                }
            } else {
                // Text sorting (alphabetical)
                aValue = aValue.toLowerCase();
                bValue = bValue.toLowerCase();
                
                if (newDirection === 'asc') {
                    return aValue.localeCompare(bValue);
                } else {
                    return bValue.localeCompare(aValue);
                }
            }
        });
        
        // Clear tbody and re-append sorted rows
        tbody.innerHTML = '';
        rows.forEach(row => tbody.appendChild(row));
        
        // Add visual feedback
        header.style.backgroundColor = '#e3f2fd';
        setTimeout(() => {
            header.style.backgroundColor = '';
        }, 300);
    }

    // Reset sort directions when table is toggled
    function toggleTable(tableId) {
        const table = document.getElementById(tableId);
        const chevronContainer = table.parentElement.querySelector('.card-body');
        const chevron = chevronContainer ? chevronContainer.querySelector('.bi-chevron-right, .bi-chevron-down') : null;

        if (table.style.display === 'none' || table.style.display === '') {
            table.style.display = 'block';
            if (chevron) {
                chevron.className = chevron.className.replace('bi-chevron-right', 'bi-chevron-down');
            }
        } else {
            table.style.display = 'none';
            if (chevron) {
                chevron.className = chevron.className.replace('bi-chevron-down', 'bi-chevron-right');
            }
            // Reset sort directions when table is hidden
            Object.keys(sortDirections).forEach(key => {
                if (key.startsWith(tableId)) {
                    delete sortDirections[key];
                }
            });
        }
    }


  </script>
  @endsection