@extends('layouts/contentNavbarLayout')

@section('title', 'KPI Indicator - Listing')

@section('page-script')
@vite(['resources/assets/js/kpi-indicator-pmu-admin.js'])
@endsection

@section('content')
<!-- DataTables CSS & JS -->
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet" />
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="{{ asset('assets/js/kpiIndicator.js') }}"></script>
<style>
  .table td, .table th {
    padding: 0.75rem 1rem;
    vertical-align: middle;
    border: 1px solid #dee2e6;
  }

  .table-hover tbody tr:hover {
    background-color: #f8f9fa;
  }

  .table-responsive .table {
    border-radius: 0.75rem;
    overflow: hidden;
  }

  /* ADD THESE SORTING STYLES */
.sortable-header {
    cursor: pointer;
    position: relative;
    user-select: none;
    padding-right: 25px !important;
}

.sortable-header:hover {
    background-color: #f8f9fa;
}

.sort-icon {
    position: absolute;
    right: 8px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 12px;
    color: #6c757d;
    transition: color 0.2s;
}

.sort-icon.active {
    color: #0d6efd;
}
</style>
 @php
  $breadcrumbs = [
    ['label' => 'Dashboard', 'url' => route('dashboard-analytics')],
    ['label' => 'KPI Indicator'],
    ['label' => 'Manage Indicator']
  ];
@endphp

@include('layouts.partials.page-header', [
  'title' => 'Manage Indicator',
  'slot' => view('layouts.partials.breadcrumb', compact('breadcrumbs'))->render()
])

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-icons/1.10.0/font/bootstrap-icons.min.css">
<style>
.sortable-header {
    cursor: pointer;
    position: relative;
    user-select: none;
    padding-right: 25px !important;
}

.sortable-header:hover {
    background-color: #f8f9fa;
}

.sort-icon {
    position: absolute;
    right: 8px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 12px;
    color: #6c757d;
    transition: color 0.2s;
}

.sort-icon.active {
    color: #0d6efd;
}

</style>

<div class="row">
  <div class="col-md-12">
    <div class="nav-align-top">
     <ul class="nav nav-pills flex-column flex-md-row mb-6">

</ul>      <!-- <li class="nav-item"><a class="nav-link" href="{{url('pages/kpi-indicator-pmu-admin-manage')}}"><i class="bx bx-sm bx-link-alt me-1_5"></i> Connections</a></li> -->

    </div>

    <div class="card mb-6">
      <!-- Account -->
      <div class="card-body">
      <div class="d-flex align-items-start align-items-sm-center gap-6  border-bottom">
      <!-- <img src="{{asset('assets/img/avatars/1.png')}}" alt="user-avatar" class="d-block w-px-100 h-px-100 rounded" id="uploadedAvatar" /> -->
          <div class="button-wrapper">

          </div>
        </div>
      </div>
      <div class="card-body pt-4">
        <form id="formAccountSettings" method="POST" onsubmit="return false">
          <div class="row g-6">

          <div class="card-body pt-4">
    <form id="formAccountSettings" method="POST" onsubmit="return false">
      <div class="row g-4">

        {{-- Year --}}
        <div class="col-md-4">
          <label class="form-label" for="year">Year</label>
          <select id="year" name="year" class="select2 form-select">
            <option value="">Please select</option>
            <option value="2023">2023</option>
            <option value="2024">2024</option>
            <option value="2025">2025</option>
          </select>
        </div>

        {{-- Division --}}
        <div class="col-md-4">
          <label class="form-label" for="division">Division</label>
          <select id="division" name="division" class="select2 form-select">
            <option value="">Please select</option>
            <option value="division1">CEO's Office</option>
            <option value="division2">Export Promotion & Market Access</option>
            <option value="division3">Management Services</option>
            <option value="division4">Strategic Planning</option>
            <option value="division5">Transformation and Digital Trade Division</option>
          </select>
        </div>

        {{-- Section --}}
        <div class="col-md-4">
          <label class="form-label" for="section">Section</label>
          <select id="section" name="section" class="select2 form-select">
            <option value="">Please select</option>
            <option value="section1">ASEAN & Oceania</option>
            <option value="section2">Central, West, South Asia & Africa Section</option>
            <option value="section3">China & Northeast Asia</option>
            <option value="section4">Construction & Business Services</option>
            <option value="section5">Coordination & Monitoring</option>
            <option value="section6">Corporate Management</option>
            <option value="section7">Customised Programme</option>
            <option value="section8">Development Assistance</option>
            <option value="section9">Digital Trade</option>
            <option value="section10">Electrical & Electronics, ICT, Machinery & Equipment</option>
            <option value="section11">Europe & Americas</option>
            <option value="section12">Export Academy</option>
            <option value="section13">Facility Management</option>
            <option value="section14">Finance Management</option>
            <option value="section15">Halal, Food & Beverages & Agro-based</option>
            <option value="section16">Human Resource</option>
            <option value="section17">Information Technology</option>
            <option value="section18">Lifestyle & Life Sciences</option>
            <option value="section19">N/A</option>
            <option value="section20">Oil & Gas, Chemical & Energy</option>
            <option value="section21">Research</option>
            <option value="section22">Strategic Communication</option>
            <option value="section23">Strategic Development</option>
            <option value="section24">Transport & Logistic</option>
          </select>
        </div>

        {{-- Unit/Office --}}
        <div class="col-md-4">
          <label class="form-label" for="unit">Unit/Office</label>
          <select id="unit" name="unit" class="select2 form-select">
            <option value="">Please select</option>
            @for ($i = 1; $i <= 87; $i++)
              <option value="unit{{ $i }}">Unit {{ $i }}</option>
            @endfor
          </select>
        </div>

        <!-- {{-- Indicator Type --}}
        <div class="col-md-4">
          <label class="form-label" for="indicator_type">Indicator Type</label>
          <select id="indicator_type" name="indicator_type" class="select2 form-select">
            <option value="">Please select</option>
            <option value="type1">Type 1</option>
            <option value="type2">Type 2</option>
            <option value="type3">Type 3</option>
            <option value="type4">Type 4</option>
            <option value="type5">Type 5</option>
            <option value="type6">Type 6</option>
          </select>
        </div>

        {{-- Status --}}
        <div class="col-md-4">
          <label class="form-label" for="status">Status</label>
          <select id="status" name="status" class="select2 form-select">
            <option value="">Please select</option>
            <option value="draft">Draft</option>
            <option value="endorsed">Endorsed</option>
            <option value="pending">Pending Endorsed</option>
            <option value="proposed">Proposed</option>
            <option value="rejected">Rejected</option>
          </select>
        </div> -->

           {{-- Indicator --}}
            <div class="col-md-4">
              <label class="form-label" for="indicator">Indicator</label>
              <select id="indicator" name="indicator" class="select2 form-select">
                <option value="">Please select</option>
              </select>
            </div>

            {{-- Indicator Type --}}
            <div class="col-md-4">
              <label class="form-label" for="indicator">Indicator Type</label>
              <select id="indicator" name="indicator" class="select2 form-select">
                <option value="">Please select</option>
              </select>
            </div>

          <div class="mt-2 d-flex justify-content-end">
            <button type="submit" class="btn btn-primary me-3">Search</button>
            <button type="reset" class="btn btn-secondary">Reset</button>
          </div>
        </form>
      </div>
      <!-- /Account -->
    </div>
    <script src="https://unpkg.com/feather-icons"></script>

  <!-- Card Body -->
  <div class="card-body">

    <!-- Button Container (Right-Aligned) -->
    <div class="d-flex justify-content-end align-items-center gap-2 mb-3">
      <!-- Choose Column Button -->
      <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#columnModal">
    <i class="bx bx-columns me-1"></i>
    Modify Column
</button>

      <!-- Print Button -->
      <a href="/export/print" class="btn btn-info">
        <i data-feather="printer" class="me-1"></i> Print
      </a>

      <!-- Export Dropdown Button -->
      <div class="dropdown">
        <button class="btn btn-danger dropdown-toggle" type="button" id="exportDropdown" data-bs-toggle="dropdown" aria-expanded="false">
          <i data-feather="download" class="me-1"></i> Export
        </button>

        <ul class="dropdown-menu shadow" aria-labelledby="exportDropdown">
          <li><a class="dropdown-item" href="/export/csv"><i data-feather="file-text" class="me-2"></i>Csv</a></li>
          <li><a class="dropdown-item" href="/export/excel"><i data-feather="file" class="me-2"></i>Excel</a></li>
          <li><a class="dropdown-item" href="/export/pdf"><i data-feather="file-minus" class="me-2"></i>Pdf</a></li>
          <li><a class="dropdown-item" href="/export/copy"><i data-feather="copy" class="me-2"></i>Copy</a></li>
        </ul>
      </div>
    </div>

    <!-- Feather Icons Activation -->
    <script>
      feather.replace();
    </script>

      <form method="GET" action="{{ url()->current() }}" class="d-flex align-items-center gap-2 mb-3">
            <label for="perPage" class="form-label mb-0">Show</label>
            <select name="perPage" id="perPage" class="form-select w-auto" onchange="this.form.submit()">
                @php
                    $options = [10, 25, 50, 100, 'all'];
                    $selectedPerPage = request('perPage', 10); // default to 10
                @endphp
                @foreach ($options as $option)
                    <option value="{{ $option }}" {{ (string)$selectedPerPage === (string)$option ? 'selected' : '' }}>
                        {{ ucfirst($option) }}
                    </option>
                @endforeach
            </select>
            <span>Entries</span>
        </form>

    <!-- Responsive Table -->
    <div class="modal fade" id="columnModal" tabindex="-1" aria-labelledby="columnModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="columnModalLabel">Modify Column - List of Manage Indicator Columns</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>

          <div class="modal-body row">
            <p>Select columns to display:</p>
        <!-- Kolum Kiri -->
        <div class="col-md-6">
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="no" checked disabled><label class="form-check-label">No</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="year" checked><label class="form-check-label">Year</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="division" checked><label class="form-check-label">Division</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="section" checked><label class="form-check-label">Section</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="unit" checked><label class="form-check-label">Unit/Office</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="indicator" checked><label class="form-check-label">Indicator</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="description"><label class="form-check-label">Description</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="submission"><label class="form-check-label">Submission</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="target" checked><label class="form-check-label">Annual Target</label></div>
        </div>

        <!-- Kolum Kanan -->
        <div class="col-md-6">
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="metric" checked><label class="form-check-label">Metric</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="category"><label class="form-check-label">Category</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="output"><label class="form-check-label">Output/Outcome</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="type" checked><label class="form-check-label">Indicator Type</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="type_def"><label class="form-check-label">Indicator Type Definition</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="achievement"><label class="form-check-label">Component Achievement</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="status" checked><label class="form-check-label">Status</label></div>
          <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="action" checked disabled><label class="form-check-label">Action</label></div>
        </div>
      </div>

      <div class="modal-footer justify-content-end">
        <button type="button" class="btn btn-primary btn-sm" onclick="selectAllColumns()">Select All</button>
        <button type="button" class="btn btn-secondary btn-sm" onclick="deselectAllColumns()">Deselect All</button>
        <button type="button" class="btn btn-success btn-sm" onclick="applyColumnSettings()">Apply</button>
      </div>
    </div>
  </div>
</div>

<!-- Jadual -->
<!-- Jadual -->
<div class="table-responsive">
              <table class="table table-bordered align-middle table-hover shadow-sm rounded" id="mainTable">
                <thead class="table-light">
                  <tr class="text-uppercase text-secondary fw-bold small text-center">
        <th><input type="checkbox" id="checkAll"></th>
        <th class="col-no sortable-header" onclick="sortTable('mainTable', 1, 'number')">
          No
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-year sortable-header" onclick="sortTable('mainTable', 2, 'number')">
          Year
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-division sortable-header" onclick="sortTable('mainTable', 3, 'text')">
          Division
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-section sortable-header" onclick="sortTable('mainTable', 4, 'text')">
          Section
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-unit sortable-header" onclick="sortTable('mainTable', 5, 'text')">
          Unit/Office
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-indicator sortable-header" onclick="sortTable('mainTable', 6, 'text')">
          Indicator
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-description sortable-header" onclick="sortTable('mainTable', 7, 'text')" style="display:none;">
          Description
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-submission sortable-header" onclick="sortTable('mainTable', 8, 'text')" style="display:none;">
          Submission
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-target sortable-header" onclick="sortTable('mainTable', 9, 'number')">
          Annual Target
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-metric sortable-header" onclick="sortTable('mainTable', 10, 'text')">
          Metric
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-category sortable-header" onclick="sortTable('mainTable', 11, 'text')" style="display:none;">
          Category
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-output sortable-header" onclick="sortTable('mainTable', 12, 'text')" style="display:none;">
          Output/Outcome
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-type sortable-header" onclick="sortTable('mainTable', 13, 'text')">
          Indicator Type
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-type_def sortable-header" onclick="sortTable('mainTable', 14, 'text')" style="display:none;">
          Indicator Type Definition
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-achievement sortable-header" onclick="sortTable('mainTable', 15, 'text')" style="display:none;">
          Component Achievement
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-status sortable-header" onclick="sortTable('mainTable', 16, 'text')">
          Status
          <i class="bi bi-arrow-down-up sort-icon"></i>
        </th>
        <th class="col-action">Action</th>
      </tr>
    </thead>
        <tbody class="table-border-bottom-0">
  <tr>
    <td><input type="checkbox" name="selected[]" value="1" class="row-checkbox"></td>
    <td class="col-no">1</td>
    <td class="col-year">2023</td>
    <td class="col-division">TRANSFORMATION & DIGITAL TRADE DIVISION</td>
    <td class="col-section">N/A</td>
    <td class="col-unit">Sabah</td>
    <td class="col-indicator">New exporters</td>
    <td class="col-description" style="display:none;">Description A</td>
    <td class="col-submission" style="display:none;">Online</td>
    <td class="col-target">25</td>
    <td class="col-metric">Company</td>
    <td class="col-category" style="display:none;">Category A</td>
    <td class="col-output" style="display:none;">Output A</td>
    <td class="col-type">
      <select name="type[]" class="form-select w-90">
        <option value="type1" selected>1</option>
        <option value="type2">2</option>
        <option value="type3">3</option>
        <option value="type4">4</option>
        <option value="type5">5</option>
        <option value="type6">6</option>
      </select>
    </td>
    <td class="col-type_def" style="display:none;">Definition A</td>
    <td class="col-achievement" style="display:none;">Achievement A</td>
    <td class="col-status">Endorse</td>
    <td class="col-action">

    </td>
  </tr>

  <tr>
    <td><input type="checkbox" name="selected[]" value="2" class="row-checkbox"></td>
    <td class="col-no">2</td>
    <td class="col-year">2024</td>
    <td class="col-division">TRANSFORMATION & DIGITAL TRADE DIVISION</td>
    <td class="col-section">N/A</td>
    <td class="col-unit">Terengganu</td>
    <td class="col-indicator">New exporters</td>
    <td class="col-description" style="display:none;">Description B</td>
    <td class="col-submission" style="display:none;">Offline</td>
    <td class="col-target">30</td>
    <td class="col-metric">Company</td>
    <td class="col-category" style="display:none;">Category B</td>
    <td class="col-output" style="display:none;">Output B</td>
    <td class="col-type">
      <select name="type[]" class="form-select w-90">
        <option value="type1">1</option>
        <option value="type2" selected>2</option>
        <option value="type3">3</option>
        <option value="type4">4</option>
        <option value="type5">5</option>
        <option value="type6">6</option>
      </select>
    </td>
    <td class="col-type_def" style="display:none;">Definition B</td>
    <td class="col-achievement" style="display:none;">Achievement B</td>
    <td class="col-status">Endorse</td>
            <td>
            <a href="{{ route('indicator.manage.type2') }}" class="btn btn-outline-primary d-flex justify-content-center align-items-center shadow-sm" style="width: 60px;">
              <i class="bx bx-edit fs-5 text-primary"></i>
            </a>
          </td>
</tr>
          <tr>
  <td><input type="checkbox" name="selected[]" value="3" class="row-checkbox"></td>
  <td class="col-no">3</td>
  <td class="col-year">2024</td>
  <td class="col-division">TRANSFORMATION & DIGITAL TRADE DIVISION</td>
  <td class="col-section">N/A</td>
  <td class="col-unit">Sarawak</td>
  <td class="col-indicator">New exporters</td>
  <td class="col-description" style="display:none;">Description C</td>
  <td class="col-submission" style="display:none;">Online</td>
  <td class="col-target">35</td>
  <td class="col-metric">Company</td>
  <td class="col-category" style="display:none;">Category C</td>
  <td class="col-output" style="display:none;">Output C</td>
  <td class="col-type">
    <select name="type[]" class="form-select w-90">
      <option value="type1">1</option>
      <option value="type2">2</option>
      <option value="type3" selected>3</option>
      <option value="type4">4</option>
      <option value="type5">5</option>
      <option value="type6">6</option>
    </select>
  </td>
  <td class="col-type_def" style="display:none;">Definition C</td>
  <td class="col-achievement" style="display:none;">Achievement C</td>
  <td class="col-status">Endorse</td>
  <td>
            <a href="{{ route('indicator.manage.type3') }}" class="btn btn-outline-primary d-flex justify-content-center align-items-center shadow-sm" style="width: 60px;">
             <i class="bx bx-edit fs-5 text-primary"></i>
            </a>
            </td>
</tr>

<tr>
  <td><input type="checkbox" name="selected[]" value="4" class="row-checkbox"></td>
  <td class="col-no">4</td>
  <td class="col-year">2024</td>
  <td class="col-division">TRANSFORMATION & DIGITAL TRADE DIVISION</td>
  <td class="col-section">N/A</td>
  <td class="col-unit">Penang</td>
  <td class="col-indicator">New exporters</td>
  <td class="col-description" style="display:none;">Description D</td>
  <td class="col-submission" style="display:none;">Offline</td>
  <td class="col-target">40</td>
  <td class="col-metric">Company</td>
  <td class="col-category" style="display:none;">Category D</td>
  <td class="col-output" style="display:none;">Output D</td>
  <td class="col-type">
    <select name="type[]" class="form-select w-90">
      <option value="type1">1</option>
      <option value="type2">2</option>
      <option value="type3">3</option>
      <option value="type4" selected>4</option>
      <option value="type5">5</option>
      <option value="type6">6</option>
    </select>
  </td>
  <td class="col-type_def" style="display:none;">Definition D</td>
  <td class="col-achievement" style="display:none;">Achievement D</td>
  <td class="col-status">Endorse</td>
    <td>
            <!-- Semua dalam satu <td> -->
           <a href="{{ route('indicator.manage.type4') }}" class="btn btn-outline-primary d-flex justify-content-center align-items-center shadow-sm" style="width: 60px;">
              <i class="bx bx-edit fs-5 text-primary"></i>
            </a>
          </td>
</tr>

<tr>
  <td><input type="checkbox" name="selected[]" value="5" class="row-checkbox"></td>
  <td class="col-no">5</td>
  <td class="col-year">2024</td>
  <td class="col-division">TRANSFORMATION & DIGITAL TRADE DIVISION</td>
  <td class="col-section">N/A</td>
  <td class="col-unit">Penang</td>
  <td class="col-indicator">New exporters</td>
  <td class="col-description" style="display:none;">Description E</td>
  <td class="col-submission" style="display:none;">Online</td>
  <td class="col-target">50</td>
  <td class="col-metric">Company</td>
  <td class="col-category" style="display:none;">Category E</td>
  <td class="col-output" style="display:none;">Output E</td>
  <td class="col-type">
    <select name="type[]" class="form-select w-90">
      <option value="type1">1</option>
      <option value="type2">2</option>
      <option value="type3">3</option>
      <option value="type4">4</option>
      <option value="type5" selected>5</option>
      <option value="type6">6</option>
    </select>
  </td>
  <td class="col-type_def" style="display:none;">Definition E</td>
  <td class="col-achievement" style="display:none;">Achievement E</td>
  <td class="col-status">Endorse</td>
  <td>
            <a href="{{ route('indicator.manage.type5') }}" class="btn btn-outline-primary d-flex justify-content-center align-items-center shadow-sm" style="width: 60px;">
              <i class="bx bx-edit fs-5 text-primary"></i>
            </a>
  </td>
</tr>

<tr>
  <td><input type="checkbox" name="selected[]" value="6" class="row-checkbox"></td>
  <td class="col-no">6</td>
  <td class="col-year">2024</td>
  <td class="col-division">TRANSFORMATION & DIGITAL TRADE DIVISION</td>
  <td class="col-section">N/A</td>
  <td class="col-unit">Penang</td>
  <td class="col-indicator">New exporters</td>
  <td class="col-description" style="display:none;">Description F</td>
  <td class="col-submission" style="display:none;">Offline</td>
  <td class="col-target">55</td>
  <td class="col-metric">Company</td>
  <td class="col-category" style="display:none;">Category F</td>
  <td class="col-output" style="display:none;">Output F</td>
  <td class="col-type">
    <select name="type[]" class="form-select w-90">
      <option value="type1">1</option>
      <option value="type2">2</option>
      <option value="type3">3</option>
      <option value="type4">4</option>
      <option value="type5">5</option>
      <option value="type6" selected>6</option>
    </select>
  </td>
  <td class="col-type_def" style="display:none;">Definition F</td>
  <td class="col-achievement" style="display:none;">Achievement F</td>
  <td class="col-status">Endorse</td>
   <td>
            <a href="{{ route('indicator.manage.type6') }}" class="btn btn-outline-primary d-flex justify-content-center align-items-center shadow-sm" style="width: 60px;">
              <i class="bx bx-edit fs-5 text-primary"></i>
            </a>

          </td>
</tr>
</tbody>
</table>


<!-- Table Footer with Inline Layout -->
<div class="d-flex justify-content-between align-items-center mt-3 flex-wrap gap-2">
  <!-- Entries Info -->
  <div>Showing 1 to 6 of 6 entries</div>

      <!-- Pagination -->
      <nav aria-label="Page navigation">
  <ul class="pagination justify-content-center flex-wrap mb-0">
    <li class="page-item prev">
      <a class="page-link" href="javascript:void(0);">
        <i class="tf-icon bx bx-chevron-left bx-sm"></i>
      </a>
    </li>
    <li class="page-item">
      <a class="page-link" href="javascript:void(0);">1</a>
    </li>
    <li class="page-item next">
      <a class="page-link" href="javascript:void(0);">
        <i class="tf-icon bx bx-chevron-right bx-sm"></i>
      </a>
    </li>
  </ul>
</nav>
    </div>
</div>

<!-- New Indicator Modal -->
<div class="modal fade" id="newIndicatorModal" tabindex="-1" aria-labelledby="newIndicatorModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form id="newIndicatorForm">
        <div class="modal-header">
          <h5 class="modal-title" id="newIndicatorModalLabel">New Indicator</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>

        <div class="modal-body">
          <div class="mb-3">
            <label for="division" class="form-label">Division</label>
            <input type="text" class="form-control" id="division" name="division">
          </div>

          <div class="mb-3">
            <label for="section" class="form-label">Section</label>
            <input type="text" class="form-control" id="section" name="section">
          </div>

          <div class="mb-3">
            <label for="unit" class="form-label">Unit/Office</label>
            <input type="text" class="form-control" id="unit" name="unit">
          </div>

          <div class="mb-3">
            <label for="indicator" class="form-label">Indicator</label>
            <input type="text" class="form-control" id="indicator" name="indicator">
          </div>

          <div class="mb-3">
            <label for="description" class="form-label">Indicator Description</label>
            <textarea class="form-control" id="description" name="description" rows="3"></textarea>
          </div>

          <div class="mb-3">
            <label for="year" class="form-label">Year</label>
            <input type="number" class="form-control" id="year" name="year" min="2000" max="2100">
          </div>
        </div>

        <div class="mt-2 d-flex gap-1 modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Add Row</button>
          <button type="submit" class="btn btn-primary">Clear Form</button>
          <button type="submit" class="btn btn-primary">Endorse</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- Account Deactivation Form -->
<form id="formAccountDeactivation" onsubmit="return false">
  <div class="form-check my-4 ms-2">
    <!-- Optional deactivation checkbox (currently hidden) -->
  </div>
</form>

  <script>
// Track sort direction for each column
let sortDirections = {};

function sortTable(tableId, columnIndex, dataType) {
  const table = document.getElementById(tableId);
  const tbody = table.querySelector('tbody');
  const rows = Array.from(tbody.querySelectorAll('tr'));
  const header = table.querySelector(`thead th:nth-child(${columnIndex + 1})`);
  const sortIcon = header.querySelector('.sort-icon');

  // Clear other active sort icons
  table.querySelectorAll('.sort-icon').forEach(icon => {
    if (icon !== sortIcon) {
      icon.classList.remove('active');
      icon.className = 'bi bi-arrow-down-up sort-icon';
    }
  });

  // Determine sort direction
  const sortKey = `${tableId}_${columnIndex}`;
  const currentDirection = sortDirections[sortKey] || 'asc';
  const newDirection = currentDirection === 'asc' ? 'desc' : 'asc';
  sortDirections[sortKey] = newDirection;

  // Update sort icon
  sortIcon.classList.add('active');
  sortIcon.className = newDirection === 'asc' ?
    'bi bi-arrow-up sort-icon active' :
    'bi bi-arrow-down sort-icon active';

  // Sort rows
  rows.sort((a, b) => {
    const aCell = a.cells[columnIndex];
    const bCell = b.cells[columnIndex];

    let aValue = aCell.textContent.trim();
    let bValue = bCell.textContent.trim();

    // Handle different data types
    if (dataType === 'number') {
      // Remove commas and convert to number
      aValue = parseFloat(aValue.replace(/,/g, '')) || 0;
      bValue = parseFloat(bValue.replace(/,/g, '')) || 0;

      if (newDirection === 'asc') {
        return aValue - bValue;
      } else {
        return bValue - aValue;
      }
    } else {
      // Text sorting (alphabetical)
      aValue = aValue.toLowerCase();
      bValue = bValue.toLowerCase();

      if (newDirection === 'asc') {
        return aValue.localeCompare(bValue);
      } else {
        return bValue.localeCompare(aValue);
      }
    }
  });

  // Clear tbody and re-append sorted rows
  tbody.innerHTML = '';
  rows.forEach(row => tbody.appendChild(row));

  // Add visual feedback
  header.style.backgroundColor = '#e3f2fd';
  setTimeout(() => {
    header.style.backgroundColor = '';
  }, 300);
}
</script>

@endsection

<script>
function selectAllColumns() {
  document.querySelectorAll('.column-toggle:not([disabled])').forEach(cb => cb.checked = true);
}

function deselectAllColumns() {
  document.querySelectorAll('.column-toggle:not([disabled])').forEach(cb => cb.checked = false);
}

function applyColumnSettings() {
  document.querySelectorAll('.column-toggle').forEach(cb => {
    const columnClass = '.col-' + cb.dataset.column;
    const show = cb.checked;
    document.querySelectorAll(columnClass).forEach(cell => {
      cell.style.display = show ? '' : 'none';
    });
  });
}
</script>
