@extends('layouts/contentNavbarLayout')

@section('title', 'KPI Indicator - Listing')

@section('page-script')
@vite(['resources/assets/js/pages-account-settings-account.js'])
@endsection

@section('content')

<meta name="csrf-token" content="{{ csrf_token() }}">

<style>
  /* ADD THESE SORTING STYLES */
  .sortable-header {
    cursor: pointer;
    position: relative;
    user-select: none;
    padding-right: 25px !important;
  }

  .sortable-header:hover {
    background-color: #f8f9fa;
  }

  .sort-icon {
    position: absolute;
    right: 8px;
    top: 50%;
    transform: translateY(-50%);
    font-size: 12px;
    color: #6c757d;
    transition: color 0.2s;
  }

  .sort-icon.active {
    color: #0d6efd;
  }

  @media print {
    body * {
      visibility: hidden !important;
    }

    #printArea,
    #printArea * {
      visibility: visible !important;
    }

    #printArea {
      position: static !important;
      padding: 0 !important;
      background: white;
      width: 100% !important;
    }

    .table {
      width: 100% !important;
      table-layout: auto !important;
      border-collapse: collapse !important;
    }

    .table th,
    .table td {
      font-size: 11px !important;
      padding: 6px 8px !important;
      text-align: center !important;
      border: 1px solid #000 !important;
      word-break: break-word !important;
      box-sizing: border-box !important;
    }

    /* Eliminate rounded borders or shadow that may affect layout */
    .table,
    .table th,
    .table td {
      border-radius: 0 !important;
      box-shadow: none !important;
    }

    /* Hide unwanted UI components */
    .btn,
    .dropdown,
    nav,
    aside,
    footer,
    .badge,
    .modal,
    .modal * {
      display: none !important;
    }

    /* Hide sorting icons */
    .sort-icon {
      display: none !important;
    }

    /* Hide action column icon */
    .col-action button,
    .col-action i {
      display: none !important;
    }

    /* Fix page setup */
    @page {
      size: A4 landscape;
      margin: 12mm;
    }

    html,
    body {
      height: auto !important;
      overflow: visible !important;
      margin: 0 !important;
      padding: 0 !important;
    }
  }
</style>



<!-- DataTables CSS & JS -->
<link href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css" rel="stylesheet" />
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="{{ asset('assets/js/kpiIndicator.js') }}"></script>
<!-- HTML2Canvas for JPG export -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
@php
$breadcrumbs = [
['label' => 'Dashboard', 'url' => route('dashboard-analytics')],
['label' => 'KPI Indicator'],
['label' => 'List of Indicator']
];
@endphp

@include('layouts.partials.page-header', [
'title' => 'List of Indicator',
'slot' => view('layouts.partials.breadcrumb', compact('breadcrumbs'))->render()
])

<br>

<!-- <div class="list-group">
                <a class="list-group-item list-group-item-action active" id="list-home-list" data-bs-toggle="list" href="javascript:void(0);">Listing</a>
                <a class="list-group-item list-group-item-action" id="list-profile-list" data-bs-toggle="list" href="{{url('pages/account-settings-notifications')}}">New</a>
                <a class="list-group-item list-group-item-action" id="list-messages-list" data-bs-toggle="list" href="#list-messages">Messages</a>
                <a class="list-group-item list-group-item-action" id="list-settings-list" data-bs-toggle="list" href="#list-settings">Settings</a>
              </div> -->
<div class="card mb-6">
  <!-- Account -->
  <div class="card-body">

    <!-- <img src="{{asset('assets/img/avatars/1.png')}}" alt="user-avatar" class="d-block w-px-100 h-px-100 rounded" id="uploadedAvatar" /> -->

    <!-- <label for="upload" class="btn btn-primary me-3 mb-4" tabindex="0">
              <span class="d-none d-sm-block">Upload new photo</span>
              <i class="bx bx-upload d-block d-sm-none"></i>
              <input type="file" id="upload" class="account-file-input" hidden accept="image/png, image/jpeg" />
            </label> -->
    <!-- <button type="button" class="btn btn-outline-secondary account-image-reset mb-4">
              <i class="bx bx-reset d-block d-sm-none"></i>
              <span class="d-none d-sm-block">Reset</span>
            </button>

            <div>Allowed JPG, GIF or PNG. Max size of 800K</div> -->


  </div>
  <div class="card-body pt-1">
    <form id="formAccountSettings" method="POST" action="{{ route('pages-account-settings-account-search') }}">
      {!! csrf_field() !!}
      <div class="row g-2">

        <div class="col-md-4">
          <label class="form-label" for="year">Year</label>
          <select id="year" name="year" class="select2 form-select">
            <option value="">Please select</option>
            <option value="2018">2018</option>
            <option value="2019">2019</option>
            <option value="2020">2020</option>
            <option value="2021">2021</option>
            <option value="2022">2022</option>
            <option value="2023">2023</option>
            <option value="2024">2024</option>
            <option value="2025">2025</option>
          </select>
        </div>

        {{-- Division --}}
        <div class="col-md-4">
          <label class="form-label" for="division">Division</label>
          <select id="division" name="division" class="select2 form-select">
            <option value="">Please select</option>
            <option value="ceo">CEO's Office</option>
            <option value="exports">Export Promotion & Market Access</option>
            <option value="management">Management Services</option>
            <option value="strategic">Strategic Planning</option>
            <option value="transformation">Transformation and Digital Trade Division</option>
          </select>
        </div>

        {{-- Section --}}
        <div class="col-md-4">
          <label class="form-label" for="section">Section</label>
          <select id="section" name="section" class="select2 form-select">
            <option value="">Please select</option>
            <option value="asean">ASEAN & Oceania</option>
            <option value="central">Central, West, South Asia & Africa Section</option>
            <option value="china">China & Northeast Asia</option>
            <option value="construction">Construction & Business Services</option>
            <option value="coordination">Coordination & Monitoring</option>
            <option value="corporate">Corporate Management</option>
            <option value="customised">Customised Programme</option>
            <option value="development">Development Assistance</option>
            <option value="digital">Digital Trade</option>
            <option value="electrical">Electrical & Electronics, ICT, Machinery & Equipment</option>
            <option value="europe">Europe & Americas</option>
            <option value="export">Export Academy</option>
            <option value="facility">Facility Management</option>
            <option value="finance">Finance Management</option>
            <option value="halal">Halal, Food & Beverages & Agro-based</option>
            <option value="human">Human Resource</option>
            <option value="information">Information Technology</option>
            <option value="lifestyle">Lifestyle & Life Sciences</option>
            <option value="na">N/A</option>
            <option value="oil">Oil & Gas, Chemical & Energy</option>
            <option value="research">Research</option>
            <option value="strategicCommunication">Strategic Communication</option>
            <option value="strategicDevelopment">Strategic Development</option>
            <option value="transport">Transport & Logistic</option>
            {{-- From Indicator Create Modal - Start --}}
            <option value="ceo">CEO OFFICE</option>
            <option value="exports">EXPORTS PROMOTION & MARKET ACCESS DIVISION</option>
            <option value="management">MANAGEMENT SERVICES DIVISION</option>
            {{-- From Indicator Create Modal - End --}}
          </select>
        </div>

        {{-- Unit/Office --}}
        <div class="col-md-4">
          <label class="form-label" for="unit">Unit/Office</label>
          <select id="unit" name="unit" class="select2 form-select">
            <option value="">Please select</option>
            @for ($i = 1; $i <= 87; $i++)
              <option value="{{ $i }}">Unit {{ $i }}</option>
            @endfor
              {{-- From Indicator Create Modal - Start --}}
              <option value="ceo">CEO OFFICE</option>
              <option value="exports">EXPORTS PROMOTION & MARKET ACCESS DIVISION</option>
              <option value="management">MANAGEMENT SERVICES DIVISION</option>
              {{-- From Indicator Create Modal - End --}}
          </select>
        </div>

        {{-- Indicator Type --}}
        <div class="col-md-4">
          <label class="form-label" for="indicator_type">Indicator Type</label>
          <select id="indicator_type" name="indicator_type" class="select2 form-select">
            <option value="">Please select</option>
            {{-- <option value="type1">Type 1</option>
            <option value="type2">Type 2</option>
            <option value="type3">Type 3</option>
            <option value="type4">Type 4</option>
            <option value="type5">Type 5</option>
            <option value="type6">Type 6</option> --}}
              @foreach ($indicator_type_list as $item)
                <option value="{{ $item->kpi_indicator_type_id }}">
                  {{ formatType($item->indicator_type) }}
                </option>
              @endforeach
          </select>
        </div>

        {{-- Status --}}
        <div class="col-md-4">
          <label class="form-label" for="status">Status</label>
          <select id="status" name="status" class="select2 form-select">
            <option value="">Please select</option>
            {{-- Add for functionalities --}}
            <option value="submitted">Submitted</option>
            {{-- Add for functionalities --}}
            <option value="draft">Draft</option>
            <option value="endorsed">Endorse</option>
            <option value="pending">Pending Endorsed</option>
            <option value="proposed">Proposed</option>
            <option value="rejected">Rejected</option>
          </select>
        </div>

        <div class="col-md-4">
          <label for="indicator" class="form-label">Indicator</label>
          <select id="indicator" name="indicator" class="select2 form-select">
            <option value="">Please select</option>
            <option value="Programme">Programme</option>
            <option value="Export Sales">Export Sales</option>
            <option value="Companies Assisted">Companies Assisted</option>
          </select>
        </div>

        <div class="col-md-4">
          <div class="mt-6 d-flex">
            <button type="submit" class="btn btn-primary me-3">Search</button>
            <button type="reset" class="btn btn-secondary">Reset</button>
          </div>
        </div>
      </form>
      </div>
      <!-- <div class="mt-6">
            <button type="submit" class="btn btn-primary me-3">Search</button>
            <button type="reset" class="btn btn-outline-secondary">Reset</button>
          </div> -->
      <!-- <div class="mt-2 d-flex justify-content-end">
            <button type="submit" class="btn btn-primary me-3">Search</button>
            <button type="reset" class="btn btn-outline-secondary">Reset</button>
          </div> -->
  </div>
  <!-- /Account -->
  <!-- </div> -->
  <script src="https://unpkg.com/feather-icons"></script>

  <!-- <div class="card"> -->
  <!-- Card Body -->
  <div class="card-body">

    <!-- Button Container (Right-Aligned) -->
    <div class="d-flex justify-content-end align-items-center gap-2 mb-3">
      <!-- Choose Column Button -->
      <button type="button" class="btn btn-primary btn-sm text-white" data-bs-toggle="modal" data-bs-target="#columnModal">
        <i class="bx bx-columns me-1"></i>
        Modify Column
      </button>

      <!-- Sync Button -->
      <button type="button" class="btn btn-success btn-sm text-white" data-bs-toggle="modal" data-bs-target="#">
        <i data-feather="refresh-ccw" class="me-1"></i>
        Sync
      </button>

      <!-- Print Button -->
      <button id="printBtn" class="btn btn-info btn-sm"><i data-feather="printer" class="me-1"></i> Print</button>

      <!-- Export Dropdown Button -->
      <div class="dropdown">
        <button class="btn btn-danger btn-sm text-white dropdown-toggle" type="button" id="exportDropdown" data-bs-toggle="dropdown" aria-expanded="false">
          <i data-feather="download" class="me-1"></i> Export
        </button>

        <ul class="dropdown-menu shadow" aria-labelledby="exportDropdown">
          <li><a class="dropdown-item" href="#"><i data-feather="file" class="me-2"></i>Excel</a></li>
          <li><a class="dropdown-item" href="#"><i data-feather="file-minus" class="me-2"></i>Pdf</a></li>
          <li><a class="dropdown-item" href="#"><i data-feather="file-minus" class="me-2"></i>Word</a></li>
          <li><a class="dropdown-item" href="#"><i data-feather="file-text" class="me-2"></i>Jpg</a></li>
        </ul>
      </div>
    </div>


    <!-- Feather Icons Activation -->
    <script>
      feather.replace();
    </script>

    <form method="GET" action="{{ url()->current() }}" class="d-flex align-items-center gap-2 mb-3">
      <label for="perPage" class="form-label mb-0">Show</label>
      <select name="perPage" id="perPage" class="form-select w-auto" onchange="this.form.submit()">
        @php
        $options = [10, 25, 50, 100, 'all'];
        $selectedPerPage = request('perPage', 10); // default to 10
        @endphp
        @foreach ($options as $option)
        <option value="{{ $option }}" {{ (string)$selectedPerPage === (string)$option ? 'selected' : '' }}>
          {{ ucfirst($option) }}
        </option>
        @endforeach
      </select>
      <span>Entries</span>
    </form>

    <!-- Responsive Table -->
    <div class="modal fade" id="columnModal" tabindex="-1" aria-labelledby="columnModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="columnModalLabel">Modify Column - List of Indicator Columns</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
              </div>
              
              <div class="modal-body row">
                <p>Select columns to display:</p>
            <!-- Kolum Kiri -->
            <div class="col-md-6">
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="no" checked disabled><label class="form-check-label">No</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="year" checked><label class="form-check-label">Year</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="division" checked><label class="form-check-label">Division</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="section" checked><label class="form-check-label">Section</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="unit" checked><label class="form-check-label">Unit/Office</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="indicator" checked><label class="form-check-label">Indicator</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="description"><label class="form-check-label">Description</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="submission"><label class="form-check-label">Submission</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="target" checked><label class="form-check-label">Annual Target</label></div>
            </div>

            <!-- Kolum Kanan -->
            <div class="col-md-6">
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="metric" checked><label class="form-check-label">Metric</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="category"><label class="form-check-label">Category</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="output"><label class="form-check-label">Output/Outcome</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="type" checked><label class="form-check-label">Indicator Type</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="type_def"><label class="form-check-label">Indicator Type Definition</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="achievement"><label class="form-check-label">Component Achievement</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="status" checked><label class="form-check-label">Status</label></div>
              <div class="form-check"><input class="form-check-input column-toggle" type="checkbox" data-column="action" checked disabled><label class="form-check-label">Action</label></div>
            </div>
          </div>

          <div class="modal-footer justify-content-end">
            <button type="button" class="btn btn-primary btn-sm" onclick="selectAllColumns()">Select All</button>
            <button type="button" class="btn btn-secondary btn-sm" onclick="deselectAllColumns()">Deselect All</button>
            <button type="button" class="btn btn-success btn-sm" onclick="applyColumnSettings()">Apply</button>
          </div>
        </div>
      </div>
    </div>

    <!-- Jadual -->
    <!-- Jadual -->
    <div class="table-responsive">
                  <table class="table table-bordered align-middle table-hover shadow-sm rounded" id="mainTable">
                    <thead class="table-light">
                      <tr class="text-uppercase text-secondary fw-bold small text-center">
            <th><input type="checkbox" id="checkAll"></th>
            <th class="col-no sortable-header" onclick="sortTable('mainTable', 1, 'number')">
              No
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-year sortable-header" onclick="sortTable('mainTable', 2, 'number')">
              Year
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-division sortable-header" onclick="sortTable('mainTable', 3, 'text')">
              Division
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-section sortable-header" onclick="sortTable('mainTable', 4, 'text')">
              Section
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-unit sortable-header" onclick="sortTable('mainTable', 5, 'text')">
              Unit/Office
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-indicator sortable-header" onclick="sortTable('mainTable', 6, 'text')">
              Indicator
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-description sortable-header" onclick="sortTable('mainTable', 7, 'text')" style="display:none;">
              Description
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-submission sortable-header" onclick="sortTable('mainTable', 8, 'text')" style="display:none;">
              Submission
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-target sortable-header" onclick="sortTable('mainTable', 9, 'number')">
              Annual Target
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-metric sortable-header" onclick="sortTable('mainTable', 10, 'text')">
              Metric
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-category sortable-header" onclick="sortTable('mainTable', 11, 'text')" style="display:none;">
              Category
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-output sortable-header" onclick="sortTable('mainTable', 12, 'text')" style="display:none;">
              Output/Outcome
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-type sortable-header" onclick="sortTable('mainTable', 13, 'text')">
              Indicator Type
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-type_def sortable-header" onclick="sortTable('mainTable', 14, 'text')" style="display:none;">
              Indicator Type Definition
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-achievement sortable-header" onclick="sortTable('mainTable', 15, 'text')" style="display:none;">
              Component Achievement
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-status sortable-header" onclick="sortTable('mainTable', 16, 'text')">
              Status
              <i class="bi bi-arrow-down-up sort-icon"></i>
            </th>
            <th class="col-action">Action</th>
          </tr>
        </thead>
                <tbody>
                  <form id="indicatorForm" method="POST" action="{{ route('indicators.list.page.submit') }}">
                    {!! csrf_field() !!}
                  @foreach ($submitted_indicator_list as $key => $field)
                    <tr>
                      <td><input type="checkbox" name="selected[]" value="{{$field->indicator_id.'__1'}}"></td>
                      <td class="col-no">{{ $key+1 }}</td>
                      <td class="col-year">{{ $field->year }}</td>
                      <td class="col-division">{{ formatDivision($field->division) }}</td>
                      <td class="col-section">{{ formatDivision($field->section) }}</td>
                      <td class="col-unit">{{ formatDivision($field->unit) }}</td>
                      <td class="col-indicator">{{ $field->indicator }}</td>
                      <td class="col-description" style="display:none">{{ $field->description }}</td>
                      <td class="col-submission" style="display:none">{{ formatSubmission($field->submission) }}</td>
                      <td class="col-target">{{ $field->annual_target }}</td>
                      <td class="col-metric">{{ formatMetric($field->metric) }}</td>
                      <td class="col-category" style="display:none">{{ formatCategory($field->category) }}</td>
                      <td class="col-output" style="display:none">{{ formatOutputOutcome($field->output_outcome) }}</td>
                      <td class="col-type">{{ formatType($field->indicator_type) }}</td>
                      <td class="col-type_def" style="display:none">{{ $field->indicator_type_def }}</td>
                      <td class="col-achievement" style="display:none">{{ formatComponentAchv($field->component_achv) }}</td>
                      <td class="col-status"><span class="badge bg-success">{{ ucwords($field->status) }}</span></td>
                      <td class="col-action">
                        <button type="button" class="btn btn-info btn-sm"
                          data-bs-toggle="modal" data-bs-target="#indicatorModal"
                          data-indicator_id="{{ $field->indicator_id }}"
                          data-year="{{ $field->year }}"
                          data-division="{{ $field->division }}"
                          data-section="{{ $field->section }}"
                          data-unit="{{ $field->unit }}"
                          data-indicator="{{ $field->indicator }}"
                          {{-- data-description="{{ $field->description }}" --}}
                          data-annual_target="{{ $field->annual_target }}"
                          data-metric="{{ $field->metric }}"
                          {{-- data-category="{{ $field->category }}" --}}
                          data-output_outcome="{{ $field->output_outcome }}"
                          data-kpi_indicator_type_id="{{ $field->indicator_type }}"
                          data-indicator_type_def="{{ $field->indicator_type_def }}"
                          {{-- data-component_achievement="{{ $field->component_achv }}" --}}
                          data-status="{{ $field->status }}"
                          data-kpi_achievement_id="{{ $field->kpi_achievement_id }}"
                          data-pmu_remarks="{{ $field->pmu_remarks }}"
                          data-submission="{{ $field->submission }}">
                          <i class="bx bx-show"></i>
                        </button>
                      </td>
                    </tr>
                  @endforeach
                </tbody>
              </table>
            </div>

            <!-- Table Footer with Inline Layout -->
            <div class="d-flex justify-content-between align-items-center mt-3 flex-wrap gap-2">
              <!-- Entries Info -->
              <div>Showing 1 to 1 of 1 entries</div>

              <!-- Pagination -->
              <nav aria-label="Page navigation">
                <ul class="pagination mb-0">
                  <li class="page-item first">
                    <a class="page-link" href="javascript:void(0);">
                      <i class="tf-icon bx bx-chevrons-left bx-sm"></i>
                    </a>
                  </li>
                  <li class="page-item prev">
                    <a class="page-link" href="javascript:void(0);">
                      <i class="tf-icon bx bx-chevron-left bx-sm"></i>
                    </a>
                  </li>
                  <li class="page-item">
                    <a class="page-link" href="javascript:void(0);">1</a>
                  </li>
                  <li class="page-item">
                    <a class="page-link" href="javascript:void(0);">2</a>
                  </li>
                  <li class="page-item next">
                    <a class="page-link" href="javascript:void(0);">
                      <i class="tf-icon bx bx-chevron-right bx-sm"></i>
                    </a>
                  </li>
                  <li class="page-item last">
                    <a class="page-link" href="javascript:void(0);">
                      <i class="tf-icon bx bx-chevrons-right bx-sm"></i>
                    </a>
                  </li>
                </ul>
              </nav>
            </div>

            <br>

            <!-- Submit Button -->
            <div class="d-flex justify-content-end gap-2">
              <button type="submit" class="btn btn-primary">Submit</button>
            </div>
          </form>
            <!-- Account Deactivation Form -->
            <form id="formAccountDeactivation" onsubmit="return false">
              <div class="form-check my-4 ms-2">
                <!-- Optional deactivation checkbox (currently hidden) -->
              </div>
            </form>
    </div>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="indicatorModal" tabindex="-1" aria-labelledby="indicatorModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-scrollable modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="indicatorModalLabel">VIEW INDICATOR</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>

      <div class="modal-body">
        <!-- First Table: Indicator Info -->
        <table class="table table-bordered">
          <tbody>
            <tr>
              <th style="width: 30%;">Year :</th>
              <td data-field="year"></td>
            </tr>
            <tr>
              <th>Division :</th>
              <td data-field="division"></td>
            </tr>
            <tr>
              <th>Section :</th>
              <td data-field="section"></td>
            </tr>
            <tr>
              <th>Unit/Office :</th>
              <td data-field="unit"></td>
            </tr>
            <tr>
              <th>Indicator :</th>
              <td data-field="indicator"></td>
            </tr>
            <tr>
              <th>Submission :</th>
              <td data-field="submission"></td>
            </tr>
            <tr>
              <th>Annual Target :</th>
              <td data-field="annual_target"></td>
            </tr>
            <tr>
              <th>Metric :</th>
              <td data-field="metric"></td>
            </tr>
            <tr>
              <th>Output/Outcome :</th>
              <td data-field="output_outcome"></td>
            </tr>
            <tr>
              <th>Indicator Type :</th>
              <td data-field="indicator_type"></td>
            </tr>
            <tr>
              <th>Indicator Type Definition :</th>
              <td data-field="indicator_type_def"></td>
            </tr>
            <tr>
              <th>Status :</th>
              <td data-field="status"></td>
            </tr>
            <tr>
              <th>Remarks PMU Admin :</th>
              <td data-field="pmu_remarks"></td>
            </tr>
          </tbody>
        </table>
        <br>

        <!-- Table radio button -->
        <div class="row mb-3">
          <div class="col-md-12">
            <div class="table-responsive print-section" id="printArea">
              <table class="table table-bordered align-middle table-hover shadow-sm rounded" id="indicatorTable">

                <!-- <thead class="table-light align-middle">
                  <tr>
                    <th><strong>Year</strong></th>
                    <th><strong>Quarter</strong></th>
                    <th><strong>Achievement Count</strong></th>

                    <th>
                      <div class="d-flex justify-content-between align-items-center px-2">
                        <span class="fw-bold text-start">Title of Success Story</span>
                        <input class="form-check-input ms-2" type="radio" name="success_story" value="1" checked>
                      </div>
                    </th>

                    <th>
                      <div class="d-flex justify-content-between align-items-center px-2">
                        <span class="fw-bold text-start">Seller/Malaysian companies</span>
                        <input class="form-check-input ms-2" type="radio" name="seller" value="1">
                      </div>
                    </th>

                    <th>
                      <div class="d-flex justify-content-between align-items-center px-2">
                        <span class="fw-bold text-start">Buyers/Foreign Buyer</span>
                        <input class="form-check-input ms-2" type="radio" name="buyers" value="1">
                      </div>
                    </th>

                    <th>
                      <div class="d-flex justify-content-between align-items-center px-2">
                        <span class="fw-bold text-start">Sector based on product/services sourced</span>
                        <input class="form-check-input ms-2" type="radio" name="sector_based" value="1">
                      </div>
                    </th>

                    <th>
                      <div class="d-flex justify-content-between align-items-center px-2">
                        <span class="fw-bold text-start">Export value (RM)</span>
                        <input class="form-check-input ms-2" type="radio" name="export_value" value="1">
                      </div>
                    </th>

                    <th>
                      <div class="d-flex justify-content-between align-items-center px-2">
                        <span class="fw-bold text-start">Approve Date</span>
                        <input class="form-check-input ms-2" type="radio" name="approve_date" value="1">
                      </div>
                    </th> -->
                  </tr>
                </thead>
              </table>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>

<script>
// Track sort direction for each column
let sortDirections = {};

function sortTable(tableId, columnIndex, dataType) {
  const table = document.getElementById(tableId);
  const tbody = table.querySelector('tbody');
  const rows = Array.from(tbody.querySelectorAll('tr'));
  const header = table.querySelector(`thead th:nth-child(${columnIndex + 1})`);
  const sortIcon = header.querySelector('.sort-icon');
  
  // Clear other active sort icons
  table.querySelectorAll('.sort-icon').forEach(icon => {
    if (icon !== sortIcon) {
      icon.classList.remove('active');
      icon.className = 'bi bi-arrow-down-up sort-icon';
    }
  });
  
  // Determine sort direction
  const sortKey = `${tableId}_${columnIndex}`;
  const currentDirection = sortDirections[sortKey] || 'asc';
  const newDirection = currentDirection === 'asc' ? 'desc' : 'asc';
  sortDirections[sortKey] = newDirection;
  
  // Update sort icon
  sortIcon.classList.add('active');
  sortIcon.className = newDirection === 'asc' ? 
    'bi bi-arrow-up sort-icon active' : 
    'bi bi-arrow-down sort-icon active';
  
  // Sort rows
  rows.sort((a, b) => {
    const aCell = a.cells[columnIndex];
    const bCell = b.cells[columnIndex];
    
    let aValue = aCell.textContent.trim();
    let bValue = bCell.textContent.trim();
    
    // Handle different data types
    if (dataType === 'number') {
      // Remove commas and convert to number
      aValue = parseFloat(aValue.replace(/,/g, '')) || 0;
      bValue = parseFloat(bValue.replace(/,/g, '')) || 0;
      
      if (newDirection === 'asc') {
        return aValue - bValue;
      } else {
        return bValue - aValue;
      }
    } else {
      // Text sorting (alphabetical)
      aValue = aValue.toLowerCase();
      bValue = bValue.toLowerCase();
      
      if (newDirection === 'asc') {
        return aValue.localeCompare(bValue);
      } else {
        return bValue.localeCompare(aValue);
      }
    }
  });
  
  // Clear tbody and re-append sorted rows
  tbody.innerHTML = '';
  rows.forEach(row => tbody.appendChild(row));
  
  // Add visual feedback
  header.style.backgroundColor = '#e3f2fd';
  setTimeout(() => {
    header.style.backgroundColor = '';
  }, 300);
}

function selectAllColumns() {
  document.querySelectorAll('.column-toggle:not([disabled])').forEach(cb => cb.checked = true);
}

function deselectAllColumns() {
  document.querySelectorAll('.column-toggle:not([disabled])').forEach(cb => cb.checked = false);
}

function applyColumnSettings() {
  document.querySelectorAll('.column-toggle').forEach(cb => {
    const columnClass = '.col-' + cb.dataset.column;
    const show = cb.checked;
    document.querySelectorAll(columnClass).forEach(cell => {
      cell.style.display = show ? '' : 'none';
    });
  });
}
</script>
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const indicatorModal = document.getElementById('indicatorModal');

    indicatorModal.addEventListener('show.bs.modal', function (event) {
      const button = event.relatedTarget; // Button that triggered the modal

      // Extract values from data-* attributes
      const year = button.getAttribute('data-year');
      const division = button.getAttribute('data-division');
      const section = button.getAttribute('data-section');
      const unit = button.getAttribute('data-unit');
      const indicator = button.getAttribute('data-indicator');
      //const description = button.getAttribute('data-description');
      const submission = button.getAttribute('data-submission');
      const annual_target = button.getAttribute('data-annual_target');
      const metric = button.getAttribute('data-metric');
      //const category = button.getAttribute('data-category');
      const output_outcome = button.getAttribute('data-output_outcome');
      const indicator_type = button.getAttribute('data-kpi_indicator_type_id');
      const indicator_type_def = button.getAttribute('data-indicator_type_def');
      //const component_achievement = button.getAttribute('data-component_achievement');
      const status = button.getAttribute('data-status');
      const pmu_remarks = button.getAttribute('data-pmu_remarks');

      // Populate modal table cells
      indicatorModal.querySelector('td[data-field="year"]').textContent = year;
      indicatorModal.querySelector('td[data-field="division"]').textContent = division;
      indicatorModal.querySelector('td[data-field="section"]').textContent = section;
      indicatorModal.querySelector('td[data-field="unit"]').textContent = unit;
      indicatorModal.querySelector('td[data-field="indicator"]').textContent = indicator;
      //indicatorModal.querySelector('td[data-field="description"]').textContent = description;
      indicatorModal.querySelector('td[data-field="submission"]').textContent = submission;
      indicatorModal.querySelector('td[data-field="annual_target"]').textContent = annual_target;
      indicatorModal.querySelector('td[data-field="metric"]').textContent = metric;
      //indicatorModal.querySelector('td[data-field="category"]').textContent = category;
      indicatorModal.querySelector('td[data-field="output_outcome"]').textContent = output_outcome;
      indicatorModal.querySelector('td[data-field="indicator_type"]').textContent = indicator_type;
      indicatorModal.querySelector('td[data-field="indicator_type_def"]').innerHTML = indicator_type_def.replace(/\n/g, '<br>');
      //indicatorModal.querySelector('td[data-field="component_achievement"]').textContent = component_achievement;
      indicatorModal.querySelector('td[data-field="status"]').textContent = status.charAt(0).toUpperCase() + status.slice(1);
      indicatorModal.querySelector('td[data-field="pmu_remarks"]').textContent = pmu_remarks;
    });
  });
</script>
@endsection