<style>
  @media print {
    body * {
      visibility: hidden;
    }

    .print-section, .print-section * {
      visibility: visible !important;
    }

    .print-section {
      position: absolute;
      top: 0;
      left: 0;
      width: 100%;
      background: white;
      padding: 20px;
      z-index: 9999;
      font-size: 12px !important;
    }

    .print-section table th,
    .print-section table td {
      font-size: 12.5px !important;
    }

    #printTitle {
      font-size: 18px !important;
      margin-bottom: 20px;
    }

    nav, aside, .btn, .dropdown, .page-header, footer {
      display: none !important;
    }

    .hide-on-print {
      display: none !important;
    }

    .d-print-block {
      display: block !important;
    }

    @page {
      margin: 20mm;
    }

    .table th {
      text-transform: capitalize !important;
    }

    .sortable-header .sort-icon {
    display: none !important;
  }

  .sortable-header {
    cursor: default !important;
    background: transparent !important;
    padding-right: 1rem !important;
  }
  }
</style>

<script>
  function printPage() {
    const now = new Date();
    const date = now.toLocaleDateString('en-GB', {
      day: '2-digit', month: 'short', year: 'numeric'
    }).toUpperCase();
    const time = now.toLocaleTimeString('en-GB', {
      hour: '2-digit', minute: '2-digit'
    });
    const fullTitle = `Export Promotion (${date}, ${time})`;

    document.getElementById('printTitle').textContent = fullTitle;

    // Trigger print
    window.print();
  }

  // Cleanup after print
  window.onafterprint = function () {
    document.getElementById('printTitle').textContent = '';
  };

  document.addEventListener("DOMContentLoaded", function () {
    feather.replace(); // load icons
  });
</script>
