
<aside id="layout-menu" class="layout-menu menu-vertical menu bg-menu-theme">

  <!-- App brand -->
  <div class="app-brand demo d-flex align-items-center justify-content-between">
    <a href="{{ url('/') }}" class="app-brand-link d-flex align-items-center">
      <div class="app-brand-logo demo" style="width: 160px !important; height: auto !important;">
        <img src="{{ asset('assets/img/kpi.png') }}" style="width: 160px !important; height: auto !important; max-height: none !important;">
      </div>
      <span class="app-brand-text demo menu-text fw-bold ms-2">{{ config('variables.templateName') }}</span>
    </a>

    <!-- Toggle button (visible on all screens) -->
    <a href="javascript:void(0);" class="layout-menu-toggle menu-link text-large ms-auto d-block d-lg-none">
      <i class="bx bx-x bx-sm d-flex align-items-center justify-content-center"></i>
    </a>
  </div>

  <div class="menu-inner-shadow"></div>

  @php
    $currentRoute = Route::currentRouteName();

    function isMenuActive($menu, $currentRoute) {
      if (isset($menu->slug)) {
        if (is_array($menu->slug)) {
          foreach ($menu->slug as $slug) {
            if (str_starts_with($currentRoute, $slug)) return true;
          }
        } else {
          if (str_starts_with($currentRoute, $menu->slug)) return true;
        }
      }

      if (isset($menu->submenu)) {
        foreach ($menu->submenu as $subMenu) {
          if (isMenuActive($subMenu, $currentRoute)) return true;
        }
      }

      return false;
    }
  @endphp

  <ul class="menu-inner py-1">
    @foreach ($menuData[0]->menu as $menu)
      @if (isset($menu->menuHeader))
        <li class="menu-header small text-uppercase">
          <span class="menu-header-text">{{ __($menu->menuHeader) }}</span>
        </li>
      @else
        @php $isActive = isMenuActive($menu, $currentRoute); @endphp
        <li class="menu-item {{ $isActive ? (isset($menu->submenu) ? 'active open' : 'active') : '' }}">
          <a href="{{ isset($menu->url) ? url($menu->url) : 'javascript:void(0);' }}"
             class="{{ isset($menu->submenu) ? 'menu-link menu-toggle' : 'menu-link' }}"
             @if (isset($menu->target) && !empty($menu->target)) target="_blank" @endif>
            @isset($menu->icon)
              <i class="{{ $menu->icon }}"></i>
            @endisset
            <div class="menu-text">{{ isset($menu->name) ? __($menu->name) : '' }}</div>
            @isset($menu->badge)
              <div class="badge rounded-pill bg-{{ $menu->badge[0] }} text-uppercase ms-auto">{{ $menu->badge[1] }}</div>
            @endisset
          </a>

          @isset($menu->submenu)
            @include('layouts.sections.menu.submenu', ['menu' => $menu->submenu])
          @endisset
        </li>
      @endif
    @endforeach
  </ul>

</aside>

<!-- Overlay for mobile sidebar -->
<div class="layout-overlay" onclick="document.body.classList.remove('sidebar-open')"></div>

<!-- JS: Toggle sidebar (desktop + mobile) -->
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const toggleBtn = document.querySelector('.layout-menu-toggle');
    const body = document.body;

    if (toggleBtn) {
      toggleBtn.addEventListener('click', function () {
        if (window.innerWidth < 992) {
          body.classList.toggle('sidebar-open'); // For mobile
        } else {
          body.classList.toggle('layout-menu-collapsed'); // For desktop
        }
      });
    }
  });
</script>
