<?php
//
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\dashboard\Analytics;
use App\Http\Controllers\layouts\WithoutMenu;
use App\Http\Controllers\layouts\WithoutNavbar;
use App\Http\Controllers\layouts\Fluid;
use App\Http\Controllers\layouts\Container;
use App\Http\Controllers\layouts\Blank;
use App\Http\Controllers\pages\AccountSettingsAccount;
use App\Http\Controllers\pages\AccountSettingsNotifications;
use App\Http\Controllers\pages\AccountSettingsConnections;
use App\Http\Controllers\pages\MiscError;
use App\Http\Controllers\pages\MiscUnderMaintenance;
use App\Http\Controllers\pages\PMUIndicator;
use App\Http\Controllers\pages\PMUIndicatorManage;
use App\Http\Controllers\authentications\LoginBasic;
use App\Http\Controllers\authentications\RegisterBasic;
use App\Http\Controllers\authentications\ForgotPasswordBasic;
use App\Http\Controllers\KpiAdmin\KpiAdminConfiguration;
use App\Http\Controllers\KpiAdmin\KpiAdminAccess;
use App\Http\Controllers\KpiAdmin\KpiAdminAudit;
use App\Http\Controllers\KpiAdmin\KpiAdminEdit;
use App\Http\Controllers\user_interface\Accordion;
use App\Http\Controllers\user_interface\Alerts;
use App\Http\Controllers\user_interface\Badges;
use App\Http\Controllers\user_interface\Buttons;
use App\Http\Controllers\user_interface\Carousel;
use App\Http\Controllers\user_interface\Collapse;
use App\Http\Controllers\user_interface\Dropdowns;
use App\Http\Controllers\user_interface\Footer;
use App\Http\Controllers\user_interface\ListGroups;
use App\Http\Controllers\user_interface\Modals;
use App\Http\Controllers\user_interface\Navbar;
use App\Http\Controllers\user_interface\Offcanvas;
use App\Http\Controllers\user_interface\PaginationBreadcrumbs;
use App\Http\Controllers\user_interface\Progress;
use App\Http\Controllers\user_interface\Spinners;
use App\Http\Controllers\user_interface\TabsPills;
use App\Http\Controllers\user_interface\Toasts;
use App\Http\Controllers\user_interface\TooltipsPopovers;
use App\Http\Controllers\user_interface\Typography;
use App\Http\Controllers\extended_ui\PerfectScrollbar;
use App\Http\Controllers\extended_ui\TextDivider;
use App\Http\Controllers\icons\Boxicons;
use App\Http\Controllers\kpiReport\kpiReportAdHoc;
use App\Http\Controllers\kpiReport\kpiReportPredefinedController;
use App\Http\Controllers\kpiReport\kpiReportCreate;
use App\Http\Controllers\form_layouts\VerticalForm;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\form_layouts\HorizontalForm;
use App\Http\Controllers\tables\Basic as TablesBasic;
// use App\Http\Controllers\PmuAchievementController; // controller PMU Achievement
use App\Http\Controllers\kpiAchievement\kpiAchievementToUpdateController;
use App\Http\Controllers\kpiAchievement\kpiAchievementUpdatedController;
use App\Http\Controllers\kpiAchievement\kpiAchievementCompaniesBySectorsController;
use Illuminate\Support\Facades\View;
use App\Http\Controllers\ExportPromotionController;
use App\Http\Controllers\ExportersDevelopmentController;
use App\Http\Controllers\authentications\LoginController;

//test

use App\Http\Controllers\HelloController;

Route::get('/hello', [HelloController::class, 'sayHello']);

//test

Route::get('/', function () {return redirect('sso/index.php');});
Route::post('/sso', [App\Http\Controllers\SsoController::class, 'index'])->name('sso.start');


// Main Page Route
// Route::get('/', [Analytics::class, 'index'])->name('dashboard-analytics');

// Login routes
Route::get('/', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login'])->name('login.post');
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');
Route::post('/loginsso', [LoginController::class, 'loginsso'])->name('login.sso');

// Authenticated routes
Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', [Analytics::class, 'index'])->name('dashboard-analytics');
    //Dashboard Filter Action
    Route::post('/dashboard', [Analytics::class, 'index'])->name('dashboard-analytics');
    // Route::get('/dashboard', function () {
    //     return "You are logged in!";
    // })->name('dashboard-analytics');
});

// layout
Route::get('/layouts/without-menu', [WithoutMenu::class, 'index'])->name('layouts-without-menu');
Route::get('/layouts/without-navbar', [WithoutNavbar::class, 'index'])->name('layouts-without-navbar');
Route::get('/layouts/fluid', [Fluid::class, 'index'])->name('layouts-fluid');
Route::get('/layouts/container', [Container::class, 'index'])->name('layouts-container');
Route::get('/layouts/blank', [Blank::class, 'index'])->name('layouts-blank');

// pages
Route::get('/pages/account-settings-account', [AccountSettingsAccount::class, 'index'])->name('pages-account-settings-account');
Route::post('/pages/account-settings-account-search', [AccountSettingsAccount::class, 'index'])->name('pages-account-settings-account-search');
Route::post('/pages/account-settings-account', [AccountSettingsAccount::class, 'SubmitIndicator'])->name('indicators.list.page.submit');

Route::get('/pages/kpi-indicator-pmu-admin', [PMUIndicator::class, 'index'])->name('kpi-indicator-pmu-admin');
Route::post('/pages/kpi-indicator-pmu-admin', [PMUIndicator::class, 'index'])->name('kpi-indicator-pmu-admin');
Route::post('/pages/kpi-indicator-pmu-admin-endorse', [PMUIndicator::class, 'endorseIndicator'])->name('indicator-endorse');
Route::post('/pages/kpi-indicator-pmu-admin-disable', [PMUIndicator::class, 'disableIndicator'])->name('indicator-disable');


Route::get('/pages/kpi-indicator-pmu-admin-manage', [PMUIndicatorManage::class, 'index'])->name('kpi-indicator-pmu-admin-manage');

Route::get('/pages/account-settings-notifications', [AccountSettingsNotifications::class, 'index'])->name('pages-account-settings-notifications');
Route::get('/pages/new-account-settings-notifications', [AccountSettingsNotifications::class, 'index'])->name('new-indicator.store');
Route::post('/pages/new-account-settings-notifications', [AccountSettingsNotifications::class, 'storeIndicator'])->name('new-indicator.store');
Route::post('/pages/account-settings-notifications-submit', [AccountSettingsNotifications::class, 'storeSubmitIndicator'])->name('indicators.submit');
Route::post('/pages/account-settings-notifications-update', [AccountSettingsNotifications::class, 'updateIndicator'])->name('indicators.update');
Route::post('/pages/account-settings-notifications-copy', [AccountSettingsNotifications::class, 'copyIndicator'])->name('indicators.copy');

Route::get('/pages/account-settings-connections', [AccountSettingsConnections::class, 'index'])->name('pages-account-settings-connections');
Route::get('/pages/misc-error', [MiscError::class, 'index'])->name('pages-misc-error');
Route::get('/pages/misc-under-maintenance', [MiscUnderMaintenance::class, 'index'])->name('pages-misc-under-maintenance');

// authentication
Route::get('/auth/login-basic', [LoginBasic::class, 'index'])->name('auth-login-basic');
Route::get('/auth/register-basic', [RegisterBasic::class, 'index'])->name('auth-register-basic');
Route::get('/auth/forgot-password-basic', [ForgotPasswordBasic::class, 'index'])->name('auth-reset-password-basic');

// KPI ADMIN
Route::get('/kpiAdmin/access', [App\Http\Controllers\KpiAdmin\KpiAdminAccess::class, 'index'])->name('kpiAdmin-access');
Route::get('/kpiAdmin/configuration', [App\Http\Controllers\KpiAdmin\KpiAdminConfiguration::class, 'index'])->name('kpi-admin-configuration');
Route::get('/kpiAdmin/audit', [KpiAdminAudit::class, 'index'])->name('kpiAdmin-audit');
Route::get('/kpiAdmin/query-mapping', [App\Http\Controllers\KpiAdmin\KpiAdminQueryMapping::class, 'index'])->name('kpiAdmin-query-mapping');
Route::get('/kpiAdmin/edit', [App\Http\Controllers\KpiAdmin\KpiAdminEdit::class,'index'])->name('kpiAdmin-edit');

Route::get('/kpiAdmin/query-mapping', [App\Http\Controllers\KpiAdmin\KpiAdminQueryMapping::class, 'index'])->name('kpiAdmin-query-mapping');
Route::get('/kpiAdmin/edit-report', [App\Http\Controllers\KpiAdmin\KpiAdminEditReport::class, 'index'])->name('kpiAdmin-edit-report');
// User Interface
Route::get('/ui/accordion', [Accordion::class, 'index'])->name('ui-accordion');
Route::get('/ui/alerts', [Alerts::class, 'index'])->name('ui-alerts');
Route::get('/ui/badges', [Badges::class, 'index'])->name('ui-badges');
Route::get('/ui/buttons', [Buttons::class, 'index'])->name('ui-buttons');
Route::get('/ui/carousel', [Carousel::class, 'index'])->name('ui-carousel');
Route::get('/ui/collapse', [Collapse::class, 'index'])->name('ui-collapse');
Route::get('/ui/dropdowns', [Dropdowns::class, 'index'])->name('ui-dropdowns');
Route::get('/ui/footer', [Footer::class, 'index'])->name('ui-footer');
Route::get('/ui/list-groups', [ListGroups::class, 'index'])->name('ui-list-groups');
Route::get('/ui/modals', [Modals::class, 'index'])->name('ui-modals');
Route::get('/ui/navbar', [Navbar::class, 'index'])->name('ui-navbar');
Route::get('/ui/offcanvas', [Offcanvas::class, 'index'])->name('ui-offcanvas');
Route::get('/ui/pagination-breadcrumbs', [PaginationBreadcrumbs::class, 'index'])->name('ui-pagination-breadcrumbs');
Route::get('/ui/progress', [Progress::class, 'index'])->name('ui-progress');
Route::get('/ui/spinners', [Spinners::class, 'index'])->name('ui-spinners');
Route::get('/ui/tabs-pills', [TabsPills::class, 'index'])->name('ui-tabs-pills');
Route::get('/ui/toasts', [Toasts::class, 'index'])->name('ui-toasts');
Route::get('/ui/tooltips-popovers', [TooltipsPopovers::class, 'index'])->name('ui-tooltips-popovers');
Route::get('/ui/typography', [Typography::class, 'index'])->name('ui-typography');

// extended ui
Route::get('/extended/ui-perfect-scrollbar', [PerfectScrollbar::class, 'index'])->name('extended-ui-perfect-scrollbar');
Route::get('/extended/ui-text-divider', [TextDivider::class, 'index'])->name('extended-ui-text-divider');

// icons
Route::get('/icons/boxicons', [Boxicons::class, 'index'])->name('icons-boxicons');

// form elements
Route::get('/kpiReport/adHoc', [kpiReportAdHoc::class, 'index'])->name('kpiReport-adHoc');
Route::get('/kpiReport/predefined', [kpiReportPredefinedController::class, 'index'])->name('kpiReport-predefined');
Route::get('/kpiReport/create', [kpiReportCreate::class, 'index'])->name('kpiReport-create');
Route::post('/kpiReport/store', [kpiReportCreate::class, 'store'])->name('kpiReport-store');
Route::get('/form/layouts-vertical', [VerticalForm::class, 'index'])->name('form-layouts-vertical');
Route::get('/form/layouts-horizontal', [HorizontalForm::class, 'index'])->name('form-layouts-horizontal');

// tables
Route::get('/tables/basic', [TablesBasic::class, 'index'])->name('tables-basic');

// KPI Achievement - To Update
Route::get('/kpi-achievement-to-update', [kpiAchievementToUpdateController::class, 'index'])->name('kpiAchievement.toUpdate.index');

// KPI Achievement - Updated
Route::get('/kpi-achievement-updated', [kpiAchievementUpdatedController::class, 'index'])->name('kpiAchievement.updated.index');
Route::post('/kpi-achievement-updated-search',[kpiAchievementUpdatedController::class,'index'])->name('kpiAchievement.updated.search');

// KPI Achievement - Companies By Sectors
Route::get('/kpi-achievement-companies-by-sectors', [kpiAchievementCompaniesBySectorsController::class, 'index'])->name('kpiAchievement.companiesBySectors.index');

// Indicator Types
Route::get('/details/{type}', function ($type) { $view = "content.indicator-types.type-{$type}";if (View::exists($view)) { return view($view); } abort(404);});

// achievement types
Route::get('/achievement-details/{type}', function ($type) { $view = "content.achievement-types.type{$type}";if (View::exists($view)) { return view($view);} abort(404); });

// annual programme
Route::get('/kpi/annual-programme', function () {
    return view('content.kpi.kpiAchievement-annualProgramme');
});

// companies by sectors
Route::get('/kpi/companies-by-sectors', function () { return view('content.kpi.kpiAchievement-companiesBySectors'); });

// listing
Route::get('/kpi/listing', function () {
    return view('content.kpi.kpiAchievement-listing');
})->name('kpiAchievement.listing');


// pmu achievement list
// Route::get('/pmu-achievement-list', [PmuAchievementController::class, 'toupdate'])->name('pmu.achievement.toupdate');

//pmu achievement manage
// Route::get('/pmu-achievement-manage', [PmuAchievementController::class, 'updated'])->name('pmu.achievement.updated');

// //Log Out
// Route::post('/logout', function () { Auth::logout(); return redirect('https://www.matrade.gov.my'); // Redirect terus ke MATRADE portal
// })->name('logout');

// Route::post('/logout', function () {
//     //Auth::logout();
//     return redirect('https://www.matrade.gov.my'); // Redirect terus ke MATRADE portal
// })->name('logout');

//Route::get('/login', function () { return redirect()->route('auth-login-basic'); })->name('login');

// New login route using our custom login page
// Route::get('/login', function () { return view('content.authentications.login'); })->name('login');

// Simple redirect to dashboard for UI testing purposes
// Route::post('/login', function () {
//     return redirect()->route('dashboard-analytics');
// })->name('login.post');

// Handle login form submission
//Route::post('/login', [App\Http\Controllers\authentications\LoginBasic::class, 'authenticate'])->name('login.post');

//Export Promotion
Route::get('/export-promotion', [ExportPromotionController::class, 'index'])->name('export-promotion');
Route::get('/programme-bpeap', [ExportPromotionController::class, 'programme'])->name('dashboard.programme-bpeap');
Route::get('/export-sales-bpeap', [ExportPromotionController::class, 'exportSales'])->name('dashboard.export-sales-bpeap');
Route::get('/companies-assisted-bpeap', [ExportPromotionController::class, 'companiesAssisted'])->name('dashboard.companies-assisted-bpeap');

Route::get('/exporters-development', [ExportersDevelopmentController::class, 'index'])->name('exporters-development');
Route::get('/programme-btpd', [ExportersDevelopmentController::class, 'programme'])->name('dashboard.programme-btpd');
Route::get('/export-sales-btpd', [ExportersDevelopmentController::class, 'exportSales'])->name('dashboard.export-sales-btpd');
Route::get('/companies-assisted-btpd', [ExportersDevelopmentController::class, 'companiesAssisted'])->name('dashboard.companies-assisted-btpd');


Route::get('/view-report', [KpiReportAdHoc::class, 'index'])->name('view-report');

// Route::post('/store-report', [CreateReport::class, 'store'])->name('store-report');

// Manage Indicator Type
Route::get('/indicator/manage/type2', function () { return view('content.kpi-indicator-pmu-admin.manage-indicator-type-2'); })->name('indicator.manage.type2');
Route::get('/indicator/manage/type3', function () { return view('content.kpi-indicator-pmu-admin.manage-indicator-type-3'); })->name('indicator.manage.type3');
Route::get('/indicator/manage/type4', function () { return view('content.kpi-indicator-pmu-admin.manage-indicator-type-4'); })->name('indicator.manage.type4');
Route::get('/indicator/manage/type5', function () { return view('content.kpi-indicator-pmu-admin.manage-indicator-type-5'); })->name('indicator.manage.type5');
Route::get('/indicator/manage/type6', function () { return view('content.kpi-indicator-pmu-admin.manage-indicator-type-6'); })->name('indicator.manage.type6');
